//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _Config_h_
#define _Config_h_


// Path set on login
#define DEFAULT_PATH		"./:/bin:/usr/bin:/usr/local/bin:/usr/X11R6/bin"

// Default X-Server (and arguments, end with NULL)
#define DEFAULT_XSERVER		{"/usr/X11R6/bin/X", NULL}

// Root window color
#define ROOTWINDOW_COLOR	"#505075"

// Console colors
#define CONSOLE_BGCOLOR		"white"
#define CONSOLE_FGCOLOR		"black"

// Shutdown message color
#define MSG_COLOR		"white"

// Commands
#define INIT_CMD		"/usr/X11R6/bin/xsetroot -solid \""ROOTWINDOW_COLOR"\" -cursor_name left_ptr"
#define LOGIN_CMD		"exec /bin/sh -login ~/.xinitrc"
#define HALT_CMD		"/sbin/shutdown -h now"
#define REBOOT_CMD		"/sbin/shutdown -r now"
#define CONSOLE_CMD		"/usr/X11R6/bin/xterm -C -fg \""CONSOLE_FGCOLOR"\" -bg \""CONSOLE_BGCOLOR"\" +sb -g %dx%d+%d+%d -fn %dx%d -T \"Console login\" -e /bin/sh -c \"/bin/cat /etc/issue; exec /bin/login\""

// Input properties
#define INPUT_NAME_X		200
#define INPUT_NAME_Y		154
#define INPUT_PASSWD_X		200
#define INPUT_PASSWD_Y		200
#define INPUT_FONT		"-*-helvetica-medium-r-*-*-18-*-*-*-*-*-*-*"
#define INPUT_BGCOLOR		"#ffffff"
#define INPUT_FGCOLOR		"black"
#define INPUT_CURSOR_HEIGHT	20
#define INPUT_MAXLENGTH_NAME	10
#define INPUT_MAXLENGTH_PASSWD	20


#endif
