# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Transaction isolation level control for Debusine."""

from enum import StrEnum

from django.db import connection


class IsolationLevel(StrEnum):
    """A PostgreSQL transaction isolation level."""

    READ_COMMITTED = "READ COMMITTED"
    REPEATABLE_READ = "REPEATABLE READ"
    SERIALIZABLE = "SERIALIZABLE"


def set_transaction(isolation_level: IsolationLevel) -> None:
    """Set the characteristics of the current transaction."""
    with connection.cursor() as cursor:
        cursor.execute(f"SET TRANSACTION ISOLATION LEVEL {isolation_level}")
