/* This file has been generated by generate_character_set_conv_tables.c */
/* DO NOT EDIT !*/

/* clang-format off */
#include "cpl_port.h"
#include "cpl_character_sets.h"

/* Character set of original IBM PC */
static const CPLCodePageConvTable CPL_CP437_to_UTF8 = {
  {0xC3, 0x87, 0x00},
  {0xC3, 0xBC, 0x00},
  {0xC3, 0xA9, 0x00},
  {0xC3, 0xA2, 0x00},
  {0xC3, 0xA4, 0x00},
  {0xC3, 0xA0, 0x00},
  {0xC3, 0xA5, 0x00},
  {0xC3, 0xA7, 0x00},
  {0xC3, 0xAA, 0x00},
  {0xC3, 0xAB, 0x00},
  {0xC3, 0xA8, 0x00},
  {0xC3, 0xAF, 0x00},
  {0xC3, 0xAE, 0x00},
  {0xC3, 0xAC, 0x00},
  {0xC3, 0x84, 0x00},
  {0xC3, 0x85, 0x00},
  {0xC3, 0x89, 0x00},
  {0xC3, 0xA6, 0x00},
  {0xC3, 0x86, 0x00},
  {0xC3, 0xB4, 0x00},
  {0xC3, 0xB6, 0x00},
  {0xC3, 0xB2, 0x00},
  {0xC3, 0xBB, 0x00},
  {0xC3, 0xB9, 0x00},
  {0xC3, 0xBF, 0x00},
  {0xC3, 0x96, 0x00},
  {0xC3, 0x9C, 0x00},
  {0xC2, 0xA2, 0x00},
  {0xC2, 0xA3, 0x00},
  {0xC2, 0xA5, 0x00},
  {0xE2, 0x82, 0xA7},
  {0xC6, 0x92, 0x00},
  {0xC3, 0xA1, 0x00},
  {0xC3, 0xAD, 0x00},
  {0xC3, 0xB3, 0x00},
  {0xC3, 0xBA, 0x00},
  {0xC3, 0xB1, 0x00},
  {0xC3, 0x91, 0x00},
  {0xC2, 0xAA, 0x00},
  {0xC2, 0xBA, 0x00},
  {0xC2, 0xBF, 0x00},
  {0xE2, 0x8C, 0x90},
  {0xC2, 0xAC, 0x00},
  {0xC2, 0xBD, 0x00},
  {0xC2, 0xBC, 0x00},
  {0xC2, 0xA1, 0x00},
  {0xC2, 0xAB, 0x00},
  {0xC2, 0xBB, 0x00},
  {0xE2, 0x96, 0x91},
  {0xE2, 0x96, 0x92},
  {0xE2, 0x96, 0x93},
  {0xE2, 0x94, 0x82},
  {0xE2, 0x94, 0xA4},
  {0xE2, 0x95, 0xA1},
  {0xE2, 0x95, 0xA2},
  {0xE2, 0x95, 0x96},
  {0xE2, 0x95, 0x95},
  {0xE2, 0x95, 0xA3},
  {0xE2, 0x95, 0x91},
  {0xE2, 0x95, 0x97},
  {0xE2, 0x95, 0x9D},
  {0xE2, 0x95, 0x9C},
  {0xE2, 0x95, 0x9B},
  {0xE2, 0x94, 0x90},
  {0xE2, 0x94, 0x94},
  {0xE2, 0x94, 0xB4},
  {0xE2, 0x94, 0xAC},
  {0xE2, 0x94, 0x9C},
  {0xE2, 0x94, 0x80},
  {0xE2, 0x94, 0xBC},
  {0xE2, 0x95, 0x9E},
  {0xE2, 0x95, 0x9F},
  {0xE2, 0x95, 0x9A},
  {0xE2, 0x95, 0x94},
  {0xE2, 0x95, 0xA9},
  {0xE2, 0x95, 0xA6},
  {0xE2, 0x95, 0xA0},
  {0xE2, 0x95, 0x90},
  {0xE2, 0x95, 0xAC},
  {0xE2, 0x95, 0xA7},
  {0xE2, 0x95, 0xA8},
  {0xE2, 0x95, 0xA4},
  {0xE2, 0x95, 0xA5},
  {0xE2, 0x95, 0x99},
  {0xE2, 0x95, 0x98},
  {0xE2, 0x95, 0x92},
  {0xE2, 0x95, 0x93},
  {0xE2, 0x95, 0xAB},
  {0xE2, 0x95, 0xAA},
  {0xE2, 0x94, 0x98},
  {0xE2, 0x94, 0x8C},
  {0xE2, 0x96, 0x88},
  {0xE2, 0x96, 0x84},
  {0xE2, 0x96, 0x8C},
  {0xE2, 0x96, 0x90},
  {0xE2, 0x96, 0x80},
  {0xCE, 0xB1, 0x00},
  {0xC3, 0x9F, 0x00},
  {0xCE, 0x93, 0x00},
  {0xCF, 0x80, 0x00},
  {0xCE, 0xA3, 0x00},
  {0xCF, 0x83, 0x00},
  {0xC2, 0xB5, 0x00},
  {0xCF, 0x84, 0x00},
  {0xCE, 0xA6, 0x00},
  {0xCE, 0x98, 0x00},
  {0xCE, 0xA9, 0x00},
  {0xCE, 0xB4, 0x00},
  {0xE2, 0x88, 0x9E},
  {0xCF, 0x86, 0x00},
  {0xCE, 0xB5, 0x00},
  {0xE2, 0x88, 0xA9},
  {0xE2, 0x89, 0xA1},
  {0xC2, 0xB1, 0x00},
  {0xE2, 0x89, 0xA5},
  {0xE2, 0x89, 0xA4},
  {0xE2, 0x8C, 0xA0},
  {0xE2, 0x8C, 0xA1},
  {0xC3, 0xB7, 0x00},
  {0xE2, 0x89, 0x88},
  {0xC2, 0xB0, 0x00},
  {0xE2, 0x88, 0x99},
  {0xC2, 0xB7, 0x00},
  {0xE2, 0x88, 0x9A},
  {0xE2, 0x81, 0xBF},
  {0xC2, 0xB2, 0x00},
  {0xE2, 0x96, 0xA0},
  {0xC2, 0xA0, 0x00},
};

/* Central and eastern Europe languages */
static const CPLCodePageConvTable CPL_CP1250_to_UTF8 = {
  {0xE2, 0x82, 0xAC},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0x9A},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0x9E},
  {0xE2, 0x80, 0xA6},
  {0xE2, 0x80, 0xA0},
  {0xE2, 0x80, 0xA1},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0xB0},
  {0xC5, 0xA0, 0x00},
  {0xE2, 0x80, 0xB9},
  {0xC5, 0x9A, 0x00},
  {0xC5, 0xA4, 0x00},
  {0xC5, 0xBD, 0x00},
  {0xC5, 0xB9, 0x00},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0x98},
  {0xE2, 0x80, 0x99},
  {0xE2, 0x80, 0x9C},
  {0xE2, 0x80, 0x9D},
  {0xE2, 0x80, 0xA2},
  {0xE2, 0x80, 0x93},
  {0xE2, 0x80, 0x94},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x84, 0xA2},
  {0xC5, 0xA1, 0x00},
  {0xE2, 0x80, 0xBA},
  {0xC5, 0x9B, 0x00},
  {0xC5, 0xA5, 0x00},
  {0xC5, 0xBE, 0x00},
  {0xC5, 0xBA, 0x00},
  {0xC2, 0xA0, 0x00},
  {0xCB, 0x87, 0x00},
  {0xCB, 0x98, 0x00},
  {0xC5, 0x81, 0x00},
  {0xC2, 0xA4, 0x00},
  {0xC4, 0x84, 0x00},
  {0xC2, 0xA6, 0x00},
  {0xC2, 0xA7, 0x00},
  {0xC2, 0xA8, 0x00},
  {0xC2, 0xA9, 0x00},
  {0xC5, 0x9E, 0x00},
  {0xC2, 0xAB, 0x00},
  {0xC2, 0xAC, 0x00},
  {0xC2, 0xAD, 0x00},
  {0xC2, 0xAE, 0x00},
  {0xC5, 0xBB, 0x00},
  {0xC2, 0xB0, 0x00},
  {0xC2, 0xB1, 0x00},
  {0xCB, 0x9B, 0x00},
  {0xC5, 0x82, 0x00},
  {0xC2, 0xB4, 0x00},
  {0xC2, 0xB5, 0x00},
  {0xC2, 0xB6, 0x00},
  {0xC2, 0xB7, 0x00},
  {0xC2, 0xB8, 0x00},
  {0xC4, 0x85, 0x00},
  {0xC5, 0x9F, 0x00},
  {0xC2, 0xBB, 0x00},
  {0xC4, 0xBD, 0x00},
  {0xCB, 0x9D, 0x00},
  {0xC4, 0xBE, 0x00},
  {0xC5, 0xBC, 0x00},
  {0xC5, 0x94, 0x00},
  {0xC3, 0x81, 0x00},
  {0xC3, 0x82, 0x00},
  {0xC4, 0x82, 0x00},
  {0xC3, 0x84, 0x00},
  {0xC4, 0xB9, 0x00},
  {0xC4, 0x86, 0x00},
  {0xC3, 0x87, 0x00},
  {0xC4, 0x8C, 0x00},
  {0xC3, 0x89, 0x00},
  {0xC4, 0x98, 0x00},
  {0xC3, 0x8B, 0x00},
  {0xC4, 0x9A, 0x00},
  {0xC3, 0x8D, 0x00},
  {0xC3, 0x8E, 0x00},
  {0xC4, 0x8E, 0x00},
  {0xC4, 0x90, 0x00},
  {0xC5, 0x83, 0x00},
  {0xC5, 0x87, 0x00},
  {0xC3, 0x93, 0x00},
  {0xC3, 0x94, 0x00},
  {0xC5, 0x90, 0x00},
  {0xC3, 0x96, 0x00},
  {0xC3, 0x97, 0x00},
  {0xC5, 0x98, 0x00},
  {0xC5, 0xAE, 0x00},
  {0xC3, 0x9A, 0x00},
  {0xC5, 0xB0, 0x00},
  {0xC3, 0x9C, 0x00},
  {0xC3, 0x9D, 0x00},
  {0xC5, 0xA2, 0x00},
  {0xC3, 0x9F, 0x00},
  {0xC5, 0x95, 0x00},
  {0xC3, 0xA1, 0x00},
  {0xC3, 0xA2, 0x00},
  {0xC4, 0x83, 0x00},
  {0xC3, 0xA4, 0x00},
  {0xC4, 0xBA, 0x00},
  {0xC4, 0x87, 0x00},
  {0xC3, 0xA7, 0x00},
  {0xC4, 0x8D, 0x00},
  {0xC3, 0xA9, 0x00},
  {0xC4, 0x99, 0x00},
  {0xC3, 0xAB, 0x00},
  {0xC4, 0x9B, 0x00},
  {0xC3, 0xAD, 0x00},
  {0xC3, 0xAE, 0x00},
  {0xC4, 0x8F, 0x00},
  {0xC4, 0x91, 0x00},
  {0xC5, 0x84, 0x00},
  {0xC5, 0x88, 0x00},
  {0xC3, 0xB3, 0x00},
  {0xC3, 0xB4, 0x00},
  {0xC5, 0x91, 0x00},
  {0xC3, 0xB6, 0x00},
  {0xC3, 0xB7, 0x00},
  {0xC5, 0x99, 0x00},
  {0xC5, 0xAF, 0x00},
  {0xC3, 0xBA, 0x00},
  {0xC5, 0xB1, 0x00},
  {0xC3, 0xBC, 0x00},
  {0xC3, 0xBD, 0x00},
  {0xC5, 0xA3, 0x00},
  {0xCB, 0x99, 0x00},
};

/* Cyrillic script */
static const CPLCodePageConvTable CPL_CP1251_to_UTF8 = {
  {0xD0, 0x82, 0x00},
  {0xD0, 0x83, 0x00},
  {0xE2, 0x80, 0x9A},
  {0xD1, 0x93, 0x00},
  {0xE2, 0x80, 0x9E},
  {0xE2, 0x80, 0xA6},
  {0xE2, 0x80, 0xA0},
  {0xE2, 0x80, 0xA1},
  {0xE2, 0x82, 0xAC},
  {0xE2, 0x80, 0xB0},
  {0xD0, 0x89, 0x00},
  {0xE2, 0x80, 0xB9},
  {0xD0, 0x8A, 0x00},
  {0xD0, 0x8C, 0x00},
  {0xD0, 0x8B, 0x00},
  {0xD0, 0x8F, 0x00},
  {0xD1, 0x92, 0x00},
  {0xE2, 0x80, 0x98},
  {0xE2, 0x80, 0x99},
  {0xE2, 0x80, 0x9C},
  {0xE2, 0x80, 0x9D},
  {0xE2, 0x80, 0xA2},
  {0xE2, 0x80, 0x93},
  {0xE2, 0x80, 0x94},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x84, 0xA2},
  {0xD1, 0x99, 0x00},
  {0xE2, 0x80, 0xBA},
  {0xD1, 0x9A, 0x00},
  {0xD1, 0x9C, 0x00},
  {0xD1, 0x9B, 0x00},
  {0xD1, 0x9F, 0x00},
  {0xC2, 0xA0, 0x00},
  {0xD0, 0x8E, 0x00},
  {0xD1, 0x9E, 0x00},
  {0xD0, 0x88, 0x00},
  {0xC2, 0xA4, 0x00},
  {0xD2, 0x90, 0x00},
  {0xC2, 0xA6, 0x00},
  {0xC2, 0xA7, 0x00},
  {0xD0, 0x81, 0x00},
  {0xC2, 0xA9, 0x00},
  {0xD0, 0x84, 0x00},
  {0xC2, 0xAB, 0x00},
  {0xC2, 0xAC, 0x00},
  {0xC2, 0xAD, 0x00},
  {0xC2, 0xAE, 0x00},
  {0xD0, 0x87, 0x00},
  {0xC2, 0xB0, 0x00},
  {0xC2, 0xB1, 0x00},
  {0xD0, 0x86, 0x00},
  {0xD1, 0x96, 0x00},
  {0xD2, 0x91, 0x00},
  {0xC2, 0xB5, 0x00},
  {0xC2, 0xB6, 0x00},
  {0xC2, 0xB7, 0x00},
  {0xD1, 0x91, 0x00},
  {0xE2, 0x84, 0x96},
  {0xD1, 0x94, 0x00},
  {0xC2, 0xBB, 0x00},
  {0xD1, 0x98, 0x00},
  {0xD0, 0x85, 0x00},
  {0xD1, 0x95, 0x00},
  {0xD1, 0x97, 0x00},
  {0xD0, 0x90, 0x00},
  {0xD0, 0x91, 0x00},
  {0xD0, 0x92, 0x00},
  {0xD0, 0x93, 0x00},
  {0xD0, 0x94, 0x00},
  {0xD0, 0x95, 0x00},
  {0xD0, 0x96, 0x00},
  {0xD0, 0x97, 0x00},
  {0xD0, 0x98, 0x00},
  {0xD0, 0x99, 0x00},
  {0xD0, 0x9A, 0x00},
  {0xD0, 0x9B, 0x00},
  {0xD0, 0x9C, 0x00},
  {0xD0, 0x9D, 0x00},
  {0xD0, 0x9E, 0x00},
  {0xD0, 0x9F, 0x00},
  {0xD0, 0xA0, 0x00},
  {0xD0, 0xA1, 0x00},
  {0xD0, 0xA2, 0x00},
  {0xD0, 0xA3, 0x00},
  {0xD0, 0xA4, 0x00},
  {0xD0, 0xA5, 0x00},
  {0xD0, 0xA6, 0x00},
  {0xD0, 0xA7, 0x00},
  {0xD0, 0xA8, 0x00},
  {0xD0, 0xA9, 0x00},
  {0xD0, 0xAA, 0x00},
  {0xD0, 0xAB, 0x00},
  {0xD0, 0xAC, 0x00},
  {0xD0, 0xAD, 0x00},
  {0xD0, 0xAE, 0x00},
  {0xD0, 0xAF, 0x00},
  {0xD0, 0xB0, 0x00},
  {0xD0, 0xB1, 0x00},
  {0xD0, 0xB2, 0x00},
  {0xD0, 0xB3, 0x00},
  {0xD0, 0xB4, 0x00},
  {0xD0, 0xB5, 0x00},
  {0xD0, 0xB6, 0x00},
  {0xD0, 0xB7, 0x00},
  {0xD0, 0xB8, 0x00},
  {0xD0, 0xB9, 0x00},
  {0xD0, 0xBA, 0x00},
  {0xD0, 0xBB, 0x00},
  {0xD0, 0xBC, 0x00},
  {0xD0, 0xBD, 0x00},
  {0xD0, 0xBE, 0x00},
  {0xD0, 0xBF, 0x00},
  {0xD1, 0x80, 0x00},
  {0xD1, 0x81, 0x00},
  {0xD1, 0x82, 0x00},
  {0xD1, 0x83, 0x00},
  {0xD1, 0x84, 0x00},
  {0xD1, 0x85, 0x00},
  {0xD1, 0x86, 0x00},
  {0xD1, 0x87, 0x00},
  {0xD1, 0x88, 0x00},
  {0xD1, 0x89, 0x00},
  {0xD1, 0x8A, 0x00},
  {0xD1, 0x8B, 0x00},
  {0xD1, 0x8C, 0x00},
  {0xD1, 0x8D, 0x00},
  {0xD1, 0x8E, 0x00},
  {0xD1, 0x8F, 0x00},
};

/* Legacy Windows single-byte character set used in a lot of countries */
static const CPLCodePageConvTable CPL_CP1252_to_UTF8 = {
  {0xE2, 0x82, 0xAC},
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0x9A},
  {0xC6, 0x92, 0x00},
  {0xE2, 0x80, 0x9E},
  {0xE2, 0x80, 0xA6},
  {0xE2, 0x80, 0xA0},
  {0xE2, 0x80, 0xA1},
  {0xCB, 0x86, 0x00},
  {0xE2, 0x80, 0xB0},
  {0xC5, 0xA0, 0x00},
  {0xE2, 0x80, 0xB9},
  {0xC5, 0x92, 0x00},
  {0, 0, 0}, /* invalid */
  {0xC5, 0xBD, 0x00},
  {0, 0, 0}, /* invalid */
  {0, 0, 0}, /* invalid */
  {0xE2, 0x80, 0x98},
  {0xE2, 0x80, 0x99},
  {0xE2, 0x80, 0x9C},
  {0xE2, 0x80, 0x9D},
  {0xE2, 0x80, 0xA2},
  {0xE2, 0x80, 0x93},
  {0xE2, 0x80, 0x94},
  {0xCB, 0x9C, 0x00},
  {0xE2, 0x84, 0xA2},
  {0xC5, 0xA1, 0x00},
  {0xE2, 0x80, 0xBA},
  {0xC5, 0x93, 0x00},
  {0, 0, 0}, /* invalid */
  {0xC5, 0xBE, 0x00},
  {0xC5, 0xB8, 0x00},
  {0xC2, 0xA0, 0x00},
  {0xC2, 0xA1, 0x00},
  {0xC2, 0xA2, 0x00},
  {0xC2, 0xA3, 0x00},
  {0xC2, 0xA4, 0x00},
  {0xC2, 0xA5, 0x00},
  {0xC2, 0xA6, 0x00},
  {0xC2, 0xA7, 0x00},
  {0xC2, 0xA8, 0x00},
  {0xC2, 0xA9, 0x00},
  {0xC2, 0xAA, 0x00},
  {0xC2, 0xAB, 0x00},
  {0xC2, 0xAC, 0x00},
  {0xC2, 0xAD, 0x00},
  {0xC2, 0xAE, 0x00},
  {0xC2, 0xAF, 0x00},
  {0xC2, 0xB0, 0x00},
  {0xC2, 0xB1, 0x00},
  {0xC2, 0xB2, 0x00},
  {0xC2, 0xB3, 0x00},
  {0xC2, 0xB4, 0x00},
  {0xC2, 0xB5, 0x00},
  {0xC2, 0xB6, 0x00},
  {0xC2, 0xB7, 0x00},
  {0xC2, 0xB8, 0x00},
  {0xC2, 0xB9, 0x00},
  {0xC2, 0xBA, 0x00},
  {0xC2, 0xBB, 0x00},
  {0xC2, 0xBC, 0x00},
  {0xC2, 0xBD, 0x00},
  {0xC2, 0xBE, 0x00},
  {0xC2, 0xBF, 0x00},
  {0xC3, 0x80, 0x00},
  {0xC3, 0x81, 0x00},
  {0xC3, 0x82, 0x00},
  {0xC3, 0x83, 0x00},
  {0xC3, 0x84, 0x00},
  {0xC3, 0x85, 0x00},
  {0xC3, 0x86, 0x00},
  {0xC3, 0x87, 0x00},
  {0xC3, 0x88, 0x00},
  {0xC3, 0x89, 0x00},
  {0xC3, 0x8A, 0x00},
  {0xC3, 0x8B, 0x00},
  {0xC3, 0x8C, 0x00},
  {0xC3, 0x8D, 0x00},
  {0xC3, 0x8E, 0x00},
  {0xC3, 0x8F, 0x00},
  {0xC3, 0x90, 0x00},
  {0xC3, 0x91, 0x00},
  {0xC3, 0x92, 0x00},
  {0xC3, 0x93, 0x00},
  {0xC3, 0x94, 0x00},
  {0xC3, 0x95, 0x00},
  {0xC3, 0x96, 0x00},
  {0xC3, 0x97, 0x00},
  {0xC3, 0x98, 0x00},
  {0xC3, 0x99, 0x00},
  {0xC3, 0x9A, 0x00},
  {0xC3, 0x9B, 0x00},
  {0xC3, 0x9C, 0x00},
  {0xC3, 0x9D, 0x00},
  {0xC3, 0x9E, 0x00},
  {0xC3, 0x9F, 0x00},
  {0xC3, 0xA0, 0x00},
  {0xC3, 0xA1, 0x00},
  {0xC3, 0xA2, 0x00},
  {0xC3, 0xA3, 0x00},
  {0xC3, 0xA4, 0x00},
  {0xC3, 0xA5, 0x00},
  {0xC3, 0xA6, 0x00},
  {0xC3, 0xA7, 0x00},
  {0xC3, 0xA8, 0x00},
  {0xC3, 0xA9, 0x00},
  {0xC3, 0xAA, 0x00},
  {0xC3, 0xAB, 0x00},
  {0xC3, 0xAC, 0x00},
  {0xC3, 0xAD, 0x00},
  {0xC3, 0xAE, 0x00},
  {0xC3, 0xAF, 0x00},
  {0xC3, 0xB0, 0x00},
  {0xC3, 0xB1, 0x00},
  {0xC3, 0xB2, 0x00},
  {0xC3, 0xB3, 0x00},
  {0xC3, 0xB4, 0x00},
  {0xC3, 0xB5, 0x00},
  {0xC3, 0xB6, 0x00},
  {0xC3, 0xB7, 0x00},
  {0xC3, 0xB8, 0x00},
  {0xC3, 0xB9, 0x00},
  {0xC3, 0xBA, 0x00},
  {0xC3, 0xBB, 0x00},
  {0xC3, 0xBC, 0x00},
  {0xC3, 0xBD, 0x00},
  {0xC3, 0xBE, 0x00},
  {0xC3, 0xBF, 0x00},
};

/* Central Europe languages */
static const CPLCodePageConvTable CPL_ISO_8859_2_to_UTF8 = {
  {0xC2, 0x80, 0x00},
  {0xC2, 0x81, 0x00},
  {0xC2, 0x82, 0x00},
  {0xC2, 0x83, 0x00},
  {0xC2, 0x84, 0x00},
  {0xC2, 0x85, 0x00},
  {0xC2, 0x86, 0x00},
  {0xC2, 0x87, 0x00},
  {0xC2, 0x88, 0x00},
  {0xC2, 0x89, 0x00},
  {0xC2, 0x8A, 0x00},
  {0xC2, 0x8B, 0x00},
  {0xC2, 0x8C, 0x00},
  {0xC2, 0x8D, 0x00},
  {0xC2, 0x8E, 0x00},
  {0xC2, 0x8F, 0x00},
  {0xC2, 0x90, 0x00},
  {0xC2, 0x91, 0x00},
  {0xC2, 0x92, 0x00},
  {0xC2, 0x93, 0x00},
  {0xC2, 0x94, 0x00},
  {0xC2, 0x95, 0x00},
  {0xC2, 0x96, 0x00},
  {0xC2, 0x97, 0x00},
  {0xC2, 0x98, 0x00},
  {0xC2, 0x99, 0x00},
  {0xC2, 0x9A, 0x00},
  {0xC2, 0x9B, 0x00},
  {0xC2, 0x9C, 0x00},
  {0xC2, 0x9D, 0x00},
  {0xC2, 0x9E, 0x00},
  {0xC2, 0x9F, 0x00},
  {0xC2, 0xA0, 0x00},
  {0xC4, 0x84, 0x00},
  {0xCB, 0x98, 0x00},
  {0xC5, 0x81, 0x00},
  {0xC2, 0xA4, 0x00},
  {0xC4, 0xBD, 0x00},
  {0xC5, 0x9A, 0x00},
  {0xC2, 0xA7, 0x00},
  {0xC2, 0xA8, 0x00},
  {0xC5, 0xA0, 0x00},
  {0xC5, 0x9E, 0x00},
  {0xC5, 0xA4, 0x00},
  {0xC5, 0xB9, 0x00},
  {0xC2, 0xAD, 0x00},
  {0xC5, 0xBD, 0x00},
  {0xC5, 0xBB, 0x00},
  {0xC2, 0xB0, 0x00},
  {0xC4, 0x85, 0x00},
  {0xCB, 0x9B, 0x00},
  {0xC5, 0x82, 0x00},
  {0xC2, 0xB4, 0x00},
  {0xC4, 0xBE, 0x00},
  {0xC5, 0x9B, 0x00},
  {0xCB, 0x87, 0x00},
  {0xC2, 0xB8, 0x00},
  {0xC5, 0xA1, 0x00},
  {0xC5, 0x9F, 0x00},
  {0xC5, 0xA5, 0x00},
  {0xC5, 0xBA, 0x00},
  {0xCB, 0x9D, 0x00},
  {0xC5, 0xBE, 0x00},
  {0xC5, 0xBC, 0x00},
  {0xC5, 0x94, 0x00},
  {0xC3, 0x81, 0x00},
  {0xC3, 0x82, 0x00},
  {0xC4, 0x82, 0x00},
  {0xC3, 0x84, 0x00},
  {0xC4, 0xB9, 0x00},
  {0xC4, 0x86, 0x00},
  {0xC3, 0x87, 0x00},
  {0xC4, 0x8C, 0x00},
  {0xC3, 0x89, 0x00},
  {0xC4, 0x98, 0x00},
  {0xC3, 0x8B, 0x00},
  {0xC4, 0x9A, 0x00},
  {0xC3, 0x8D, 0x00},
  {0xC3, 0x8E, 0x00},
  {0xC4, 0x8E, 0x00},
  {0xC4, 0x90, 0x00},
  {0xC5, 0x83, 0x00},
  {0xC5, 0x87, 0x00},
  {0xC3, 0x93, 0x00},
  {0xC3, 0x94, 0x00},
  {0xC5, 0x90, 0x00},
  {0xC3, 0x96, 0x00},
  {0xC3, 0x97, 0x00},
  {0xC5, 0x98, 0x00},
  {0xC5, 0xAE, 0x00},
  {0xC3, 0x9A, 0x00},
  {0xC5, 0xB0, 0x00},
  {0xC3, 0x9C, 0x00},
  {0xC3, 0x9D, 0x00},
  {0xC5, 0xA2, 0x00},
  {0xC3, 0x9F, 0x00},
  {0xC5, 0x95, 0x00},
  {0xC3, 0xA1, 0x00},
  {0xC3, 0xA2, 0x00},
  {0xC4, 0x83, 0x00},
  {0xC3, 0xA4, 0x00},
  {0xC4, 0xBA, 0x00},
  {0xC4, 0x87, 0x00},
  {0xC3, 0xA7, 0x00},
  {0xC4, 0x8D, 0x00},
  {0xC3, 0xA9, 0x00},
  {0xC4, 0x99, 0x00},
  {0xC3, 0xAB, 0x00},
  {0xC4, 0x9B, 0x00},
  {0xC3, 0xAD, 0x00},
  {0xC3, 0xAE, 0x00},
  {0xC4, 0x8F, 0x00},
  {0xC4, 0x91, 0x00},
  {0xC5, 0x84, 0x00},
  {0xC5, 0x88, 0x00},
  {0xC3, 0xB3, 0x00},
  {0xC3, 0xB4, 0x00},
  {0xC5, 0x91, 0x00},
  {0xC3, 0xB6, 0x00},
  {0xC3, 0xB7, 0x00},
  {0xC5, 0x99, 0x00},
  {0xC5, 0xAF, 0x00},
  {0xC3, 0xBA, 0x00},
  {0xC5, 0xB1, 0x00},
  {0xC3, 0xBC, 0x00},
  {0xC3, 0xBD, 0x00},
  {0xC5, 0xA3, 0x00},
  {0xCB, 0x99, 0x00},
};

/* New Western Europe */
static const CPLCodePageConvTable CPL_ISO_8859_15_to_UTF8 = {
  {0xC2, 0x80, 0x00},
  {0xC2, 0x81, 0x00},
  {0xC2, 0x82, 0x00},
  {0xC2, 0x83, 0x00},
  {0xC2, 0x84, 0x00},
  {0xC2, 0x85, 0x00},
  {0xC2, 0x86, 0x00},
  {0xC2, 0x87, 0x00},
  {0xC2, 0x88, 0x00},
  {0xC2, 0x89, 0x00},
  {0xC2, 0x8A, 0x00},
  {0xC2, 0x8B, 0x00},
  {0xC2, 0x8C, 0x00},
  {0xC2, 0x8D, 0x00},
  {0xC2, 0x8E, 0x00},
  {0xC2, 0x8F, 0x00},
  {0xC2, 0x90, 0x00},
  {0xC2, 0x91, 0x00},
  {0xC2, 0x92, 0x00},
  {0xC2, 0x93, 0x00},
  {0xC2, 0x94, 0x00},
  {0xC2, 0x95, 0x00},
  {0xC2, 0x96, 0x00},
  {0xC2, 0x97, 0x00},
  {0xC2, 0x98, 0x00},
  {0xC2, 0x99, 0x00},
  {0xC2, 0x9A, 0x00},
  {0xC2, 0x9B, 0x00},
  {0xC2, 0x9C, 0x00},
  {0xC2, 0x9D, 0x00},
  {0xC2, 0x9E, 0x00},
  {0xC2, 0x9F, 0x00},
  {0xC2, 0xA0, 0x00},
  {0xC2, 0xA1, 0x00},
  {0xC2, 0xA2, 0x00},
  {0xC2, 0xA3, 0x00},
  {0xE2, 0x82, 0xAC},
  {0xC2, 0xA5, 0x00},
  {0xC5, 0xA0, 0x00},
  {0xC2, 0xA7, 0x00},
  {0xC5, 0xA1, 0x00},
  {0xC2, 0xA9, 0x00},
  {0xC2, 0xAA, 0x00},
  {0xC2, 0xAB, 0x00},
  {0xC2, 0xAC, 0x00},
  {0xC2, 0xAD, 0x00},
  {0xC2, 0xAE, 0x00},
  {0xC2, 0xAF, 0x00},
  {0xC2, 0xB0, 0x00},
  {0xC2, 0xB1, 0x00},
  {0xC2, 0xB2, 0x00},
  {0xC2, 0xB3, 0x00},
  {0xC5, 0xBD, 0x00},
  {0xC2, 0xB5, 0x00},
  {0xC2, 0xB6, 0x00},
  {0xC2, 0xB7, 0x00},
  {0xC5, 0xBE, 0x00},
  {0xC2, 0xB9, 0x00},
  {0xC2, 0xBA, 0x00},
  {0xC2, 0xBB, 0x00},
  {0xC5, 0x92, 0x00},
  {0xC5, 0x93, 0x00},
  {0xC5, 0xB8, 0x00},
  {0xC2, 0xBF, 0x00},
  {0xC3, 0x80, 0x00},
  {0xC3, 0x81, 0x00},
  {0xC3, 0x82, 0x00},
  {0xC3, 0x83, 0x00},
  {0xC3, 0x84, 0x00},
  {0xC3, 0x85, 0x00},
  {0xC3, 0x86, 0x00},
  {0xC3, 0x87, 0x00},
  {0xC3, 0x88, 0x00},
  {0xC3, 0x89, 0x00},
  {0xC3, 0x8A, 0x00},
  {0xC3, 0x8B, 0x00},
  {0xC3, 0x8C, 0x00},
  {0xC3, 0x8D, 0x00},
  {0xC3, 0x8E, 0x00},
  {0xC3, 0x8F, 0x00},
  {0xC3, 0x90, 0x00},
  {0xC3, 0x91, 0x00},
  {0xC3, 0x92, 0x00},
  {0xC3, 0x93, 0x00},
  {0xC3, 0x94, 0x00},
  {0xC3, 0x95, 0x00},
  {0xC3, 0x96, 0x00},
  {0xC3, 0x97, 0x00},
  {0xC3, 0x98, 0x00},
  {0xC3, 0x99, 0x00},
  {0xC3, 0x9A, 0x00},
  {0xC3, 0x9B, 0x00},
  {0xC3, 0x9C, 0x00},
  {0xC3, 0x9D, 0x00},
  {0xC3, 0x9E, 0x00},
  {0xC3, 0x9F, 0x00},
  {0xC3, 0xA0, 0x00},
  {0xC3, 0xA1, 0x00},
  {0xC3, 0xA2, 0x00},
  {0xC3, 0xA3, 0x00},
  {0xC3, 0xA4, 0x00},
  {0xC3, 0xA5, 0x00},
  {0xC3, 0xA6, 0x00},
  {0xC3, 0xA7, 0x00},
  {0xC3, 0xA8, 0x00},
  {0xC3, 0xA9, 0x00},
  {0xC3, 0xAA, 0x00},
  {0xC3, 0xAB, 0x00},
  {0xC3, 0xAC, 0x00},
  {0xC3, 0xAD, 0x00},
  {0xC3, 0xAE, 0x00},
  {0xC3, 0xAF, 0x00},
  {0xC3, 0xB0, 0x00},
  {0xC3, 0xB1, 0x00},
  {0xC3, 0xB2, 0x00},
  {0xC3, 0xB3, 0x00},
  {0xC3, 0xB4, 0x00},
  {0xC3, 0xB5, 0x00},
  {0xC3, 0xB6, 0x00},
  {0xC3, 0xB7, 0x00},
  {0xC3, 0xB8, 0x00},
  {0xC3, 0xB9, 0x00},
  {0xC3, 0xBA, 0x00},
  {0xC3, 0xBB, 0x00},
  {0xC3, 0xBC, 0x00},
  {0xC3, 0xBD, 0x00},
  {0xC3, 0xBE, 0x00},
  {0xC3, 0xBF, 0x00},
};


const CPLCodePageConvTable* CPLGetConversionTableToUTF8(const char* pszEncoding)
{
    if (EQUAL(pszEncoding, "CP437"))
        return &CPL_CP437_to_UTF8;
    if (EQUAL(pszEncoding, "CP1250"))
        return &CPL_CP1250_to_UTF8;
    if (EQUAL(pszEncoding, "CP1251"))
        return &CPL_CP1251_to_UTF8;
    if (EQUAL(pszEncoding, "CP1252"))
        return &CPL_CP1252_to_UTF8;
    if (EQUAL(pszEncoding, "ISO-8859-2"))
        return &CPL_ISO_8859_2_to_UTF8;
    if (EQUAL(pszEncoding, "ISO-8859-15"))
        return &CPL_ISO_8859_15_to_UTF8;
    return CPL_NULLPTR;
}

/* clang-format on */
