//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2023-01-01/examples/ListTopLevelDomains.json
func ExampleTopLevelDomainsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTopLevelDomainsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TopLevelDomainCollection = armappservice.TopLevelDomainCollection{
		// 	Value: []*armappservice.TopLevelDomain{
		// 		{
		// 			Name: to.Ptr("com"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/com"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("net"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/net"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("co.uk"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/co.uk"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(false),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("org"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/org"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("nl"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/nl"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("in"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/in"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(false),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("biz"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/biz"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(true),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("org.uk"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/org.uk"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(false),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("co.in"),
		// 			Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/co.in"),
		// 			Properties: &armappservice.TopLevelDomainProperties{
		// 				Privacy: to.Ptr(false),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2023-01-01/examples/GetTopLevelDomain.json
func ExampleTopLevelDomainsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTopLevelDomainsClient().Get(ctx, "com", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TopLevelDomain = armappservice.TopLevelDomain{
	// 	Name: to.Ptr("com"),
	// 	Type: to.Ptr("Microsoft.DomainRegistration/topLevelDomains"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.DomainRegistration/topLevelDomains/com"),
	// 	Properties: &armappservice.TopLevelDomainProperties{
	// 		Privacy: to.Ptr(true),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2023-01-01/examples/ListTopLevelDomainAgreements.json
func ExampleTopLevelDomainsClient_NewListAgreementsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTopLevelDomainsClient().NewListAgreementsPager("in", armappservice.TopLevelDomainAgreementOption{
		ForTransfer:    to.Ptr(false),
		IncludePrivacy: to.Ptr(true),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TldLegalAgreementCollection = armappservice.TldLegalAgreementCollection{
		// 	Value: []*armappservice.TldLegalAgreement{
		// 		{
		// 			AgreementKey: to.Ptr("DNRA"),
		// 			Content: to.Ptr("<table width=\"100%\">\n<tbody>\n<tr><td width=\"100\"></td><td></td></tr>\n<tr><td></td><td>\n<table>\n<tbody>\n<tr><th align=\"left\" class=\"EULATitle\">\nDomain Name Registration Agreement\n</th></tr>\n<tr><td class=\"bodyText\">\n<p><strong>Last Revised: October 6, 2017</strong></p>\n<p style=\"text-align: justify;\"><strong>PLEASE READ THIS AGREEMENT CAREFULLY, AS IT CONTAINS IMPORTANT INFORMATION REGARDING YOUR LEGAL RIGHTS AND REMEDIES.</strong></p>\r\n<p style=\"text-align: justify;\"><strong>1. OVERVIEW</strong></p>\r\n<p style=\"text-align: justify;\">This Domain Name Registration Agreement (this \"<span style=\"text-decoration: underline;\">Agreement</span>\") is entered into by and between 510456, an individual (\"<span style=\"text-decoration: underline;\">Azure</span>\") and you, and is made effective as of the date of electronic acceptance.&nbsp; This Agreement sets forth the terms and conditions of your use of Azure's Domain Name Registration services (the \"<span style=\"text-decoration: underline;\">Domain Name Registration Services</span>\" or the \"<span style=\"text-decoration: underline;\">Services</span>\").&nbsp;The terms \"we\", \"us\" or \"our\" shall refer to Azure.&nbsp; The terms \"you\", \"your\", \"User\" or \"customer\" shall refer to any individual or entity who accepts this Agreement.&nbsp; Unless otherwise specified, nothing in this Agreement shall be deemed to confer any third-party rights or benefits.</p>\r\n<p style=\"text-align: justify;\">Your electronic acceptance of this Agreement signifies that you have read, understand, acknowledge and agree to be bound by this Agreement, which incorporates by reference each of&nbsp;(i) Azure&rsquo;s&nbsp;<a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=utos&amp;prog_id=510456\" target=\"_blank\">Universal Terms of Service Agreement</a> (\"<span style=\"text-decoration: underline;\">UTOS</span>\"),&nbsp;(ii) all agreements, guidelines, policies, practices, procedures, registration requirements or operational standards of the top-level domain (\"<span style=\"text-decoration: underline;\">TLD</span>\")&nbsp;in which you register any domain (&ldquo;<span style=\"text-decoration: underline;\">Registry Policies</span>&rdquo;),&nbsp;and (iii) any plan limits, product disclaimers or other restrictions presented to you on the Domain Name Registration Services landing page of the Azure website (this &ldquo;<span style=\"text-decoration: underline;\">Site</span>&rdquo;).&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>TO&nbsp;LINK TO AND REVIEW THE REGISTRY POLICIES FOR THE TLD IN WHICH YOU WISH TO REGISTER A DOMAIN NAME, PLEASE CLICK&nbsp;<span style=\"text-decoration: underline;\"><a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=20012&amp;prog_id=510456\" target=\"_blank\">HERE</a></span>.&nbsp;</strong>&nbsp;&nbsp;&nbsp;</p>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that (i) Azure, in its sole and absolute discretion, may change or modify this Agreement, and any policies or agreements which are incorporated herein, at any time, and such changes or modifications shall be effective immediately upon posting to this Site, and (ii) your use of this Site or the Services found at this Site after such changes or modifications have been made&nbsp;shall constitute your acceptance of this Agreement as last revised.&nbsp; If you do not agree to be bound by this Agreement as last revised, do not use (or continue to use) this Site or the Services found at this Site.&nbsp; In addition, Azure may occasionally notify you of changes or modifications to this Agreement by email.&nbsp; It is therefore very important that you keep your shopper account (&ldquo;<span style=\"text-decoration: underline;\">Shopper Account</span>&rdquo;) information, including your email address, current.&nbsp; Azure assumes no liability or responsibility for your failure to receive an email notification if such failure results from an inaccurate or out-of-date email address.&nbsp; &nbsp;  Azure is not an Internet Corporation for Assigned Names and Numbers (\"<span style=\"text-decoration: underline;\">ICANN</span>\") accredited registrar; it is an authorized reseller of domain name registration services.&nbsp; Accordingly, you acknowledge and agree that Azure may modify this Agreement in order to comply with any terms and conditions set forth by (i) the sponsoring registrar, (ii) ICANN, and/or (iii) the registry applicable to the&nbsp;TLD or country code top level domain (\"<span style=\"text-decoration: underline;\">ccTLD</span>\") in question. &nbsp;As used herein, the terms \"registry\", \"Registry\", \"registry operator\" or \"Registry Operator\" shall refer to the registry applicable to the TLD or ccTLD in question.&nbsp; To identify the sponsoring registrar, click&nbsp;<a href=\"http://www.internic.net/whois.html\" target=\"_blank\">here</a>.&nbsp; </p>\r\n<p style=\"text-align: justify;\"><strong>2. PROVISIONS SPECIFIC TO ALL REGISTRATIONS</strong></p>\r\n<p style=\"text-align: justify;\"><strong><em>Unless otherwise noted, the provisions below in this Section 2 are generally applicable to all TLDs that we offer.&nbsp; Special provisions specific to any TLD or ccTLD (those in addition to posted Registry Policies) are identified elsewhere below in this Agreement.&nbsp;</em></strong></p>\r\n<ol>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Registry Policies</span></em>. You agree to be bound by all Registry Policies (defined above in this Agreement) applicable to your domain name registration (at any level).<strong>&nbsp;IT IS YOUR RESPONSIBILITY TO VISIT THE APPLICABLE TLD SITE AND READ AND REVIEW ALL APPLICABLE REGISTRY POLICIES PRIOR TO YOUR REGISTRATION IN THE TLD.&nbsp; REGISTRY POLICIES FOR EACH TLD CAN BE FOUND BY VISITING THE CORRESPONDING TLD LINK LISTED&nbsp;</strong><a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=20012&amp;prog_id=510456\" target=\"_blank\">HERE</a>.&nbsp;&nbsp;Notwithstanding anything in this Agreement to the contrary, the Registry Operator of the TLD in which the domain name registration is made is and shall be an intended third party beneficiary of this Agreement. As such the parties to this agreement acknowledge and agree that the third party beneficiary rights of the Registry Operator have vested and that the Registry Operator has relied on its third party beneficiary rights under this Agreement in agreeing to Azure being a registrar for the respective TLD. The third party beneficiary rights of the Registry Operator will survive any termination of this Agreement.&nbsp;&nbsp;&nbsp;&nbsp;</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Registration Requirements</span></em>.&nbsp; To the extent any TLD or ccTLD requires you meet eligibility (e.g., residency for .JP, .EU, etc.), validation (e.g., DNS validation) or other authentication requirements as a condition to registering a domain name in the TLD, you agree that by submitting an application or registering or renewing your domain name, you represent and warrant that: (a) all information provided to register or renew the domain name (including all supporting documents, if any) is true, complete and correct, and is not misleading in any way, and the application is made in good faith; (b) you meet, and will continue to meet, the eligibility criteria prescribed in the Registry Policies for the applicable TLD for the duration of the domain name registration; (c) you have not previously submitted an application for the domain name with another registrar using the same eligibility criteria, and the other registrar has rejected the application (if applicable); (d) you acknowledge and agree that even if the domain name is accepted for registration, your entitlement to register the domain name may be challenged by others who claim to have an entitlement to the domain name; and (e) you acknowledge and agree that the Registry or the registrar can cancel the registration of the domain name if any of the warranties required are found to be untrue, incomplete, incorrect or misleading.</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Ownership</span></em>.&nbsp; You acknowledge and agree that registration of a domain name does not create any proprietary right for you, the registrar, or any other person in the name used as a domain name or the domain name registration and that the entry of a domain name in the Registry shall not be construed as evidence or ownership of the domain name registered as a domain name. You shall not in any way transfer or purport to transfer a proprietary right in any domain name registration or grant or purport to grant as security or in any other manner encumber or purport to encumber a domain name registration.</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">ICANN Requirements</span></em>. You agree to comply with the ICANN requirements, standards, policies, procedures, and practices for which each applicable Registry Operator has monitoring responsibility in accordance with the Registry Agreement between ICANN and itself or any other arrangement with ICANN.</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Indemnification of Registry</span></em>.&nbsp; You agree to indemnify, defend and hold harmless (within 30 days of demand) the Registry Operator and Registry Service Provider and their subcontractors, subsidiaries, affiliates, divisions, shareholders, directors, officers, employees, accountants, attorneys, insurers, agents, predecessors, successors and assigns, from and against any and all claims, demands, damages, losses, costs, expenses, causes of action or other liabilities of any kind, whether known or unknown, including reasonable legal and attorney&rsquo;s fees and expenses, in any way arising out of, relating to, or otherwise in connection with the your domain name registration, including, without limitation, the use, registration, extension, renewal, deletion, and/or transfer thereof and/or the violation of any applicable terms or conditions governing the registration. You shall not enter into any settlement or compromise of any such indemnifiable claim without Registrar&rsquo;s or Registry Operator&rsquo;s prior written consent, which consent shall not be unreasonably withheld, and you agree that these indemnification obligations shall survive the termination or expiration of the Agreement for any reason.&nbsp; IN NO EVENT SHALL THE REGISTRY OPERATOR BE LIABLE TO YOU OR ANY OTHER PERSON FOR ANY DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, SPECIAL, EXEMPLARY OR PUNITIVE DAMAGES, INCLUDING LOSS OF PROFIT OR GOODWILL, FOR ANY MATTER, WHETHER SUCH LIABILITY IS ASSERTED ON THE BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF WARRANTIES, EITHER EXPRESS OR IMPLIED, ANY BREACH OF THIS AGREEMENT OR ITS INCORPORATED AGREEMENTS AND POLICIES YOUR INABILITY TO USE THE DOMAIN NAME, YOUR LOSS OF DATA OR FILES OR OTHERWISE, EVEN IF THE REGISTRY OPERATOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Regulated TLDs</span></em>.&nbsp;&nbsp; For domain name registration in any &ldquo;Regulated&rdquo; TLD, you acknowledge and agree your registration is subject to the following additional requirements: (a) comply with all applicable laws, including those that relate to privacy, data collection, consumer protection (including in relation to misleading and deceptive conduct), fair lending, debt collection, organic farming, disclosure of data, and financial disclosures; (b) if you collect and maintain sensitive health and financial data you must implement reasonable and appropriate security measures commensurate with the offering of those services, as defined by applicable law.&nbsp; Regulated TLDs include: <strong><em>.games, .juegos, .school, .schule, .toys, .eco, .care, .diet, .fitness, .health, .clinic, .dental, .healthcare, .cash, .broker, .claims, .exchange, .finance, .financial, .fund, .investments, .lease, .loans, .market, .money, .trading, .credit, .insure, .tax, .mortgage, .degree, .mba, .audio, .book, .broadway, .film, .movie, .music, .software, .fashion, .video, .app, .art, .band, .cloud, .data, .digital, .fan, .free, .gratis, .discount, .sale, .media, .news, .online, .pictures, .radio, .show, .theater, .tours, .accountants, .architect, .associates, .broker, .legal, .realty, .vet, .engineering, .law, .limited, .show; .theater; .town, .city, .reise, and .reisen</em></strong></div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Highly Regulated TLDs</span></em>. In addition to the requirements for Regulated TLDs, domain name registration in any Highly-Regulated TLD is subject to the following requirements: (a) you will provide administrative contact information, which must be kept up&#8208;to&#8208;date, for the notification of complaints or reports of registration abuse, as well as the contact details of the relevant regulatory, or Industry self&#8208;regulatory, bodies in their main place of business; (b) you represent that you possess any necessary authorizations, charters, licenses and/or other related credentials for participation in the sector associated with such Highly&#8208;regulated TLD; and (c) you will report any material changes to the validity of you authorizations, charters, licenses and/or other related credentials for participation in the sector associated with the Highly&#8208;regulated TLD to ensure you continue to conform to the appropriate regulations and licensing requirements and generally conduct your activities in the interests of the consumers they serve.&nbsp; Highly Regulated TLDs include: <strong><strong><em>.abogado, .attorney, .bank, .bet, .bingo, .casino .charity (and IDN equivalent xn--30rr7y), .cpa, .corp, creditcard, .creditunion .dds, .dentist, .doctor, .fail, .gmbh, .gripe, .hospital, .inc, .insurance, .lawyer, .lifeinsurance, .llc, .llp, .ltda, .medical, .mutuelle, .pharmacy, .poker, .university, .sarl, .spreadbetting, .srl, .surgery .university, .vermogensberater, and .vesicherung,&nbsp; </em></strong></strong><em><span style=\"background: white; color: black; font-family: 'Arial',sans-serif; font-size: 10pt; font-style: normal;\">For .doctor, registrants who hold themselves out to be licensed medical practitioners must be able to demonstrate to the Registrar and Registry, upon request, that they hold the applicable license.</span></em></div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Special Safeguard TLDs</span></em>.&nbsp; In addition to the requirements for Regulated and Highly-Regulated TLDs, by registering a domain name in any &ldquo;Special-Safeguard&rdquo; TLD, you agree to take reasonable steps to avoid misrepresenting or falsely implying that you or your business is affiliated with, sponsored or endorsed by one or more country's or government's military forces if such affiliation, sponsorship or endorsement does not exist.&nbsp; Special Safeguard TLDs include:&nbsp; <strong><em>.army, .navy, .airforce</em></strong></div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Third Party Beneficiary</span></em>.&nbsp; Notwithstanding anything in this Agreement to the contrary, the Registry Operator for any TLD in which your register a domain name is and shall be an intended third party beneficiary of this Agreement. As such the parties to this agreement acknowledge and agree that the third party beneficiary rights of the Registry Operator have vested and that the Registry Operator has relied on its third party beneficiary rights under this Agreement in agreeing to Azure being a registrar for the TLD. Third party beneficiary rights of the Registry Operator shall survive any termination of this Agreement.</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Variable and Non-Uniform Pricing</span></em>.&nbsp; You acknowledge, understand and agree that certain domain names in certain TLDs are established by Registry Policies to be variably priced (i.e., standard v. premium names) and/or may have non-uniform renewal registration pricing (such that the Fee for a domain name registration renewal may differ from other domain names in the same TLD, e.g., renewal registration for one domain may be $100.00 and $33.00 for a different domain name).</div>\r\n</li>\r\n<li>\r\n<div style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Restriction on Availability of Privacy or Proxy</span></em>.&nbsp; You acknowledge and agree that, as dictated by the Registry Policies, for certain TLDs you may not be permitted to purchase private or proxy TLD registrations. In such case, you must register for any and all TLD registrations using your personal information, which information you represent and warrant is current, accurate and complete.</div>\r\n</li>\r\n</ol>\r\n<p style=\"text-align: justify;\"><strong>3. FEES AND PAYMENTS</strong></p>\r\n<p style=\"text-align: justify;\"><strong><em>(A) GENERAL TERMS, INCLUDING AUTOMATIC RENEWAL TERMS</em></strong></p>\r\n<p style=\"text-align: justify;\">You agree to pay any and all prices and fees due for Services purchased or obtained at this Site at the time you order the Services.&nbsp; Azure expressly reserves the right to change or modify its prices and fees at any time, and such changes or modifications shall be posted online at this Site and effective immediately without need for further notice to you.&nbsp; If you have purchased or obtained Services for a period of months or years, changes or modifications in prices and fees shall be effective when the Services in question come up for renewal as further described below.&nbsp;</p>\r\n<p style=\"text-align: justify;\">Unless otherwise specifically noted (for reasons such as those highlighted&nbsp;in Section 2(x) above), the renewal price for any domain name in any TLD will be the same as the list (non-sale) price shown when you search for and select a domain, and again in the cart prior to purchase.&nbsp; For example, if the list price is $9.99, and a different renewal price is not specifically identified, then the renewal price is also $9.99<strong></strong>.&nbsp; Likewise, if a domain name has a&nbsp;sale price of $8.99, with the list&nbsp;(non-sale) price&nbsp;shown (as a strike-through)&nbsp;at $9.99, the renewal price will be&nbsp;$9.99<strong>*</strong>.&nbsp;&nbsp;</p>\r\n<p style=\"text-align: justify;\"><span style=\"font-size: xx-small;\"><em><strong>*Renewal price&nbsp;subject to change prior to actual date of renewal.&nbsp; </strong></em></span></p>\r\n<p style=\"text-align: justify;\">For all other terms and conditions relating to&nbsp;fees, payment, refund and billing, etc. applicable to the Services offered under the scope of this Agreement, please refer to the &ldquo;Fees and Payments&rdquo; section of our&nbsp;<a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=utos&amp;prog_id=510456\" target=\"_blank\"><span style=\"text-decoration: underline;\"><span style=\"color: #0066cc;\">UTOS</span></span></a>.&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong><em>(B) DOMAIN NAME RENEWAL TERMS</em></strong></p>\r\n<p style=\"text-align: justify;\">When you register a domain name, you will have two&nbsp;renewal options: (i) \"<span style=\"text-decoration: underline;\">Automatic Renewal</span>\"&nbsp;(ii) \"<span style=\"text-decoration: underline;\">Extended Automatic Renewal</span>\", and (iii) \"<span style=\"text-decoration: underline;\">Manual Renewal</span>\":&nbsp;</p>\r\n<ol style=\"text-align: justify;\">\r\n<li><span style=\"text-decoration: underline;\">Automatic Renewal</span>.&nbsp; Automatic Renewal is the default setting. Therefore, unless you select&nbsp;Extended Automatic Renewal, Azure will enroll you in&nbsp;Automatic Renewal.&nbsp;&nbsp;Domain names will automatically renew, for a period equivalent to the length of your original domain name registration, any domain name that is up for renewal and will take payment from the Payment Method you have on file with Azure, at Azure's then current rates. Thus, if you have chosen to register your domain name for one (1) year, Azure will automatically renew it for one (1) year. If you have chosen to register your domain name for two (2) years, Azure will automatically renew it for two (2) years, and so on.</li>\r\n<li><span style=\"text-decoration: underline;\">Extended Automatic Renewal</span>.&nbsp; If you enroll in the Extended Automatic Renewal plan, Azure will automatically renew any domain name that is up for renewal for an additional one-year period on each and every anniversary of your domain name registration, so the initial registration period will always remain intact.&nbsp; Thus, if you have chosen to register your domain name for two (2) years, Azure will automatically renew it for one (1) additional year on each and every anniversary of your domain name registration so your two (2) year registration period will always remain intact. If you have chosen to register your domain name for five (5) years, Azure will automatically renew it for one (1) additional year on each and every anniversary of your domain name registration so your five (5) year registration period will always remain intact, and so on.&nbsp; Azure will take payment from the Payment Method you have on file with Azure, at Azure's then current one-year domain name registration rate.</li>\r\n<li><span style=\"text-decoration: underline;\">Manual Renewal</span>.&nbsp; If you have elected to turn off automatic renewal and cancel the product (i.e., cancel&nbsp;the domain name registration) effective at expiration of the then current term, you may nonetheless elect to manually renew the domain name at anytime prior to its&nbsp;expiration date&nbsp;by&nbsp;logging into&nbsp;your <a href=\"https://www.securepaynet.net/gdshop/shopper_lookup.asp?prog_id=510456\" target=\"_blank\">Account Manager</a>&nbsp;and manually implementing the renewal or by calling customer service (should you in fact want the domain name to be renewed). If you fail to manually implement the renewal before the expiration date, the domain name will be cancelled and you will no longer have use of that name.</li>\r\n</ol>\r\n<p style=\"text-align: justify;\">All renewals will be subject to the terms of this Agreement, as it may be amended from time to time, and you acknowledge and agree to be bound by the terms of this Agreement (as amended) for all renewed domains.&nbsp; Domain name renewals will be non-refundable. <span style=\"color: #5b9bd5; font-family: 'Arial',sans-serif; font-size: 10pt; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; mso-ansi-language: EN-US; mso-fareast-language: EN-US; mso-bidi-language: AR-SA; mso-themecolor: accent1;\"><span style=\"color: #000000;\">In the event that we are unable to automatically renew your domain name for the renewal option selected for any reason, we may automatically renew your domain name for a period less than your original registration period to the extent necessary for the transaction to succeed.</span> </span>If for any reason Azure is not able to take the payment from the Payment Method you have on file, and you fail to respond to our notices, your domain name registration will expire. It is your responsibility to keep your Payment Method information current, which includes the expiration date if you are using a credit card.</p>\r\n<p style=\"text-align: justify;\">For certain ccTLDs (.am, .at, .be, .br, .ca, .cn, .com.cn, .net.cn, .org.cn, .de, .eu, .fm, .gs, .it, .jp, .ms, .nu, .nz, .co.nz, .net.nz, .org.nz, .tc, .tk, .tw, .com.tw, .org.tw, .idv.tw, .uk,&nbsp;and .vg), renewal billing will occur on the first day of the month prior to the month of expiration.</p>\r\n<p style=\"text-align: justify;\">For certain ccTLDs (.am, .at, .be, .ca, .cn, .com.cn, .net.cn, .org.cn, .de, .eu, .fm, .gs, .it, .jp, .ms, .nu, .nz, .co.nz, .net.nz, .org.nz, .tc, .tk, .tw, .com.tw, .org.tw, .idv.tw, .uk,&nbsp;and .vg),&nbsp;renewal will occur, or must occur manually if the product was previously cancelled, no later than the 20th of the month prior to the expiration date, or your domain name will be placed in non-renewal status. For some ccTLDs (.es) renewal&nbsp;must be processed&nbsp;no later than seven days before the expiration date, or your domain name will be placed in non-renewal status.&nbsp; When the domain name is in non-renewal status, you can renew the domain name only by calling Azure and requesting that the domain name be renewed. You cannot renew the domain name through your <a href=\"https://www.securepaynet.net/gdshop/shopper_lookup.asp?prog_id=510456\" target=\"_blank\">Account Manager</a>. If you fail to manually implement the renewal of any cancelled product before the expiration date, the domain name will be cancelled and you will no longer have use of that name.</p>\r\n<p style=\"text-align: justify;\">You agree that Azure will not be responsible for cancelled domain names that you fail to renew in the timeframes indicated in this Agreement. In any case, if you fail to renew your domain name in a timely fashion, additional charges may apply. If you signed up for privacy services, protected registration, or any other similar service, with your domain name registration, these services will automatically be renewed when your domain name registration is up for renewal, and you will incur the applicable additional renewal fee unless you cancel in advance.&nbsp;</p>\r\n<p style=\"text-align: justify;\">If you fail to renew your domain name in the timeframes indicated in this Agreement, you agree that Azure may, in its sole discretion, renew your expired domain name on your behalf. If Azure decides to renew your expired domain name on your behalf, you will have a Renewal Grace Period during which you may reimburse Azure for the renewal and keep your domain name. The Renewal Grace Period is currently twelve (12) days but subject to change under the terms of this Agreement. For certain ccTLDs (.am, .at, .be, .cn, .com.cn, .net.cn, .org.cn, .de, .eu, .fm, .gs, .it, .jp, .ms, .nu, .nz, .co.nz, .net.nz, .org.nz, .tc, .tk, .tw, .com.tw, .org.tw, .idv.tw, .uk,&nbsp;and .vg) there is no Renewal Grace Period after the expiration date of the domain name. If you do not reimburse Azure for the renewal during the Renewal Grace Period your domain name will be placed on Hold and flagged for deletion after which you will have a 30-day redemption period during which you may pay Azure a Redemption fee and redeem your domain name. The Redemption fee is currently $80.00 USD and is subject to change under the terms of this Agreement. If you do not redeem your domain name prior to the end of the 30-day redemption period Azure may, in its sole discretion, delete your domain name or transfer it to another registrant on your behalf.&nbsp; During the redemption period your domain name may be parked.&nbsp;</p>\r\n<p style=\"text-align: justify;\">If your domain name is deleted, the Registry also provides a 30-day Redemption Grace Period during which you may pay Azure a redemption fee and redeem your domain name. The redemption fee is currently $80.00 USD and is subject to change under the terms of this Agreement. If you do not redeem your domain name prior to the end of the Registry's Redemption Grace Period the Registry will release your name and it will become available for registration on a first-come-first-served basis.</p>\r\n<p style=\"text-align: justify;\">Renewal Grace Periods and Redemption Grace Periods vary for different ccTLDs. Please refer to the specific terms for the applicable TLD. In the event there is a conflict between the provisions of this paragraph and the ccTLD terms, the ccTLD terms shall control.</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\">Our registration expiration notification policy and associated fees are described&nbsp;<a href=\"http://help.securepaynet.net/article/8803\" target=\"_blank\">here</a>.</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong><em>(C) FREE PRODUCT TERMS</em></strong></p>\r\n<p style=\"text-align: justify;\">In the event you are provided with free products with the registration of a domain name, you acknowledge and agree that such free products will only be available with a valid purchase and may be terminated in the event the domain name&nbsp;is deleted or cancelled.&nbsp; For free domain names, you acknowledge and agree that you may not change the account associated with such free domain for the first five (5) days after registration.&nbsp; In the event a free domain name is offered with the registration of another domain and if the paid domain name registered fails, then we may, in its sole discretion, either delete the registration of the free domain or refund the difference between the amount paid and the value of the free domain.&nbsp; Failed registrations associated with promotionals offers may result in the deletion of the free or discounted item or an adjustment between the registered domain price and the value of the discounted item, in&nbsp;our sole discretion.</p>\r\n<p style=\"text-align: justify;\"><strong>4. TERM OF AGREEMENT; TRANSFERS; DOMAIN TASTING</strong></p>\r\n<p style=\"text-align: justify;\">The term of this Agreement shall continue in full force and effect as long as you have any domain name registered through Azure.</p>\r\n<p style=\"text-align: justify;\">You agree that you will not transfer any domain name registered through Azure to another domain name registrar during the first sixty (60) days after its initial registration date.&nbsp; You agree that you may not transfer any domain name for&nbsp;ten (10) days after a Change of Account.</p>\r\n<p style=\"text-align: justify;\">You further agree that you will not engage in \"domain tasting\" by using the five (5) day grace period in which a registrant may choose to cancel a domain name and get a full refund of the registration fee as a vehicle to test the marketability or viability of a domain name.&nbsp; If Azure determines (which determination shall be made by Azure in its sole and absolute discretion) that you have been engaging in \"domain tasting\", then Azure reserves the right to (a) charge you a small fee (which fee shall be deducted from any refund issued) or (b) refuse your cancellation/refund request altogether. Azure will not charge you a fee if Azure cancels your domain name during the five (5) day grace period due to fraud or other activity outside of your control. The five (5) day grace period does not apply to Premium Domains, which are non-refundable.</p>\r\n<p style=\"text-align: justify;\">You agree that Azure shall not be bound by (i) any representations made by third parties who you may use to purchase services from Azure, or (ii) any statements of a general nature, which may be posted on Azure's website or contained in Azure's promotional materials.</p>\r\n<p style=\"text-align: justify;\"><strong>5. UP TO DATE INFORMATION; USE OF INFORMATION AND EXPIRATION</strong></p>\r\n<p style=\"text-align: justify;\">You agree to notify Azure within five (5) business days when any of the information you provided as part of the application and/or registration process changes. It is your responsibility to keep this information in a current and accurate status. Failure by you, for whatever reason, to provide Azure with accurate and reliable information on an initial and continual basis, shall be considered to be a material breach of this Agreement and a basis for suspension and/or cancellation of the domain name. Failure by you, for whatever reason, to respond within five (5) business days to any inquiries made by Azure to determine the validity of information provided by you, shall also be considered to be a material breach of this Agreement and a basis for suspension and/or cancellation of the domain name. You agree to retain a copy for your record of the receipt for purchase of your domain name.</p>\r\n<p style=\"text-align: justify;\">You agree that for each domain name registered by you, the following contact data is required: postal address, email address, telephone number, and if available, a facsimile number for the Registered Name Holder and, if different from the Registered Name Holder, the same contact information for, a technical contact, an administrative contact and a billing contact.</p>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that domain name registration requires that this contact information, in whole or in part, be shared with the registry operator, for their use, copying, distribution, publication, modification and other processing &nbsp;for (among other uses in accordance with our Privacy Policy) the purpose of administration of the domain name registration, which may require such information be transferred back and forth across international borders, to and from the U.S. to the EU, for example. As required by ICANN, this information must also be made publicly available by means of Whois, and that the registry operator may also be required to make this information publicly available by Whois. Both Azure and the registry operator may be required to archive this information with a third-party escrow service. You hereby consent and give permission for all such requirements and disclosures. Further, you represent and warrant that, if you are providing information about a third party, you have notified the third party of the disclosure and the purpose for the disclosure and you have obtained the third party's consent to such disclosure.&nbsp; Registrar will not process data in a way that is incompatible with this Agreement.&nbsp; Registrar will take reasonable precautions to protect data from loss or misuse.</p>\r\n<p style=\"text-align: justify;\">You agree that for each domain name registered by you the following information will be made publicly available in the Whois directory as determined by ICANN Policy and may be sold in bulk as set forth in the ICANN agreement:</p>\r\n<ul style=\"text-align: justify;\">\r\n<li>The domain name;</li>\r\n<li>Your name and postal address;</li>\r\n<li>The name, email address, postal address, voice and fax numbers for technical and administrative contacts;</li>\r\n<li>The Internet protocol numbers for the primary and secondary name servers;</li>\r\n<li>The corresponding names of the name servers; and</li>\r\n<li>The original date of registration and expiration date.</li>\r\n<li>Name of primary name server and secondary name server.</li>\r\n<li>Identity of the registrar.</li>\r\n</ul>\r\n<p style=\"text-align: justify;\">You agree that, to the extent permitted by ICANN, Azure may make use of the publicly available information you provided during the registration process. If you engage in the reselling of domain names you agree to provide any individuals whose personal information you've obtained, information about the possible uses of their personal information pursuant to ICANN policy. You also agree to obtain consent, and evidence of consent, from those individuals for such use of the personal information they provide.</p>\r\n<p style=\"text-align: justify;\">You agree that Azure has the right to make public and share with third parties&nbsp;certain information in connection with the sale or purchase of domain names on the website, including but not limited to (a) the name of the domain name sold or purchased, (b) the sale or purchase price of the domain name sold or purchased, and (c) information relating to the timing of the sale or purchase.</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\">In order for us to comply with any current or future rules and policies for domain name systems including any rules or policies established by the CIRA or any provincial or federal government or by other organization having control or authority to establish rules or policies, you hereby grant to us the right to disclose to third parties through an interactive publicly accessible registration database the following information that you are required to provide when applying for a domain name:</p>\r\n<ol style=\"text-align: justify;\">\r\n<li>The domain or sub-domain name(s) registered by you;</li>\r\n<li>Your organization name, type and postal address;</li>\r\n<li>The name(s), position(s), postal address(es), e-mail address(es), voice telephone number(s) and where available the fax number(s) of the technical and administrative contacts for your domain or sub-domain name(s);</li>\r\n<li>The full hostnames and Internet protocol (IP) addresses of at least two (2) name server hosts (one primary and at least one secondary) for your domain or sub-domain name. Up to six (6) name servers may be specified. If a host has more than one (1) IP address, use a comma-separated list;</li>\r\n<li>The corresponding names of those name servers;</li>\r\n<li>The original creation date of the registration; and</li>\r\n<li>The expiration date of the registration.</li>\r\n</ol>\r\n<p style=\"text-align: justify;\">We may be required to make this information available in bulk form to third parties. We may also transfer or assign this information to CIRA or such other third party as we may decide, in our sole discretion. </p>\r\n<p style=\"text-align: justify;\"><strong>6. DISPUTE RESOLUTION POLICY</strong></p>\r\n<p style=\"text-align: justify;\">You agree to be bound by our current Dispute Resolution Policy. This policy is incorporated herein and made a part of this Agreement. You can view the&nbsp;<a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=uniform_domain&amp;prog_id=510456\" target=\"_blank\">Uniform Domain Name Dispute Resolution Policy</a>&nbsp;online. You agree that Azure may from time to time modify its Dispute Resolution Policy. Azure will post any changes to its Dispute Resolution Policy at least thirty (30) days before they become effective. You agree that by maintaining your domain name registrations with Azure after the updated policy becomes effective that you agree to the Dispute Resolution policy as amended. You agree to review Azure's website periodically to determine if changes have been made to the Dispute Resolution Policy. If you cancel or terminate your&nbsp;Services with Azure as a result of the modified Dispute Resolution policy, no fees will be refunded to you.&nbsp;You also agree to submit to proceedings commenced under ICANN's Uniform Rapid Suspension System, if applicable.&nbsp;</p>\r\n<p style=\"text-align: justify;\">You agree that if a dispute arises as a result of one (1) or more domain names you have registered using Azure, you will indemnify, defend and hold Azure harmless as provided for in this Agreement. You also agree that if Azure is notified that a complaint has been filed with a governmental, administrative or judicial body, regarding a domain name registered by you using Azure, that Azure, in its sole discretion, may take whatever action Azure deems necessary regarding further modification, assignment of and/or control of the domain name deemed necessary to comply with the actions or requirements of the governmental, administrative or judicial body until such time as the dispute is settled. In this event you agree to hold Azure harmless for any action taken by Azure.</p>\r\n<p style=\"text-align: justify;\">You agree to submit, without prejudice to other potentially applicable jurisdictions, to the jurisdiction of the courts (1) of your domicile,&nbsp;(2) where registrar is located or (3) where the registry operator is located (e.g., China for .CN, Columbia for .CO, UK for .EU, etc.).</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\">In the case of .ca domain names, you agree that, if your use of the service or the registration of a .ca domain name is challenged by a third party, you will be subject to the provisions specified by CIRA in their dispute resolution policy, in effect at the time of the dispute.</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong>7. TRANSFER OF DOMAIN NAMES; RESALE PRACTICES</strong></p>\r\n<p style=\"margin: 0in 0in 0pt;\"><span style=\"font-family: arial,helvetica,sans-serif; font-size: small;\">If you transfer any domain name, you agree to provide the information required by, and to abide by, the procedures and conditions set forth in our&nbsp;<a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=TRANSFER_SA&amp;prog_id=510456\" target=\"_blank\"><span style=\"text-decoration: underline;\"><span style=\"color: #0066cc;\">Domain Name Transfer Agreement</span></span></a> and <a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=domain_nc&amp;prog_id=510456\" target=\"_blank\"><span style=\"text-decoration: underline;\"><span style=\"color: #0066cc;\">Change of Registrant Agreement</span></span></a>. You may view the latest versions of our Domain Name Transfer Agreement and Change of Registrant Agreementonline. In order to further protect your domain name, any domain name registered with&nbsp;Azure or transferred to&nbsp;Azure shall be placed on lock status, unless an opted-out has occurred as defined in our Change of Registrant Agreement or Domain Name Proxy Agreement. The domain name must be placed on unlock status in order to initiate a transfer of the domain name away from&nbsp;Azure to a new Registrar. You may log into your account with&nbsp;Azure at any time after your domain name has been successfully transferred to Azure, and change the status to unlock.</span></p>\r\n<p style=\"text-align: justify;\">In the event you are purchasing a domain name on behalf of a third party, you agree to inform any customer of yours, who may be acquiring a domain name through you using Azure's registration services, that they are in fact registering their domain name through Azure and that Azure  or its licensor  is an accredited registrar with ICANN. You agree not to represent that you are an ICANN-accredited registrar or that you are in any way providing superior access to the ICANN Domain Name Registry. You also agree not to use the ICANN trademark logo in any of your promotional materials including your website.</p>\r\n<p style=\"text-align: justify;\">You agree to obtain each of your customers' acceptances to the then current version of this Agreement, and to retain evidence of their acceptance for a period of not less than three (3) years. Should you require that your customers accept additional terms and conditions that are not required by Azure, you agree that such additional terms and conditions shall not conflict with this Agreement and the policies and procedures adopted by ICANN.</p>\r\n<p style=\"text-align: justify;\">You agree that Azure is not lending you access to its registrar connections or its registry access, nor will you be deemed to be a registrar in your own right. Furthermore, you agree you will not attempt to gain access to Azure's registrar connections or registry access. You agree to provide complete, accurate and current data for each registrant to be added to a registry in accordance with ICANN requirements for inclusion in the Whois database.</p>\r\n<p style=\"text-align: justify;\">You agree to provide your customers with adequate customer support, and to maintain contact with them with regard to providing a medium for them to communicate changes in the information they provided as part of the domain name registration process. Upon receiving corrected or updated information you will, within five (5) business days, provide such information to Azure so Azure may update its registration records. You will retain copies of all communications between you and your customers and will upon request provide Azure copies of same.</p>\r\n<p style=\"text-align: justify;\"><strong>8. YOUR OBLIGATIONS; SUSPENSION OF SERVICES; BREACH OF AGREEMENT</strong></p>\r\n<p style=\"text-align: justify;\">You represent and warrant to the best of your knowledge that, neither the registration of the domain nor the manner it is directly or indirectly used, infringes the legal rights of any third party.&nbsp; You will comply with all applicable laws, including, but not limited to those relating to privacy, data collection, consumer protection, fair lending, debt collection, organic farming, and disclosure of data and financial disclosures.&nbsp; If you collect and maintain sensitive health and financial data, you must implement reasonable and appropriate security measures commensurate with the offering of those services, as defined by applicable law.&nbsp; You represent that you possess any necessary authorization, charter, license, and/or other related credential for participation in the sector associated with the associated registry tld string.&nbsp; You will report any material changes to the validity of your authorization, charter, license, and/or other related credential. You will indemnify and hold harmless the registrar and registry operator, and their directors, officers, employees and agents, from and against any and all claims, damages, liabilities, costs and expenses (including reasonable legal fees and expenses) arising out of or related to the domain name registration.&nbsp; This obligation shall survive expiration or termination of this Agreement or the domain name registration.</p>\r\n<p style=\"text-align: justify;\">You agree that, in addition to other events set forth in this Agreement:</p>\r\n<ol style=\"text-align: justify;\">\r\n<li>Your ability to use any of the services provided by Azure is subject to cancellation or suspension in the event there is an unresolved breach of this Agreement and/or suspension or cancellation is required by any policy now in effect or adopted later by ICANN;</li>\r\n<li>Your registration of any domain names shall be subject to suspension, cancellation or transfer pursuant to any ICANN&nbsp;adopted specification or policy, or pursuant to any Azure procedure not inconsistent with an ICANN adopted specification or policy (a) to correct mistakes by Azure or the registry operator in registering any domain name; or (b) for the resolution of disputes concerning any domain name.</li>\r\n</ol>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that Azure and registry reserve the right to deny, cancel or transfer any registration or transaction, or place any domain name(s) on registry lock, hold or similar status, as either deems necessary, in the unlimited and sole discretion of either Azure or the registry: (i) to comply with specifications adopted by any industry group generally recognized as authoritative with respect to the Internet (e.g., RFCs), (ii) to correct mistakes made by registry or any registrar in connection with a domain name registration, (iii) for the non-payment of fees to registry, (iv) to protect the integrity and stability of the registry, (v) to comply with any applicable court orders, laws, government rules or requirements, requests of law enforcement, or any dispute resolution process, (vi) to comply with any applicable ICANN rules or regulations, including without limitation, the registry agreement, (vii) to avoid any liability, civil or criminal, on the part of registry operator, as well as its affiliates, subsidiaries, officers, directors, and employees, (viii) per the terms of this Agreement, (ix) following an occurrence of any of the prohibited activities described in Section 8 below, or (x) during the resolution of a dispute.</p>\r\n<p style=\"text-align: justify;\">You agree that your failure to comply completely with the terms and conditions of this Agreement and any Azure rule or policy may be considered by Azure to be a material breach of this Agreement and Azure may provide you with notice of such breach either in writing or electronically (i.e. email). In the event you do not provide Azure with material evidence that you have not breached your obligations to Azure within ten (10) business days, Azure may terminate its relationship with you and take any remedial action available to Azure under the applicable laws. Such remedial action may be implemented without notice to you and may include, but is not limited to, cancelling the registration of any of your domain names and discontinuing any services provided by Azure to you. No fees will be refunded to you should your Services be cancelled or terminated because of a breach.</p>\r\n<p style=\"text-align: justify;\">Azure's failure to act upon or notify you of any event, which may constitute a breach, shall not relieve you from or excuse you of the fact that you have committed a breach.</p>\r\n<p style=\"text-align: justify;\"><strong>9. RESTRICTION OF SERVICES; RIGHT OF REFUSAL</strong></p>\r\n<p style=\"text-align: justify;\">You agree not to use the services provided by Azure, or to allow or enable others, to use the services provided by Azure for the purposes of:</p>\r\n<ul style=\"text-align: justify;\">\r\n<li>The transmission of unsolicited email (Spam); and</li>\r\n<li>Repetitive, high volume inquires into any of the services provided by Azure (i.e. domain name availability, etc.).</li>\r\n</ul>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that you are prohibited from distributing malware, abusively operating botnets, phishing, piracy, trademark or copyright infringement, fraudulent or deceptive practices, counterfeiting or otherwise engaging in activity contrary to applicable law, and you acknowledge and agree that the consequences for such activities include suspension of the domain name.</p>\r\n<p style=\"text-align: justify;\">If you are hosting your domain name system (&ldquo;<span style=\"text-decoration: underline;\">DNS</span>&rdquo;) on Azure&rsquo;s servers, or are using our systems to forward a domain name, URL, or otherwise to a system or site hosted elsewhere, or if you have your domain name registered with Azure, you are responsible for ensuring there is no excessive overloading on Azure&rsquo;s servers. You may not use Azure&rsquo;s servers and your domain name as a source, intermediary, reply to address, or destination address for email denial-of-service attack, Internet packet flooding, packet corruption, or other abusive attack. Server hacking or other perpetration of security breaches is prohibited. You agree that Azure reserves the right to deactivate your domain name from its DNS if Azure deems it is the recipient of activities caused by your site that threaten the stability of its network.</p>\r\n<p style=\"text-align: justify;\">You agree that Azure, in its sole discretion and without liability to you, may refuse to accept the registration of any domain name. Azure also may in its sole discretion and without liability to you delete the registration of any domain name during the first thirty (30) days after registration has taken place. Azure may also cancel the registration of a domain name, after thirty (30) days, if that name is being used, as determined by Azure in its sole discretion, in association with spam or morally objectionable activities. Morally objectionable activities will include, but not be limited to:</p>\r\n<ul style=\"text-align: justify;\">\r\n<li>Activities prohibited by the laws of the United States and/or foreign territories in which you conduct business;</li>\r\n<li>Activities designed to encourage unlawful behavior by others, such as hate crimes, terrorism and child pornography;&nbsp;and</li>\r\n<li>Activities designed to harm or use unethically minors in any way.</li>\r\n</ul>\r\n<p style=\"text-align: justify;\">In the event Azure refuses a registration or deletes an existing registration during the first thirty (30) days after registration, you will receive a refund of any fees paid to Azure in connection with the registration either being cancelled or refused. In the event Azure deletes the registration of a domain name being used in association with spam or morally objectionable activities, no refund will be issued.</p>\r\n<p style=\"text-align: justify;\"><strong>10. DEFAULT SETTINGS; PARKED PAGE</strong></p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">Choosing Your Domain Name Settings</span>.&nbsp; When you register a domain name with Azure, you will be prompted to choose your domain name settings during the checkout process.&nbsp; If you plan on using another provider for your website or hosting needs, then you should enter the name servers of such provider when you choose your domain name settings.&nbsp; This will direct your domain name away from Azure&rsquo;s name servers.&nbsp; If you are an existing Azure customer and have already set up a customer profile designating your domain name settings for new domain name registrations, you will not need to complete this step again during the checkout process. &nbsp;&nbsp;</p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">Azure&rsquo;s Default Settings</span>.&nbsp; If you do not direct your domain name away from Azure&rsquo;s name servers as described above, Azure will direct your domain name to&nbsp;a &ldquo;<span style=\"text-decoration: underline;\">Parked Page</span>&rdquo; (&ldquo;<span style=\"text-decoration: underline;\">Default Setting</span>&rdquo;).&nbsp; You acknowledge and agree that Azure has the right to set the Default Setting.&nbsp;</p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">Parked Page Default Setting</span>.&nbsp; Azure&rsquo;s Parked Page service is an online domain monetization system designed to generate revenue (through the use of pay per click advertising) from domain names that are not actively being used as websites.&nbsp; If your domain name is directed to a Parked Page, you acknowledge and agree that Azure may display both (a) in-house advertising (which includes links to Azure products and services) and (b) third-party advertising (which includes links to third-party products and services) on your Parked Page through the use of pop-up or pop-under browser windows, banner advertisements, audio or video streams, or any other advertising means, and we may aggregate for our own use, related usage data by means of cookies and other similar means.&nbsp; In addition, you acknowledge and agree that all in-house and third-party advertising will be selected by Azure and its advertising partners, as appropriate, and you will not be permitted to customize the advertising, or entitled to any compensation in exchange therefor.&nbsp; Please note that the third-party advertising displayed on Azure&rsquo;s Parked Pages may contain content offensive to you, including but not limited to links to adult content.&nbsp; Azure makes no effort to edit, control, monitor, or restrict the content and third-party advertising displayed on Azure&rsquo;s Parked Pages, and expressly disclaims any liability or responsibility to you or any third party in connection therewith.</p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">Changing Azure&rsquo;s Default Settings</span>.&nbsp; You may change Azure&rsquo;s Default Settings at any time during the term of your domain name registration.</p>\r\n<ol style=\"text-align: justify;\">\r\n<li><span style=\"text-decoration: underline;\">Content Displaying On Your Parked Page</span>.&nbsp;&nbsp;You&nbsp;can not&nbsp;modify the content displaying on your Parked Page.&nbsp; You may select one of the other options listed below.</li>\r\n<li><span style=\"text-decoration: underline;\">Participating In Domain Name Monetization</span>.&nbsp; If you wish to participate in the domain monetization potential presented by Azure&rsquo;s Parked Page service, please review and consider purchasing our CashParking&reg; service.&nbsp; &nbsp;</li>\r\n<li><span style=\"text-decoration: underline;\">No Content</span>.&nbsp; If the options listed above are not acceptable to you, please contact customer support to learn what other options might be available to you.</li>\r\n</ol>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">Return To Parked Page Default Setting Upon Domain Name Expiration</span>.&nbsp; Upon domain name expiration, and regardless of how you use your domain name during the term of your domain name registration, your domain name will automatically return to the Parked Page Default Setting described above.&nbsp; As used in this paragraph, &ldquo;expiration&rdquo; is deemed to include any &ldquo;renewal period&rdquo; or &ldquo;redemption period&rdquo; immediately after the domain name expires, but before the domain name is returned to the registry.&nbsp; Once your domain name has returned to the Parked Page Default Setting described above, the only way to opt out of the Parked Page service is to renew, redeem, or re-register your domain name in accordance with Section 2(B), Domain Name Renewal Terms, of this Agreement.&nbsp;&nbsp;&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>11. DOMAIN ADD-ONS</strong></p>\r\n<p style=\"text-align: justify;\"><strong>Business Registration:&nbsp;&nbsp;</strong>Business registration allows You to display additional information about the business that is the basis of Your domain name, including, but not limited to, such information as Your fax number, street address, and hours of operation. </product-offering></p>\r\n<p style=\"text-align: justify;\"><strong>Certified Domains</strong>.&nbsp; The certified domain service generally allow You to:&nbsp;(i) put a Certified Domain Validation seal on Your website; and (ii) have Your domain name listed as \"Certified\", in WHOIS lookups on our website. &nbsp;&nbsp;The Certified Domain Validation seal renews independently of Your domain. When You renew Your domain, You must also, when necessary, separately renew Your Certified Validation seal. However, the Certified Domain Validation seal can be cancelled independently of Your domain. If the domain is cancelled, the Certified Domain associated with the cancelled domain will automatically cancel.&nbsp; The Certified Domain seal is a trademark and is protected by copyright, trademark and other intellectual property laws. You may use the Certified Domain seal only in conjunction with the purchase of the Services set forth in the Agreement, and subject to the terms and conditions hereof. Other than provided for in this Agreement, You may not otherwise use, reproduce, or modify the mark for any additional promotional use, without our prior written approval. Your right to the use of the Certified Domain seal is immediately terminated upon expiration or termination of this Agreement.</product-offering></p>\r\n<p style=\"text-align: justify;\"><strong>Expiration Consolidation.</strong>&nbsp; You understand and acknowledge the expiration consolidation service may only be used to consolidate the expiration of .com and .net domain names. The service may not be used to consolidate domains that are on Registrar HOLD, Registry HOLD, or pending Transfer status. You acknowledge the service may only be used to push the expiration date of Your domains forward in time, at least one (1) month forward and no more than ten (10) years forward, and then, only for a period lasting less than twelve (12) months. Once the service has been used to consolidate domains, the new expiration date may not be reversed. To ensure the service is not abused or used as an alternative to renewals, you may only use the service on each domain once in any 12-month period. The service may only be used on domain names that have not passed their expiration date. In order to change the expiration date again, You will be required to renew the domain name first.&nbsp; You further understand and acknowledge the service may only be used to coordinate domains where we are the registrar of record. Domains not registered with us must be transferred before we can perform the Service.&nbsp;</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong>Backordering/Monitoring</strong>.&nbsp; You agree a domain name that has expired shall be subject first to a grace period of twelve (12) days, followed by the ICANN-mandated&nbsp;redemption grace period of thirty (30) days. During this period of time, the current domain name registrant may renew the domain name and retain ownership. We do not guarantee your backorder will result in you obtaining the domain name and expressly reserves the right to (a) refuse additional backorders or (b) cancel existing backorders at any time for any reason.&nbsp; If your backorder is refused or cancelled,&nbsp;we agree to promptly refund any fees paid for such domain name backorder. The domain name may also be placed in a secondary market for resale through the Auctions&reg; service.&nbsp; After your first year of Auctions membership, you agree that unless otherwise advised, we will automatically renew your Auctions membership using the payment method you have on file for so long as your backorder credit is active. You may learn more about Auctions by visiting the Auctions website. The domain name may also be subject to a drop pool process before it is available for purchasing. You understand&nbsp;we and our registrar affiliates use our services, including backordering.&nbsp; Therefore, the domain name may be registered with a different registrar, but can be managed through your account.&nbsp; By using the Services, you will be able to, among other things:</p>\r\n<ol style=\"text-align: justify;\">\r\n<li>Backorder any domain name under the top level domains .COM, .NET, .US, .BIZ, .INFO, .ORG, .MOBI. A backorder for a domain name will include the price of up to a one-year domain name registration. Should you successfully backorder any domain name, you will be subject to the terms and conditions of the&nbsp;Domain Name Registration&nbsp;and related agreements, which are incorporated herein by reference.</li>\r\n<li>Change your backorder until you obtain a domain name. You will have the opportunity to change the credit to a different domain name until you successfully capture one. After three (3) years, if the credit is not used, we reserves the right to remove the credit.</li>\r\n<li>Subscribe monthly to an expiring domain name list. You may also choose to purchase a subscription to a list of domain names expiring within the next five (5) days. If you subscribe to the expiring domain name list, you agree the payment method you have on file may be charged on a monthly subscription basis for the term of the Services you purchase.</li>\r\n<li>Select domain names off the expiring domain name list you would like to register. Each domain name you attempt to backorder will include the price of up to a one-year domain name registration, as set forth in subsection (i) above.</li>\r\n<li>Monitor your currently registered domain names for changes in registrar, status, expiration date or name servers at no additional cost.</li>\r\n<li>Subscribe to Domain Alert Pro or monitoring, which enables you to monitor any currently registered domain name, regardless of registrar, for historical tracking of status changes and designation of multiple email notification addresses.</li>\r\n</ol>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong>Transfer Validation.</strong>&nbsp;The transfer validation service is provided to help You keep Your domain name secure. By choosing to use the service, You are making an explicit and voluntary request to us to deny all attempts to transfer Your domain name to another registrar, or to move Your domain name to another account, unless You verify each request as described herein. You will provide us with a contact name, phone number and PIN for domain transfer validations. You will be contacted by us when a domain transfer is requested for a domain name in Your account. When we receive a transfer request, we will call You to verify the transfer request. If we cannot reach You with seventy-two (72) hours of receipt of the transfer request, the transfer will be denied. If You do not provide the proper PIN, the transfer will be denied. When we receive a change of account request, we will call You to verify the change request. If we cannot reach You with seventy-two (72) hours of receipt of the change request, the change will be denied. If You do not provide the proper PIN, the change will be denied. Availability of Services are subject to the terms and conditions of this Agreement and each of our policies and procedures. We shall use commercially reasonable efforts to attempt to provide certain portions of the Services on a twenty-four (24) hours a day, seven (7) days a week basis throughout the term of this Agreement and other portions of the service, during normal business hours. You acknowledge and agree that from time to time the Services may be inaccessible or inoperable for any reason, including, without limitation: (i) equipment malfunctions; (ii) periodic maintenance procedures or repairs that we may undertake from time to time; or (iii) causes beyond the reasonable control of us or that are not reasonably foreseeable by us, including, without limitation, interruption or failure of telecommunication or digital transmission links, hostile network attacks, network congestion or other failures. You acknowledge and agree that we has no control over the availability of the service on a continuous or uninterrupted basis.</p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong>12. PRE-REGISTRATIONS</strong></p>\r\n<p style=\"text-align: justify;\">If you submit an application for pre-registration of a domain name, Azure does not guarantee that the name will be secured for you, or that you will have immediate access to the domain name if secured.&nbsp; Azure may use third-party service providers for the pre-registration services.</p>\r\n<p style=\"text-align: justify;\"><strong>13. PROVISIONS SPECIFIC TO .BIZ REGISTRATIONS</strong></p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Domain Name Dispute Policy</span></em>.&nbsp;&nbsp;If you reserved or registered a .BIZ domain name through us, in addition to our Dispute Resolution Policy, you hereby acknowledge that you have read and understood and agree to be bound by the terms and conditions of the&nbsp;<a href=\"http://www.icann.org/en/help/dndr/rdrp\" target=\"_blank\">Restrictions Dispute Resolution Policy</a>&nbsp;applicable to the .biz TLD.</p>\r\n<p style=\"text-align: justify;\">The RDRP sets forth the terms under which any allegation that a domain name is not used primarily for business or commercial purposes shall be enforced on a case-by-case basis by an independent ICANN-accredited dispute provider. Registry Operator will not review, monitor, or otherwise verify that any particular domain name is being used primarily for business or commercial purposes or that a domain name is being used in compliance with the SUDRP or UDRP processes.</p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">One Year Registration</span></em>.&nbsp; If you are registering a .BIZ domain name and you elect to take advantage of special pricing applicable to one-year registrations, we will automatically renew your domain name for an additional one-year period at the end of the first year term by taking payment from the Payment Method you have on file, unless you notify us that you do not wish to renew. You will be notified and given the opportunity to accept or decline the one-year renewal prior to your domain name expiration date. In the event you decide not to renew your one-year .BIZ domain name for a second year, your domain name registration will automatically revert back to us and we will gain full rights of registration to such domain name. You agree that if you delete or transfer your .BIZ domain name during the first year, you will automatically be charged the second year renewal fees. </p>\r\n<p style=\"text-align: justify;\"><show-only pl_id=\"GD\"></p>\r\n<p style=\"text-align: justify;\"><strong>14. PROVISIONS SPECIFIC TO .INFO REGISTRATIONS&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">One Year Registration</span></em>.&nbsp; If you are registering a .INFO domain name and you elect to take advantage of special pricing applicable to one-year registrations, we will automatically renew your domain name for an additional one-year period at the end of the first year term by taking payment from the Payment Method you have on file, unless you notify us that you do not wish to renew. You will be notified and given the opportunity to accept or decline the one-year renewal prior to your domain name expiration date. In the event you decide not to renew your one-year .INFO domain name for a second year, your domain name registration will automatically revert back to us and we will gain full rights of registration to such domain name. You agree that if you delete or transfer your .INFO domain name during the first year, you will automatically be charged the second year renewal fees. </p>\r\n<p style=\"text-align: justify;\"><strong>15. PROVISIONS SPECIFIC TO .MOBI REGISTRATIONS&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Instant Mobilizer</span></em><span style=\"text-decoration: underline;\">.</span>&nbsp;You are hereby granted a personal, revocable, non-exclusive, non-transferable, non-assignable, non-sublicensable license to use the Instant Mobilizer service (&ldquo;Service&rdquo;), provided, however, You abide by the terms and conditions set forth. You shall not alter, modify, adapt or translate the whole or part of the Service in any way whatsoever. You may not create derivative works based on the Service. You may not rent, lease, assign, dispose of, novate, sub-license or otherwise transfer any of its rights to use the Service to any third party.&nbsp; In the event that the volume of traffic to You from Your use of the Service is sufficient so as to jeopardize the provision of Service for other end users, we and our licensors reserve the right to, at its sole discretion, permanently or temporarily, discontinue Your use of the Service. For the avoidance of doubt, the volume of traffic generated by You should not exceed two thousand (2,000) page views per day.&nbsp; You acknowledge and agree the text \"Instant Mobilizer from dotMobi\" or equivalent, will be inserted at the footer of Your site.&nbsp; In the event a dotMobi domain to which the Service is being provided is transferred to another domain name registrar, the Service will be interrupted on that dotMobi domain, and Service will not be restored if the new registrar does not offer the Service.&nbsp; </p>\r\n<p style=\"text-align: justify;\"><show-only pl_id=\"GD\"></p>\r\n<p style=\"text-align: justify;\"><strong>16. PROVISIONS SPECIFIC TO .NAME REGISTRATIONS&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\"></p>\r\n<p style=\"text-align: justify;\"><strong>17.&nbsp;PROVISIONS SPECIFIC TO .REISE REGISTRATIONS</strong></p>\r\n<p style=\"text-align: justify;\">Domain Names registered in .REISE should be used for purposes dedicated to travel topics within six months following initial Registration, e.g. utilized on the Internet or otherwise used to perform a function.</p>\r\n<p style=\"text-align: justify;\"><strong>18.&nbsp;PROVISIONS SPECIFIC TO .SEXY REGISTRATIONS</strong></p>\r\n<p style=\"text-align: justify;\">You shall not permit content unsuitable for viewing by a minor to be viewed from the main or top-level directory of a .SEXY domain name. For purposes of clarity, content viewed at the main or top-level directory of a .SEXY domain name is the content immediately visible if a user navigates to http://example.sexy or http://www.example.sexy. No restrictions apply to the content at any other page or subdirectory addressed by a .SEXY Registered Name.&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>19. COUNTRY CODE TOP LEVEL DOMAINS</strong></p>\r\n<p style=\"text-align: justify;\">You represent and warrant that you meet the eligibility requirements of each ccTLD you apply for. You further agree to be bound by any registry rules, policies, and agreements for that particular ccTLD. These may include, but are not limited to, agreeing to indemnify the ccTLD provider, limiting the liability of the ccTLD provider, and requirements that any disputes be resolved under that particular country's laws.</p>\r\n<p style=\"text-align: justify;\"><strong><em>(A)&nbsp;PROVISIONS SPECIFIC TO .AU REGISTRATIONS</em></strong><strong>&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\">.au Registrations (to include com.au, net.au and org.au) are governed by the following additional terms and conditions:</p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">auDA</span>. auDA means .au Domain Administration Limited ACN 079 009 340, the .au domain names administrator.&nbsp; The Registrar acts as agent for auDA for the sole purpose, but only to the extent necessary, to enable auDA to receive the benefit of rights and covenants conferred to it under this Agreement. auDA is an intended third party beneficiary of this agreement.</p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">auDA Published Policy</span>.&nbsp; auDA Published Policies means those specifications and policies established and published by auDA from time to time at&nbsp;<a href=\"http://www.auda.org.au/\">http://www.auda.org.au</a>.&nbsp; You must comply with all auDA Published Policies, as if they were incorporated into, and form part of, this Agreement. In the event of any inconsistency between any auDA Published Policy and this Agreement, then the auDA Published Policy will prevail to the extent of such inconsistency.&nbsp; You acknowledge that under the auDA Published Policies: (1) there are mandatory terms and conditions that apply to all domain names; (2) licences, and such terms and conditions are incorporated into, and form part of, this Agreement; (3) You are bound by, and must submit to, the .au Dispute Resolution Policy; and (4) auDA may delete or cancel the registration of a .au domain name.<strong>&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\"><span style=\"text-decoration: underline;\">auDA's Liabilities and Indemnity</span>.&nbsp; To the fullest extent permitted by law, auDA will not be liable to Registrant for any direct, indirect, consequential, special, punitive or exemplary losses or damages of any kind (including, without limitation, loss of use, loss or profit, loss or corruption of data, business interruption or indirect costs) suffered by Registrant arising from, as a result of, or otherwise in connection with, any act or omission whatsoever of auDA, its employees, agents or contractors. Registrant agrees to indemnify, keep indemnified and hold auDA, its employees, agents and contractors harmless from all and any claims or liabilities, arising from, as a result of, or otherwise in connection with, Registrant's registration or use of its .au domain name. Nothing in this document is intended to exclude the operation of Trade Practices Act 1974.</p>\r\n<p style=\"text-align: justify;\"><strong><em>(B) PROVISIONS SPECIFIC TO .CA REGISTRATIONS</em></strong><strong></strong></p>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that registration of your selected domain name in your first application to CIRA shall not be effective until you have entered into and agreed to be bound by CIRA's Registrant Agreement.</p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">CIRA Certified Registrar</span></em>.&nbsp; The registrar shall immediately give notice to you in the event that it is no longer a CIRA Certified Registrar, has had its certification as a CIRA Certified Registrar suspended or terminated, or the Registrar Agreement between CIRA and the Registrar is terminated or expires. CIRA may post notice of such suspension, termination, or expiry on its website and may, if CIRA deems appropriate, give notice to the registrants thereof. In the event that the registrar is no longer a CIRA Certified Registrar, has had its certification as a CIRA Certified Registrar suspended or terminated or in the event the Registrar Agreement between CIRA and the Registrar is terminated or expires, you shall be responsible for changing your Registrar of Record to a new CIRA Certified Registrar within thirty (30) days of the earlier of notice thereof being given to you by (i) the Registrar or (ii) CIRA in accordance with CIRA's then current Registry PRP; provided, however, that if any of your domain name registrations are scheduled to expire within thirty (30) days of the giving of such notice, then you shall have thirty (30) days from the anniversary date of the registration(s), to register with a new CIRA certified registrar and to renew such domain name registration(s) in accordance with the Registry PRP.</p>\r\n<p style=\"text-align: justify;\">You acknowledge and agree that should there be insufficient funds prepaid by the registrar in the CIRA Deposit Account to be applied in payment of any fees, CIRA may in its sole discretion stop accepting applications for domain name registrations from the registrar, stop effecting registrations of domain names and transfers, renewals, modifications, and cancellations requested by the registrar and stop performing other billable transactions requested by the registrar not paid in full and CIRA may terminate the Registrar Agreement between CIRA and the Registrar.</p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">.CA ASCII and IDN domain variants</span></em><em>&nbsp;</em>are bundled and reserved for a single registrant.&nbsp; Registrants are not required to register all variants in a bundle, but all registered variants must be registered and managed at a single registrar. Each variant registered will incur a registration fee.&nbsp; In addition, when registering multiple .CA domain (ASCII and IDN) variants in a bundle, your registrant information&nbsp;<strong><span style=\"text-decoration: underline;\">must be identical</span></strong>.&nbsp; If variants are registered at other registrars or if registrant information does not match, it may result in an \"unavailable\" search result, delayed or failed registration. If information does not match, validation is required and may take up to seven business days and delay availability of domain.&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong><em>(C)&nbsp;PROVISIONS SPECIFIC TO .CN REGISTRATIONS</em></strong><strong>&nbsp;</strong></p>\r\n<p style=\"text-align: justify;\">.CN is a restricted TLD &ndash; applications are subject to both a domain name check <strong><span style=\"text-decoration: underline;\">and</span></strong> real name verification as required by the China.&nbsp; Registrations in .CN are therefore subject to the following additional terms:</p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Verification, Registration and Activation</span></em><em>.</em>&nbsp;&nbsp;If a domain name is not permitted to be registered by the Chinese government, as determined by us, the Registry Operator and/or a 3<sup>rd</sup>&nbsp;party provider utilized for such services and determinations, in either party&rsquo;s discretion, the application for registration will not be successful.&nbsp; In such event, the name will be deleted and you will be eligible for a refund as further described below.</p>\r\n<p style=\"text-align: justify;\">If permitted, then the Registration may proceed, but a .CN domain name may not be activated (i.e., it will not resolve in the Internet) <em><span style=\"text-decoration: underline;\">unless and until</span></em> you have submitted (via the process described during registration) valid documents required of us and the Registry to perform real name verification.&nbsp; The following are acceptable forms of documents for the purpose of verification:</p>\r\n<ul style=\"text-align: justify;\">\r\n<li>China: Resident ID, temporary resident ID, business license or organization code certificate</li>\r\n<li>Hong Kong Special Administrative Region/Macao Special Administrative Region: Resident ID, driver&rsquo;s license, passport or business license</li>\r\n<li>Singapore: Driver&rsquo;s license, passport or business license</li>\r\n<li>Taiwan: Resident ID, driver&rsquo;s license or business license</li>\r\n<li>Other Countries/Regions: Driver&rsquo;s license or passport</li>\r\n</ul>\r\n<p style=\"text-align: justify;\">Documents submitted to us&nbsp;are used by us and shared with the Registry solely for the purpose of real name verification, and are otherwise subject to our <a href=\"http://www.securepaynet.net/agreements/ShowDoc.aspx?pageid=privacy&amp;prog_id=510456\">Privacy Policy</a>. &nbsp;By registering a .CN domain, you expressly agree that your data may be stored on servers in the U.S., or otherwise outside of the China.</p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Refunds</span></em><em>.</em>&nbsp; Refunds for .CN Registrations will only be allowed where (i) registration of the applied for domain name is not permitted by the Chinese government; or (ii) you notify us of your intent to cancel for any reason within the first five (5) days after the Registration (i.e., after it is deemed permissible by the Chinese government).&nbsp; For the avoidance of doubt, refunds will not be permitted under any circumstances after five (5) days from the date of Registration, including, for example, in the event real name verification is not successful or if the Chinese government determines after Registration that the domain name should not have been registered (and directs us to delete).</p>\r\n<p style=\"text-align: justify;\"><strong><em>(D) PROVISIONS SPECIFIC TO .JP REGISTRATIONS</em></strong><strong></strong></p>\r\n<p style=\"text-align: justify;\"><em><span style=\"text-decoration: underline;\">Registration Restrictions</span></em>.&nbsp; You represent and warrant that you have a local presence in Japan with a home or office address. You agree that certain domain names are reserved and can only be registered by certain parties. These include: (i) TLDs, other than ccTLDs, as determined by ICANN; (ii) geographical-type .JP domain names that are defined as metropolitan, prefectural, and municipal labels; (iii) names of primary and secondary educational organizations; (iv) names of organizations related to Internet management; (v) names required for .JP domain name operations; and (vi) character strings which may be confused with ASCII-converted Japanese domain names. The complete list of .JP Reserved Domains is available&nbsp;<a href=\"http://www.nic.ad.jp/dotjp/doc/dotjp-reserved.html\" target=\"_blank\">here</a>.&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>20. ENGLISH LANGUAGE CONTROLS</strong></p>\r\n<p style=\"text-align: justify;\">This Agreement, along with all policies and the applicable product agreements identified above and incorporated herein by reference (collectively, the &ldquo;Agreement&rdquo;), is executed in the English language. To the extent any translation is provided to you, it is provided for convenience purposes only, and in the event of any conflict between the English and translated version, where permitted by law, the English version will control and prevail. Where the translated version is required to be provided to you and is to be considered binding by law (i) both language versions shall have equal validity, (ii) each party acknowledges that it has reviewed both language versions and that they are substantially the same in all material respects, and (iii) in the event of any discrepancy between these two versions, the translated version may prevail, provided that the intent of the Parties has been fully taken into consideration.&nbsp;</p>\n</td></tr>\n<tr><td>\n<br />\n<span class=\"finePrint\">\nRevised: 10/6/17<br />\nCopyright &copy; 2000-2017  All Rights Reserved.\n</span>\n</td></tr>\n</tbody>\n</table>\n</td></tr>\n</tbody>\n</table>"),
		// 			Title: to.Ptr("Domain Name Registration Agreement"),
		// 			URL: to.Ptr("http://www.secureserver.net/agreements/ShowDoc.aspx?pageid=reg_sa&pl_id=510456"),
		// 		},
		// 		{
		// 			AgreementKey: to.Ptr("DNPA"),
		// 			Content: to.Ptr("<table width=\"100%\">\n<tbody>\n<tr><td width=\"100\"></td><td></td></tr>\n<tr><td></td><td>\n<table>\n<tbody>\n<tr><th align=\"left\" class=\"EULATitle\">\nDomain Name Proxy Agreement\n</th></tr>\n<tr><td class=\"bodyText\">\n<p><strong>Last Revised: October 25, 2017</strong></p>\n<p>Please read this Domain Name Proxy Agreement (\"Agreement\") carefully. By using the Services and/or website of Domains By Proxy, LLC, a Delaware limited liability company (\"DBP\"), You (as defined below) agree to all the terms and conditions set forth both herein and in the DBP privacy policy, which is incorporated by reference and can be found by clicking <a href=\"http://www.domainsbyproxy.com/policy/ShowDoc.aspx?pageid=privacy\" target=\"_blank\">here</a>.&nbsp; You acknowledge that DBP may amend this Agreement at any time upon posting the amended terms on its website, and that any new, different or additional features changing the services provided by DBP will automatically be subject to this Agreement. If You do not agree to be bound by, or if You object to, the terms and conditions of this Agreement and any amendments hereto, do not use or access DBP's services. Continued use of DBP's services and its website after any such changes to this Agreement have been posted, constitutes Your acceptance of those changes.</p>\r\n<p>This Agreement is by and between DBP and you, your heirs, assigns, agents and contractors (\"You\") and is made effective as of the date of electronic execution. This Agreement sets forth the terms and conditions of Your relationship with DBP and Your use of DBP's services and represents the entire Agreement between You and DBP. By using DBP's Services, You acknowledge that You have read, understand and agree to be bound by all the terms and conditions of this Agreement, and You further agree to be bound by the terms of this Agreement for transactions entered into by:</p>\r\n<ol>\r\n<li>You on Your behalf;</li>\r\n<li>Anyone acting as Your agent; and</li>\r\n<li>Anyone who uses the account You have established with DBP, whether or not the transactions were on Your behalf and/or authorized by You.</li>\r\n</ol>\r\n<p>You agree You will be bound by representations made by third parties acting on Your behalf, which either use or&nbsp;purchase services from DBP.&nbsp;You further agree that DBP will not be bound by statements of a general nature on DBP's website or&nbsp;DBP promotional materials. You further agree to abide by the terms and conditions promulgated by the Internet Corporation for Assigned Names and Numbers (\"ICANN\") (including the Uniform Domain Name Dispute Resolution Policy (\"Dispute Resolution Policy\") and Your Registrar (i.e., the ICANN-accredited person or entity through which You register a domain name).</p>\r\n<p class=\"heading1\">1. description of DBP's private registration services</p>\r\n<p>When You subscribe to DBP's private registration service through a DBP-affiliated Registrar, DBP will display its contact information in the publicly available \"Whois\" directory in place of Your information. DBP shall keep Your name, postal address, email address, phone and fax numbers confidential, subject to Section 4 of this Agreement. The following&nbsp;information (and not Your personal information) will be made publicly available in the \"Whois\" directory as determined by ICANN policy:</p>\r\n<ol>\r\n<li>DBP's name as the proxy Registrant of the domain name&nbsp;and a proxy email&nbsp;address, phone number and postal address for the proxy Registrant's contact information;</li>\r\n<li>A proxy&nbsp;postal address and phone number for the domain name registration's technical contact;</li>\r\n<li>A proxy&nbsp;email address, postal address and phone number for the domain name registration's administrative contact;</li>\r\n<li>A proxy email address, postal address and phone number for the domain's name registration's billing contact;</li>\r\n<li>The primary and secondary domain name servers You designate for the domain name;</li>\r\n<li>The domain name's original date of registration and expiration date of the registration; and</li>\r\n<li>The identity of the Registrar.</li>\r\n</ol>\r\n<p class=\"heading1\">2. full benefits of domain registration retained by you</p>\r\n<p>Although DBP will show in the \"Whois\" directory as&nbsp;the Registrant of each domain name registration You designate, You will retain the full benefits of domain name registration with respect to each such domain name registration, including, subject to Section 4 below:</p>\r\n<ol>\r\n<li>The right to sell, transfer or assign each domain name registration, which shall require cancellation of the DBP services associated with each such domain name registration;</li>\r\n<li>The right to control the use of each domain name registration, including designating the primary and secondary domain name servers to which each domain name points;</li>\r\n<li>The right to cancel each domain name registration;</li>\r\n<li>The right to cancel the DBP services associated with each domain name registration and/or Your&nbsp;privacy services with DBP so that Your contract information is listed in the \"Whois\" directory; and</li>\r\n<li>The right to renew each domain name registration upon its expiration, subject to Your Registrar's applicable rules and policies.</li>\r\n</ol>\r\n<p class=\"heading1\">3. PERSONAL INFORMATION AND your notification obligations; representation and warranties; ACCOUNT SECURITY</p>\r\n<p><strong>Personal Information&nbsp;and Your Notification Obligations&nbsp;</strong></p>\r\n<p>You agree that for each domain name for which you use DBP services, You will provide accurate and current information as to:</p>\r\n<ol>\r\n<li>Your name, the email address,&nbsp;postal address, phone and fax numbers for the domain name registration's Registrant contact;</li>\r\n<li>The email address, postal address, phone and fax numbers for the domain name registration's technical contact;</li>\r\n<li>The email address, postal address, phone and fax numbers for the domain name registration's administrative contact;</li>\r\n<li>The email address, postal address, phone and fax numbers for the domain name registration's billing contact; and</li>\r\n<li>You agree to provide government issued photo identification and/or government issued business identification as required for verification of identity when requested.</li>\r\n</ol>\r\n<p>You agree to:</p>\r\n<ol>\r\n<li>Notify DBP within&nbsp;three (3) calendar days when any of the personal information You provided upon subscribing to DBP's services, changes;</li>\r\n<li>Respond within three (3)&nbsp;calendar days to any inquiries made by DBP to determine the validity of personal information provided by You; and</li>\r\n<li>Timely respond to email messages&nbsp;DBP sends to You regarding correspondence DBP has received that is either addressed to or involves You and/or Your domain name registration, as more fully set forth in Section 5(c) below.</li>\r\n<li>To allow DBP to act as your Designated Agent (as that term is defined below) in instances when DBP services are added to or cancelled from your domain name and&nbsp;for the purpose of facilitating&nbsp;a change of registrant request (as further described below).&nbsp;</li>\r\n</ol>\r\n<p>It is Your responsibility to keep Your personal information current and accurate at all times.</p>\r\n<p><strong>Renewals </strong></p>\r\n<p>You agree DBP will&nbsp;arrange for Your Registrar to charge the credit card You have on file with the Registrar, at the Registrar's then current rates.</p>\r\n<p>If for any reason DBP and/or the Registrar for Your domain name is unable to charge Your credit card for the full amount of the service provided, or if DBP and/or the Registrar is charged back for any fee it previously charged to the credit card You provided, You agree that DBP and/or the Registrar may, without notice to You, pursue all available remedies in order to obtain payment, including but not limited to immediate cancellation of all services DBP provides to You.</p>\r\n<p><strong>Representations and Warranties </strong></p>\r\n<p>You warrant that all information provided by You to DBP is truthful, complete, current and accurate. You also warrant that You are using DBP's private registration services in good faith and You have no knowledge of Your domain name infringing upon or conflicting with the legal rights of a third party or a third party's trademark or trade name. You also warrant the domain name being registered by DBP on Your behalf will not be used in connection with any illegal activity, or in connection with the transmission of Spam, or that contains or installs any viruses, worms, bugs, Trojan horses or other code, files or programs designed to, or capable or, disrupting, damaging or limiting the functionality of any software or hardware.</p>\r\n<p class=\"heading2\">Account Security</p>\r\n<p>You agree You are entirely responsible for maintaining the confidentiality of Your customer number/login ID&nbsp;and password (\"Account Access Information\").&nbsp; You agree to notify DBP immediately of any unauthorized use of Your account or any other breach of security.&nbsp; You agree DBP will not be liable for any loss that You may incur as a result of someone else using Your Account Access Information, either with or without Your knowledge.&nbsp; You further agree You could be held liable for losses incurred by DBP or another party due to someone else using Your Account Access Information.&nbsp; For security purposes, You should keep Account Access Information in a secure location and take precautions to prevent others from gaining access to Your Account Access Information.&nbsp; You agree that You are entirely responsible for all activity in Your account, whether initiated by You, or by others.&nbsp; DBP specifically disclaims liability for any activity in Your account, regardless of whether You authorized the activity.</p>\r\n<p><strong>Designated Agency and Change of Registrant Information</strong></p>\r\n<p>&ldquo;DESIGNATED AGENT&rdquo; MEANS AN INDIVIDUAL OR ENTITY THAT THE PRIOR REGISTRANT OR NEW REGISTRANT EXPLICITLY AUTHORIZES TO APPROVE A CHANGE OF REGISTRANT REQUEST ON ITS BEHALF.&nbsp; IN THE CASE OF DBP SERVICES, A CHANGE OF REGISTRANT REQUEST MAY ALSO ARISE&nbsp;DUE TO INSTANCES WHERE DBP SERVICES ARE ADDED, OR REMOVED, FROM A DOMAIN NAME.&nbsp;&nbsp;FOR THE PURPOSE OF&nbsp;FACILITATING ANY SUCH CHANGE REQUEST,&nbsp;AND IN ACCORDANCE WITH ICANN'S <a href=\"https://www.icann.org/resources/pages/transfer-policy-2016-06-01-en\">CHANGE OF REGISTRANT POLICY</a>, YOU AGREE TO APPOINT&nbsp;DBP AS&nbsp;YOUR DESIGNATED AGENT FOR THE SOLE PURPOSE OF&nbsp;EXPLICITLY CONSENTING TO MATERIAL CHANGES OF REGISTRATION CONTACT INFORMATION ON YOUR BEHALF.</p>\r\n<p class=\"heading1\">4. DBP's rights to deny, suspend, terminate service and to disclose your personal information</p>\r\n<p>You understand and agree that DBP has the absolute right and power, in its sole discretion and without any liability to You whatsoever, to:</p>\r\n<ol>\r\n<li>Cancel the privacy service (which means that Your information will be available in the \"Whois\" directory) and/or reveal Your name and personal information that You provided to DBP:&nbsp;&nbsp;<br />A. When required by law, in the good faith belief that such action is necessary in order to conform to the edicts of the law or in the interest of public safety; <br />B. To comply with legal process served upon DBP or in response to a reasonable threat of litigation against DBP (as determined by DBP in its sole and absolute discretion); or <br />C. To comply with ICANN rules, policies, or procedures.</li>\r\n<li>Resolve any and all third party claims, whether threatened or made, arising out of Your use of a domain name&nbsp;for which DBP is the registrant listed in the \"Whois\" directory&nbsp;on Your behalf; or</li>\r\n<li>Take any other action DBP deems necessary: <br />A. In the event you breach any provision of this Agreement or the DBP Anti-Spam Policy; <br />B.&nbsp;To protect the integrity and stability of, and to comply with registration requirements, terms, conditions and policies of, the applicable domain name Registry and/or Registry Provider;<ol><ol>C. To comply with any applicable laws, government rules or requirements, subpoenas, court orders or requests of law enforcement;&nbsp;</ol></ol>D. To comply with ICANN's Dispute Resolution Policy or ICANN's Change of Registrant Policy; <br />E. To avoid any financial loss or legal liability (civil or criminal) on the part of DBP, its parent companies, subsidiaries, affiliates, shareholders, agents, officers, directors and employees; <br />F. If the domain name for which DBP is the registrant on Your behalf violates or infringes a third party's trademark, trade name or other legal rights; and <br />G. If it comes to DBP's attention that You are using DBP's services in a manner (as determined by DBP in its sole and absolute discretion) that:</li>\r\n</ol>\r\n<blockquote style=\"margin: 0 0 0 40px; border: none; padding: 0px;\">\r\n<ul>\r\n<li>Is illegal, or promotes or encourages illegal activity;</li>\r\n<li>Promotes, encourages or engages in child pornography or the exploitation of children;</li>\r\n<li>Promotes, encourages or engages in terrorism, violence against people, animals, or property;</li>\r\n<li>Promotes, encourages or engages in any spam or other unsolicited bulk email, or computer or network hacking or cracking;</li>\r\n<li>Violates the Ryan Haight Online Pharmacy Consumer Protection Act of 2008 or similar legislation, or promotes, encourages or engages in the sale or distribution of prescription medication without a valid prescription; &nbsp;</li>\r\n<li>Infringes on the intellectual property rights of another User or any other person or entity;</li>\r\n<li>Violates the privacy or publicity rights of another User or any other person or entity, or breaches any duty of confidentiality that you owe to another User or any other person or entity;</li>\r\n<li>Interferes with the operation of DBP services;</li>\r\n<li>Contains or installs any viruses, worms, bugs, Trojan horses or other code, files or programs designed to, or capable of, disrupting, damaging or limiting the functionality of any software or hardware; or</li>\r\n<li>Contains false or deceptive language, or unsubstantiated or comparative claims, regarding DBP or its services.</li>\r\n</ul>\r\n</blockquote>\r\n<p>You further understand and agree that if DBP is named as a defendant in, or investigated in anticipation of, any legal or administrative proceeding arising out of Your domain name registration or Your use of DBP's services, Your private registration service may be canceled, which means the domain name registration will revert back to You and Your identity will therefore be revealed in the Whois directory as Registrant.</p>\r\n<p>In the event:</p>\r\n<ol>\r\n<li>DBP takes any of the actions set forth in subsection&nbsp;i, ii, or iii&nbsp;above or section 5; and/or</li>\r\n<li>You elect to cancel DBP's services for any reason --</li>\r\n</ol>\r\n<p>Neither DBP nor your Registrar will refund any fees paid by You whatsoever.</p>\r\n<p class=\"heading1\">5. communications forwarding</p>\r\n<p><strong>a. Correspondence Forwarding </strong></p>\r\n<p>Inasmuch as DBP's name, postal address and phone number will be listed in the Whois directory, You agree DBP will review and forward communications addressed to Your domain name that are received via email, certified or traceable courier mail (such as UPS, FedEx, or DHL), or first class U.S. postal mail. You specifically acknowledge DBP will not forward to You first class postal mail (other than legal notices), \"junk\" mail or other unsolicited communications (whether delivered through email, fax, postal mail or telephone), and You further authorize DBP to either discard all such communications or return all such communications to sender unopened. You agree to waive any and all claims arising from Your failure to receive communications directed to Your domain name but not forwarded to You by DBP.</p>\r\n<p><strong>b. Email Forwarding </strong></p>\r\n<p>The Whois directory requires an email address for every purchased domain name registration. When You purchase a private domain registration, DBP creates a private email address for that domain name, \"@domainsbyproxy.com\". Thereafter, when messages are sent to that private email address, DBP handles them according to the email preference You selected for that particular domain name. You have three (3) email preferences from which to choose. You can elect to:</p>\r\n<ol>\r\n<li>Have all of the messages forwarded;</li>\r\n<li>Have all of the messages filtered for Spam and then forwarded; or</li>\r\n<li>Have none of the messages forwarded.</li>\r\n</ol>\r\n<p>As with all communications, You agree to waive any and all claims arising from Your failure to receive email directed to Your domain name but not forwarded to You by DBP.</p>\r\n<p><strong>c. Notifications Regarding Correspondence and Your Obligation to Respond </strong></p>\r\n<p>When DBP receives certified or traceable courier mail or legal notices addressed to Your domain name, in most cases, DBP will attempt to forward the mail to you via email. If&nbsp;You do not respond to the DBP email and/or the correspondence DBP has received regarding&nbsp;Your domain name registration concerns a&nbsp;dispute of any kind or otherwise requires immediate disposition, DBP may immediately reveal Your identity and/or cancel the DBP private registration service regarding either the domain name registration(s) in question.&nbsp;This means the Whois directory will revert to displaying Your name, postal address, email address and phone number that you provided to DBP.</p>\r\n<p><strong>d.&nbsp;</strong><strong>Additional Administrative Fees </strong></p>\r\n<p>DBP reserves the right to charge You&nbsp;reasonable&nbsp;\"administrative fees\" or \"processing fees\" for (i) &nbsp;tasks DBP may perform outside the normal scope of its&nbsp;Services, (ii) additional time and/or costs DBP may incur in providing its Services, and/or (iii) Your non-compliance with the Agreement (as determined by DBP in its sole and absolute discretion). Typical administrative or processing fee scenarios&nbsp;include, but are not limited to, (i) customer service issues that&nbsp;require additional personal time and attention; (ii)&nbsp;disputes that require accounting or&nbsp;legal services, whether performed by DBP staff or by outside firms retained by DBP; (iii) recouping any and all costs and fees, including the cost of Services, incurred by DBP as the result of chargebacks or other payment disputes brought by You, Your bank or Payment Method processor.&nbsp; These administrative fees or processing fees will be billed to the Payment Method You have on file with&nbsp;Your Registrar.</p>\r\n<p>You agree to waive the right to trial by jury in any proceeding that takes place relating to or arising out of this Agreement.</p>\r\n<p class=\"heading1\">6. limitations of liability</p>\r\n<p><strong>UNDER NO CIRCUMSTANCES SHALL DBP BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, PUNITIVE, SPECIAL, OR CONSEQUENTIAL DAMAGES FOR ANY REASON WHATSOEVER RELATED TO THIS AGREEMENT, YOUR DOMAIN NAME REGISTRATION, DBP'S SERVICES, USE OR INABILITY TO USE THE DBP WEBSITE OR THE MATERIALS AND CONTENT OF THE WEBSITE OR ANY OTHER WEBSITES LINKED TO THE DBP WEBSITE OR YOUR PROVISION OF ANY PERSONALLY IDENTIFIABLE INFORMATION TO DBP OR ANY THIRD PARTY. THIS LIMITATION APPLIES REGARDLESS OF WHETHER THE ALLEGED LIABILITY IS BASED ON CONTRACT, TORT, WARRANTY, NEGLIGENCE, STRICT LIABILITY OR ANY OTHER BASIS, EVEN IF DBP HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR SUCH DAMAGES WERE REASONABLY FORESEEABLE. BECAUSE CERTAIN JURISDICTIONS DO NOT PERMIT THE LIMITATION OR ELIMINATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES, DBP'S LIABILITY IN SUCH JURISDICTIONS SHALL BE LIMITED TO THE SMALLEST AMOUNT PERMITTED BY LAW. </strong></p>\r\n<p><strong>YOU FURTHER UNDERSTAND AND AGREE THAT DBP DISCLAIMS ANY LOSS OR LIABILITY RESULTING FROM: </strong></p>\r\n<ol>\r\n<li><strong>THE INADVERTENT DISCLOSURE OR THEFT OF YOUR PERSONAL INFORMATION; </strong></li>\r\n<li><strong>ACCESS DELAYS OR INTERRUPTIONS TO OUR WEBSITE OR THE WEBSITES OF OUR AFFILIATED REGISTRARS; </strong></li>\r\n<li><strong>DATA NON-DELIVERY OF MIS-DELIVERY BETWEEN YOU AND DBP; </strong></li>\r\n<li><strong>THE FAILURE FOR WHATEVER REASON TO RENEW A PRIVATE DOMAIN NAME REGISTRATION; </strong></li>\r\n<li><strong>THE UNAUTHORIZED USE OF YOUR DBP ACCOUNT OR ANY OF DBP'S SERVICES; </strong></li>\r\n<li><strong>ERRORS, OMISSIONS OR MISSTATEMENTS BY DBP; </strong></li>\r\n<li><strong>DELETION OF, FAILURE TO STORE, FAILURE TO PROCESS OR ACT UPON EMAIL MESSAGES FORWARDED TO EITHER YOU OR YOUR PRIVATE DOMAIN NAME REGISTRATION; </strong></li>\r\n<li><strong>PROCESSING OF UPDATED INFORMATION REGARDING YOUR DBP ACCOUNT; AND/OR </strong></li>\r\n<li><strong>ANY ACT OR OMISSION CAUSED BY YOU OR YOUR AGENTS (WHETHER AUTHORIZED BY YOU OR NOT). </strong></li>\r\n</ol>\r\n<p class=\"heading1\">7. indemnity</p>\r\n<p>You agree to release, defend, indemnify and hold harmless DBP, its parent companies, subsidiaries, affiliates, shareholders, agents, directors, officers and employees and Your Registrar, from and against any and all claims, demands, liabilities, losses, damages or costs, including reasonable attorneys' fees, arising out of or related in any way to this Agreement, the services provided hereunder by DBP, the DBP website, Your account with DBP, Your use of Your domain name registration, and/or disputes arising in connection with the <a href=\"http://www.icann.org/en/dndr/udrp/uniform-rules.htm\" target=\"_blank\">dispute policy</a>.</p>\r\n<p class=\"heading1\">8. DBP warranty disclaimer</p>\r\n<p><strong>DBP, ITS PARENT COMPANIES, SUBSIDIARIES, AFFILIATES, SHAREHOLDERS, AGENTS, DIRECTORS, OFFICERS, AND EMPLOYEES EXPRESSLY DISCLAIM ALL REPRESENTATIONS AND WARRANTIES OF ANY KIND IN CONNECTION WITH THIS AGREEMENT, THE SERVICE PROVIDED HEREUNDER, THE DBP WEBSITE OR ANY WEBSITES LINKED TO THE DBP WEBSITE, WHETHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL DBP SERVICES, AS WELL AS THE DBP WEBSITE, ARE PROVIDED \"AS IS\". YOUR SUBSCRIPTION TO AND USE OF DBP'S SERVICES AND ITS WEBSITE ARE ENTIRELY AT YOUR RISK. SOME JURISDICTIONS DO NOT ALLOW THE DISCLAIMER OF IMPLIED WARRANTIES, IN WHICH EVENT THE FOREGOING DISCLAIMER MAY NOT APPLY TO YOU. </strong></p>\r\n<p class=\"heading1\">9. copyright and trademark</p>\r\n<p>You understand and agree that all content and materials contained in this Agreement, the <a href=\"http://www.domainsbyproxy.com/policy/ShowDoc.aspx?pageid=privacy\" target=\"_blank\">Privacy Policy </a>and the DBP website <a href=\"http://www.domainsbyproxy.com/\" target=\"_blank\">found here </a>, are protected by the various copyright, patent, trademark, service mark and trade secret laws of the United States, as well as any other applicable proprietary rights and laws, and that DBP expressly reserves its rights in and to all such content and materials.</p>\r\n<p>You further understand and agree You are prohibited from using, in any manner whatsoever, any of the afore-described content and materials without the express written permission of DBP. No license or right under any copyright, patent, trademark, service mark or other proprietary right or license is granted to You or conferred upon You by this Agreement or otherwise.</p>\r\n<p class=\"heading1\">10. miscellaneous provisions</p>\r\n<p><strong>a. Severability; Construction; Entire Agreement </strong></p>\r\n<p>If any part of this Agreement shall be held to be illegal, unenforceable or invalid, in whole or in part, such provision shall be modified to the minimum extent necessary to make it legal, enforceable and valid, and the legality, enforceability and validity of the remaining provisions of this Agreement shall not be affected or impaired. The headings herein will not be considered a part of this Agreement. You agree this Agreement, including the policies it incorporates by reference, constitute the complete and only Agreement between You and DBP regarding the services contemplated herein.</p>\r\n<p><strong>b. Governing Law; Venue; Waiver Of Trial By Jury </strong></p>\r\n<p>This Agreement shall be governed in all respects by the laws and judicial decisions of Maricopa County, Arizona, excluding its conflicts of laws rules. Except as provided immediately below, You agree that any action relating to or arising out of this Agreement, shall be brought exclusively in the courts of Maricopa County, Arizona. For the adjudication of domain name registration disputes, you agree to submit to the exclusive jurisdiction and venue of the U.S. District Court for the District of Arizona located in Phoenix, Arizona. You agree to waive the right to trial by jury in any proceeding, regardless of venue, that takes place relating to or arising out of this Agreement.</p>\r\n<p><strong>c. Notices </strong></p>\r\n<p>All notices from DBP to You will be sent to the email address You provided to DBP. Notices by email shall be deemed effective twenty-four (24) hours after the email is sent by DBP, unless DBP receives notice that the email address is invalid, in which event DBP may give You notice via first class or certified mail, return receipt requested. All notices from You to DBP shall be sent via certified mail, return receipt requested or traceable courier to:</p>\r\n<ol><ol>Domains By Proxy, LLC</ol><ol>Attn: General Counsel</ol><ol>14455 North Hayden Rd.<br />Suite 219<br />Scottsdale, AZ 85260<br /></ol></ol>\r\n<p>Notices sent via certified mail or traceable courier shall be deemed effective five (5) days after the date of mailing.</p>\r\n<p><strong>d. Insurance </strong></p>\r\n<p>In the unlikely event You lose Your domain name registration to a third party solely as a result of DBP's negligent actions (and absent fraud or other negligent or willful misconduct committed by a third party), You may be insured against such loss through DBP's Professional Liability Insurance Policy, which is currently underwritten by American International Insurance Company. Of course, every claim is subject to the then-carrier's investigation into the facts and circumstances surrounding such claim. In the event You have reason to believe that circumstances exist which warrant the filing of an insurance claim, please send a written notice (specifying the basis for such claim), via certified mail, return receipt requested, to:</p>\r\n<ol><ol>Domains By Proxy, LLC</ol><ol>Attn: Insurance Claims</ol><ol>14455 North Hayden Rd.<br />Suite 219<br />Scottsdale, AZ 85260<br /></ol></ol>\r\n<p><strong>e. Indemnification </strong></p>\r\n<p>In the unlikely event You lose Your domain name registration to a third party solely as a result of DBP's willful misconduct, Your Registrar (the \"Indemnifying Party\") will indemnify and hold You harmless against any losses, damages or costs (including reasonable attorneys' fees) resulting from any claim, action, proceeding, suit or demand arising out of or related to the loss of Your domain name registration. Such indemnification obligations under this Section 10(e) are conditioned upon the following:</p>\r\n<ol>\r\n<li>That You promptly give both DBP and the Indemnifying Party written notice of the claim, demand, or action and provide reasonable assistance to the Indemnifying Party, at its cost and expense, in connection therewith, and</li>\r\n<li>That the Indemnifying Party has the right, at its option, to control and direct the defense to any settlement of such claim, demand, or action.</li>\r\n</ol>\r\n<p>Any notice concerning indemnification shall, with respect to DBP, be sent in accordance with Section 10(c) of this Agreement. With respect to Your Registrar, notices regarding indemnification should be sent in accordance with the notification provisions contained in Your Registrar's Domain Name Registration Agreement.</p>\r\n<p><strong>f. Term of Agreement; Survival </strong></p>\r\n<p>The terms of this Agreement shall continue in full force and effect as long as DBP is the Registrant for any domain name on Your behalf. Sections 5 (Communications Forwarding), 6 (Limitation of Liability), 7 (Indemnity), 8 (Warranty Disclaimer) and 10 (Miscellaneous Provisions) shall survive any termination or expiration of this Agreement.</p>\n</td></tr>\n<tr><td>\n<br />\n<span class=\"finePrint\">\nRevised: 10/25/17<br />\nCopyright &copy; 2003-2017  All Rights Reserved.\n</span>\n</td></tr>\n</tbody>\n</table>\n</td></tr>\n</tbody>\n</table>"),
		// 			Title: to.Ptr("Domain Name Proxy Agreement"),
		// 			URL: to.Ptr("http://www.secureserver.net/agreements/ShowDoc.aspx?pageid=domain_nameproxy&pl_id=510456"),
		// 	}},
		// }
	}
}
