//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/botservice/armbotservice"
	"net/http"
	"net/url"
	"regexp"
)

// DirectLineServer is a fake server for instances of the armbotservice.DirectLineClient type.
type DirectLineServer struct {
	// RegenerateKeys is the fake for method DirectLineClient.RegenerateKeys
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateKeys func(ctx context.Context, resourceGroupName string, resourceName string, channelName armbotservice.RegenerateKeysChannelName, parameters armbotservice.SiteInfo, options *armbotservice.DirectLineClientRegenerateKeysOptions) (resp azfake.Responder[armbotservice.DirectLineClientRegenerateKeysResponse], errResp azfake.ErrorResponder)
}

// NewDirectLineServerTransport creates a new instance of DirectLineServerTransport with the provided implementation.
// The returned DirectLineServerTransport instance is connected to an instance of armbotservice.DirectLineClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDirectLineServerTransport(srv *DirectLineServer) *DirectLineServerTransport {
	return &DirectLineServerTransport{srv: srv}
}

// DirectLineServerTransport connects instances of armbotservice.DirectLineClient to instances of DirectLineServer.
// Don't use this type directly, use NewDirectLineServerTransport instead.
type DirectLineServerTransport struct {
	srv *DirectLineServer
}

// Do implements the policy.Transporter interface for DirectLineServerTransport.
func (d *DirectLineServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DirectLineClient.RegenerateKeys":
		resp, err = d.dispatchRegenerateKeys(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DirectLineServerTransport) dispatchRegenerateKeys(req *http.Request) (*http.Response, error) {
	if d.srv.RegenerateKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.BotService/botServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/channels/(?P<channelName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regeneratekeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbotservice.SiteInfo](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	channelNameParam, err := parseWithCast(matches[regex.SubexpIndex("channelName")], func(v string) (armbotservice.RegenerateKeysChannelName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armbotservice.RegenerateKeysChannelName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.RegenerateKeys(req.Context(), resourceGroupNameParam, resourceNameParam, channelNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BotChannel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
