//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatashare_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_Get.json
func ExampleDataSetsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Get(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientGetResponse{
	// 	                            DataSetClassification: &armdatashare.BlobDataSet{
	// 		Name: to.Ptr("Dataset1"),
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindBlob),
	// 		Properties: &armdatashare.BlobProperties{
	// 			ContainerName: to.Ptr("C1"),
	// 			FilePath: to.Ptr("file21"),
	// 			ResourceGroup: to.Ptr("SampleResourceGroup"),
	// 			StorageAccountName: to.Ptr("storage2"),
	// 			SubscriptionID: to.Ptr("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_Create.json
func ExampleDataSetsClient_Create_dataSetsCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", &armdatashare.BlobDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindBlob),
		Properties: &armdatashare.BlobProperties{
			ContainerName:      to.Ptr("C1"),
			FilePath:           to.Ptr("file21"),
			ResourceGroup:      to.Ptr("SampleResourceGroup"),
			StorageAccountName: to.Ptr("storage2"),
			SubscriptionID:     to.Ptr("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.BlobDataSet{
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindBlob),
	// 		Properties: &armdatashare.BlobProperties{
	// 			ContainerName: to.Ptr("C1"),
	// 			DataSetID: to.Ptr("a08f184b-0567-4b11-ba22-a1199336d226"),
	// 			FilePath: to.Ptr("inputpath"),
	// 			ResourceGroup: to.Ptr("SampleResourceGroup"),
	// 			StorageAccountName: to.Ptr("adspipelinemetadatatable"),
	// 			SubscriptionID: to.Ptr("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_KustoCluster_Create.json
func ExampleDataSetsClient_Create_dataSetsKustoClusterCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", &armdatashare.KustoClusterDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindKustoCluster),
		Properties: &armdatashare.KustoClusterDataSetProperties{
			KustoClusterResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.KustoClusterDataSet{
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindKustoCluster),
	// 		Properties: &armdatashare.KustoClusterDataSetProperties{
	// 			DataSetID: to.Ptr("a08f184b-0567-4b11-ba22-a1199336d226"),
	// 			KustoClusterResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1"),
	// 			Location: to.Ptr("West US 2"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_KustoDatabase_Create.json
func ExampleDataSetsClient_Create_dataSetsKustoDatabaseCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", &armdatashare.KustoDatabaseDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindKustoDatabase),
		Properties: &armdatashare.KustoDatabaseDataSetProperties{
			KustoDatabaseResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1/databases/Database1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.KustoDatabaseDataSet{
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindKustoDatabase),
	// 		Properties: &armdatashare.KustoDatabaseDataSetProperties{
	// 			DataSetID: to.Ptr("a08f184b-0567-4b11-ba22-a1199336d226"),
	// 			KustoDatabaseResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Kusto/clusters/Cluster1/databases/Database1"),
	// 			Location: to.Ptr("West US 2"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_SqlDBTable_Create.json
func ExampleDataSetsClient_Create_dataSetsSqlDbTableCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", &armdatashare.SQLDBTableDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindSQLDBTable),
		Properties: &armdatashare.SQLDBTableProperties{
			DatabaseName:        to.Ptr("SqlDB1"),
			SchemaName:          to.Ptr("dbo"),
			SQLServerResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
			TableName:           to.Ptr("Table1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.SQLDBTableDataSet{
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindSQLDBTable),
	// 		Properties: &armdatashare.SQLDBTableProperties{
	// 			DataSetID: to.Ptr("a08f184b-0567-4b11-ba22-a1199336d226"),
	// 			DatabaseName: to.Ptr("SqlDB1"),
	// 			SchemaName: to.Ptr("dbo"),
	// 			SQLServerResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
	// 			TableName: to.Ptr("Table1"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_SqlDWTable_Create.json
func ExampleDataSetsClient_Create_dataSetsSqlDwTableCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", &armdatashare.SQLDWTableDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindSQLDWTable),
		Properties: &armdatashare.SQLDWTableProperties{
			DataWarehouseName:   to.Ptr("DataWarehouse1"),
			SchemaName:          to.Ptr("dbo"),
			SQLServerResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
			TableName:           to.Ptr("Table1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.SQLDWTableDataSet{
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindSQLDWTable),
	// 		Properties: &armdatashare.SQLDWTableProperties{
	// 			DataSetID: to.Ptr("a08f184b-0567-4b11-ba22-a1199336d226"),
	// 			DataWarehouseName: to.Ptr("DataWarehouse1"),
	// 			SchemaName: to.Ptr("dbo"),
	// 			SQLServerResourceID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
	// 			TableName: to.Ptr("Table1"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_SynapseWorkspaceSqlPoolTable_Create.json
func ExampleDataSetsClient_Create_dataSetsSynapseWorkspaceSqlPoolTableCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSetsClient().Create(ctx, "SampleResourceGroup", "sourceAccount", "share1", "dataset1", &armdatashare.SynapseWorkspaceSQLPoolTableDataSet{
		Kind: to.Ptr(armdatashare.DataSetKindSynapseWorkspaceSQLPoolTable),
		Properties: &armdatashare.SynapseWorkspaceSQLPoolTableDataSetProperties{
			SynapseWorkspaceSQLPoolTableResourceID: to.Ptr("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armdatashare.DataSetsClientCreateResponse{
	// 	                            DataSetClassification: &armdatashare.SynapseWorkspaceSQLPoolTableDataSet{
	// 		Name: to.Ptr("dataset1"),
	// 		Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
	// 		ID: to.Ptr("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/sourceAccount/shares/share1/dataSets/dataset1"),
	// 		Kind: to.Ptr(armdatashare.DataSetKindSynapseWorkspaceSQLPoolTable),
	// 		Properties: &armdatashare.SynapseWorkspaceSQLPoolTableDataSetProperties{
	// 			SynapseWorkspaceSQLPoolTableResourceID: to.Ptr("/subscriptions/0f3dcfc3-18f8-4099-b381-8353e19d43a7/resourceGroups/SampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool/schemas/dbo/tables/table1"),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_Delete.json
func ExampleDataSetsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataSetsClient().BeginDelete(ctx, "SampleResourceGroup", "Account1", "Share1", "Dataset1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/DataSets_ListByShare.json
func ExampleDataSetsClient_NewListBySharePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataSetsClient().NewListBySharePager("SampleResourceGroup", "Account1", "Share1", &armdatashare.DataSetsClientListByShareOptions{SkipToken: nil,
		Filter:  nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataSetList = armdatashare.DataSetList{
		// 	Value: []armdatashare.DataSetClassification{
		// 		&armdatashare.BlobDataSet{
		// 			Name: to.Ptr("Dataset1"),
		// 			Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
		// 			ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset1"),
		// 			Kind: to.Ptr(armdatashare.DataSetKindBlob),
		// 			Properties: &armdatashare.BlobProperties{
		// 				ContainerName: to.Ptr("C1"),
		// 				FilePath: to.Ptr("file22"),
		// 				ResourceGroup: to.Ptr("SampleResourceGroup"),
		// 				StorageAccountName: to.Ptr("storage1"),
		// 				SubscriptionID: to.Ptr("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
		// 			},
		// 		},
		// 		&armdatashare.BlobDataSet{
		// 			Name: to.Ptr("Dataset1"),
		// 			Type: to.Ptr("Microsoft.DataShare/accounts/shares/dataSets"),
		// 			ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/shares/Share1/datasets/Dataset2"),
		// 			Kind: to.Ptr(armdatashare.DataSetKindBlob),
		// 			Properties: &armdatashare.BlobProperties{
		// 				ContainerName: to.Ptr("C1"),
		// 				FilePath: to.Ptr("file21"),
		// 				ResourceGroup: to.Ptr("SampleResourceGroup"),
		// 				StorageAccountName: to.Ptr("storage2"),
		// 				SubscriptionID: to.Ptr("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
		// 			},
		// 	}},
		// }
	}
}
