//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ExtensionTopicsServer is a fake server for instances of the armeventgrid.ExtensionTopicsClient type.
type ExtensionTopicsServer struct {
	// Get is the fake for method ExtensionTopicsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, options *armeventgrid.ExtensionTopicsClientGetOptions) (resp azfake.Responder[armeventgrid.ExtensionTopicsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewExtensionTopicsServerTransport creates a new instance of ExtensionTopicsServerTransport with the provided implementation.
// The returned ExtensionTopicsServerTransport instance is connected to an instance of armeventgrid.ExtensionTopicsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExtensionTopicsServerTransport(srv *ExtensionTopicsServer) *ExtensionTopicsServerTransport {
	return &ExtensionTopicsServerTransport{srv: srv}
}

// ExtensionTopicsServerTransport connects instances of armeventgrid.ExtensionTopicsClient to instances of ExtensionTopicsServer.
// Don't use this type directly, use NewExtensionTopicsServerTransport instead.
type ExtensionTopicsServerTransport struct {
	srv *ExtensionTopicsServer
}

// Do implements the policy.Transporter interface for ExtensionTopicsServerTransport.
func (e *ExtensionTopicsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExtensionTopicsClient.Get":
		resp, err = e.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExtensionTopicsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/extensionTopics/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), scopeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionTopic, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
