//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
	"net/http"
	"net/url"
	"regexp"
)

// FirmwareServer is a fake server for instances of the armiotfirmwaredefense.FirmwareClient type.
type FirmwareServer struct {
	// Create is the fake for method FirmwareClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware armiotfirmwaredefense.Firmware, options *armiotfirmwaredefense.FirmwareClientCreateOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method FirmwareClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientDeleteOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientDeleteResponse], errResp azfake.ErrorResponder)

	// GenerateBinaryHardeningDetails is the fake for method FirmwareClient.GenerateBinaryHardeningDetails
	// HTTP status codes to indicate success: http.StatusOK
	GenerateBinaryHardeningDetails func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateBinaryHardeningDetailsOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateBinaryHardeningDetailsResponse], errResp azfake.ErrorResponder)

	// GenerateBinaryHardeningSummary is the fake for method FirmwareClient.GenerateBinaryHardeningSummary
	// HTTP status codes to indicate success: http.StatusOK
	GenerateBinaryHardeningSummary func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateBinaryHardeningSummaryOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateBinaryHardeningSummaryResponse], errResp azfake.ErrorResponder)

	// GenerateComponentDetails is the fake for method FirmwareClient.GenerateComponentDetails
	// HTTP status codes to indicate success: http.StatusOK
	GenerateComponentDetails func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateComponentDetailsOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateComponentDetailsResponse], errResp azfake.ErrorResponder)

	// GenerateCryptoCertificateSummary is the fake for method FirmwareClient.GenerateCryptoCertificateSummary
	// HTTP status codes to indicate success: http.StatusOK
	GenerateCryptoCertificateSummary func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateCryptoCertificateSummaryOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateCryptoCertificateSummaryResponse], errResp azfake.ErrorResponder)

	// GenerateCryptoKeySummary is the fake for method FirmwareClient.GenerateCryptoKeySummary
	// HTTP status codes to indicate success: http.StatusOK
	GenerateCryptoKeySummary func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateCryptoKeySummaryOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateCryptoKeySummaryResponse], errResp azfake.ErrorResponder)

	// GenerateCveSummary is the fake for method FirmwareClient.GenerateCveSummary
	// HTTP status codes to indicate success: http.StatusOK
	GenerateCveSummary func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateCveSummaryOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateCveSummaryResponse], errResp azfake.ErrorResponder)

	// GenerateDownloadURL is the fake for method FirmwareClient.GenerateDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GenerateDownloadURL func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateDownloadURLOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateDownloadURLResponse], errResp azfake.ErrorResponder)

	// GenerateFilesystemDownloadURL is the fake for method FirmwareClient.GenerateFilesystemDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GenerateFilesystemDownloadURL func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateFilesystemDownloadURLOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateFilesystemDownloadURLResponse], errResp azfake.ErrorResponder)

	// GenerateSummary is the fake for method FirmwareClient.GenerateSummary
	// HTTP status codes to indicate success: http.StatusOK
	GenerateSummary func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGenerateSummaryOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGenerateSummaryResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FirmwareClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientGetOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkspacePager is the fake for method FirmwareClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armiotfirmwaredefense.FirmwareClientListByWorkspaceOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListByWorkspaceResponse])

	// NewListGenerateBinaryHardeningListPager is the fake for method FirmwareClient.NewListGenerateBinaryHardeningListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGenerateBinaryHardeningListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGenerateBinaryHardeningListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateBinaryHardeningListResponse])

	// NewListGenerateComponentListPager is the fake for method FirmwareClient.NewListGenerateComponentListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGenerateComponentListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGenerateComponentListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateComponentListResponse])

	// NewListGenerateCryptoCertificateListPager is the fake for method FirmwareClient.NewListGenerateCryptoCertificateListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGenerateCryptoCertificateListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGenerateCryptoCertificateListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoCertificateListResponse])

	// NewListGenerateCryptoKeyListPager is the fake for method FirmwareClient.NewListGenerateCryptoKeyListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGenerateCryptoKeyListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGenerateCryptoKeyListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoKeyListResponse])

	// NewListGenerateCveListPager is the fake for method FirmwareClient.NewListGenerateCveListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGenerateCveListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGenerateCveListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCveListResponse])

	// NewListGeneratePasswordHashListPager is the fake for method FirmwareClient.NewListGeneratePasswordHashListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGeneratePasswordHashListPager func(resourceGroupName string, workspaceName string, firmwareID string, options *armiotfirmwaredefense.FirmwareClientListGeneratePasswordHashListOptions) (resp azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGeneratePasswordHashListResponse])

	// Update is the fake for method FirmwareClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Update func(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware armiotfirmwaredefense.FirmwareUpdateDefinition, options *armiotfirmwaredefense.FirmwareClientUpdateOptions) (resp azfake.Responder[armiotfirmwaredefense.FirmwareClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewFirmwareServerTransport creates a new instance of FirmwareServerTransport with the provided implementation.
// The returned FirmwareServerTransport instance is connected to an instance of armiotfirmwaredefense.FirmwareClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFirmwareServerTransport(srv *FirmwareServer) *FirmwareServerTransport {
	return &FirmwareServerTransport{
		srv:                                       srv,
		newListByWorkspacePager:                   newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListByWorkspaceResponse]](),
		newListGenerateBinaryHardeningListPager:   newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateBinaryHardeningListResponse]](),
		newListGenerateComponentListPager:         newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateComponentListResponse]](),
		newListGenerateCryptoCertificateListPager: newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoCertificateListResponse]](),
		newListGenerateCryptoKeyListPager:         newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoKeyListResponse]](),
		newListGenerateCveListPager:               newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCveListResponse]](),
		newListGeneratePasswordHashListPager:      newTracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGeneratePasswordHashListResponse]](),
	}
}

// FirmwareServerTransport connects instances of armiotfirmwaredefense.FirmwareClient to instances of FirmwareServer.
// Don't use this type directly, use NewFirmwareServerTransport instead.
type FirmwareServerTransport struct {
	srv                                       *FirmwareServer
	newListByWorkspacePager                   *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListByWorkspaceResponse]]
	newListGenerateBinaryHardeningListPager   *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateBinaryHardeningListResponse]]
	newListGenerateComponentListPager         *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateComponentListResponse]]
	newListGenerateCryptoCertificateListPager *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoCertificateListResponse]]
	newListGenerateCryptoKeyListPager         *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCryptoKeyListResponse]]
	newListGenerateCveListPager               *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGenerateCveListResponse]]
	newListGeneratePasswordHashListPager      *tracker[azfake.PagerResponder[armiotfirmwaredefense.FirmwareClientListGeneratePasswordHashListResponse]]
}

// Do implements the policy.Transporter interface for FirmwareServerTransport.
func (f *FirmwareServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FirmwareClient.Create":
		resp, err = f.dispatchCreate(req)
	case "FirmwareClient.Delete":
		resp, err = f.dispatchDelete(req)
	case "FirmwareClient.GenerateBinaryHardeningDetails":
		resp, err = f.dispatchGenerateBinaryHardeningDetails(req)
	case "FirmwareClient.GenerateBinaryHardeningSummary":
		resp, err = f.dispatchGenerateBinaryHardeningSummary(req)
	case "FirmwareClient.GenerateComponentDetails":
		resp, err = f.dispatchGenerateComponentDetails(req)
	case "FirmwareClient.GenerateCryptoCertificateSummary":
		resp, err = f.dispatchGenerateCryptoCertificateSummary(req)
	case "FirmwareClient.GenerateCryptoKeySummary":
		resp, err = f.dispatchGenerateCryptoKeySummary(req)
	case "FirmwareClient.GenerateCveSummary":
		resp, err = f.dispatchGenerateCveSummary(req)
	case "FirmwareClient.GenerateDownloadURL":
		resp, err = f.dispatchGenerateDownloadURL(req)
	case "FirmwareClient.GenerateFilesystemDownloadURL":
		resp, err = f.dispatchGenerateFilesystemDownloadURL(req)
	case "FirmwareClient.GenerateSummary":
		resp, err = f.dispatchGenerateSummary(req)
	case "FirmwareClient.Get":
		resp, err = f.dispatchGet(req)
	case "FirmwareClient.NewListByWorkspacePager":
		resp, err = f.dispatchNewListByWorkspacePager(req)
	case "FirmwareClient.NewListGenerateBinaryHardeningListPager":
		resp, err = f.dispatchNewListGenerateBinaryHardeningListPager(req)
	case "FirmwareClient.NewListGenerateComponentListPager":
		resp, err = f.dispatchNewListGenerateComponentListPager(req)
	case "FirmwareClient.NewListGenerateCryptoCertificateListPager":
		resp, err = f.dispatchNewListGenerateCryptoCertificateListPager(req)
	case "FirmwareClient.NewListGenerateCryptoKeyListPager":
		resp, err = f.dispatchNewListGenerateCryptoKeyListPager(req)
	case "FirmwareClient.NewListGenerateCveListPager":
		resp, err = f.dispatchNewListGenerateCveListPager(req)
	case "FirmwareClient.NewListGeneratePasswordHashListPager":
		resp, err = f.dispatchNewListGeneratePasswordHashListPager(req)
	case "FirmwareClient.Update":
		resp, err = f.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FirmwareServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if f.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotfirmwaredefense.Firmware](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Create(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if f.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateBinaryHardeningDetails(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateBinaryHardeningDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateBinaryHardeningDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateBinaryHardeningDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateBinaryHardeningDetails(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BinaryHardening, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateBinaryHardeningSummary(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateBinaryHardeningSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateBinaryHardeningSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateBinaryHardeningSummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateBinaryHardeningSummary(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BinaryHardeningSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateComponentDetails(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateComponentDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateComponentDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateComponentDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateComponentDetails(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Component, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateCryptoCertificateSummary(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateCryptoCertificateSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateCryptoCertificateSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCryptoCertificateSummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateCryptoCertificateSummary(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CryptoCertificateSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateCryptoKeySummary(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateCryptoKeySummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateCryptoKeySummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCryptoKeySummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateCryptoKeySummary(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CryptoKeySummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateCveSummary(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateCveSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateCveSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCveSummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateCveSummary(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CveSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateDownloadURL(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateDownloadURL(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).URLToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateFilesystemDownloadURL(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateFilesystemDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateFilesystemDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateFilesystemDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateFilesystemDownloadURL(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).URLToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGenerateSummary(req *http.Request) (*http.Response, error) {
	if f.srv.GenerateSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateSummary not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateSummary`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GenerateSummary(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FirmwareSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := f.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		f.newListByWorkspacePager.add(req, newListByWorkspacePager)
		server.PagerResponderInjectNextLinks(newListByWorkspacePager, req, func(page *armiotfirmwaredefense.FirmwareClientListByWorkspaceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		f.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGenerateBinaryHardeningListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGenerateBinaryHardeningListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGenerateBinaryHardeningListPager not implemented")}
	}
	newListGenerateBinaryHardeningListPager := f.newListGenerateBinaryHardeningListPager.get(req)
	if newListGenerateBinaryHardeningListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateBinaryHardeningList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGenerateBinaryHardeningListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGenerateBinaryHardeningListPager = &resp
		f.newListGenerateBinaryHardeningListPager.add(req, newListGenerateBinaryHardeningListPager)
		server.PagerResponderInjectNextLinks(newListGenerateBinaryHardeningListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGenerateBinaryHardeningListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGenerateBinaryHardeningListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGenerateBinaryHardeningListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGenerateBinaryHardeningListPager) {
		f.newListGenerateBinaryHardeningListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGenerateComponentListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGenerateComponentListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGenerateComponentListPager not implemented")}
	}
	newListGenerateComponentListPager := f.newListGenerateComponentListPager.get(req)
	if newListGenerateComponentListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateComponentList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGenerateComponentListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGenerateComponentListPager = &resp
		f.newListGenerateComponentListPager.add(req, newListGenerateComponentListPager)
		server.PagerResponderInjectNextLinks(newListGenerateComponentListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGenerateComponentListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGenerateComponentListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGenerateComponentListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGenerateComponentListPager) {
		f.newListGenerateComponentListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGenerateCryptoCertificateListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGenerateCryptoCertificateListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGenerateCryptoCertificateListPager not implemented")}
	}
	newListGenerateCryptoCertificateListPager := f.newListGenerateCryptoCertificateListPager.get(req)
	if newListGenerateCryptoCertificateListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCryptoCertificateList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGenerateCryptoCertificateListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGenerateCryptoCertificateListPager = &resp
		f.newListGenerateCryptoCertificateListPager.add(req, newListGenerateCryptoCertificateListPager)
		server.PagerResponderInjectNextLinks(newListGenerateCryptoCertificateListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGenerateCryptoCertificateListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGenerateCryptoCertificateListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGenerateCryptoCertificateListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGenerateCryptoCertificateListPager) {
		f.newListGenerateCryptoCertificateListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGenerateCryptoKeyListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGenerateCryptoKeyListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGenerateCryptoKeyListPager not implemented")}
	}
	newListGenerateCryptoKeyListPager := f.newListGenerateCryptoKeyListPager.get(req)
	if newListGenerateCryptoKeyListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCryptoKeyList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGenerateCryptoKeyListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGenerateCryptoKeyListPager = &resp
		f.newListGenerateCryptoKeyListPager.add(req, newListGenerateCryptoKeyListPager)
		server.PagerResponderInjectNextLinks(newListGenerateCryptoKeyListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGenerateCryptoKeyListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGenerateCryptoKeyListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGenerateCryptoKeyListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGenerateCryptoKeyListPager) {
		f.newListGenerateCryptoKeyListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGenerateCveListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGenerateCveListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGenerateCveListPager not implemented")}
	}
	newListGenerateCveListPager := f.newListGenerateCveListPager.get(req)
	if newListGenerateCveListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCveList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGenerateCveListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGenerateCveListPager = &resp
		f.newListGenerateCveListPager.add(req, newListGenerateCveListPager)
		server.PagerResponderInjectNextLinks(newListGenerateCveListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGenerateCveListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGenerateCveListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGenerateCveListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGenerateCveListPager) {
		f.newListGenerateCveListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchNewListGeneratePasswordHashListPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListGeneratePasswordHashListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGeneratePasswordHashListPager not implemented")}
	}
	newListGeneratePasswordHashListPager := f.newListGeneratePasswordHashListPager.get(req)
	if newListGeneratePasswordHashListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generatePasswordHashList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListGeneratePasswordHashListPager(resourceGroupNameParam, workspaceNameParam, firmwareIDParam, nil)
		newListGeneratePasswordHashListPager = &resp
		f.newListGeneratePasswordHashListPager.add(req, newListGeneratePasswordHashListPager)
		server.PagerResponderInjectNextLinks(newListGeneratePasswordHashListPager, req, func(page *armiotfirmwaredefense.FirmwareClientListGeneratePasswordHashListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGeneratePasswordHashListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListGeneratePasswordHashListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGeneratePasswordHashListPager) {
		f.newListGeneratePasswordHashListPager.remove(req)
	}
	return resp, nil
}

func (f *FirmwareServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTFirmwareDefense/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firmwares/(?P<firmwareId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotfirmwaredefense.FirmwareUpdateDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	firmwareIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("firmwareId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Update(req.Context(), resourceGroupNameParam, workspaceNameParam, firmwareIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Firmware, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
