//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2021-06-01/examples/WorkspacesSubscriptionList.json
func ExampleDeletedWorkspacesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDeletedWorkspacesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armoperationalinsights.WorkspaceListResult{
		// 	Value: []*armoperationalinsights.Workspace{
		// 		{
		// 			Name: to.Ptr("AzTest2170"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/oiautorest6685/providers/microsoft.operationalinsights/workspaces/aztest2170"),
		// 			Location: to.Ptr("australiasoutheast"),
		// 			Tags: map[string]*string{
		// 				"tag1": to.Ptr("val1"),
		// 			},
		// 			Properties: &armoperationalinsights.WorkspaceProperties{
		// 				CustomerID: to.Ptr("bc089d7b-485c-4aff-a71e-c00f362d8d2f"),
		// 				ProvisioningState: to.Ptr(armoperationalinsights.WorkspaceEntityStatusSucceeded),
		// 				PublicNetworkAccessForIngestion: to.Ptr(armoperationalinsights.PublicNetworkAccessTypeEnabled),
		// 				PublicNetworkAccessForQuery: to.Ptr(armoperationalinsights.PublicNetworkAccessTypeEnabled),
		// 				RetentionInDays: to.Ptr[int32](30),
		// 				SKU: &armoperationalinsights.WorkspaceSKU{
		// 					Name: to.Ptr(armoperationalinsights.WorkspaceSKUNameEnumPerGB2018),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2021-06-01/examples/WorkspacesListByResourceGroup.json
func ExampleDeletedWorkspacesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDeletedWorkspacesClient().NewListByResourceGroupPager("oiautorest6685", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceListResult = armoperationalinsights.WorkspaceListResult{
		// 	Value: []*armoperationalinsights.Workspace{
		// 		{
		// 			Name: to.Ptr("AzTest2170"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/oiautorest6685/providers/microsoft.operationalinsights/workspaces/aztest2170"),
		// 			Location: to.Ptr("australiasoutheast"),
		// 			Tags: map[string]*string{
		// 				"tag1": to.Ptr("val1"),
		// 			},
		// 			Properties: &armoperationalinsights.WorkspaceProperties{
		// 				CustomerID: to.Ptr("bc089d7b-485c-4aff-a71e-c00f362d8d2f"),
		// 				ProvisioningState: to.Ptr(armoperationalinsights.WorkspaceEntityStatusSucceeded),
		// 				PublicNetworkAccessForIngestion: to.Ptr(armoperationalinsights.PublicNetworkAccessTypeEnabled),
		// 				PublicNetworkAccessForQuery: to.Ptr(armoperationalinsights.PublicNetworkAccessTypeEnabled),
		// 				RetentionInDays: to.Ptr[int32](30),
		// 				SKU: &armoperationalinsights.WorkspaceSKU{
		// 					Name: to.Ptr(armoperationalinsights.WorkspaceSKUNameEnumPerGB2018),
		// 				},
		// 			},
		// 	}},
		// }
	}
}
