//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/redhatopenshift/armredhatopenshift"
	"net/http"
	"net/url"
	"regexp"
)

// OpenShiftVersionsServer is a fake server for instances of the armredhatopenshift.OpenShiftVersionsClient type.
type OpenShiftVersionsServer struct {
	// NewListPager is the fake for method OpenShiftVersionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(location string, options *armredhatopenshift.OpenShiftVersionsClientListOptions) (resp azfake.PagerResponder[armredhatopenshift.OpenShiftVersionsClientListResponse])
}

// NewOpenShiftVersionsServerTransport creates a new instance of OpenShiftVersionsServerTransport with the provided implementation.
// The returned OpenShiftVersionsServerTransport instance is connected to an instance of armredhatopenshift.OpenShiftVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOpenShiftVersionsServerTransport(srv *OpenShiftVersionsServer) *OpenShiftVersionsServerTransport {
	return &OpenShiftVersionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armredhatopenshift.OpenShiftVersionsClientListResponse]](),
	}
}

// OpenShiftVersionsServerTransport connects instances of armredhatopenshift.OpenShiftVersionsClient to instances of OpenShiftVersionsServer.
// Don't use this type directly, use NewOpenShiftVersionsServerTransport instead.
type OpenShiftVersionsServerTransport struct {
	srv          *OpenShiftVersionsServer
	newListPager *tracker[azfake.PagerResponder[armredhatopenshift.OpenShiftVersionsClientListResponse]]
}

// Do implements the policy.Transporter interface for OpenShiftVersionsServerTransport.
func (o *OpenShiftVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OpenShiftVersionsClient.NewListPager":
		resp, err = o.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OpenShiftVersionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := o.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RedHatOpenShift/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/openshiftversions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListPager(locationParam, nil)
		newListPager = &resp
		o.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armredhatopenshift.OpenShiftVersionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		o.newListPager.remove(req)
	}
	return resp, nil
}
