//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securitydevops/armsecuritydevops"
	"net/http"
	"net/url"
	"regexp"
)

// GitHubRepoServer is a fake server for instances of the armsecuritydevops.GitHubRepoClient type.
type GitHubRepoServer struct {
	// BeginCreateOrUpdate is the fake for method GitHubRepoClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo armsecuritydevops.GitHubRepo, options *armsecuritydevops.GitHubRepoClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.GitHubRepoClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method GitHubRepoClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, options *armsecuritydevops.GitHubRepoClientGetOptions) (resp azfake.Responder[armsecuritydevops.GitHubRepoClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method GitHubRepoClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, options *armsecuritydevops.GitHubRepoClientListOptions) (resp azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListResponse])

	// NewListByConnectorPager is the fake for method GitHubRepoClient.NewListByConnectorPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByConnectorPager func(resourceGroupName string, gitHubConnectorName string, options *armsecuritydevops.GitHubRepoClientListByConnectorOptions) (resp azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListByConnectorResponse])

	// BeginUpdate is the fake for method GitHubRepoClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo armsecuritydevops.GitHubRepo, options *armsecuritydevops.GitHubRepoClientBeginUpdateOptions) (resp azfake.PollerResponder[armsecuritydevops.GitHubRepoClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewGitHubRepoServerTransport creates a new instance of GitHubRepoServerTransport with the provided implementation.
// The returned GitHubRepoServerTransport instance is connected to an instance of armsecuritydevops.GitHubRepoClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGitHubRepoServerTransport(srv *GitHubRepoServer) *GitHubRepoServerTransport {
	return &GitHubRepoServerTransport{
		srv:                     srv,
		beginCreateOrUpdate:     newTracker[azfake.PollerResponder[armsecuritydevops.GitHubRepoClientCreateOrUpdateResponse]](),
		newListPager:            newTracker[azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListResponse]](),
		newListByConnectorPager: newTracker[azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListByConnectorResponse]](),
		beginUpdate:             newTracker[azfake.PollerResponder[armsecuritydevops.GitHubRepoClientUpdateResponse]](),
	}
}

// GitHubRepoServerTransport connects instances of armsecuritydevops.GitHubRepoClient to instances of GitHubRepoServer.
// Don't use this type directly, use NewGitHubRepoServerTransport instead.
type GitHubRepoServerTransport struct {
	srv                     *GitHubRepoServer
	beginCreateOrUpdate     *tracker[azfake.PollerResponder[armsecuritydevops.GitHubRepoClientCreateOrUpdateResponse]]
	newListPager            *tracker[azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListResponse]]
	newListByConnectorPager *tracker[azfake.PagerResponder[armsecuritydevops.GitHubRepoClientListByConnectorResponse]]
	beginUpdate             *tracker[azfake.PollerResponder[armsecuritydevops.GitHubRepoClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for GitHubRepoServerTransport.
func (g *GitHubRepoServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GitHubRepoClient.BeginCreateOrUpdate":
		resp, err = g.dispatchBeginCreateOrUpdate(req)
	case "GitHubRepoClient.Get":
		resp, err = g.dispatchGet(req)
	case "GitHubRepoClient.NewListPager":
		resp, err = g.dispatchNewListPager(req)
	case "GitHubRepoClient.NewListByConnectorPager":
		resp, err = g.dispatchNewListByConnectorPager(req)
	case "GitHubRepoClient.BeginUpdate":
		resp, err = g.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GitHubRepoServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := g.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repos/(?P<gitHubRepoName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.GitHubRepo](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
		if err != nil {
			return nil, err
		}
		gitHubRepoNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubRepoName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, gitHubRepoNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		g.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		g.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		g.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (g *GitHubRepoServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repos/(?P<gitHubRepoName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
	if err != nil {
		return nil, err
	}
	gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
	if err != nil {
		return nil, err
	}
	gitHubRepoNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubRepoName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, gitHubRepoNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GitHubRepo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GitHubRepoServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := g.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repos`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListPager(resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, nil)
		newListPager = &resp
		g.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecuritydevops.GitHubRepoClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		g.newListPager.remove(req)
	}
	return resp, nil
}

func (g *GitHubRepoServerTransport) dispatchNewListByConnectorPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListByConnectorPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByConnectorPager not implemented")}
	}
	newListByConnectorPager := g.newListByConnectorPager.get(req)
	if newListByConnectorPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repos`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListByConnectorPager(resourceGroupNameParam, gitHubConnectorNameParam, nil)
		newListByConnectorPager = &resp
		g.newListByConnectorPager.add(req, newListByConnectorPager)
		server.PagerResponderInjectNextLinks(newListByConnectorPager, req, func(page *armsecuritydevops.GitHubRepoClientListByConnectorResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByConnectorPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListByConnectorPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByConnectorPager) {
		g.newListByConnectorPager.remove(req)
	}
	return resp, nil
}

func (g *GitHubRepoServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := g.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/gitHubConnectors/(?P<gitHubConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/owners/(?P<gitHubOwnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repos/(?P<gitHubRepoName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecuritydevops.GitHubRepo](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		gitHubConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubConnectorName")])
		if err != nil {
			return nil, err
		}
		gitHubOwnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubOwnerName")])
		if err != nil {
			return nil, err
		}
		gitHubRepoNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("gitHubRepoName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginUpdate(req.Context(), resourceGroupNameParam, gitHubConnectorNameParam, gitHubOwnerNameParam, gitHubRepoNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		g.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		g.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		g.beginUpdate.remove(req)
	}

	return resp, nil
}
