//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolVulnerabilityAssessmentRuleBaselinesServer is a fake server for instances of the armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClient type.
type SQLPoolVulnerabilityAssessmentRuleBaselinesServer struct {
	// CreateOrUpdate is the fake for method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, ruleID string, baselineName armsynapse.VulnerabilityAssessmentPolicyBaselineName, parameters armsynapse.SQLPoolVulnerabilityAssessmentRuleBaseline, options *armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (resp azfake.Responder[armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, ruleID string, baselineName armsynapse.VulnerabilityAssessmentPolicyBaselineName, options *armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (resp azfake.Responder[armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, vulnerabilityAssessmentName armsynapse.VulnerabilityAssessmentName, ruleID string, baselineName armsynapse.VulnerabilityAssessmentPolicyBaselineName, options *armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport creates a new instance of SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport with the provided implementation.
// The returned SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport instance is connected to an instance of armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport(srv *SQLPoolVulnerabilityAssessmentRuleBaselinesServer) *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport {
	return &SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport{srv: srv}
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport connects instances of armsynapse.SQLPoolVulnerabilityAssessmentRuleBaselinesClient to instances of SQLPoolVulnerabilityAssessmentRuleBaselinesServer.
// Don't use this type directly, use NewSQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport instead.
type SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport struct {
	srv *SQLPoolVulnerabilityAssessmentRuleBaselinesServer
}

// Do implements the policy.Transporter interface for SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport.
func (s *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.SQLPoolVulnerabilityAssessmentRuleBaseline](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsynapse.VulnerabilityAssessmentPolicyBaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentPolicyBaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, ruleIDParam, baselineNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolVulnerabilityAssessmentRuleBaseline, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsynapse.VulnerabilityAssessmentPolicyBaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentPolicyBaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, ruleIDParam, baselineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsynapse.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsynapse.VulnerabilityAssessmentPolicyBaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.VulnerabilityAssessmentPolicyBaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, vulnerabilityAssessmentNameParam, ruleIDParam, baselineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolVulnerabilityAssessmentRuleBaseline, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
