/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2014, STMicroelectronics International N.V.
 * Copyright (c) 2021, SumUp Services GmbH
 * Copyright 2023 NXP
 */

#ifndef XTEST_4000_DATA_H
#define XTEST_4000_DATA_H
#include <stdint.h>
#include <nist/186-3dsatestvectors.h>
#include <nist/ecccdhtestvectors.h>

/*
 * XTS-AES Test data from:
 * http://grouper.ieee.org/groups/1619/email/pdf00086.pdf
 */

/*
 * XTS-AES applied for a data unit of 32 bytes, 32 bytes key material.
 */

/* Vector 1 */
static const uint8_t ciph_data_aes_xts_vect1_key1[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ciph_data_aes_xts_vect1_key2[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ciph_data_aes_xts_vect1_iv[16] = {
	0x0
};
static const uint8_t ciph_data_aes_xts_vect1_ptx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
/* TWK 66e94bd4ef8a2c3b884cfa59ca342b2eccd297a8df1559761099f4b39469565c */
static const uint8_t ciph_data_aes_xts_vect1_ctx[] = {
	0x91, 0x7c, 0xf6, 0x9e, 0xbd, 0x68, 0xb2, 0xec,
	0x9b, 0x9f, 0xe9, 0xa3, 0xea, 0xdd, 0xa6, 0x92,
	0xcd, 0x43, 0xd2, 0xf5, 0x95, 0x98, 0xed, 0x85,
	0x8c, 0x02, 0xc2, 0x65, 0x2f, 0xbf, 0x92, 0x2e,
};

/* Vector 2 */
static const uint8_t ciph_data_aes_xts_vect2_key1[] = {
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
};
static const uint8_t ciph_data_aes_xts_vect2_key2[] = {
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
};
static const uint8_t ciph_data_aes_xts_vect2_iv[16] = {
	0x33, 0x33, 0x33, 0x33, 0x33
};
static const uint8_t ciph_data_aes_xts_vect2_ptx[] = {
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
};
/* TWK 3f803bcd0d7fd2b37558419f59d5cda6f900779a1bfea467ebb0823eb3aa9b4d */
static const uint8_t ciph_data_aes_xts_vect2_ctx[] = {
	0xc4, 0x54, 0x18, 0x5e, 0x6a, 0x16, 0x93, 0x6e,
	0x39, 0x33, 0x40, 0x38, 0xac, 0xef, 0x83, 0x8b,
	0xfb, 0x18, 0x6f, 0xff, 0x74, 0x80, 0xad, 0xc4,
	0x28, 0x93, 0x82, 0xec, 0xd6, 0xd3, 0x94, 0xf0,
};

/* Vector 3 */
static const uint8_t ciph_data_aes_xts_vect3_key1[] = {
	0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
	0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
};
static const uint8_t ciph_data_aes_xts_vect3_key2[] = {
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
};
static const uint8_t ciph_data_aes_xts_vect3_iv[16] = {
	0x33, 0x33, 0x33, 0x33, 0x33
};
static const uint8_t ciph_data_aes_xts_vect3_ptx[] = {
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
};
/* TWK 3f803bcd0d7fd2b37558419f59d5cda6f900779a1bfea467ebb0823eb3aa9b4d */
static const uint8_t ciph_data_aes_xts_vect3_ctx[] = {
	0xaf, 0x85, 0x33, 0x6b, 0x59, 0x7a, 0xfc, 0x1a,
	0x90, 0x0b, 0x2e, 0xb2, 0x1e, 0xc9, 0x49, 0xd2,
	0x92, 0xdf, 0x4c, 0x04, 0x7e, 0x0b, 0x21, 0x53,
	0x21, 0x86, 0xa5, 0x97, 0x1a, 0x22, 0x7a, 0x89,
};

/*
 * XTS-AES-128 applied for a data unit of 512 bytes
 */

/* Vector 4 */
static const uint8_t ciph_data_aes_xts_vect4_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect4_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect4_iv[16] = {
	0x00
};
static const uint8_t ciph_data_aes_xts_vect4_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect4_ctx[] = {
	0x27, 0xa7, 0x47, 0x9b, 0xef, 0xa1, 0xd4, 0x76,
	0x48, 0x9f, 0x30, 0x8c, 0xd4, 0xcf, 0xa6, 0xe2,
	0xa9, 0x6e, 0x4b, 0xbe, 0x32, 0x08, 0xff, 0x25,
	0x28, 0x7d, 0xd3, 0x81, 0x96, 0x16, 0xe8, 0x9c,

	0xc7, 0x8c, 0xf7, 0xf5, 0xe5, 0x43, 0x44, 0x5f,
	0x83, 0x33, 0xd8, 0xfa, 0x7f, 0x56, 0x00, 0x00,
	0x05, 0x27, 0x9f, 0xa5, 0xd8, 0xb5, 0xe4, 0xad,
	0x40, 0xe7, 0x36, 0xdd, 0xb4, 0xd3, 0x54, 0x12,

	0x32, 0x80, 0x63, 0xfd, 0x2a, 0xab, 0x53, 0xe5,
	0xea, 0x1e, 0x0a, 0x9f, 0x33, 0x25, 0x00, 0xa5,
	0xdf, 0x94, 0x87, 0xd0, 0x7a, 0x5c, 0x92, 0xcc,
	0x51, 0x2c, 0x88, 0x66, 0xc7, 0xe8, 0x60, 0xce,

	0x93, 0xfd, 0xf1, 0x66, 0xa2, 0x49, 0x12, 0xb4,
	0x22, 0x97, 0x61, 0x46, 0xae, 0x20, 0xce, 0x84,
	0x6b, 0xb7, 0xdc, 0x9b, 0xa9, 0x4a, 0x76, 0x7a,
	0xae, 0xf2, 0x0c, 0x0d, 0x61, 0xad, 0x02, 0x65,

	0x5e, 0xa9, 0x2d, 0xc4, 0xc4, 0xe4, 0x1a, 0x89,
	0x52, 0xc6, 0x51, 0xd3, 0x31, 0x74, 0xbe, 0x51,
	0xa1, 0x0c, 0x42, 0x11, 0x10, 0xe6, 0xd8, 0x15,
	0x88, 0xed, 0xe8, 0x21, 0x03, 0xa2, 0x52, 0xd8,

	0xa7, 0x50, 0xe8, 0x76, 0x8d, 0xef, 0xff, 0xed,
	0x91, 0x22, 0x81, 0x0a, 0xae, 0xb9, 0x9f, 0x91,
	0x72, 0xaf, 0x82, 0xb6, 0x04, 0xdc, 0x4b, 0x8e,
	0x51, 0xbc, 0xb0, 0x82, 0x35, 0xa6, 0xf4, 0x34,

	0x13, 0x32, 0xe4, 0xca, 0x60, 0x48, 0x2a, 0x4b,
	0xa1, 0xa0, 0x3b, 0x3e, 0x65, 0x00, 0x8f, 0xc5,
	0xda, 0x76, 0xb7, 0x0b, 0xf1, 0x69, 0x0d, 0xb4,
	0xea, 0xe2, 0x9c, 0x5f, 0x1b, 0xad, 0xd0, 0x3c,

	0x5c, 0xcf, 0x2a, 0x55, 0xd7, 0x05, 0xdd, 0xcd,
	0x86, 0xd4, 0x49, 0x51, 0x1c, 0xeb, 0x7e, 0xc3,
	0x0b, 0xf1, 0x2b, 0x1f, 0xa3, 0x5b, 0x91, 0x3f,
	0x9f, 0x74, 0x7a, 0x8a, 0xfd, 0x1b, 0x13, 0x0e,

	0x94, 0xbf, 0xf9, 0x4e, 0xff, 0xd0, 0x1a, 0x91,
	0x73, 0x5c, 0xa1, 0x72, 0x6a, 0xcd, 0x0b, 0x19,
	0x7c, 0x4e, 0x5b, 0x03, 0x39, 0x36, 0x97, 0xe1,
	0x26, 0x82, 0x6f, 0xb6, 0xbb, 0xde, 0x8e, 0xcc,

	0x1e, 0x08, 0x29, 0x85, 0x16, 0xe2, 0xc9, 0xed,
	0x03, 0xff, 0x3c, 0x1b, 0x78, 0x60, 0xf6, 0xde,
	0x76, 0xd4, 0xce, 0xcd, 0x94, 0xc8, 0x11, 0x98,
	0x55, 0xef, 0x52, 0x97, 0xca, 0x67, 0xe9, 0xf3,

	0xe7, 0xff, 0x72, 0xb1, 0xe9, 0x97, 0x85, 0xca,
	0x0a, 0x7e, 0x77, 0x20, 0xc5, 0xb3, 0x6d, 0xc6,
	0xd7, 0x2c, 0xac, 0x95, 0x74, 0xc8, 0xcb, 0xbc,
	0x2f, 0x80, 0x1e, 0x23, 0xe5, 0x6f, 0xd3, 0x44,

	0xb0, 0x7f, 0x22, 0x15, 0x4b, 0xeb, 0xa0, 0xf0,
	0x8c, 0xe8, 0x89, 0x1e, 0x64, 0x3e, 0xd9, 0x95,
	0xc9, 0x4d, 0x9a, 0x69, 0xc9, 0xf1, 0xb5, 0xf4,
	0x99, 0x02, 0x7a, 0x78, 0x57, 0x2a, 0xee, 0xbd,

	0x74, 0xd2, 0x0c, 0xc3, 0x98, 0x81, 0xc2, 0x13,
	0xee, 0x77, 0x0b, 0x10, 0x10, 0xe4, 0xbe, 0xa7,
	0x18, 0x84, 0x69, 0x77, 0xae, 0x11, 0x9f, 0x7a,
	0x02, 0x3a, 0xb5, 0x8c, 0xca, 0x0a, 0xd7, 0x52,

	0xaf, 0xe6, 0x56, 0xbb, 0x3c, 0x17, 0x25, 0x6a,
	0x9f, 0x6e, 0x9b, 0xf1, 0x9f, 0xdd, 0x5a, 0x38,
	0xfc, 0x82, 0xbb, 0xe8, 0x72, 0xc5, 0x53, 0x9e,
	0xdb, 0x60, 0x9e, 0xf4, 0xf7, 0x9c, 0x20, 0x3e,

	0xbb, 0x14, 0x0f, 0x2e, 0x58, 0x3c, 0xb2, 0xad,
	0x15, 0xb4, 0xaa, 0x5b, 0x65, 0x50, 0x16, 0xa8,
	0x44, 0x92, 0x77, 0xdb, 0xd4, 0x77, 0xef, 0x2c,
	0x8d, 0x6c, 0x01, 0x7d, 0xb7, 0x38, 0xb1, 0x8d,

	0xeb, 0x4a, 0x42, 0x7d, 0x19, 0x23, 0xce, 0x3f,
	0xf2, 0x62, 0x73, 0x57, 0x79, 0xa4, 0x18, 0xf2,
	0x0a, 0x28, 0x2d, 0xf9, 0x20, 0x14, 0x7b, 0xea,
	0xbe, 0x42, 0x1e, 0xe5, 0x31, 0x9d, 0x05, 0x68,
};

/* Vector 5 */
static const uint8_t ciph_data_aes_xts_vect5_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect5_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect5_iv[16] = {
	0x01
};
static const uint8_t ciph_data_aes_xts_vect5_ptx[] = {
	0x27, 0xa7, 0x47, 0x9b, 0xef, 0xa1, 0xd4, 0x76,
	0x48, 0x9f, 0x30, 0x8c, 0xd4, 0xcf, 0xa6, 0xe2,
	0xa9, 0x6e, 0x4b, 0xbe, 0x32, 0x08, 0xff, 0x25,
	0x28, 0x7d, 0xd3, 0x81, 0x96, 0x16, 0xe8, 0x9c,

	0xc7, 0x8c, 0xf7, 0xf5, 0xe5, 0x43, 0x44, 0x5f,
	0x83, 0x33, 0xd8, 0xfa, 0x7f, 0x56, 0x00, 0x00,
	0x05, 0x27, 0x9f, 0xa5, 0xd8, 0xb5, 0xe4, 0xad,
	0x40, 0xe7, 0x36, 0xdd, 0xb4, 0xd3, 0x54, 0x12,

	0x32, 0x80, 0x63, 0xfd, 0x2a, 0xab, 0x53, 0xe5,
	0xea, 0x1e, 0x0a, 0x9f, 0x33, 0x25, 0x00, 0xa5,
	0xdf, 0x94, 0x87, 0xd0, 0x7a, 0x5c, 0x92, 0xcc,
	0x51, 0x2c, 0x88, 0x66, 0xc7, 0xe8, 0x60, 0xce,

	0x93, 0xfd, 0xf1, 0x66, 0xa2, 0x49, 0x12, 0xb4,
	0x22, 0x97, 0x61, 0x46, 0xae, 0x20, 0xce, 0x84,
	0x6b, 0xb7, 0xdc, 0x9b, 0xa9, 0x4a, 0x76, 0x7a,
	0xae, 0xf2, 0x0c, 0x0d, 0x61, 0xad, 0x02, 0x65,

	0x5e, 0xa9, 0x2d, 0xc4, 0xc4, 0xe4, 0x1a, 0x89,
	0x52, 0xc6, 0x51, 0xd3, 0x31, 0x74, 0xbe, 0x51,
	0xa1, 0x0c, 0x42, 0x11, 0x10, 0xe6, 0xd8, 0x15,
	0x88, 0xed, 0xe8, 0x21, 0x03, 0xa2, 0x52, 0xd8,

	0xa7, 0x50, 0xe8, 0x76, 0x8d, 0xef, 0xff, 0xed,
	0x91, 0x22, 0x81, 0x0a, 0xae, 0xb9, 0x9f, 0x91,
	0x72, 0xaf, 0x82, 0xb6, 0x04, 0xdc, 0x4b, 0x8e,
	0x51, 0xbc, 0xb0, 0x82, 0x35, 0xa6, 0xf4, 0x34,

	0x13, 0x32, 0xe4, 0xca, 0x60, 0x48, 0x2a, 0x4b,
	0xa1, 0xa0, 0x3b, 0x3e, 0x65, 0x00, 0x8f, 0xc5,
	0xda, 0x76, 0xb7, 0x0b, 0xf1, 0x69, 0x0d, 0xb4,
	0xea, 0xe2, 0x9c, 0x5f, 0x1b, 0xad, 0xd0, 0x3c,

	0x5c, 0xcf, 0x2a, 0x55, 0xd7, 0x05, 0xdd, 0xcd,
	0x86, 0xd4, 0x49, 0x51, 0x1c, 0xeb, 0x7e, 0xc3,
	0x0b, 0xf1, 0x2b, 0x1f, 0xa3, 0x5b, 0x91, 0x3f,
	0x9f, 0x74, 0x7a, 0x8a, 0xfd, 0x1b, 0x13, 0x0e,

	0x94, 0xbf, 0xf9, 0x4e, 0xff, 0xd0, 0x1a, 0x91,
	0x73, 0x5c, 0xa1, 0x72, 0x6a, 0xcd, 0x0b, 0x19,
	0x7c, 0x4e, 0x5b, 0x03, 0x39, 0x36, 0x97, 0xe1,
	0x26, 0x82, 0x6f, 0xb6, 0xbb, 0xde, 0x8e, 0xcc,

	0x1e, 0x08, 0x29, 0x85, 0x16, 0xe2, 0xc9, 0xed,
	0x03, 0xff, 0x3c, 0x1b, 0x78, 0x60, 0xf6, 0xde,
	0x76, 0xd4, 0xce, 0xcd, 0x94, 0xc8, 0x11, 0x98,
	0x55, 0xef, 0x52, 0x97, 0xca, 0x67, 0xe9, 0xf3,

	0xe7, 0xff, 0x72, 0xb1, 0xe9, 0x97, 0x85, 0xca,
	0x0a, 0x7e, 0x77, 0x20, 0xc5, 0xb3, 0x6d, 0xc6,
	0xd7, 0x2c, 0xac, 0x95, 0x74, 0xc8, 0xcb, 0xbc,
	0x2f, 0x80, 0x1e, 0x23, 0xe5, 0x6f, 0xd3, 0x44,

	0xb0, 0x7f, 0x22, 0x15, 0x4b, 0xeb, 0xa0, 0xf0,
	0x8c, 0xe8, 0x89, 0x1e, 0x64, 0x3e, 0xd9, 0x95,
	0xc9, 0x4d, 0x9a, 0x69, 0xc9, 0xf1, 0xb5, 0xf4,
	0x99, 0x02, 0x7a, 0x78, 0x57, 0x2a, 0xee, 0xbd,

	0x74, 0xd2, 0x0c, 0xc3, 0x98, 0x81, 0xc2, 0x13,
	0xee, 0x77, 0x0b, 0x10, 0x10, 0xe4, 0xbe, 0xa7,
	0x18, 0x84, 0x69, 0x77, 0xae, 0x11, 0x9f, 0x7a,
	0x02, 0x3a, 0xb5, 0x8c, 0xca, 0x0a, 0xd7, 0x52,

	0xaf, 0xe6, 0x56, 0xbb, 0x3c, 0x17, 0x25, 0x6a,
	0x9f, 0x6e, 0x9b, 0xf1, 0x9f, 0xdd, 0x5a, 0x38,
	0xfc, 0x82, 0xbb, 0xe8, 0x72, 0xc5, 0x53, 0x9e,
	0xdb, 0x60, 0x9e, 0xf4, 0xf7, 0x9c, 0x20, 0x3e,

	0xbb, 0x14, 0x0f, 0x2e, 0x58, 0x3c, 0xb2, 0xad,
	0x15, 0xb4, 0xaa, 0x5b, 0x65, 0x50, 0x16, 0xa8,
	0x44, 0x92, 0x77, 0xdb, 0xd4, 0x77, 0xef, 0x2c,
	0x8d, 0x6c, 0x01, 0x7d, 0xb7, 0x38, 0xb1, 0x8d,

	0xeb, 0x4a, 0x42, 0x7d, 0x19, 0x23, 0xce, 0x3f,
	0xf2, 0x62, 0x73, 0x57, 0x79, 0xa4, 0x18, 0xf2,
	0x0a, 0x28, 0x2d, 0xf9, 0x20, 0x14, 0x7b, 0xea,
	0xbe, 0x42, 0x1e, 0xe5, 0x31, 0x9d, 0x05, 0x68,
};
static const uint8_t ciph_data_aes_xts_vect5_ctx[] = {
	0x26, 0x4d, 0x3c, 0xa8, 0x51, 0x21, 0x94, 0xfe,
	0xc3, 0x12, 0xc8, 0xc9, 0x89, 0x1f, 0x27, 0x9f,
	0xef, 0xdd, 0x60, 0x8d, 0x0c, 0x02, 0x7b, 0x60,
	0x48, 0x3a, 0x3f, 0xa8, 0x11, 0xd6, 0x5e, 0xe5,

	0x9d, 0x52, 0xd9, 0xe4, 0x0e, 0xc5, 0x67, 0x2d,
	0x81, 0x53, 0x2b, 0x38, 0xb6, 0xb0, 0x89, 0xce,
	0x95, 0x1f, 0x0f, 0x9c, 0x35, 0x59, 0x0b, 0x8b,
	0x97, 0x8d, 0x17, 0x52, 0x13, 0xf3, 0x29, 0xbb,

	0x1c, 0x2f, 0xd3, 0x0f, 0x2f, 0x7f, 0x30, 0x49,
	0x2a, 0x61, 0xa5, 0x32, 0xa7, 0x9f, 0x51, 0xd3,
	0x6f, 0x5e, 0x31, 0xa7, 0xc9, 0xa1, 0x2c, 0x28,
	0x60, 0x82, 0xff, 0x7d, 0x23, 0x94, 0xd1, 0x8f,

	0x78, 0x3e, 0x1a, 0x8e, 0x72, 0xc7, 0x22, 0xca,
	0xaa, 0xa5, 0x2d, 0x8f, 0x06, 0x56, 0x57, 0xd2,
	0x63, 0x1f, 0xd2, 0x5b, 0xfd, 0x8e, 0x5b, 0xaa,
	0xd6, 0xe5, 0x27, 0xd7, 0x63, 0x51, 0x75, 0x01,

	0xc6, 0x8c, 0x5e, 0xdc, 0x3c, 0xdd, 0x55, 0x43,
	0x5c, 0x53, 0x2d, 0x71, 0x25, 0xc8, 0x61, 0x4d,
	0xee, 0xd9, 0xad, 0xaa, 0x3a, 0xca, 0xde, 0x58,
	0x88, 0xb8, 0x7b, 0xef, 0x64, 0x1c, 0x4c, 0x99,

	0x4c, 0x80, 0x91, 0xb5, 0xbc, 0xd3, 0x87, 0xf3,
	0x96, 0x3f, 0xb5, 0xbc, 0x37, 0xaa, 0x92, 0x2f,
	0xbf, 0xe3, 0xdf, 0x4e, 0x5b, 0x91, 0x5e, 0x6e,
	0xb5, 0x14, 0x71, 0x7b, 0xdd, 0x2a, 0x74, 0x07,

	0x9a, 0x50, 0x73, 0xf5, 0xc4, 0xbf, 0xd4, 0x6a,
	0xdf, 0x7d, 0x28, 0x2e, 0x7a, 0x39, 0x3a, 0x52,
	0x57, 0x9d, 0x11, 0xa0, 0x28, 0xda, 0x4d, 0x9c,
	0xd9, 0xc7, 0x71, 0x24, 0xf9, 0x64, 0x8e, 0xe3,

	0x83, 0xb1, 0xac, 0x76, 0x39, 0x30, 0xe7, 0x16,
	0x2a, 0x8d, 0x37, 0xf3, 0x50, 0xb2, 0xf7, 0x4b,
	0x84, 0x72, 0xcf, 0x09, 0x90, 0x20, 0x63, 0xc6,
	0xb3, 0x2e, 0x8c, 0x2d, 0x92, 0x90, 0xce, 0xfb,

	0xd7, 0x34, 0x6d, 0x1c, 0x77, 0x9a, 0x0d, 0xf5,
	0x0e, 0xdc, 0xde, 0x45, 0x31, 0xda, 0x07, 0xb0,
	0x99, 0xc6, 0x38, 0xe8, 0x3a, 0x75, 0x59, 0x44,
	0xdf, 0x2a, 0xef, 0x1a, 0xa3, 0x17, 0x52, 0xfd,

	0x32, 0x3d, 0xcb, 0x71, 0x0f, 0xb4, 0xbf, 0xbb,
	0x9d, 0x22, 0xb9, 0x25, 0xbc, 0x35, 0x77, 0xe1,
	0xb8, 0x94, 0x9e, 0x72, 0x9a, 0x90, 0xbb, 0xaf,
	0xea, 0xcf, 0x7f, 0x78, 0x79, 0xe7, 0xb1, 0x14,

	0x7e, 0x28, 0xba, 0x0b, 0xae, 0x94, 0x0d, 0xb7,
	0x95, 0xa6, 0x1b, 0x15, 0xec, 0xf4, 0xdf, 0x8d,
	0xb0, 0x7b, 0x82, 0x4b, 0xb0, 0x62, 0x80, 0x2c,
	0xc9, 0x8a, 0x95, 0x45, 0xbb, 0x2a, 0xae, 0xed,

	0x77, 0xcb, 0x3f, 0xc6, 0xdb, 0x15, 0xdc, 0xd7,
	0xd8, 0x0d, 0x7d, 0x5b, 0xc4, 0x06, 0xc4, 0x97,
	0x0a, 0x34, 0x78, 0xad, 0xa8, 0x89, 0x9b, 0x32,
	0x91, 0x98, 0xeb, 0x61, 0xc1, 0x93, 0xfb, 0x62,

	0x75, 0xaa, 0x8c, 0xa3, 0x40, 0x34, 0x4a, 0x75,
	0xa8, 0x62, 0xae, 0xbe, 0x92, 0xee, 0xe1, 0xce,
	0x03, 0x2f, 0xd9, 0x50, 0xb4, 0x7d, 0x77, 0x04,
	0xa3, 0x87, 0x69, 0x23, 0xb4, 0xad, 0x62, 0x84,

	0x4b, 0xf4, 0xa0, 0x9c, 0x4d, 0xbe, 0x8b, 0x43,
	0x97, 0x18, 0x4b, 0x74, 0x71, 0x36, 0x0c, 0x95,
	0x64, 0x88, 0x0a, 0xed, 0xdd, 0xb9, 0xba, 0xa4,
	0xaf, 0x2e, 0x75, 0x39, 0x4b, 0x08, 0xcd, 0x32,

	0xff, 0x47, 0x9c, 0x57, 0xa0, 0x7d, 0x3e, 0xab,
	0x5d, 0x54, 0xde, 0x5f, 0x97, 0x38, 0xb8, 0xd2,
	0x7f, 0x27, 0xa9, 0xf0, 0xab, 0x11, 0x79, 0x9d,
	0x7b, 0x7f, 0xfe, 0xfb, 0x27, 0x04, 0xc9, 0x5c,

	0x6a, 0xd1, 0x2c, 0x39, 0xf1, 0xe8, 0x67, 0xa4,
	0xb7, 0xb1, 0xd7, 0x81, 0x8a, 0x4b, 0x75, 0x3d,
	0xfd, 0x2a, 0x89, 0xcc, 0xb4, 0x5e, 0x00, 0x1a,
	0x03, 0xa8, 0x67, 0xb1, 0x87, 0xf2, 0x25, 0xdd,
};

/* Vector 6 */
static const uint8_t ciph_data_aes_xts_vect6_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect6_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect6_iv[16] = {
	0x02
};
static const uint8_t ciph_data_aes_xts_vect6_ptx[] = {
	0x26, 0x4d, 0x3c, 0xa8, 0x51, 0x21, 0x94, 0xfe,
	0xc3, 0x12, 0xc8, 0xc9, 0x89, 0x1f, 0x27, 0x9f,
	0xef, 0xdd, 0x60, 0x8d, 0x0c, 0x02, 0x7b, 0x60,
	0x48, 0x3a, 0x3f, 0xa8, 0x11, 0xd6, 0x5e, 0xe5,

	0x9d, 0x52, 0xd9, 0xe4, 0x0e, 0xc5, 0x67, 0x2d,
	0x81, 0x53, 0x2b, 0x38, 0xb6, 0xb0, 0x89, 0xce,
	0x95, 0x1f, 0x0f, 0x9c, 0x35, 0x59, 0x0b, 0x8b,
	0x97, 0x8d, 0x17, 0x52, 0x13, 0xf3, 0x29, 0xbb,

	0x1c, 0x2f, 0xd3, 0x0f, 0x2f, 0x7f, 0x30, 0x49,
	0x2a, 0x61, 0xa5, 0x32, 0xa7, 0x9f, 0x51, 0xd3,
	0x6f, 0x5e, 0x31, 0xa7, 0xc9, 0xa1, 0x2c, 0x28,
	0x60, 0x82, 0xff, 0x7d, 0x23, 0x94, 0xd1, 0x8f,

	0x78, 0x3e, 0x1a, 0x8e, 0x72, 0xc7, 0x22, 0xca,
	0xaa, 0xa5, 0x2d, 0x8f, 0x06, 0x56, 0x57, 0xd2,
	0x63, 0x1f, 0xd2, 0x5b, 0xfd, 0x8e, 0x5b, 0xaa,
	0xd6, 0xe5, 0x27, 0xd7, 0x63, 0x51, 0x75, 0x01,

	0xc6, 0x8c, 0x5e, 0xdc, 0x3c, 0xdd, 0x55, 0x43,
	0x5c, 0x53, 0x2d, 0x71, 0x25, 0xc8, 0x61, 0x4d,
	0xee, 0xd9, 0xad, 0xaa, 0x3a, 0xca, 0xde, 0x58,
	0x88, 0xb8, 0x7b, 0xef, 0x64, 0x1c, 0x4c, 0x99,

	0x4c, 0x80, 0x91, 0xb5, 0xbc, 0xd3, 0x87, 0xf3,
	0x96, 0x3f, 0xb5, 0xbc, 0x37, 0xaa, 0x92, 0x2f,
	0xbf, 0xe3, 0xdf, 0x4e, 0x5b, 0x91, 0x5e, 0x6e,
	0xb5, 0x14, 0x71, 0x7b, 0xdd, 0x2a, 0x74, 0x07,

	0x9a, 0x50, 0x73, 0xf5, 0xc4, 0xbf, 0xd4, 0x6a,
	0xdf, 0x7d, 0x28, 0x2e, 0x7a, 0x39, 0x3a, 0x52,
	0x57, 0x9d, 0x11, 0xa0, 0x28, 0xda, 0x4d, 0x9c,
	0xd9, 0xc7, 0x71, 0x24, 0xf9, 0x64, 0x8e, 0xe3,

	0x83, 0xb1, 0xac, 0x76, 0x39, 0x30, 0xe7, 0x16,
	0x2a, 0x8d, 0x37, 0xf3, 0x50, 0xb2, 0xf7, 0x4b,
	0x84, 0x72, 0xcf, 0x09, 0x90, 0x20, 0x63, 0xc6,
	0xb3, 0x2e, 0x8c, 0x2d, 0x92, 0x90, 0xce, 0xfb,

	0xd7, 0x34, 0x6d, 0x1c, 0x77, 0x9a, 0x0d, 0xf5,
	0x0e, 0xdc, 0xde, 0x45, 0x31, 0xda, 0x07, 0xb0,
	0x99, 0xc6, 0x38, 0xe8, 0x3a, 0x75, 0x59, 0x44,
	0xdf, 0x2a, 0xef, 0x1a, 0xa3, 0x17, 0x52, 0xfd,

	0x32, 0x3d, 0xcb, 0x71, 0x0f, 0xb4, 0xbf, 0xbb,
	0x9d, 0x22, 0xb9, 0x25, 0xbc, 0x35, 0x77, 0xe1,
	0xb8, 0x94, 0x9e, 0x72, 0x9a, 0x90, 0xbb, 0xaf,
	0xea, 0xcf, 0x7f, 0x78, 0x79, 0xe7, 0xb1, 0x14,

	0x7e, 0x28, 0xba, 0x0b, 0xae, 0x94, 0x0d, 0xb7,
	0x95, 0xa6, 0x1b, 0x15, 0xec, 0xf4, 0xdf, 0x8d,
	0xb0, 0x7b, 0x82, 0x4b, 0xb0, 0x62, 0x80, 0x2c,
	0xc9, 0x8a, 0x95, 0x45, 0xbb, 0x2a, 0xae, 0xed,

	0x77, 0xcb, 0x3f, 0xc6, 0xdb, 0x15, 0xdc, 0xd7,
	0xd8, 0x0d, 0x7d, 0x5b, 0xc4, 0x06, 0xc4, 0x97,
	0x0a, 0x34, 0x78, 0xad, 0xa8, 0x89, 0x9b, 0x32,
	0x91, 0x98, 0xeb, 0x61, 0xc1, 0x93, 0xfb, 0x62,

	0x75, 0xaa, 0x8c, 0xa3, 0x40, 0x34, 0x4a, 0x75,
	0xa8, 0x62, 0xae, 0xbe, 0x92, 0xee, 0xe1, 0xce,
	0x03, 0x2f, 0xd9, 0x50, 0xb4, 0x7d, 0x77, 0x04,
	0xa3, 0x87, 0x69, 0x23, 0xb4, 0xad, 0x62, 0x84,

	0x4b, 0xf4, 0xa0, 0x9c, 0x4d, 0xbe, 0x8b, 0x43,
	0x97, 0x18, 0x4b, 0x74, 0x71, 0x36, 0x0c, 0x95,
	0x64, 0x88, 0x0a, 0xed, 0xdd, 0xb9, 0xba, 0xa4,
	0xaf, 0x2e, 0x75, 0x39, 0x4b, 0x08, 0xcd, 0x32,

	0xff, 0x47, 0x9c, 0x57, 0xa0, 0x7d, 0x3e, 0xab,
	0x5d, 0x54, 0xde, 0x5f, 0x97, 0x38, 0xb8, 0xd2,
	0x7f, 0x27, 0xa9, 0xf0, 0xab, 0x11, 0x79, 0x9d,
	0x7b, 0x7f, 0xfe, 0xfb, 0x27, 0x04, 0xc9, 0x5c,

	0x6a, 0xd1, 0x2c, 0x39, 0xf1, 0xe8, 0x67, 0xa4,
	0xb7, 0xb1, 0xd7, 0x81, 0x8a, 0x4b, 0x75, 0x3d,
	0xfd, 0x2a, 0x89, 0xcc, 0xb4, 0x5e, 0x00, 0x1a,
	0x03, 0xa8, 0x67, 0xb1, 0x87, 0xf2, 0x25, 0xdd,
};
static const uint8_t ciph_data_aes_xts_vect6_ctx[] = {
	0xfa, 0x76, 0x2a, 0x36, 0x80, 0xb7, 0x60, 0x07,
	0x92, 0x8e, 0xd4, 0xa4, 0xf4, 0x9a, 0x94, 0x56,
	0x03, 0x1b, 0x70, 0x47, 0x82, 0xe6, 0x5e, 0x16,
	0xce, 0xcb, 0x54, 0xed, 0x7d, 0x01, 0x7b, 0x5e,

	0x18, 0xab, 0xd6, 0x7b, 0x33, 0x8e, 0x81, 0x07,
	0x8f, 0x21, 0xed, 0xb7, 0x86, 0x8d, 0x90, 0x1e,
	0xbe, 0x9c, 0x73, 0x1a, 0x7c, 0x18, 0xb5, 0xe6,
	0xde, 0xc1, 0xd6, 0xa7, 0x2e, 0x07, 0x8a, 0xc9,

	0xa4, 0x26, 0x2f, 0x86, 0x0b, 0xee, 0xfa, 0x14,
	0xf4, 0xe8, 0x21, 0x01, 0x82, 0x72, 0xe4, 0x11,
	0xa9, 0x51, 0x50, 0x2b, 0x6e, 0x79, 0x06, 0x6e,
	0x84, 0x25, 0x2c, 0x33, 0x46, 0xf3, 0xaa, 0x62,

	0x34, 0x43, 0x51, 0xa2, 0x91, 0xd4, 0xbe, 0xdc,
	0x7a, 0x07, 0x61, 0x8b, 0xde, 0xa2, 0xaf, 0x63,
	0x14, 0x5c, 0xc7, 0xa4, 0xb8, 0xd4, 0x07, 0x06,
	0x91, 0xae, 0x89, 0x0c, 0xd6, 0x57, 0x33, 0xe7,

	0x94, 0x6e, 0x90, 0x21, 0xa1, 0xdf, 0xfc, 0x4c,
	0x59, 0xf1, 0x59, 0x42, 0x5e, 0xe6, 0xd5, 0x0c,
	0xa9, 0xb1, 0x35, 0xfa, 0x61, 0x62, 0xce, 0xa1,
	0x8a, 0x93, 0x98, 0x38, 0xdc, 0x00, 0x0f, 0xb3,

	0x86, 0xfa, 0xd0, 0x86, 0xac, 0xce, 0x5a, 0xc0,
	0x7c, 0xb2, 0xec, 0xe7, 0xfd, 0x58, 0x0b, 0x00,
	0xcf, 0xa5, 0xe9, 0x85, 0x89, 0x63, 0x1d, 0xc2,
	0x5e, 0x8e, 0x2a, 0x3d, 0xaf, 0x2f, 0xfd, 0xec,

	0x26, 0x53, 0x16, 0x59, 0x91, 0x2c, 0x9d, 0x8f,
	0x7a, 0x15, 0xe5, 0x86, 0x5e, 0xa8, 0xfb, 0x58,
	0x16, 0xd6, 0x20, 0x70, 0x52, 0xbd, 0x71, 0x28,
	0xcd, 0x74, 0x3c, 0x12, 0xc8, 0x11, 0x87, 0x91,

	0xa4, 0x73, 0x68, 0x11, 0x93, 0x5e, 0xb9, 0x82,
	0xa5, 0x32, 0x34, 0x9e, 0x31, 0xdd, 0x40, 0x1e,
	0x0b, 0x66, 0x0a, 0x56, 0x8c, 0xb1, 0xa4, 0x71,
	0x1f, 0x55, 0x2f, 0x55, 0xde, 0xd5, 0x9f, 0x1f,

	0x15, 0xbf, 0x71, 0x96, 0xb3, 0xca, 0x12, 0xa9,
	0x1e, 0x48, 0x8e, 0xf5, 0x9d, 0x64, 0xf3, 0xa0,
	0x2b, 0xf4, 0x52, 0x39, 0x49, 0x9a, 0xc6, 0x17,
	0x6a, 0xe3, 0x21, 0xc4, 0xa2, 0x11, 0xec, 0x54,

	0x53, 0x65, 0x97, 0x1c, 0x5d, 0x3f, 0x4f, 0x09,
	0xd4, 0xeb, 0x13, 0x9b, 0xfd, 0xf2, 0x07, 0x3d,
	0x33, 0x18, 0x0b, 0x21, 0x00, 0x2b, 0x65, 0xcc,
	0x98, 0x65, 0xe7, 0x6c, 0xb2, 0x4c, 0xd9, 0x2c,

	0x87, 0x4c, 0x24, 0xc1, 0x83, 0x50, 0x39, 0x9a,
	0x93, 0x6a, 0xb3, 0x63, 0x70, 0x79, 0x29, 0x5d,
	0x76, 0xc4, 0x17, 0x77, 0x6b, 0x94, 0xef, 0xce,
	0x3a, 0x0e, 0xf7, 0x20, 0x6b, 0x15, 0x11, 0x05,

	0x19, 0x65, 0x5c, 0x95, 0x6c, 0xbd, 0x8b, 0x24,
	0x89, 0x40, 0x5e, 0xe2, 0xb0, 0x9a, 0x6b, 0x6e,
	0xeb, 0xe0, 0xc5, 0x37, 0x90, 0xa1, 0x2a, 0x89,
	0x98, 0x37, 0x8b, 0x33, 0xa5, 0xb7, 0x11, 0x59,

	0x62, 0x5f, 0x4b, 0xa4, 0x9d, 0x2a, 0x2f, 0xdb,
	0xa5, 0x9f, 0xbf, 0x08, 0x97, 0xbc, 0x7a, 0xab,
	0xd8, 0xd7, 0x07, 0xdc, 0x14, 0x0a, 0x80, 0xf0,
	0xf3, 0x09, 0xf8, 0x35, 0xd3, 0xda, 0x54, 0xab,

	0x58, 0x4e, 0x50, 0x1d, 0xfa, 0x0e, 0xe9, 0x77,
	0xfe, 0xc5, 0x43, 0xf7, 0x41, 0x86, 0xa8, 0x02,
	0xb9, 0xa3, 0x7a, 0xdb, 0x3e, 0x82, 0x91, 0xec,
	0xa0, 0x4d, 0x66, 0x52, 0x0d, 0x22, 0x9e, 0x60,

	0x40, 0x1e, 0x72, 0x82, 0xbe, 0xf4, 0x86, 0xae,
	0x05, 0x9a, 0xa7, 0x06, 0x96, 0xe0, 0xe3, 0x05,
	0xd7, 0x77, 0x14, 0x0a, 0x7a, 0x88, 0x3e, 0xcd,
	0xcb, 0x69, 0xb9, 0xff, 0x93, 0x8e, 0x8a, 0x42,

	0x31, 0x86, 0x4c, 0x69, 0xca, 0x2c, 0x20, 0x43,
	0xbe, 0xd0, 0x07, 0xff, 0x3e, 0x60, 0x5e, 0x01,
	0x4b, 0xcf, 0x51, 0x81, 0x38, 0xdc, 0x3a, 0x25,
	0xc5, 0xe2, 0x36, 0x17, 0x1a, 0x2d, 0x01, 0xd6,
};

/* Vector 7 */
static const uint8_t ciph_data_aes_xts_vect7_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect7_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect7_iv[16] = {
	0xfd
};
static const uint8_t ciph_data_aes_xts_vect7_ptx[] = {
	0x8e, 0x41, 0xb7, 0x8c, 0x39, 0x0b, 0x5a, 0xf9,
	0xd7, 0x58, 0xbb, 0x21, 0x4a, 0x67, 0xe9, 0xf6,
	0xbf, 0x77, 0x27, 0xb0, 0x9a, 0xc6, 0x12, 0x40,
	0x84, 0xc3, 0x76, 0x11, 0x39, 0x8f, 0xa4, 0x5d,

	0xaa, 0xd9, 0x48, 0x68, 0x60, 0x0e, 0xd3, 0x91,
	0xfb, 0x1a, 0xcd, 0x48, 0x57, 0xa9, 0x5b, 0x46,
	0x6e, 0x62, 0xef, 0x9f, 0x4b, 0x37, 0x72, 0x44,
	0xd1, 0xc1, 0x52, 0xe7, 0xb3, 0x0d, 0x73, 0x1a,

	0xad, 0x30, 0xc7, 0x16, 0xd2, 0x14, 0xb7, 0x07,
	0xae, 0xd9, 0x9e, 0xb5, 0xb5, 0xe5, 0x80, 0xb3,
	0xe8, 0x87, 0xcf, 0x74, 0x97, 0x46, 0x56, 0x51,
	0xd4, 0xb6, 0x0e, 0x60, 0x42, 0x05, 0x1d, 0xa3,

	0x69, 0x3c, 0x3b, 0x78, 0xc1, 0x44, 0x89, 0x54,
	0x3b, 0xe8, 0xb6, 0xad, 0x0b, 0xa6, 0x29, 0x56,
	0x5b, 0xba, 0x20, 0x23, 0x13, 0xba, 0x7b, 0x0d,
	0x0c, 0x94, 0xa3, 0x25, 0x2b, 0x67, 0x6f, 0x46,

	0xcc, 0x02, 0xce, 0x0f, 0x8a, 0x7d, 0x34, 0xc0,
	0xed, 0x22, 0x91, 0x29, 0x67, 0x3c, 0x1f, 0x61,
	0xae, 0xd5, 0x79, 0xd0, 0x8a, 0x92, 0x03, 0xa2,
	0x5a, 0xac, 0x3a, 0x77, 0xe9, 0xdb, 0x60, 0x26,

	0x79, 0x96, 0xdb, 0x38, 0xdf, 0x63, 0x73, 0x56,
	0xd9, 0xdc, 0xd1, 0x63, 0x2e, 0x36, 0x99, 0x39,
	0xf2, 0xa2, 0x9d, 0x89, 0x34, 0x5c, 0x66, 0xe0,
	0x50, 0x66, 0xf1, 0xa3, 0x67, 0x7a, 0xef, 0x18,

	0xde, 0xa4, 0x11, 0x3f, 0xae, 0xb6, 0x29, 0xe4,
	0x67, 0x21, 0xa6, 0x6d, 0x0a, 0x7e, 0x78, 0x5d,
	0x3e, 0x29, 0xaf, 0x25, 0x94, 0xeb, 0x67, 0xdf,
	0xa9, 0x82, 0xaf, 0xfe, 0x0a, 0xac, 0x05, 0x8f,

	0x6e, 0x15, 0x86, 0x42, 0x69, 0xb1, 0x35, 0x41,
	0x82, 0x61, 0xfc, 0x3a, 0xfb, 0x08, 0x94, 0x72,
	0xcf, 0x68, 0xc4, 0x5d, 0xd7, 0xf2, 0x31, 0xc6,
	0x24, 0x9b, 0xa0, 0x25, 0x5e, 0x1e, 0x03, 0x38,

	0x33, 0xfc, 0x4d, 0x00, 0xa3, 0xfe, 0x02, 0x13,
	0x2d, 0x7b, 0xc3, 0x87, 0x36, 0x14, 0xb8, 0xae,
	0xe3, 0x42, 0x73, 0x58, 0x1e, 0xa0, 0x32, 0x5c,
	0x81, 0xf0, 0x27, 0x0a, 0xff, 0xa1, 0x36, 0x41,

	0xd0, 0x52, 0xd3, 0x6f, 0x07, 0x57, 0xd4, 0x84,
	0x01, 0x43, 0x54, 0xd0, 0x2d, 0x68, 0x83, 0xca,
	0x15, 0xc2, 0x4d, 0x8c, 0x39, 0x56, 0xb1, 0xbd,
	0x02, 0x7b, 0xcf, 0x41, 0xf1, 0x51, 0xfd, 0x80,

	0x23, 0xc5, 0x34, 0x0e, 0x56, 0x06, 0xf3, 0x7e,
	0x90, 0xfd, 0xb8, 0x7c, 0x86, 0xfb, 0x4f, 0xa6,
	0x34, 0xb3, 0x71, 0x8a, 0x30, 0xba, 0xce, 0x06,
	0xa6, 0x6e, 0xaf, 0x8f, 0x63, 0xc4, 0xaa, 0x3b,

	0x63, 0x78, 0x26, 0xa8, 0x7f, 0xe8, 0xcf, 0xa4,
	0x42, 0x82, 0xe9, 0x2c, 0xb1, 0x61, 0x5a, 0xf3,
	0xa2, 0x8e, 0x53, 0xbc, 0x74, 0xc7, 0xcb, 0xa1,
	0xa0, 0x97, 0x7b, 0xe9, 0x06, 0x5d, 0x0c, 0x1a,

	0x5d, 0xec, 0x6c, 0x54, 0xae, 0x38, 0xd3, 0x7f,
	0x37, 0xaa, 0x35, 0x28, 0x3e, 0x04, 0x8e, 0x55,
	0x30, 0xa8, 0x5c, 0x4e, 0x7a, 0x29, 0xd7, 0xb9,
	0x2e, 0xc0, 0xc3, 0x16, 0x9c, 0xdf, 0x2a, 0x80,

	0x5c, 0x76, 0x04, 0xbc, 0xe6, 0x00, 0x49, 0xb9,
	0xfb, 0x7b, 0x8e, 0xaa, 0xc1, 0x0f, 0x51, 0xae,
	0x23, 0x79, 0x4c, 0xeb, 0xa6, 0x8b, 0xb5, 0x81,
	0x12, 0xe2, 0x93, 0xb9, 0xb6, 0x92, 0xca, 0x72,

	0x1b, 0x37, 0xc6, 0x62, 0xf8, 0x57, 0x4e, 0xd4,
	0xdb, 0xa6, 0xf8, 0x8e, 0x17, 0x08, 0x81, 0xc8,
	0x2c, 0xdd, 0xc1, 0x03, 0x4a, 0x0c, 0xa7, 0xe2,
	0x84, 0xbf, 0x09, 0x62, 0xb6, 0xb2, 0x62, 0x92,

	0xd8, 0x36, 0xfa, 0x9f, 0x73, 0xc1, 0xac, 0x77,
	0x0e, 0xef, 0x0f, 0x2d, 0x3a, 0x1e, 0xaf, 0x61,
	0xd3, 0xe0, 0x35, 0x55, 0xfd, 0x42, 0x4e, 0xed,
	0xd6, 0x7e, 0x18, 0xa1, 0x80, 0x94, 0xf8, 0x88,
};
static const uint8_t ciph_data_aes_xts_vect7_ctx[] = {
	0xd5, 0x5f, 0x68, 0x4f, 0x81, 0xf4, 0x42, 0x6e,
	0x9f, 0xde, 0x92, 0xa5, 0xff, 0x02, 0xdf, 0x2a,
	0xc8, 0x96, 0xaf, 0x63, 0x96, 0x28, 0x88, 0xa9,
	0x79, 0x10, 0xc1, 0x37, 0x9e, 0x20, 0xb0, 0xa3,

	0xb1, 0xdb, 0x61, 0x3f, 0xb7, 0xfe, 0x2e, 0x07,
	0x00, 0x43, 0x29, 0xea, 0x5c, 0x22, 0xbf, 0xd3,
	0x3e, 0x3d, 0xbe, 0x4c, 0xf5, 0x8c, 0xc6, 0x08,
	0xc2, 0xc2, 0x6c, 0x19, 0xa2, 0xe2, 0xfe, 0x22,

	0xf9, 0x87, 0x32, 0xc2, 0xb5, 0xcb, 0x84, 0x4c,
	0xc6, 0xc0, 0x70, 0x2d, 0x91, 0xe1, 0xd5, 0x0f,
	0xc4, 0x38, 0x2a, 0x7e, 0xba, 0x56, 0x35, 0xcd,
	0x60, 0x24, 0x32, 0xa2, 0x30, 0x6a, 0xc4, 0xce,

	0x82, 0xf8, 0xd7, 0x0c, 0x8d, 0x9b, 0xc1, 0x5f,
	0x91, 0x8f, 0xe7, 0x1e, 0x74, 0xc6, 0x22, 0xd5,
	0xcf, 0x71, 0x17, 0x8b, 0xf6, 0xe0, 0xb9, 0xcc,
	0x9f, 0x2b, 0x41, 0xdd, 0x8d, 0xbe, 0x44, 0x1c,

	0x41, 0xcd, 0x0c, 0x73, 0xa6, 0xdc, 0x47, 0xa3,
	0x48, 0xf6, 0x70, 0x2f, 0x9d, 0x0e, 0x9b, 0x1b,
	0x14, 0x31, 0xe9, 0x48, 0xe2, 0x99, 0xb9, 0xec,
	0x22, 0x72, 0xab, 0x2c, 0x5f, 0x0c, 0x7b, 0xe8,

	0x6a, 0xff, 0xa5, 0xde, 0xc8, 0x7a, 0x0b, 0xee,
	0x81, 0xd3, 0xd5, 0x00, 0x07, 0xed, 0xaa, 0x2b,
	0xcf, 0xcc, 0xb3, 0x56, 0x05, 0x15, 0x5f, 0xf3,
	0x6e, 0xd8, 0xed, 0xd4, 0xa4, 0x0d, 0xcd, 0x4b,

	0x24, 0x3a, 0xcd, 0x11, 0xb2, 0xb9, 0x87, 0xbd,
	0xbf, 0xaf, 0x91, 0xa7, 0xca, 0xc2, 0x7e, 0x9c,
	0x5a, 0xea, 0x52, 0x5e, 0xe5, 0x3d, 0xe7, 0xb2,
	0xd3, 0x33, 0x2c, 0x86, 0x44, 0x40, 0x2b, 0x82,

	0x3e, 0x94, 0xa7, 0xdb, 0x26, 0x27, 0x6d, 0x2d,
	0x23, 0xaa, 0x07, 0x18, 0x0f, 0x76, 0xb4, 0xfd,
	0x29, 0xb9, 0xc0, 0x82, 0x30, 0x99, 0xc9, 0xd6,
	0x2c, 0x51, 0x98, 0x80, 0xae, 0xe7, 0xe9, 0x69,

	0x76, 0x17, 0xc1, 0x49, 0x7d, 0x47, 0xbf, 0x3e,
	0x57, 0x19, 0x50, 0x31, 0x14, 0x21, 0xb6, 0xb7,
	0x34, 0xd3, 0x8b, 0x0d, 0xb9, 0x1e, 0xb8, 0x53,
	0x31, 0xb9, 0x1e, 0xa9, 0xf6, 0x15, 0x30, 0xf5,

	0x45, 0x12, 0xa5, 0xa5, 0x2a, 0x4b, 0xad, 0x58,
	0x9e, 0xb6, 0x97, 0x81, 0xd5, 0x37, 0xf2, 0x32,
	0x97, 0xbb, 0x45, 0x9b, 0xda, 0xd2, 0x94, 0x8a,
	0x29, 0xe1, 0x55, 0x0b, 0xf4, 0x78, 0x7e, 0x0b,

	0xe9, 0x5b, 0xb1, 0x73, 0xcf, 0x5f, 0xab, 0x17,
	0xda, 0xb7, 0xa1, 0x3a, 0x05, 0x2a, 0x63, 0x45,
	0x3d, 0x97, 0xcc, 0xec, 0x1a, 0x32, 0x19, 0x54,
	0x88, 0x6b, 0x7a, 0x12, 0x99, 0xfa, 0xae, 0xec,

	0xae, 0x35, 0xc6, 0xea, 0xac, 0xa7, 0x53, 0xb0,
	0x41, 0xb5, 0xe5, 0xf0, 0x93, 0xbf, 0x83, 0x39,
	0x7f, 0xd2, 0x1d, 0xd6, 0xb3, 0x01, 0x20, 0x66,
	0xfc, 0xc0, 0x58, 0xcc, 0x32, 0xc3, 0xb0, 0x9d,

	0x75, 0x62, 0xde, 0xe2, 0x95, 0x09, 0xb5, 0x83,
	0x93, 0x92, 0xc9, 0xff, 0x05, 0xf5, 0x1f, 0x31,
	0x66, 0xaa, 0xac, 0x4a, 0xc5, 0xf2, 0x38, 0x03,
	0x8a, 0x30, 0x45, 0xe6, 0xf7, 0x2e, 0x48, 0xef,

	0x0f, 0xe8, 0xbc, 0x67, 0x5e, 0x82, 0xc3, 0x18,
	0xa2, 0x68, 0xe4, 0x39, 0x70, 0x27, 0x1b, 0xf1,
	0x19, 0xb8, 0x1b, 0xf6, 0xa9, 0x82, 0x74, 0x65,
	0x54, 0xf8, 0x4e, 0x72, 0xb9, 0xf0, 0x02, 0x80,

	0xa3, 0x20, 0xa0, 0x81, 0x42, 0x92, 0x3c, 0x23,
	0xc8, 0x83, 0x42, 0x3f, 0xf9, 0x49, 0x82, 0x7f,
	0x29, 0xbb, 0xac, 0xdc, 0x1c, 0xcd, 0xb0, 0x49,
	0x38, 0xce, 0x60, 0x98, 0xc9, 0x5b, 0xa6, 0xb3,

	0x25, 0x28, 0xf4, 0xef, 0x78, 0xee, 0xd7, 0x78,
	0xb2, 0xe1, 0x22, 0xdd, 0xfd, 0x1c, 0xbd, 0xd1,
	0x1d, 0x1c, 0x0a, 0x67, 0x83, 0xe0, 0x11, 0xfc,
	0x53, 0x6d, 0x63, 0xd0, 0x53, 0x26, 0x06, 0x37,
};

/* Vector 8 */
static const uint8_t ciph_data_aes_xts_vect8_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect8_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect8_iv[16] = {
	0xfe
};
static const uint8_t ciph_data_aes_xts_vect8_ptx[] = {
	0xd5, 0x5f, 0x68, 0x4f, 0x81, 0xf4, 0x42, 0x6e,
	0x9f, 0xde, 0x92, 0xa5, 0xff, 0x02, 0xdf, 0x2a,
	0xc8, 0x96, 0xaf, 0x63, 0x96, 0x28, 0x88, 0xa9,
	0x79, 0x10, 0xc1, 0x37, 0x9e, 0x20, 0xb0, 0xa3,

	0xb1, 0xdb, 0x61, 0x3f, 0xb7, 0xfe, 0x2e, 0x07,
	0x00, 0x43, 0x29, 0xea, 0x5c, 0x22, 0xbf, 0xd3,
	0x3e, 0x3d, 0xbe, 0x4c, 0xf5, 0x8c, 0xc6, 0x08,
	0xc2, 0xc2, 0x6c, 0x19, 0xa2, 0xe2, 0xfe, 0x22,

	0xf9, 0x87, 0x32, 0xc2, 0xb5, 0xcb, 0x84, 0x4c,
	0xc6, 0xc0, 0x70, 0x2d, 0x91, 0xe1, 0xd5, 0x0f,
	0xc4, 0x38, 0x2a, 0x7e, 0xba, 0x56, 0x35, 0xcd,
	0x60, 0x24, 0x32, 0xa2, 0x30, 0x6a, 0xc4, 0xce,

	0x82, 0xf8, 0xd7, 0x0c, 0x8d, 0x9b, 0xc1, 0x5f,
	0x91, 0x8f, 0xe7, 0x1e, 0x74, 0xc6, 0x22, 0xd5,
	0xcf, 0x71, 0x17, 0x8b, 0xf6, 0xe0, 0xb9, 0xcc,
	0x9f, 0x2b, 0x41, 0xdd, 0x8d, 0xbe, 0x44, 0x1c,

	0x41, 0xcd, 0x0c, 0x73, 0xa6, 0xdc, 0x47, 0xa3,
	0x48, 0xf6, 0x70, 0x2f, 0x9d, 0x0e, 0x9b, 0x1b,
	0x14, 0x31, 0xe9, 0x48, 0xe2, 0x99, 0xb9, 0xec,
	0x22, 0x72, 0xab, 0x2c, 0x5f, 0x0c, 0x7b, 0xe8,

	0x6a, 0xff, 0xa5, 0xde, 0xc8, 0x7a, 0x0b, 0xee,
	0x81, 0xd3, 0xd5, 0x00, 0x07, 0xed, 0xaa, 0x2b,
	0xcf, 0xcc, 0xb3, 0x56, 0x05, 0x15, 0x5f, 0xf3,
	0x6e, 0xd8, 0xed, 0xd4, 0xa4, 0x0d, 0xcd, 0x4b,

	0x24, 0x3a, 0xcd, 0x11, 0xb2, 0xb9, 0x87, 0xbd,
	0xbf, 0xaf, 0x91, 0xa7, 0xca, 0xc2, 0x7e, 0x9c,
	0x5a, 0xea, 0x52, 0x5e, 0xe5, 0x3d, 0xe7, 0xb2,
	0xd3, 0x33, 0x2c, 0x86, 0x44, 0x40, 0x2b, 0x82,

	0x3e, 0x94, 0xa7, 0xdb, 0x26, 0x27, 0x6d, 0x2d,
	0x23, 0xaa, 0x07, 0x18, 0x0f, 0x76, 0xb4, 0xfd,
	0x29, 0xb9, 0xc0, 0x82, 0x30, 0x99, 0xc9, 0xd6,
	0x2c, 0x51, 0x98, 0x80, 0xae, 0xe7, 0xe9, 0x69,

	0x76, 0x17, 0xc1, 0x49, 0x7d, 0x47, 0xbf, 0x3e,
	0x57, 0x19, 0x50, 0x31, 0x14, 0x21, 0xb6, 0xb7,
	0x34, 0xd3, 0x8b, 0x0d, 0xb9, 0x1e, 0xb8, 0x53,
	0x31, 0xb9, 0x1e, 0xa9, 0xf6, 0x15, 0x30, 0xf5,

	0x45, 0x12, 0xa5, 0xa5, 0x2a, 0x4b, 0xad, 0x58,
	0x9e, 0xb6, 0x97, 0x81, 0xd5, 0x37, 0xf2, 0x32,
	0x97, 0xbb, 0x45, 0x9b, 0xda, 0xd2, 0x94, 0x8a,
	0x29, 0xe1, 0x55, 0x0b, 0xf4, 0x78, 0x7e, 0x0b,

	0xe9, 0x5b, 0xb1, 0x73, 0xcf, 0x5f, 0xab, 0x17,
	0xda, 0xb7, 0xa1, 0x3a, 0x05, 0x2a, 0x63, 0x45,
	0x3d, 0x97, 0xcc, 0xec, 0x1a, 0x32, 0x19, 0x54,
	0x88, 0x6b, 0x7a, 0x12, 0x99, 0xfa, 0xae, 0xec,

	0xae, 0x35, 0xc6, 0xea, 0xac, 0xa7, 0x53, 0xb0,
	0x41, 0xb5, 0xe5, 0xf0, 0x93, 0xbf, 0x83, 0x39,
	0x7f, 0xd2, 0x1d, 0xd6, 0xb3, 0x01, 0x20, 0x66,
	0xfc, 0xc0, 0x58, 0xcc, 0x32, 0xc3, 0xb0, 0x9d,

	0x75, 0x62, 0xde, 0xe2, 0x95, 0x09, 0xb5, 0x83,
	0x93, 0x92, 0xc9, 0xff, 0x05, 0xf5, 0x1f, 0x31,
	0x66, 0xaa, 0xac, 0x4a, 0xc5, 0xf2, 0x38, 0x03,
	0x8a, 0x30, 0x45, 0xe6, 0xf7, 0x2e, 0x48, 0xef,

	0x0f, 0xe8, 0xbc, 0x67, 0x5e, 0x82, 0xc3, 0x18,
	0xa2, 0x68, 0xe4, 0x39, 0x70, 0x27, 0x1b, 0xf1,
	0x19, 0xb8, 0x1b, 0xf6, 0xa9, 0x82, 0x74, 0x65,
	0x54, 0xf8, 0x4e, 0x72, 0xb9, 0xf0, 0x02, 0x80,

	0xa3, 0x20, 0xa0, 0x81, 0x42, 0x92, 0x3c, 0x23,
	0xc8, 0x83, 0x42, 0x3f, 0xf9, 0x49, 0x82, 0x7f,
	0x29, 0xbb, 0xac, 0xdc, 0x1c, 0xcd, 0xb0, 0x49,
	0x38, 0xce, 0x60, 0x98, 0xc9, 0x5b, 0xa6, 0xb3,

	0x25, 0x28, 0xf4, 0xef, 0x78, 0xee, 0xd7, 0x78,
	0xb2, 0xe1, 0x22, 0xdd, 0xfd, 0x1c, 0xbd, 0xd1,
	0x1d, 0x1c, 0x0a, 0x67, 0x83, 0xe0, 0x11, 0xfc,
	0x53, 0x6d, 0x63, 0xd0, 0x53, 0x26, 0x06, 0x37,
};
static const uint8_t ciph_data_aes_xts_vect8_ctx[] = {
	0x72, 0xef, 0xc1, 0xeb, 0xfe, 0x1e, 0xe2, 0x59,
	0x75, 0xa6, 0xeb, 0x3a, 0xa8, 0x58, 0x9d, 0xda,
	0x2b, 0x26, 0x1f, 0x1c, 0x85, 0xbd, 0xab, 0x44,
	0x2a, 0x9e, 0x5b, 0x2d, 0xd1, 0xd7, 0xc3, 0x95,

	0x7a, 0x16, 0xfc, 0x08, 0xe5, 0x26, 0xd4, 0xb1,
	0x22, 0x3f, 0x1b, 0x12, 0x32, 0xa1, 0x1a, 0xf2,
	0x74, 0xc3, 0xd7, 0x0d, 0xac, 0x57, 0xf8, 0x3e,
	0x09, 0x83, 0xc4, 0x98, 0xf1, 0xa6, 0xf1, 0xae,

	0xcb, 0x02, 0x1c, 0x3e, 0x70, 0x08, 0x5a, 0x1e,
	0x52, 0x7f, 0x1c, 0xe4, 0x1e, 0xe5, 0x91, 0x1a,
	0x82, 0x02, 0x01, 0x61, 0x52, 0x9c, 0xd8, 0x27,
	0x73, 0x76, 0x2d, 0xaf, 0x54, 0x59, 0xde, 0x94,

	0xa0, 0xa8, 0x2a, 0xda, 0xe7, 0xe1, 0x70, 0x3c,
	0x80, 0x85, 0x43, 0xc2, 0x9e, 0xd6, 0xfb, 0x32,
	0xd9, 0xe0, 0x04, 0x32, 0x7c, 0x13, 0x55, 0x18,
	0x0c, 0x99, 0x5a, 0x07, 0x74, 0x14, 0x93, 0xa0,

	0x9c, 0x21, 0xba, 0x01, 0xa3, 0x87, 0x88, 0x2d,
	0xa4, 0xf6, 0x25, 0x34, 0xb8, 0x7b, 0xb1, 0x5d,
	0x60, 0xd1, 0x97, 0x20, 0x1c, 0x0f, 0xd3, 0xbf,
	0x30, 0xc1, 0x50, 0x0a, 0x3e, 0xcf, 0xec, 0xdd,

	0x66, 0xd8, 0x72, 0x1f, 0x90, 0xbc, 0xc4, 0xc1,
	0x7e, 0xe9, 0x25, 0xc6, 0x1b, 0x0a, 0x03, 0x72,
	0x7a, 0x9c, 0x0d, 0x5f, 0x5c, 0xa4, 0x62, 0xfb,
	0xfa, 0x0a, 0xf1, 0xc2, 0x51, 0x3a, 0x9d, 0x9d,

	0x4b, 0x53, 0x45, 0xbd, 0x27, 0xa5, 0xf6, 0xe6,
	0x53, 0xf7, 0x51, 0x69, 0x3e, 0x6b, 0x6a, 0x2b,
	0x8e, 0xad, 0x57, 0xd5, 0x11, 0xe0, 0x0e, 0x58,
	0xc4, 0x5b, 0x7b, 0x8d, 0x00, 0x5a, 0xf7, 0x92,

	0x88, 0xf5, 0xc7, 0xc2, 0x2f, 0xd4, 0xf1, 0xbf,
	0x7a, 0x89, 0x8b, 0x03, 0xa5, 0x63, 0x4c, 0x6a,
	0x1a, 0xe3, 0xf9, 0xfa, 0xe5, 0xde, 0x4f, 0x29,
	0x6a, 0x28, 0x96, 0xb2, 0x3e, 0x7e, 0xd4, 0x3e,

	0xd1, 0x4f, 0xa5, 0xa2, 0x80, 0x3f, 0x4d, 0x28,
	0xf0, 0xd3, 0xff, 0xcf, 0x24, 0x75, 0x76, 0x77,
	0xae, 0xbd, 0xb4, 0x7b, 0xb3, 0x88, 0x37, 0x87,
	0x08, 0x94, 0x8a, 0x8d, 0x41, 0x26, 0xed, 0x18,

	0x39, 0xe0, 0xda, 0x29, 0xa5, 0x37, 0xa8, 0xc1,
	0x98, 0xb3, 0xc6, 0x6a, 0xb0, 0x07, 0x12, 0xdd,
	0x26, 0x16, 0x74, 0xbf, 0x45, 0xa7, 0x3d, 0x67,
	0xf7, 0x69, 0x14, 0xf8, 0x30, 0xca, 0x01, 0x4b,

	0x65, 0x59, 0x6f, 0x27, 0xe4, 0xcf, 0x62, 0xde,
	0x66, 0x12, 0x5a, 0x55, 0x66, 0xdf, 0x99, 0x75,
	0x15, 0x56, 0x28, 0xb4, 0x00, 0xfb, 0xfb, 0x3a,
	0x29, 0x04, 0x0e, 0xd5, 0x0f, 0xaf, 0xfd, 0xbb,

	0x18, 0xae, 0xce, 0x7c, 0x5c, 0x44, 0x69, 0x32,
	0x60, 0xaa, 0xb3, 0x86, 0xc0, 0xa3, 0x7b, 0x11,
	0xb1, 0x14, 0xf1, 0xc4, 0x15, 0xae, 0xbb, 0x65,
	0x3b, 0xe4, 0x68, 0x17, 0x94, 0x28, 0xd4, 0x3a,

	0x4d, 0x8b, 0xc3, 0xec, 0x38, 0x81, 0x3e, 0xca,
	0x30, 0xa1, 0x3c, 0xf1, 0xbb, 0x18, 0xd5, 0x24,
	0xf1, 0x99, 0x2d, 0x44, 0xd8, 0xb1, 0xa4, 0x2e,
	0xa3, 0x0b, 0x22, 0xe6, 0xc9, 0x5b, 0x19, 0x9d,

	0x8d, 0x18, 0x2f, 0x88, 0x40, 0xb0, 0x9d, 0x05,
	0x95, 0x85, 0xc3, 0x1a, 0xd6, 0x91, 0xfa, 0x06,
	0x19, 0xff, 0x03, 0x8a, 0xca, 0x2c, 0x39, 0xa9,
	0x43, 0x42, 0x11, 0x57, 0x36, 0x17, 0x17, 0xc4,

	0x9d, 0x32, 0x20, 0x28, 0xa7, 0x46, 0x48, 0x11,
	0x3b, 0xd8, 0xc9, 0xd7, 0xec, 0x77, 0xcf, 0x3c,
	0x89, 0xc1, 0xec, 0x87, 0x18, 0xce, 0xff, 0x85,
	0x16, 0xd9, 0x6b, 0x34, 0xc3, 0xc6, 0x14, 0xf1,

	0x06, 0x99, 0xc9, 0xab, 0xc4, 0xed, 0x04, 0x11,
	0x50, 0x62, 0x23, 0xbe, 0xa1, 0x6a, 0xf3, 0x5c,
	0x88, 0x3a, 0xcc, 0xdb, 0xe1, 0x10, 0x4e, 0xef,
	0x0c, 0xfd, 0xb5, 0x4e, 0x12, 0xfb, 0x23, 0x0a,
};

/* Vector 9 */
static const uint8_t ciph_data_aes_xts_vect9_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
};
static const uint8_t ciph_data_aes_xts_vect9_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
};
static const uint8_t ciph_data_aes_xts_vect9_iv[16] = {
	0xff
};
static const uint8_t ciph_data_aes_xts_vect9_ptx[] = {
	0x72, 0xef, 0xc1, 0xeb, 0xfe, 0x1e, 0xe2, 0x59,
	0x75, 0xa6, 0xeb, 0x3a, 0xa8, 0x58, 0x9d, 0xda,
	0x2b, 0x26, 0x1f, 0x1c, 0x85, 0xbd, 0xab, 0x44,
	0x2a, 0x9e, 0x5b, 0x2d, 0xd1, 0xd7, 0xc3, 0x95,

	0x7a, 0x16, 0xfc, 0x08, 0xe5, 0x26, 0xd4, 0xb1,
	0x22, 0x3f, 0x1b, 0x12, 0x32, 0xa1, 0x1a, 0xf2,
	0x74, 0xc3, 0xd7, 0x0d, 0xac, 0x57, 0xf8, 0x3e,
	0x09, 0x83, 0xc4, 0x98, 0xf1, 0xa6, 0xf1, 0xae,

	0xcb, 0x02, 0x1c, 0x3e, 0x70, 0x08, 0x5a, 0x1e,
	0x52, 0x7f, 0x1c, 0xe4, 0x1e, 0xe5, 0x91, 0x1a,
	0x82, 0x02, 0x01, 0x61, 0x52, 0x9c, 0xd8, 0x27,
	0x73, 0x76, 0x2d, 0xaf, 0x54, 0x59, 0xde, 0x94,

	0xa0, 0xa8, 0x2a, 0xda, 0xe7, 0xe1, 0x70, 0x3c,
	0x80, 0x85, 0x43, 0xc2, 0x9e, 0xd6, 0xfb, 0x32,
	0xd9, 0xe0, 0x04, 0x32, 0x7c, 0x13, 0x55, 0x18,
	0x0c, 0x99, 0x5a, 0x07, 0x74, 0x14, 0x93, 0xa0,

	0x9c, 0x21, 0xba, 0x01, 0xa3, 0x87, 0x88, 0x2d,
	0xa4, 0xf6, 0x25, 0x34, 0xb8, 0x7b, 0xb1, 0x5d,
	0x60, 0xd1, 0x97, 0x20, 0x1c, 0x0f, 0xd3, 0xbf,
	0x30, 0xc1, 0x50, 0x0a, 0x3e, 0xcf, 0xec, 0xdd,

	0x66, 0xd8, 0x72, 0x1f, 0x90, 0xbc, 0xc4, 0xc1,
	0x7e, 0xe9, 0x25, 0xc6, 0x1b, 0x0a, 0x03, 0x72,
	0x7a, 0x9c, 0x0d, 0x5f, 0x5c, 0xa4, 0x62, 0xfb,
	0xfa, 0x0a, 0xf1, 0xc2, 0x51, 0x3a, 0x9d, 0x9d,

	0x4b, 0x53, 0x45, 0xbd, 0x27, 0xa5, 0xf6, 0xe6,
	0x53, 0xf7, 0x51, 0x69, 0x3e, 0x6b, 0x6a, 0x2b,
	0x8e, 0xad, 0x57, 0xd5, 0x11, 0xe0, 0x0e, 0x58,
	0xc4, 0x5b, 0x7b, 0x8d, 0x00, 0x5a, 0xf7, 0x92,

	0x88, 0xf5, 0xc7, 0xc2, 0x2f, 0xd4, 0xf1, 0xbf,
	0x7a, 0x89, 0x8b, 0x03, 0xa5, 0x63, 0x4c, 0x6a,
	0x1a, 0xe3, 0xf9, 0xfa, 0xe5, 0xde, 0x4f, 0x29,
	0x6a, 0x28, 0x96, 0xb2, 0x3e, 0x7e, 0xd4, 0x3e,

	0xd1, 0x4f, 0xa5, 0xa2, 0x80, 0x3f, 0x4d, 0x28,
	0xf0, 0xd3, 0xff, 0xcf, 0x24, 0x75, 0x76, 0x77,
	0xae, 0xbd, 0xb4, 0x7b, 0xb3, 0x88, 0x37, 0x87,
	0x08, 0x94, 0x8a, 0x8d, 0x41, 0x26, 0xed, 0x18,

	0x39, 0xe0, 0xda, 0x29, 0xa5, 0x37, 0xa8, 0xc1,
	0x98, 0xb3, 0xc6, 0x6a, 0xb0, 0x07, 0x12, 0xdd,
	0x26, 0x16, 0x74, 0xbf, 0x45, 0xa7, 0x3d, 0x67,
	0xf7, 0x69, 0x14, 0xf8, 0x30, 0xca, 0x01, 0x4b,

	0x65, 0x59, 0x6f, 0x27, 0xe4, 0xcf, 0x62, 0xde,
	0x66, 0x12, 0x5a, 0x55, 0x66, 0xdf, 0x99, 0x75,
	0x15, 0x56, 0x28, 0xb4, 0x00, 0xfb, 0xfb, 0x3a,
	0x29, 0x04, 0x0e, 0xd5, 0x0f, 0xaf, 0xfd, 0xbb,

	0x18, 0xae, 0xce, 0x7c, 0x5c, 0x44, 0x69, 0x32,
	0x60, 0xaa, 0xb3, 0x86, 0xc0, 0xa3, 0x7b, 0x11,
	0xb1, 0x14, 0xf1, 0xc4, 0x15, 0xae, 0xbb, 0x65,
	0x3b, 0xe4, 0x68, 0x17, 0x94, 0x28, 0xd4, 0x3a,

	0x4d, 0x8b, 0xc3, 0xec, 0x38, 0x81, 0x3e, 0xca,
	0x30, 0xa1, 0x3c, 0xf1, 0xbb, 0x18, 0xd5, 0x24,
	0xf1, 0x99, 0x2d, 0x44, 0xd8, 0xb1, 0xa4, 0x2e,
	0xa3, 0x0b, 0x22, 0xe6, 0xc9, 0x5b, 0x19, 0x9d,

	0x8d, 0x18, 0x2f, 0x88, 0x40, 0xb0, 0x9d, 0x05,
	0x95, 0x85, 0xc3, 0x1a, 0xd6, 0x91, 0xfa, 0x06,
	0x19, 0xff, 0x03, 0x8a, 0xca, 0x2c, 0x39, 0xa9,
	0x43, 0x42, 0x11, 0x57, 0x36, 0x17, 0x17, 0xc4,

	0x9d, 0x32, 0x20, 0x28, 0xa7, 0x46, 0x48, 0x11,
	0x3b, 0xd8, 0xc9, 0xd7, 0xec, 0x77, 0xcf, 0x3c,
	0x89, 0xc1, 0xec, 0x87, 0x18, 0xce, 0xff, 0x85,
	0x16, 0xd9, 0x6b, 0x34, 0xc3, 0xc6, 0x14, 0xf1,

	0x06, 0x99, 0xc9, 0xab, 0xc4, 0xed, 0x04, 0x11,
	0x50, 0x62, 0x23, 0xbe, 0xa1, 0x6a, 0xf3, 0x5c,
	0x88, 0x3a, 0xcc, 0xdb, 0xe1, 0x10, 0x4e, 0xef,
	0x0c, 0xfd, 0xb5, 0x4e, 0x12, 0xfb, 0x23, 0x0a,
};
static const uint8_t ciph_data_aes_xts_vect9_ctx[] = {
	0x32, 0x60, 0xae, 0x8d, 0xad, 0x1f, 0x4a, 0x32,
	0xc5, 0xca, 0xfe, 0x3a, 0xb0, 0xeb, 0x95, 0x54,
	0x9d, 0x46, 0x1a, 0x67, 0xce, 0xb9, 0xe5, 0xaa,
	0x2d, 0x3a, 0xfb, 0x62, 0xde, 0xce, 0x05, 0x53,

	0x19, 0x3b, 0xa5, 0x0c, 0x75, 0xbe, 0x25, 0x1e,
	0x08, 0xd1, 0xd0, 0x8f, 0x10, 0x88, 0x57, 0x6c,
	0x7e, 0xfd, 0xfa, 0xaf, 0x3f, 0x45, 0x95, 0x59,
	0x57, 0x1e, 0x12, 0x51, 0x17, 0x53, 0xb0, 0x7a,

	0xf0, 0x73, 0xf3, 0x5d, 0xa0, 0x6a, 0xf0, 0xce,
	0x0b, 0xbf, 0x6b, 0x8f, 0x5c, 0xcc, 0x5c, 0xea,
	0x50, 0x0e, 0xc1, 0xb2, 0x11, 0xbd, 0x51, 0xf6,
	0x3b, 0x60, 0x6b, 0xf6, 0x52, 0x87, 0x96, 0xca,

	0x12, 0x17, 0x3b, 0xa3, 0x9b, 0x89, 0x35, 0xee,
	0x44, 0xcc, 0xce, 0x64, 0x6f, 0x90, 0xa4, 0x5b,
	0xf9, 0xcc, 0xc5, 0x67, 0xf0, 0xac, 0xe1, 0x3d,
	0xc2, 0xd5, 0x3e, 0xbe, 0xed, 0xc8, 0x1f, 0x58,

	0xb2, 0xe4, 0x11, 0x79, 0xdd, 0xdf, 0x0d, 0x5a,
	0x5c, 0x42, 0xf5, 0xd8, 0x50, 0x6c, 0x1a, 0x5d,
	0x2f, 0x8f, 0x59, 0xf3, 0xea, 0x87, 0x3c, 0xbc,
	0xd0, 0xee, 0xc1, 0x9a, 0xcb, 0xf3, 0x25, 0x42,

	0x3b, 0xd3, 0xdc, 0xb8, 0xc2, 0xb1, 0xbf, 0x1d,
	0x1e, 0xae, 0xd0, 0xeb, 0xa7, 0xf0, 0x69, 0x8e,
	0x43, 0x14, 0xfb, 0xeb, 0x2f, 0x15, 0x66, 0xd1,
	0xb9, 0x25, 0x30, 0x08, 0xcb, 0xcc, 0xf4, 0x5a,

	0x2b, 0x0d, 0x9c, 0x5c, 0x9c, 0x21, 0x47, 0x4f,
	0x40, 0x76, 0xe0, 0x2b, 0xe2, 0x60, 0x50, 0xb9,
	0x9d, 0xee, 0x4f, 0xd6, 0x8a, 0x4c, 0xf8, 0x90,
	0xe4, 0x96, 0xe4, 0xfc, 0xae, 0x7b, 0x70, 0xf9,

	0x4e, 0xa5, 0xa9, 0x06, 0x2d, 0xa0, 0xda, 0xeb,
	0xa1, 0x99, 0x3d, 0x2c, 0xcd, 0x1d, 0xd3, 0xc2,
	0x44, 0xb8, 0x42, 0x88, 0x01, 0x49, 0x5a, 0x58,
	0xb2, 0x16, 0x54, 0x7e, 0x7e, 0x84, 0x7c, 0x46,

	0xd1, 0xd7, 0x56, 0x37, 0x7b, 0x62, 0x42, 0xd2,
	0xe5, 0xfb, 0x83, 0xbf, 0x75, 0x2b, 0x54, 0xe0,
	0xdf, 0x71, 0xe8, 0x89, 0xf3, 0xa2, 0xbb, 0x0f,
	0x4c, 0x10, 0x80, 0x5b, 0xf3, 0xc5, 0x90, 0x37,

	0x6e, 0x3c, 0x24, 0xe2, 0x2f, 0xf5, 0x7f, 0x7f,
	0xa9, 0x65, 0x57, 0x73, 0x75, 0x32, 0x5c, 0xea,
	0x5d, 0x92, 0x0d, 0xb9, 0x4b, 0x9c, 0x33, 0x6b,
	0x45, 0x5f, 0x6e, 0x89, 0x4c, 0x01, 0x86, 0x6f,

	0xe9, 0xfb, 0xb8, 0xc8, 0xd3, 0xf7, 0x0a, 0x29,
	0x57, 0x28, 0x5f, 0x6d, 0xfb, 0x5d, 0xcd, 0x8c,
	0xbf, 0x54, 0x78, 0x2f, 0x8f, 0xe7, 0x76, 0x6d,
	0x47, 0x23, 0x81, 0x99, 0x13, 0xac, 0x77, 0x34,

	0x21, 0xe3, 0xa3, 0x10, 0x95, 0x86, 0x6b, 0xad,
	0x22, 0xc8, 0x6a, 0x60, 0x36, 0xb2, 0x51, 0x8b,
	0x20, 0x59, 0xb4, 0x22, 0x9d, 0x18, 0xc8, 0xc2,
	0xcc, 0xbd, 0xf9, 0x06, 0xc6, 0xcc, 0x6e, 0x82,

	0x46, 0x4e, 0xe5, 0x7b, 0xdd, 0xb0, 0xbe, 0xbc,
	0xb1, 0xdc, 0x64, 0x53, 0x25, 0xbf, 0xb3, 0xe6,
	0x65, 0xef, 0x72, 0x51, 0x08, 0x2c, 0x88, 0xeb,
	0xb1, 0xcf, 0x20, 0x3b, 0xd7, 0x79, 0xfd, 0xd3,

	0x86, 0x75, 0x71, 0x3c, 0x8d, 0xaa, 0xdd, 0x17,
	0xe1, 0xca, 0xbe, 0xe4, 0x32, 0xb0, 0x97, 0x87,
	0xb6, 0xdd, 0xf3, 0x30, 0x4e, 0x38, 0xb7, 0x31,
	0xb4, 0x5d, 0xf5, 0xdf, 0x51, 0xb7, 0x8f, 0xcf,

	0xb3, 0xd3, 0x24, 0x66, 0x02, 0x8d, 0x0b, 0xa3,
	0x65, 0x55, 0xe7, 0xe1, 0x1a, 0xb0, 0xee, 0x06,
	0x66, 0x06, 0x1d, 0x16, 0x45, 0xd9, 0x62, 0x44,
	0x4b, 0xc4, 0x7a, 0x38, 0x18, 0x89, 0x30, 0xa8,

	0x4b, 0x4d, 0x56, 0x13, 0x95, 0xc7, 0x3c, 0x08,
	0x70, 0x21, 0x92, 0x7c, 0xa6, 0x38, 0xb7, 0xaf,
	0xc8, 0xa8, 0x67, 0x9c, 0xcb, 0x84, 0xc2, 0x65,
	0x55, 0x44, 0x0e, 0xc7, 0xf1, 0x04, 0x45, 0xcd,
};

/*
 * XTS-AES-256 applied for a data unit of 512 bytes
 */

/* Vector 10 */
static const uint8_t ciph_data_aes_xts_vect10_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
	0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69,
	0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
};
static const uint8_t ciph_data_aes_xts_vect10_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
	0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37,
	0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
};
static const uint8_t ciph_data_aes_xts_vect10_iv[16] = {
	0xff
};
static const uint8_t ciph_data_aes_xts_vect10_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect10_ctx[] = {
	0x1c, 0x3b, 0x3a, 0x10, 0x2f, 0x77, 0x03, 0x86,
	0xe4, 0x83, 0x6c, 0x99, 0xe3, 0x70, 0xcf, 0x9b,
	0xea, 0x00, 0x80, 0x3f, 0x5e, 0x48, 0x23, 0x57,
	0xa4, 0xae, 0x12, 0xd4, 0x14, 0xa3, 0xe6, 0x3b,

	0x5d, 0x31, 0xe2, 0x76, 0xf8, 0xfe, 0x4a, 0x8d,
	0x66, 0xb3, 0x17, 0xf9, 0xac, 0x68, 0x3f, 0x44,
	0x68, 0x0a, 0x86, 0xac, 0x35, 0xad, 0xfc, 0x33,
	0x45, 0xbe, 0xfe, 0xcb, 0x4b, 0xb1, 0x88, 0xfd,

	0x57, 0x76, 0x92, 0x6c, 0x49, 0xa3, 0x09, 0x5e,
	0xb1, 0x08, 0xfd, 0x10, 0x98, 0xba, 0xec, 0x70,
	0xaa, 0xa6, 0x69, 0x99, 0xa7, 0x2a, 0x82, 0xf2,
	0x7d, 0x84, 0x8b, 0x21, 0xd4, 0xa7, 0x41, 0xb0,

	0xc5, 0xcd, 0x4d, 0x5f, 0xff, 0x9d, 0xac, 0x89,
	0xae, 0xba, 0x12, 0x29, 0x61, 0xd0, 0x3a, 0x75,
	0x71, 0x23, 0xe9, 0x87, 0x0f, 0x8a, 0xcf, 0x10,
	0x00, 0x02, 0x08, 0x87, 0x89, 0x14, 0x29, 0xca,

	0x2a, 0x3e, 0x7a, 0x7d, 0x7d, 0xf7, 0xb1, 0x03,
	0x55, 0x16, 0x5c, 0x8b, 0x9a, 0x6d, 0x0a, 0x7d,
	0xe8, 0xb0, 0x62, 0xc4, 0x50, 0x0d, 0xc4, 0xcd,
	0x12, 0x0c, 0x0f, 0x74, 0x18, 0xda, 0xe3, 0xd0,

	0xb5, 0x78, 0x1c, 0x34, 0x80, 0x3f, 0xa7, 0x54,
	0x21, 0xc7, 0x90, 0xdf, 0xe1, 0xde, 0x18, 0x34,
	0xf2, 0x80, 0xd7, 0x66, 0x7b, 0x32, 0x7f, 0x6c,
	0x8c, 0xd7, 0x55, 0x7e, 0x12, 0xac, 0x3a, 0x0f,

	0x93, 0xec, 0x05, 0xc5, 0x2e, 0x04, 0x93, 0xef,
	0x31, 0xa1, 0x2d, 0x3d, 0x92, 0x60, 0xf7, 0x9a,
	0x28, 0x9d, 0x6a, 0x37, 0x9b, 0xc7, 0x0c, 0x50,
	0x84, 0x14, 0x73, 0xd1, 0xa8, 0xcc, 0x81, 0xec,

	0x58, 0x3e, 0x96, 0x45, 0xe0, 0x7b, 0x8d, 0x96,
	0x70, 0x65, 0x5b, 0xa5, 0xbb, 0xcf, 0xec, 0xc6,
	0xdc, 0x39, 0x66, 0x38, 0x0a, 0xd8, 0xfe, 0xcb,
	0x17, 0xb6, 0xba, 0x02, 0x46, 0x9a, 0x02, 0x0a,

	0x84, 0xe1, 0x8e, 0x8f, 0x84, 0x25, 0x20, 0x70,
	0xc1, 0x3e, 0x9f, 0x1f, 0x28, 0x9b, 0xe5, 0x4f,
	0xbc, 0x48, 0x14, 0x57, 0x77, 0x8f, 0x61, 0x60,
	0x15, 0xe1, 0x32, 0x7a, 0x02, 0xb1, 0x40, 0xf1,

	0x50, 0x5e, 0xb3, 0x09, 0x32, 0x6d, 0x68, 0x37,
	0x8f, 0x83, 0x74, 0x59, 0x5c, 0x84, 0x9d, 0x84,
	0xf4, 0xc3, 0x33, 0xec, 0x44, 0x23, 0x88, 0x51,
	0x43, 0xcb, 0x47, 0xbd, 0x71, 0xc5, 0xed, 0xae,

	0x9b, 0xe6, 0x9a, 0x2f, 0xfe, 0xce, 0xb1, 0xbe,
	0xc9, 0xde, 0x24, 0x4f, 0xbe, 0x15, 0x99, 0x2b,
	0x11, 0xb7, 0x7c, 0x04, 0x0f, 0x12, 0xbd, 0x8f,
	0x6a, 0x97, 0x5a, 0x44, 0xa0, 0xf9, 0x0c, 0x29,

	0xa9, 0xab, 0xc3, 0xd4, 0xd8, 0x93, 0x92, 0x72,
	0x84, 0xc5, 0x87, 0x54, 0xcc, 0xe2, 0x94, 0x52,
	0x9f, 0x86, 0x14, 0xdc, 0xd2, 0xab, 0xa9, 0x91,
	0x92, 0x5f, 0xed, 0xc4, 0xae, 0x74, 0xff, 0xac,

	0x6e, 0x33, 0x3b, 0x93, 0xeb, 0x4a, 0xff, 0x04,
	0x79, 0xda, 0x9a, 0x41, 0x0e, 0x44, 0x50, 0xe0,
	0xdd, 0x7a, 0xe4, 0xc6, 0xe2, 0x91, 0x09, 0x00,
	0x57, 0x5d, 0xa4, 0x01, 0xfc, 0x07, 0x05, 0x9f,

	0x64, 0x5e, 0x8b, 0x7e, 0x9b, 0xfd, 0xef, 0x33,
	0x94, 0x30, 0x54, 0xff, 0x84, 0x01, 0x14, 0x93,
	0xc2, 0x7b, 0x34, 0x29, 0xea, 0xed, 0xb4, 0xed,
	0x53, 0x76, 0x44, 0x1a, 0x77, 0xed, 0x43, 0x85,

	0x1a, 0xd7, 0x7f, 0x16, 0xf5, 0x41, 0xdf, 0xd2,
	0x69, 0xd5, 0x0d, 0x6a, 0x5f, 0x14, 0xfb, 0x0a,
	0xab, 0x1c, 0xbb, 0x4c, 0x15, 0x50, 0xbe, 0x97,
	0xf7, 0xab, 0x40, 0x66, 0x19, 0x3c, 0x4c, 0xaa,

	0x77, 0x3d, 0xad, 0x38, 0x01, 0x4b, 0xd2, 0x09,
	0x2f, 0xa7, 0x55, 0xc8, 0x24, 0xbb, 0x5e, 0x54,
	0xc4, 0xf3, 0x6f, 0xfd, 0xa9, 0xfc, 0xea, 0x70,
	0xb9, 0xc6, 0xe6, 0x93, 0xe1, 0x48, 0xc1, 0x51,
};

/* Vector 11 */
static const uint8_t ciph_data_aes_xts_vect11_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
	0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69,
	0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
};
static const uint8_t ciph_data_aes_xts_vect11_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
	0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37,
	0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
};
static const uint8_t ciph_data_aes_xts_vect11_iv[16] = {
	0xff, 0xff
};
static const uint8_t ciph_data_aes_xts_vect11_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect11_ctx[] = {
	0x77, 0xa3, 0x12, 0x51, 0x61, 0x8a, 0x15, 0xe6,
	0xb9, 0x2d, 0x1d, 0x66, 0xdf, 0xfe, 0x7b, 0x50,
	0xb5, 0x0b, 0xad, 0x55, 0x23, 0x05, 0xba, 0x02,
	0x17, 0xa6, 0x10, 0x68, 0x8e, 0xff, 0x7e, 0x11,

	0xe1, 0xd0, 0x22, 0x54, 0x38, 0xe0, 0x93, 0x24,
	0x2d, 0x6d, 0xb2, 0x74, 0xfd, 0xe8, 0x01, 0xd4,
	0xca, 0xe0, 0x6f, 0x20, 0x92, 0xc7, 0x28, 0xb2,
	0x47, 0x85, 0x59, 0xdf, 0x58, 0xe8, 0x37, 0xc2,

	0x46, 0x9e, 0xe4, 0xa4, 0xfa, 0x79, 0x4e, 0x4b,
	0xbc, 0x7f, 0x39, 0xbc, 0x02, 0x6e, 0x3c, 0xb7,
	0x2c, 0x33, 0xb0, 0x88, 0x8f, 0x25, 0xb4, 0xac,
	0xf5, 0x6a, 0x2a, 0x98, 0x04, 0xf1, 0xce, 0x6d,

	0x3d, 0x6e, 0x1d, 0xc6, 0xca, 0x18, 0x1d, 0x4b,
	0x54, 0x61, 0x79, 0xd5, 0x55, 0x44, 0xaa, 0x77,
	0x60, 0xc4, 0x0d, 0x06, 0x74, 0x15, 0x39, 0xc7,
	0xe3, 0xcd, 0x9d, 0x2f, 0x66, 0x50, 0xb2, 0x01,

	0x3f, 0xd0, 0xee, 0xb8, 0xc2, 0xb8, 0xe3, 0xd8,
	0xd2, 0x40, 0xcc, 0xae, 0x2d, 0x4c, 0x98, 0x32,
	0x0a, 0x74, 0x42, 0xe1, 0xc8, 0xd7, 0x5a, 0x42,
	0xd6, 0xe6, 0xcf, 0xa4, 0xc2, 0xec, 0xa1, 0x79,

	0x8d, 0x15, 0x8c, 0x7a, 0xec, 0xdf, 0x82, 0x49,
	0x0f, 0x24, 0xbb, 0x9b, 0x38, 0xe1, 0x08, 0xbc,
	0xda, 0x12, 0xc3, 0xfa, 0xf9, 0xa2, 0x11, 0x41,
	0xc3, 0x61, 0x3b, 0x58, 0x36, 0x7f, 0x92, 0x2a,

	0xaa, 0x26, 0xcd, 0x22, 0xf2, 0x3d, 0x70, 0x8d,
	0xae, 0x69, 0x9a, 0xd7, 0xcb, 0x40, 0xa8, 0xad,
	0x0b, 0x6e, 0x27, 0x84, 0x97, 0x3d, 0xcb, 0x60,
	0x56, 0x84, 0xc0, 0x8b, 0x8d, 0x69, 0x98, 0xc6,

	0x9a, 0xac, 0x04, 0x99, 0x21, 0x87, 0x1e, 0xbb,
	0x65, 0x30, 0x1a, 0x46, 0x19, 0xca, 0x80, 0xec,
	0xb4, 0x85, 0xa3, 0x1d, 0x74, 0x42, 0x23, 0xce,
	0x8d, 0xdc, 0x23, 0x94, 0x82, 0x8d, 0x6a, 0x80,

	0x47, 0x0c, 0x09, 0x2f, 0x5b, 0xa4, 0x13, 0xc3,
	0x37, 0x8f, 0xa6, 0x05, 0x42, 0x55, 0xc6, 0xf9,
	0xdf, 0x44, 0x95, 0x86, 0x2b, 0xbb, 0x32, 0x87,
	0x68, 0x1f, 0x93, 0x1b, 0x68, 0x7c, 0x88, 0x8a,

	0xbf, 0x84, 0x4d, 0xfc, 0x8f, 0xc2, 0x83, 0x31,
	0xe5, 0x79, 0x92, 0x8c, 0xd1, 0x2b, 0xd2, 0x39,
	0x0a, 0xe1, 0x23, 0xcf, 0x03, 0x81, 0x8d, 0x14,
	0xde, 0xdd, 0xe5, 0xc0, 0xc2, 0x4c, 0x8a, 0xb0,

	0x18, 0xbf, 0xca, 0x75, 0xca, 0x09, 0x6f, 0x2d,
	0x53, 0x1f, 0x3d, 0x16, 0x19, 0xe7, 0x85, 0xf1,
	0xad, 0xa4, 0x37, 0xca, 0xb9, 0x2e, 0x98, 0x05,
	0x58, 0xb3, 0xdc, 0xe1, 0x47, 0x4a, 0xfb, 0x75,

	0xbf, 0xed, 0xbf, 0x8f, 0xf5, 0x4c, 0xb2, 0x61,
	0x8e, 0x02, 0x44, 0xc9, 0xac, 0x0d, 0x3c, 0x66,
	0xfb, 0x51, 0x59, 0x8c, 0xd2, 0xdb, 0x11, 0xf9,
	0xbe, 0x39, 0x79, 0x1a, 0xbe, 0x44, 0x7c, 0x63,

	0x09, 0x4f, 0x7c, 0x45, 0x3b, 0x7f, 0xf8, 0x7c,
	0xb5, 0xbb, 0x36, 0xb7, 0xc7, 0x9e, 0xfb, 0x08,
	0x72, 0xd1, 0x70, 0x58, 0xb8, 0x3b, 0x15, 0xab,
	0x08, 0x66, 0xad, 0x8a, 0x58, 0x65, 0x6c, 0x5a,

	0x7e, 0x20, 0xdb, 0xdf, 0x30, 0x8b, 0x24, 0x61,
	0xd9, 0x7c, 0x0e, 0xc0, 0x02, 0x4a, 0x27, 0x15,
	0x05, 0x52, 0x49, 0xcf, 0x3b, 0x47, 0x8d, 0xdd,
	0x47, 0x40, 0xde, 0x65, 0x4f, 0x75, 0xca, 0x68,

	0x6e, 0x0d, 0x73, 0x45, 0xc6, 0x9e, 0xd5, 0x0c,
	0xdc, 0x2a, 0x8b, 0x33, 0x2b, 0x1f, 0x88, 0x24,
	0x10, 0x8a, 0xc9, 0x37, 0xeb, 0x05, 0x05, 0x85,
	0x60, 0x8e, 0xe7, 0x34, 0x09, 0x7f, 0xc0, 0x90,

	0x54, 0xfb, 0xff, 0x89, 0xee, 0xae, 0xea, 0x79,
	0x1f, 0x4a, 0x7a, 0xb1, 0xf9, 0x86, 0x82, 0x94,
	0xa4, 0xf9, 0xe2, 0x7b, 0x42, 0xaf, 0x81, 0x00,
	0xcb, 0x9d, 0x59, 0xce, 0xf9, 0x64, 0x58, 0x03,
};


/* Vector 12 */
static const uint8_t ciph_data_aes_xts_vect12_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
	0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69,
	0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
};
static const uint8_t ciph_data_aes_xts_vect12_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
	0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37,
	0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
};
static const uint8_t ciph_data_aes_xts_vect12_iv[16] = {
	0xff, 0xff, 0xff
};
static const uint8_t ciph_data_aes_xts_vect12_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect12_ctx[] = {
	0xe3, 0x87, 0xaa, 0xa5, 0x8b, 0xa4, 0x83, 0xaf,
	0xa7, 0xe8, 0xeb, 0x46, 0x97, 0x78, 0x31, 0x7e,
	0xcf, 0x4c, 0xf5, 0x73, 0xaa, 0x9d, 0x4e, 0xac,
	0x23, 0xf2, 0xcd, 0xf9, 0x14, 0xe4, 0xe2, 0x00,

	0xa8, 0xb4, 0x90, 0xe4, 0x2e, 0xe6, 0x46, 0x80,
	0x2d, 0xc6, 0xee, 0x2b, 0x47, 0x1b, 0x27, 0x81,
	0x95, 0xd6, 0x09, 0x18, 0xec, 0xec, 0xb4, 0x4b,
	0xf7, 0x99, 0x66, 0xf8, 0x3f, 0xab, 0xa0, 0x49,

	0x92, 0x98, 0xeb, 0xc6, 0x99, 0xc0, 0xc8, 0x63,
	0x47, 0x15, 0xa3, 0x20, 0xbb, 0x4f, 0x07, 0x5d,
	0x62, 0x2e, 0x74, 0xc8, 0xc9, 0x32, 0x00, 0x4f,
	0x25, 0xb4, 0x1e, 0x36, 0x10, 0x25, 0xb5, 0xa8,

	0x78, 0x15, 0x39, 0x1f, 0x61, 0x08, 0xfc, 0x4a,
	0xfa, 0x6a, 0x05, 0xd9, 0x30, 0x3c, 0x6b, 0xa6,
	0x8a, 0x12, 0x8a, 0x55, 0x70, 0x5d, 0x41, 0x59,
	0x85, 0x83, 0x2f, 0xde, 0xaa, 0xe6, 0xc8, 0xe1,

	0x91, 0x10, 0xe8, 0x4d, 0x1b, 0x1f, 0x19, 0x9a,
	0x26, 0x92, 0x11, 0x9e, 0xdc, 0x96, 0x13, 0x26,
	0x58, 0xf0, 0x9d, 0xa7, 0xc6, 0x23, 0xef, 0xce,
	0xc7, 0x12, 0x53, 0x7a, 0x3d, 0x94, 0xc0, 0xbf,

	0x5d, 0x7e, 0x35, 0x2e, 0xc9, 0x4a, 0xe5, 0x79,
	0x7f, 0xdb, 0x37, 0x7d, 0xc1, 0x55, 0x11, 0x50,
	0x72, 0x1a, 0xdf, 0x15, 0xbd, 0x26, 0xa8, 0xef,
	0xc2, 0xfc, 0xaa, 0xd5, 0x68, 0x81, 0xfa, 0x9e,

	0x62, 0x46, 0x2c, 0x28, 0xf3, 0x0a, 0xe1, 0xce,
	0xac, 0xa9, 0x3c, 0x34, 0x5c, 0xf2, 0x43, 0xb7,
	0x3f, 0x54, 0x2e, 0x20, 0x74, 0xa7, 0x05, 0xbd,
	0x26, 0x43, 0xbb, 0x9f, 0x7c, 0xc7, 0x9b, 0xb6,

	0xe7, 0x09, 0x1e, 0xa6, 0xe2, 0x32, 0xdf, 0x0f,
	0x9a, 0xd0, 0xd6, 0xcf, 0x50, 0x23, 0x27, 0x87,
	0x6d, 0x82, 0x20, 0x7a, 0xbf, 0x21, 0x15, 0xcd,
	0xac, 0xf6, 0xd5, 0xa4, 0x8f, 0x6c, 0x18, 0x79,

	0xa6, 0x5b, 0x11, 0x5f, 0x0f, 0x8b, 0x3c, 0xb3,
	0xc5, 0x9d, 0x15, 0xdd, 0x8c, 0x76, 0x9b, 0xc0,
	0x14, 0x79, 0x5a, 0x18, 0x37, 0xf3, 0x90, 0x1b,
	0x58, 0x45, 0xeb, 0x49, 0x1a, 0xdf, 0xef, 0xe0,

	0x97, 0xb1, 0xfa, 0x30, 0xa1, 0x2f, 0xc1, 0xf6,
	0x5b, 0xa2, 0x29, 0x05, 0x03, 0x15, 0x39, 0x97,
	0x1a, 0x10, 0xf2, 0xf3, 0x6c, 0x32, 0x1b, 0xb5,
	0x13, 0x31, 0xcd, 0xef, 0xb3, 0x9e, 0x39, 0x64,

	0xc7, 0xef, 0x07, 0x99, 0x94, 0xf5, 0xb6, 0x9b,
	0x2e, 0xdd, 0x83, 0xa7, 0x1e, 0xf5, 0x49, 0x97,
	0x1e, 0xe9, 0x3f, 0x44, 0xea, 0xc3, 0x93, 0x8f,
	0xcd, 0xd6, 0x1d, 0x01, 0xfa, 0x71, 0x79, 0x9d,

	0xa3, 0xa8, 0x09, 0x1c, 0x4c, 0x48, 0xaa, 0x9e,
	0xd2, 0x63, 0xff, 0x07, 0x49, 0xdf, 0x95, 0xd4,
	0x4f, 0xef, 0x6a, 0x0b, 0xb5, 0x78, 0xec, 0x69,
	0x45, 0x6a, 0xa5, 0x40, 0x8a, 0xe3, 0x2c, 0x7a,

	0xf0, 0x8a, 0xd7, 0xba, 0x89, 0x21, 0x28, 0x7e,
	0x3b, 0xbe, 0xe3, 0x1b, 0x76, 0x7b, 0xe0, 0x6a,
	0x0e, 0x70, 0x5c, 0x86, 0x4a, 0x76, 0x91, 0x37,
	0xdf, 0x28, 0x29, 0x22, 0x83, 0xea, 0x81, 0xa2,

	0x48, 0x02, 0x41, 0xb4, 0x4d, 0x99, 0x21, 0xcd,
	0xbe, 0xc1, 0xbc, 0x28, 0xdc, 0x1f, 0xda, 0x11,
	0x4b, 0xd8, 0xe5, 0x21, 0x7a, 0xc9, 0xd8, 0xeb,
	0xaf, 0xa7, 0x20, 0xe9, 0xda, 0x4f, 0x9a, 0xce,

	0x23, 0x1c, 0xc9, 0x49, 0xe5, 0xb9, 0x6f, 0xe7,
	0x6f, 0xfc, 0x21, 0x06, 0x3f, 0xdd, 0xc8, 0x3a,
	0x6b, 0x86, 0x79, 0xc0, 0x0d, 0x35, 0xe0, 0x95,
	0x76, 0xa8, 0x75, 0x30, 0x5b, 0xed, 0x5f, 0x36,

	0xed, 0x24, 0x2c, 0x89, 0x00, 0xdd, 0x1f, 0xa9,
	0x65, 0xbc, 0x95, 0x0d, 0xfc, 0xe0, 0x9b, 0x13,
	0x22, 0x63, 0xa1, 0xee, 0xf5, 0x2d, 0xd6, 0x88,
	0x8c, 0x30, 0x9f, 0x5a, 0x7d, 0x71, 0x28, 0x26,
};

/* Vector 13 */
static const uint8_t ciph_data_aes_xts_vect13_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
	0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69,
	0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
};
static const uint8_t ciph_data_aes_xts_vect13_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
	0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37,
	0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
};
static const uint8_t ciph_data_aes_xts_vect13_iv[16] = {
	0xff, 0xff, 0xff, 0xff
};
static const uint8_t ciph_data_aes_xts_vect13_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect13_ctx[] = {
	0xbf, 0x53, 0xd2, 0xda, 0xde, 0x78, 0xe8, 0x22,
	0xa4, 0xd9, 0x49, 0xa9, 0xbc, 0x67, 0x66, 0xb0,
	0x1b, 0x06, 0xa8, 0xef, 0x70, 0xd2, 0x67, 0x48,
	0xc6, 0xa7, 0xfc, 0x36, 0xd8, 0x0a, 0xe4, 0xc5,

	0x52, 0x0f, 0x7c, 0x4a, 0xb0, 0xac, 0x85, 0x44,
	0x42, 0x4f, 0xa4, 0x05, 0x16, 0x2f, 0xef, 0x5a,
	0x6b, 0x7f, 0x22, 0x94, 0x98, 0x06, 0x36, 0x18,
	0xd3, 0x9f, 0x00, 0x03, 0xcb, 0x5f, 0xb8, 0xd1,

	0xc8, 0x6b, 0x64, 0x34, 0x97, 0xda, 0x1f, 0xf9,
	0x45, 0xc8, 0xd3, 0xbe, 0xde, 0xca, 0x4f, 0x47,
	0x97, 0x02, 0xa7, 0xa7, 0x35, 0xf0, 0x43, 0xdd,
	0xb1, 0xd6, 0xaa, 0xad, 0xe3, 0xc4, 0xa0, 0xac,

	0x7c, 0xa7, 0xf3, 0xfa, 0x52, 0x79, 0xbe, 0xf5,
	0x6f, 0x82, 0xcd, 0x7a, 0x2f, 0x38, 0x67, 0x2e,
	0x82, 0x48, 0x14, 0xe1, 0x07, 0x00, 0x30, 0x0a,
	0x05, 0x5e, 0x16, 0x30, 0xb8, 0xf1, 0xcb, 0x0e,

	0x91, 0x9f, 0x5e, 0x94, 0x20, 0x10, 0xa4, 0x16,
	0xe2, 0xbf, 0x48, 0xcb, 0x46, 0x99, 0x3d, 0x3c,
	0xb6, 0xa5, 0x1c, 0x19, 0xba, 0xcf, 0x86, 0x47,
	0x85, 0xa0, 0x0b, 0xc2, 0xec, 0xff, 0x15, 0xd3,

	0x50, 0x87, 0x5b, 0x24, 0x6e, 0xd5, 0x3e, 0x68,
	0xbe, 0x6f, 0x55, 0xbd, 0x7e, 0x05, 0xcf, 0xc2,
	0xb2, 0xed, 0x64, 0x32, 0x19, 0x8a, 0x64, 0x44,
	0xb6, 0xd8, 0xc2, 0x47, 0xfa, 0xb9, 0x41, 0xf5,

	0x69, 0x76, 0x8b, 0x5c, 0x42, 0x93, 0x66, 0xf1,
	0xd3, 0xf0, 0x0f, 0x03, 0x45, 0xb9, 0x61, 0x23,
	0xd5, 0x62, 0x04, 0xc0, 0x1c, 0x63, 0xb2, 0x2c,
	0xe7, 0x8b, 0xaf, 0x11, 0x6e, 0x52, 0x5e, 0xd9,

	0x0f, 0xde, 0xa3, 0x9f, 0xa4, 0x69, 0x49, 0x4d,
	0x38, 0x66, 0xc3, 0x1e, 0x05, 0xf2, 0x95, 0xff,
	0x21, 0xfe, 0xa8, 0xd4, 0xe6, 0xe1, 0x3d, 0x67,
	0xe4, 0x7c, 0xe7, 0x22, 0xe9, 0x69, 0x8a, 0x1c,

	0x10, 0x48, 0xd6, 0x8e, 0xbc, 0xde, 0x76, 0xb8,
	0x6f, 0xcf, 0x97, 0x6e, 0xab, 0x8a, 0xa9, 0x79,
	0x02, 0x68, 0xb7, 0x06, 0x8e, 0x01, 0x7a, 0x8b,
	0x9b, 0x74, 0x94, 0x09, 0x51, 0x4f, 0x10, 0x53,

	0x02, 0x7f, 0xd1, 0x6c, 0x37, 0x86, 0xea, 0x1b,
	0xac, 0x5f, 0x15, 0xcb, 0x79, 0x71, 0x1e, 0xe2,
	0xab, 0xe8, 0x2f, 0x5c, 0xf8, 0xb1, 0x3a, 0xe7,
	0x30, 0x30, 0xef, 0x5b, 0x9e, 0x44, 0x57, 0xe7,

	0x5d, 0x13, 0x04, 0xf9, 0x88, 0xd6, 0x2d, 0xd6,
	0xfc, 0x4b, 0x94, 0xed, 0x38, 0xba, 0x83, 0x1d,
	0xa4, 0xb7, 0x63, 0x49, 0x71, 0xb6, 0xcd, 0x8e,
	0xc3, 0x25, 0xd9, 0xc6, 0x1c, 0x00, 0xf1, 0xdf,

	0x73, 0x62, 0x7e, 0xd3, 0x74, 0x5a, 0x5e, 0x84,
	0x89, 0xf3, 0xa9, 0x5c, 0x69, 0x63, 0x9c, 0x32,
	0xcd, 0x6e, 0x1d, 0x53, 0x7a, 0x85, 0xf7, 0x5c,
	0xc8, 0x44, 0x72, 0x6e, 0x8a, 0x72, 0xfc, 0x00,

	0x77, 0xad, 0x22, 0x00, 0x0f, 0x1d, 0x50, 0x78,
	0xf6, 0xb8, 0x66, 0x31, 0x8c, 0x66, 0x8f, 0x1a,
	0xd0, 0x3d, 0x5a, 0x5f, 0xce, 0xd5, 0x21, 0x9f,
	0x2e, 0xab, 0xbd, 0x0a, 0xa5, 0xc0, 0xf4, 0x60,

	0xd1, 0x83, 0xf0, 0x44, 0x04, 0xa0, 0xd6, 0xf4,
	0x69, 0x55, 0x8e, 0x81, 0xfa, 0xb2, 0x4a, 0x16,
	0x79, 0x05, 0xab, 0x4c, 0x78, 0x78, 0x50, 0x2a,
	0xd3, 0xe3, 0x8f, 0xdb, 0xe6, 0x2a, 0x41, 0x55,

	0x6c, 0xec, 0x37, 0x32, 0x57, 0x59, 0x53, 0x3c,
	0xe8, 0xf2, 0x5f, 0x36, 0x7c, 0x87, 0xbb, 0x55,
	0x78, 0xd6, 0x67, 0xae, 0x93, 0xf9, 0xe2, 0xfd,
	0x99, 0xbc, 0xbc, 0x5f, 0x2f, 0xbb, 0xa8, 0x8c,

	0xf6, 0x51, 0x61, 0x39, 0x42, 0x0f, 0xcf, 0xf3,
	0xb7, 0x36, 0x1d, 0x86, 0x32, 0x2c, 0x4b, 0xd8,
	0x4c, 0x82, 0xf3, 0x35, 0xab, 0xb1, 0x52, 0xc4,
	0xa9, 0x34, 0x11, 0x37, 0x3a, 0xaa, 0x82, 0x20,
};

/* Vector 14 */
static const uint8_t ciph_data_aes_xts_vect14_key1[] = {
	0x27, 0x18, 0x28, 0x18, 0x28, 0x45, 0x90, 0x45,
	0x23, 0x53, 0x60, 0x28, 0x74, 0x71, 0x35, 0x26,
	0x62, 0x49, 0x77, 0x57, 0x24, 0x70, 0x93, 0x69,
	0x99, 0x59, 0x57, 0x49, 0x66, 0x96, 0x76, 0x27,
};
static const uint8_t ciph_data_aes_xts_vect14_key2[] = {
	0x31, 0x41, 0x59, 0x26, 0x53, 0x58, 0x97, 0x93,
	0x23, 0x84, 0x62, 0x64, 0x33, 0x83, 0x27, 0x95,
	0x02, 0x88, 0x41, 0x97, 0x16, 0x93, 0x99, 0x37,
	0x51, 0x05, 0x82, 0x09, 0x74, 0x94, 0x45, 0x92,
};
static const uint8_t ciph_data_aes_xts_vect14_iv[16] = {
	0xff, 0xff, 0xff, 0xff, 0xff
};
static const uint8_t ciph_data_aes_xts_vect14_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect14_ctx[] = {
	0x64, 0x49, 0x7e, 0x5a, 0x83, 0x1e, 0x4a, 0x93,
	0x2c, 0x09, 0xbe, 0x3e, 0x53, 0x93, 0x37, 0x6d,
	0xaa, 0x59, 0x95, 0x48, 0xb8, 0x16, 0x03, 0x1d,
	0x22, 0x4b, 0xbf, 0x50, 0xa8, 0x18, 0xed, 0x23,

	0x50, 0xea, 0xe7, 0xe9, 0x60, 0x87, 0xc8, 0xa0,
	0xdb, 0x51, 0xad, 0x29, 0x0b, 0xd0, 0x0c, 0x1a,
	0xc1, 0x62, 0x08, 0x57, 0x63, 0x5b, 0xf2, 0x46,
	0xc1, 0x76, 0xab, 0x46, 0x3b, 0xe3, 0x0b, 0x80,

	0x8d, 0xa5, 0x48, 0x08, 0x1a, 0xc8, 0x47, 0xb1,
	0x58, 0xe1, 0x26, 0x4b, 0xe2, 0x5b, 0xb0, 0x91,
	0x0b, 0xbc, 0x92, 0x64, 0x71, 0x08, 0x08, 0x94,
	0x15, 0xd4, 0x5f, 0xab, 0x1b, 0x3d, 0x26, 0x04,

	0xe8, 0xa8, 0xef, 0xf1, 0xae, 0x40, 0x20, 0xcf,
	0xa3, 0x99, 0x36, 0xb6, 0x68, 0x27, 0xb2, 0x3f,
	0x37, 0x1b, 0x92, 0x20, 0x0b, 0xe9, 0x02, 0x51,
	0xe6, 0xd7, 0x3c, 0x5f, 0x86, 0xde, 0x5f, 0xd4,

	0xa9, 0x50, 0x78, 0x19, 0x33, 0xd7, 0x9a, 0x28,
	0x27, 0x2b, 0x78, 0x2a, 0x2e, 0xc3, 0x13, 0xef,
	0xdf, 0xcc, 0x06, 0x28, 0xf4, 0x3d, 0x74, 0x4c,
	0x2d, 0xc2, 0xff, 0x3d, 0xcb, 0x66, 0x99, 0x9b,

	0x50, 0xc7, 0xca, 0x89, 0x5b, 0x0c, 0x64, 0x79,
	0x1e, 0xea, 0xa5, 0xf2, 0x94, 0x99, 0xfb, 0x1c,
	0x02, 0x6f, 0x84, 0xce, 0x5b, 0x5c, 0x72, 0xba,
	0x10, 0x83, 0xcd, 0xdb, 0x5c, 0xe4, 0x54, 0x34,

	0x63, 0x16, 0x65, 0xc3, 0x33, 0xb6, 0x0b, 0x11,
	0x59, 0x3f, 0xb2, 0x53, 0xc5, 0x17, 0x9a, 0x2c,
	0x8d, 0xb8, 0x13, 0x78, 0x2a, 0x00, 0x48, 0x56,
	0xa1, 0x65, 0x30, 0x11, 0xe9, 0x3f, 0xb6, 0xd8,

	0x76, 0xc1, 0x83, 0x66, 0xdd, 0x86, 0x83, 0xf5,
	0x34, 0x12, 0xc0, 0xc1, 0x80, 0xf9, 0xc8, 0x48,
	0x59, 0x2d, 0x59, 0x3f, 0x86, 0x09, 0xca, 0x73,
	0x63, 0x17, 0xd3, 0x56, 0xe1, 0x3e, 0x2b, 0xff,

	0x3a, 0x9f, 0x59, 0xcd, 0x9a, 0xeb, 0x19, 0xcd,
	0x48, 0x25, 0x93, 0xd8, 0xc4, 0x61, 0x28, 0xbb,
	0x32, 0x42, 0x3b, 0x37, 0xa9, 0xad, 0xfb, 0x48,
	0x2b, 0x99, 0x45, 0x3f, 0xbe, 0x25, 0xa4, 0x1b,

	0xf6, 0xfe, 0xb4, 0xaa, 0x0b, 0xef, 0x5e, 0xd2,
	0x4b, 0xf7, 0x3c, 0x76, 0x29, 0x78, 0x02, 0x54,
	0x82, 0xc1, 0x31, 0x15, 0xe4, 0x01, 0x5a, 0xac,
	0x99, 0x2e, 0x56, 0x13, 0xa3, 0xb5, 0xc2, 0xf6,

	0x85, 0xb8, 0x47, 0x95, 0xcb, 0x6e, 0x9b, 0x26,
	0x56, 0xd8, 0xc8, 0x81, 0x57, 0xe5, 0x2c, 0x42,
	0xf9, 0x78, 0xd8, 0x63, 0x4c, 0x43, 0xd0, 0x6f,
	0xea, 0x92, 0x8f, 0x28, 0x22, 0xe4, 0x65, 0xaa,

	0x65, 0x76, 0xe9, 0xbf, 0x41, 0x93, 0x84, 0x50,
	0x6c, 0xc3, 0xce, 0x3c, 0x54, 0xac, 0x1a, 0x6f,
	0x67, 0xdc, 0x66, 0xf3, 0xb3, 0x01, 0x91, 0xe6,
	0x98, 0x38, 0x0b, 0xc9, 0x99, 0xb0, 0x5a, 0xbc,

	0xe1, 0x9d, 0xc0, 0xc6, 0xdc, 0xc2, 0xdd, 0x00,
	0x1e, 0xc5, 0x35, 0xba, 0x18, 0xde, 0xb2, 0xdf,
	0x1a, 0x10, 0x10, 0x23, 0x10, 0x83, 0x18, 0xc7,
	0x5d, 0xc9, 0x86, 0x11, 0xa0, 0x9d, 0xc4, 0x8a,

	0x0a, 0xcd, 0xec, 0x67, 0x6f, 0xab, 0xdf, 0x22,
	0x2f, 0x07, 0xe0, 0x26, 0xf0, 0x59, 0xb6, 0x72,
	0xb5, 0x6e, 0x5c, 0xbc, 0x8e, 0x1d, 0x21, 0xbb,
	0xd8, 0x67, 0xdd, 0x92, 0x72, 0x12, 0x05, 0x46,

	0x81, 0xd7, 0x0e, 0xa7, 0x37, 0x13, 0x4c, 0xdf,
	0xce, 0x93, 0xb6, 0xf8, 0x2a, 0xe2, 0x24, 0x23,
	0x27, 0x4e, 0x58, 0xa0, 0x82, 0x1c, 0xc5, 0x50,
	0x2e, 0x2d, 0x0a, 0xb4, 0x58, 0x5e, 0x94, 0xde,

	0x69, 0x75, 0xbe, 0x5e, 0x0b, 0x4e, 0xfc, 0xe5,
	0x1c, 0xd3, 0xe7, 0x0c, 0x25, 0xa1, 0xfb, 0xbb,
	0xd6, 0x09, 0xd2, 0x73, 0xad, 0x5b, 0x0d, 0x59,
	0x63, 0x1c, 0x53, 0x1f, 0x6a, 0x0a, 0x57, 0xb9,
};

/*
 * XTS-AES-128 applied for a data unit that is not a multiple of 16 bytes
 */

/* Vector 15 */
static const uint8_t ciph_data_aes_xts_vect15_key1[] = {
	0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
	0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
};
static const uint8_t ciph_data_aes_xts_vect15_key2[] = {
	0xbf, 0xbe, 0xbd, 0xbc, 0xbb, 0xba, 0xb9, 0xb8,
	0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 0xb1, 0xb0,
};
static const uint8_t ciph_data_aes_xts_vect15_iv[16] = {
	0x9a, 0x78, 0x56, 0x34, 0x12
};
static const uint8_t ciph_data_aes_xts_vect15_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10
};
static const uint8_t ciph_data_aes_xts_vect15_ctx[] = {
	0x6c, 0x16, 0x25, 0xdb, 0x46, 0x71, 0x52, 0x2d,
	0x3d, 0x75, 0x99, 0x60, 0x1d, 0xe7, 0xca, 0x09,
	0xed
};

/* Vector 16 */
static const uint8_t ciph_data_aes_xts_vect16_key1[] = {
	0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
	0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
};
static const uint8_t ciph_data_aes_xts_vect16_key2[] = {
	0xbf, 0xbe, 0xbd, 0xbc, 0xbb, 0xba, 0xb9, 0xb8,
	0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 0xb1, 0xb0,
};
static const uint8_t ciph_data_aes_xts_vect16_iv[16] = {
	0x9a, 0x78, 0x56, 0x34, 0x12
};
static const uint8_t ciph_data_aes_xts_vect16_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11
};
static const uint8_t ciph_data_aes_xts_vect16_ctx[] = {
	0xd0, 0x69, 0x44, 0x4b, 0x7a, 0x7e, 0x0c, 0xab,
	0x09, 0xe2, 0x44, 0x47, 0xd2, 0x4d, 0xeb, 0x1f,
	0xed, 0xbf
};

/* Vector 17 */
static const uint8_t ciph_data_aes_xts_vect17_key1[] = {
	0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
	0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
};
static const uint8_t ciph_data_aes_xts_vect17_key2[] = {
	0xbf, 0xbe, 0xbd, 0xbc, 0xbb, 0xba, 0xb9, 0xb8,
	0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 0xb1, 0xb0,
};
static const uint8_t ciph_data_aes_xts_vect17_iv[16] = {
	0x9a, 0x78, 0x56, 0x34, 0x12
};
static const uint8_t ciph_data_aes_xts_vect17_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12
};
static const uint8_t ciph_data_aes_xts_vect17_ctx[] = {
	0xe5, 0xdf, 0x13, 0x51, 0xc0, 0x54, 0x4b, 0xa1,
	0x35, 0x0b, 0x33, 0x63, 0xcd, 0x8e, 0xf4, 0xbe,
	0xed, 0xbf, 0x9d
};

/* Vector 18 */
static const uint8_t ciph_data_aes_xts_vect18_key1[] = {
	0xff, 0xfe, 0xfd, 0xfc, 0xfb, 0xfa, 0xf9, 0xf8,
	0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
};
static const uint8_t ciph_data_aes_xts_vect18_key2[] = {
	0xbf, 0xbe, 0xbd, 0xbc, 0xbb, 0xba, 0xb9, 0xb8,
	0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 0xb1, 0xb0,
};
static const uint8_t ciph_data_aes_xts_vect18_iv[16] = {
	0x9a, 0x78, 0x56, 0x34, 0x12
};
static const uint8_t ciph_data_aes_xts_vect18_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13
};
static const uint8_t ciph_data_aes_xts_vect18_ctx[] = {
	0x9d, 0x84, 0xc8, 0x13, 0xf7, 0x19, 0xaa, 0x2c,
	0x7b, 0xe3, 0xf6, 0x61, 0x71, 0xc7, 0xc5, 0xc2,
	0xed, 0xbf, 0x9d, 0xac
};

/* Vector 19 */
static const uint8_t ciph_data_aes_xts_vect19_key1[] = {
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
};
static const uint8_t ciph_data_aes_xts_vect19_key2[] = {
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
};
static const uint8_t ciph_data_aes_xts_vect19_iv[16] = {
	0x21, 0x43, 0x65, 0x87, 0xa9
};
static const uint8_t ciph_data_aes_xts_vect19_ptx[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,

	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,

	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,

	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,

	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};
static const uint8_t ciph_data_aes_xts_vect19_ctx[] = {
	0x38, 0xb4, 0x58, 0x12, 0xef, 0x43, 0xa0, 0x5b,
	0xd9, 0x57, 0xe5, 0x45, 0x90, 0x7e, 0x22, 0x3b,
	0x95, 0x4a, 0xb4, 0xaa, 0xf0, 0x88, 0x30, 0x3a,
	0xd9, 0x10, 0xea, 0xdf, 0x14, 0xb4, 0x2b, 0xe6,

	0x8b, 0x24, 0x61, 0x14, 0x9d, 0x8c, 0x8b, 0xa8,
	0x5f, 0x99, 0x2b, 0xe9, 0x70, 0xbc, 0x62, 0x1f,
	0x1b, 0x06, 0x57, 0x3f, 0x63, 0xe8, 0x67, 0xbf,
	0x58, 0x75, 0xac, 0xaf, 0xa0, 0x4e, 0x42, 0xcc,

	0xbd, 0x7b, 0xd3, 0xc2, 0xa0, 0xfb, 0x1f, 0xff,
	0x79, 0x1e, 0xc5, 0xec, 0x36, 0xc6, 0x6a, 0xe4,
	0xac, 0x1e, 0x80, 0x6d, 0x81, 0xfb, 0xf7, 0x09,
	0xdb, 0xe2, 0x9e, 0x47, 0x1f, 0xad, 0x38, 0x54,

	0x9c, 0x8e, 0x66, 0xf5, 0x34, 0x5d, 0x7c, 0x1e,
	0xb9, 0x4f, 0x40, 0x5d, 0x1e, 0xc7, 0x85, 0xcc,
	0x6f, 0x6a, 0x68, 0xf6, 0x25, 0x4d, 0xd8, 0x33,
	0x9f, 0x9d, 0x84, 0x05, 0x7e, 0x01, 0xa1, 0x77,

	0x41, 0x99, 0x04, 0x82, 0x99, 0x95, 0x16, 0xb5,
	0x61, 0x1a, 0x38, 0xf4, 0x1b, 0xb6, 0x47, 0x8e,
	0x6f, 0x17, 0x3f, 0x32, 0x08, 0x05, 0xdd, 0x71,
	0xb1, 0x93, 0x2f, 0xc3, 0x33, 0xcb, 0x9e, 0xe3,

	0x99, 0x36, 0xbe, 0xea, 0x9a, 0xd9, 0x6f, 0xa1,
	0x0f, 0xb4, 0x11, 0x2b, 0x90, 0x17, 0x34, 0xdd,
	0xad, 0x40, 0xbc, 0x18, 0x78, 0x99, 0x5f, 0x8e,
	0x11, 0xae, 0xe7, 0xd1, 0x41, 0xa2, 0xf5, 0xd4,

	0x8b, 0x7a, 0x4e, 0x1e, 0x7f, 0x0b, 0x2c, 0x04,
	0x83, 0x0e, 0x69, 0xa4, 0xfd, 0x13, 0x78, 0x41,
	0x1c, 0x2f, 0x28, 0x7e, 0xdf, 0x48, 0xc6, 0xc4,
	0xe5, 0xc2, 0x47, 0xa1, 0x96, 0x80, 0xf7, 0xfe,

	0x41, 0xce, 0xfb, 0xd4, 0x9b, 0x58, 0x21, 0x06,
	0xe3, 0x61, 0x6c, 0xbb, 0xe4, 0xdf, 0xb2, 0x34,
	0x4b, 0x2a, 0xe9, 0x51, 0x93, 0x91, 0xf3, 0xe0,
	0xfb, 0x49, 0x22, 0x25, 0x4b, 0x1d, 0x6d, 0x2d,

	0x19, 0xc6, 0xd4, 0xd5, 0x37, 0xb3, 0xa2, 0x6f,
	0x3b, 0xcc, 0x51, 0x58, 0x8b, 0x32, 0xf3, 0xec,
	0xa0, 0x82, 0x9b, 0x6a, 0x5a, 0xc7, 0x25, 0x78,
	0xfb, 0x81, 0x4f, 0xb4, 0x3c, 0xf8, 0x0d, 0x64,

	0xa2, 0x33, 0xe3, 0xf9, 0x97, 0xa3, 0xf0, 0x26,
	0x83, 0x34, 0x2f, 0x2b, 0x33, 0xd2, 0x5b, 0x49,
	0x25, 0x36, 0xb9, 0x3b, 0xec, 0xb2, 0xf5, 0xe1,
	0xa8, 0xb8, 0x2f, 0x5b, 0x88, 0x33, 0x42, 0x72,

	0x9e, 0x8a, 0xe0, 0x9d, 0x16, 0x93, 0x88, 0x41,
	0xa2, 0x1a, 0x97, 0xfb, 0x54, 0x3e, 0xea, 0x3b,
	0xbf, 0xf5, 0x9f, 0x13, 0xc1, 0xa1, 0x84, 0x49,
	0xe3, 0x98, 0x70, 0x1c, 0x1a, 0xd5, 0x16, 0x48,

	0x34, 0x6c, 0xbc, 0x04, 0xc2, 0x7b, 0xb2, 0xda,
	0x3b, 0x93, 0xa1, 0x37, 0x2c, 0xca, 0xe5, 0x48,
	0xfb, 0x53, 0xbe, 0xe4, 0x76, 0xf9, 0xe9, 0xc9,
	0x17, 0x73, 0xb1, 0xbb, 0x19, 0x82, 0x83, 0x94,

	0xd5, 0x5d, 0x3e, 0x1a, 0x20, 0xed, 0x69, 0x11,
	0x3a, 0x86, 0x0b, 0x68, 0x29, 0xff, 0xa8, 0x47,
	0x22, 0x46, 0x04, 0x43, 0x50, 0x70, 0x22, 0x1b,
	0x25, 0x7e, 0x8d, 0xff, 0x78, 0x36, 0x15, 0xd2,

	0xca, 0xe4, 0x80, 0x3a, 0x93, 0xaa, 0x43, 0x34,
	0xab, 0x48, 0x2a, 0x0a, 0xfa, 0xc9, 0xc0, 0xae,
	0xda, 0x70, 0xb4, 0x5a, 0x48, 0x1d, 0xf5, 0xde,
	0xc5, 0xdf, 0x8c, 0xc0, 0xf4, 0x23, 0xc7, 0x7a,

	0x5f, 0xd4, 0x6c, 0xd3, 0x12, 0x02, 0x1d, 0x4b,
	0x43, 0x88, 0x62, 0x41, 0x9a, 0x79, 0x1b, 0xe0,
	0x3b, 0xb4, 0xd9, 0x7c, 0x0e, 0x59, 0x57, 0x85,
	0x42, 0x53, 0x1b, 0xa4, 0x66, 0xa8, 0x3b, 0xaf,

	0x92, 0xce, 0xfc, 0x15, 0x1b, 0x5c, 0xc1, 0x61,
	0x1a, 0x16, 0x78, 0x93, 0x81, 0x9b, 0x63, 0xfb,
	0x8a, 0x6b, 0x18, 0xe8, 0x6d, 0xe6, 0x02, 0x90,
	0xfa, 0x72, 0xb7, 0x97, 0xb0, 0xce, 0x59, 0xf3,
};

/* AES-CCM test data from NIST Special Publication 800-38C */

/*
 * Example1:
 * K:     40414243 44454647 48494a4b 4c4d4e4f
 * N:     10111213 141516
 * A:     00010203 04050607
 * P:     20212223
 * B:     4f101112 13141516 00000000 00000004
 *        00080001 02030405 06070000 00000000
 *        20212223 00000000 00000000 00000000
 * T:     6084341b
 * Ctr0:  07101112 13141516 00000000 00000000
 * S0:    2d281146 10676c26 32bad748 559a679a
 * Ctr1:  07101112 13141516 00000000 00000001
 * S1:    51432378 e474b339 71318484 103cddfb
 * C:     7162015b 4dac255d
 */
static const uint8_t ae_data_aes_ccm_vect1_key[] = {
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f
};
static const uint8_t ae_data_aes_ccm_vect1_nonce[] = {
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16
};
static const uint8_t ae_data_aes_ccm_vect1_aad[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07
};
static const uint8_t ae_data_aes_ccm_vect1_ptx[] = {
	0x20, 0x21, 0x22, 0x23
};
static const uint8_t ae_data_aes_ccm_vect1_ctx[] = {
	0x71, 0x62, 0x01, 0x5b,
};
static const uint8_t ae_data_aes_ccm_vect1_tag[] = {
	0x4d, 0xac, 0x25, 0x5d
};

/*
 * Example 2:
 * K:    40414243 44454647 48494a4b 4c4d4e4f
 * N:    10111213 14151617
 * A:    00010203 04050607 08090a0b 0c0d0e0f
 * P:    20212223 24252627 28292a2b 2c2d2e2f
 * B:    56101112 13141516 17000000 00000010
 *       00100001 02030405 06070809 0a0b0c0d
 *       0e0f0000 00000000 00000000 00000000
 *       20212223 24252627 28292a2b 2c2d2e2f
 * T:    7f479ffc a464
 * Ctr0: 06101112 13141516 17000000 00000000
 * S0:   6081d043 08a97dcc 20cdcc60 bf947b78
 * Ctr1: 06101112 13141516 17000000 00000001
 * S1:   f280d2c3 75cf7945 20335db9 2b107712
 * C:    d2a1f0e0 51ea5f62 081a7792 073d593d
 *       1fc64fbf accd
 */
static const uint8_t ae_data_aes_ccm_vect2_key[] = {
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f
};
static const uint8_t ae_data_aes_ccm_vect2_nonce[] = {
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17
};
static const uint8_t ae_data_aes_ccm_vect2_aad[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f
};
static const uint8_t ae_data_aes_ccm_vect2_ptx[] = {
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f
};
static const uint8_t ae_data_aes_ccm_vect2_ctx[] = {
	0xd2, 0xa1, 0xf0, 0xe0, 0x51, 0xea, 0x5f, 0x62,
	0x08, 0x1a, 0x77, 0x92, 0x07, 0x3d, 0x59, 0x3d,
};
static const uint8_t ae_data_aes_ccm_vect2_tag[] = {
	0x1f, 0xc6, 0x4f, 0xbf, 0xac, 0xcd
};

/*
 * Example 3
 * K:    40414243 44454647 48494a4b 4c4d4e4f
 * N:    10111213 14151617 18191a1b
 * A:    00010203 04050607 08090a0b 0c0d0e0f
 *       10111213
 * P:    20212223 24252627 28292a2b 2c2d2e2f
 *       30313233 34353637
 * B:    5a101112 13141516 1718191a 1b000018
 *       00140001 02030405 06070809 0a0b0c0d
 *       0e0f1011 12130000 00000000 00000000
 *       20212223 24252627 28292a2b 2c2d2e2f
 *       30313233 34353637 00000000 00000000
 * T:    67c99240 c7d51048
 * Ctr0: 02101112 13141516 1718191a 1b000000
 * S0:   2f8a00bb 06658919 c3a040a6 eaed1a7f
 * Ctr1: 02101112 13141516 1718191a 1b000001
 * S1:   c393238a d1923c5d b335c0c7 e1bac924
 * Ctr2: 02101112 13141516 1718191a 1b000002
 * S2:   514798ea 9077bc92 6c22ebef 2ac732dc
 * C:    e3b201a9 f5b71a7a 9b1ceaec cd97e70b
 *       6176aad9 a4428aa5 484392fb c1b09951
 */
static const uint8_t ae_data_aes_ccm_vect3_key[] = {
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f
};
static const uint8_t ae_data_aes_ccm_vect3_nonce[] = {
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b
};
static const uint8_t ae_data_aes_ccm_vect3_aad[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13
};
static const uint8_t ae_data_aes_ccm_vect3_ptx[] = {
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37
};
static const uint8_t ae_data_aes_ccm_vect3_ctx[] = {
	0xe3, 0xb2, 0x01, 0xa9, 0xf5, 0xb7, 0x1a, 0x7a,
	0x9b, 0x1c, 0xea, 0xec, 0xcd, 0x97, 0xe7, 0x0b,
	0x61, 0x76, 0xaa, 0xd9, 0xa4, 0x42, 0x8a, 0xa5,
};
static const uint8_t ae_data_aes_ccm_vect3_tag[] = {
	0x48, 0x43, 0x92, 0xfb, 0xc1, 0xb0, 0x99, 0x51
};

/*
 * AES-GCM vectors from the reviced "The Galois/Counter Mode of Operation
 * (GCM)" 2005-05-31 spec
 */

/*
 * Test case 1
 *              K 00000000000000000000000000000000
 *              P
 *             IV 000000000000000000000000
 *              H 66e94bd4ef8a2c3b884cfa59ca342b2e
 *             Y0 00000000000000000000000000000001
 *       E(K, Y0) 58e2fccefa7e3061367f1d57a4e7455a
 * len(A)||len(C) 00000000000000000000000000000000
 *  GHASH(H, A, C) 00000000000000000000000000000000
 *              C
 *              T 58e2fccefa7e3061367f1d57a4e7455a
 */
static const uint8_t ae_data_aes_gcm_vect1_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ae_data_aes_gcm_vect1_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};
#define ae_data_aes_gcm_vect1_aad NULL
#define ae_data_aes_gcm_vect1_ptx NULL
#define ae_data_aes_gcm_vect1_ctx NULL
static const uint8_t ae_data_aes_gcm_vect1_tag[] = {
	0x58, 0xe2, 0xfc, 0xce, 0xfa, 0x7e, 0x30, 0x61,
	0x36, 0x7f, 0x1d, 0x57, 0xa4, 0xe7, 0x45, 0x5a
};

/*
 * Test case 2
 *              K 00000000000000000000000000000000
 *              P 00000000000000000000000000000000
 *             IV 000000000000000000000000
 *              H 66e94bd4ef8a2c3b884cfa59ca342b2e
 *             Y0 00000000000000000000000000000001
 *       E(K, Y0) 58e2fccefa7e3061367f1d57a4e7455a
 *             Y1 00000000000000000000000000000002
 *       E(K, Y1) 0388dace60b6a392f328c2b971b2fe78
 *             X1 5e2ec746917062882c85b0685353deb7
 * len(A)||len(C) 00000000000000000000000000000080
 *  GHASH(H, A, C) f38cbb1ad69223dcc3457ae5b6b0f885
 *              C 0388dace60b6a392f328c2b971b2fe78
 *              T ab6e47d42cec13bdf53a67b21257bddf
 */

static const uint8_t ae_data_aes_gcm_vect2_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ae_data_aes_gcm_vect2_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};
#define ae_data_aes_gcm_vect2_aad NULL
static const uint8_t ae_data_aes_gcm_vect2_ptx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t ae_data_aes_gcm_vect2_ctx[] = {
	0x03, 0x88, 0xda, 0xce, 0x60, 0xb6, 0xa3, 0x92,
	0xf3, 0x28, 0xc2, 0xb9, 0x71, 0xb2, 0xfe, 0x78
};
static const uint8_t ae_data_aes_gcm_vect2_tag[] = {
	0xab, 0x6e, 0x47, 0xd4, 0x2c, 0xec, 0x13, 0xbd,
	0xf5, 0x3a, 0x67, 0xb2, 0x12, 0x57, 0xbd, 0xdf
};

/*
 * Test case 3
 *              K feffe9928665731c6d6a8f9467308308
 *              P d9313225f88406e5a55909c5aff5269a
 *                86a7a9531534f7da2e4c303d8a318a72
 *                1c3c0c95956809532fcf0e2449a6b525
 *                b16aedf5aa0de657ba637b391aafd255
 *             IV cafebabefacedbaddecaf888
 *              H b83b533708bf535d0aa6e52980d53b78
 *             Y0 cafebabefacedbaddecaf88800000001
 *       E(K, Y0) 3247184b3c4f69a44dbcd22887bbb418
 *             Y1 cafebabefacedbaddecaf88800000002
 *       E(K, Y1) 9bb22ce7d9f372c1ee2b28722b25f206
 *             Y2 cafebabefacedbaddecaf88800000003
 *       E(K, Y2) 650d887c3936533a1b8d4e1ea39d2b5c
 *             Y3 cafebabefacedbaddecaf88800000004
 *       E(K, Y3) 3de91827c10e9a4f5240647ee5221f20
 *             Y4 cafebabefacedbaddecaf88800000005
 *       E(K, Y4) aac9e6ccc0074ac0873b9ba85d908bd0
 *             X1 59ed3f2bb1a0aaa07c9f56c6a504647b
 *             X2 b714c9048389afd9f9bc5c1d4378e052
 *             X3 47400c6577b1ee8d8f40b2721e86ff10
 *             X4 4796cf49464704b5dd91f159bb1b7f95
 * len(A)||len(C) 00000000000000000000000000000200
 *  GHASH(H, A, C) 7f1b32b81b820d02614f8895ac1d4eac
 *              C 42831ec2217774244b7221b784d0d49c
 *                e3aa212f2c02a4e035c17e2329aca12e
 *                21d514b25466931c7d8f6a5aac84aa05
 *                1ba30b396a0aac973d58e091473f5985
 *              T 4d5c2af327cd64a62cf35abd2ba6fab4
 */

static const uint8_t ae_data_aes_gcm_vect3_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08
};
static const uint8_t ae_data_aes_gcm_vect3_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88
};
#define ae_data_aes_gcm_vect3_aad NULL
static const uint8_t ae_data_aes_gcm_vect3_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55
};
static const uint8_t ae_data_aes_gcm_vect3_ctx[] = {
	0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,
	0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,
	0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,
	0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,
	0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,
	0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,
	0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,
	0x3d, 0x58, 0xe0, 0x91, 0x47, 0x3f, 0x59, 0x85
};
static const uint8_t ae_data_aes_gcm_vect3_tag[] = {
	0x4d, 0x5c, 0x2a, 0xf3, 0x27, 0xcd, 0x64, 0xa6,
	0x2c, 0xf3, 0x5a, 0xbd, 0x2b, 0xa6, 0xfa, 0xb4
};

/*
 * Test case 4
 *              K feffe9928665731c6d6a8f9467308308
 *              P d9313225f88406e5a55909c5aff5269a
 *                86a7a9531534f7da2e4c303d8a318a72
 *                1c3c0c95956809532fcf0e2449a6b525
 *                b16aedf5aa0de657ba637b39
 *              A feedfacedeadbeeffeedfacedeadbeef
 *                abaddad2
 *             IV cafebabefacedbaddecaf888
 *              H b83b533708bf535d0aa6e52980d53b78
 *             Y0 cafebabefacedbaddecaf88800000001
 *       E(K, Y0) 3247184b3c4f69a44dbcd22887bbb418
 *             X1 ed56aaf8a72d67049fdb9228edba1322
 *             X2 cd47221ccef0554ee4bb044c88150352
 *             Y1 cafebabefacedbaddecaf88800000002
 *       E(K, Y1) 9bb22ce7d9f372c1ee2b28722b25f206
 *             Y2 cafebabefacedbaddecaf88800000003
 *       E(K, Y2) 650d887c3936533a1b8d4e1ea39d2b5c
 *             Y3 cafebabefacedbaddecaf88800000004
 *       E(K, Y3) 3de91827c10e9a4f5240647ee5221f20
 *             Y4 cafebabefacedbaddecaf88800000005
 *       E(K, Y4) aac9e6ccc0074ac0873b9ba85d908bd0
 *             X3 54f5e1b2b5a8f9525c23924751a3ca51
 *             X4 324f585c6ffc1359ab371565d6c45f93
 *             X5 ca7dd446af4aa70cc3c0cd5abba6aa1c
 *             X6 1590df9b2eb6768289e57d56274c8570
 * len(A)||len(C) 00000000000000a000000000000001e0
 *  GHASH(H, A, C) 698e57f70e6ecc7fd9463b7260a9ae5f
 *              C 42831ec2217774244b7221b784d0d49c
 *                e3aa212f2c02a4e035c17e2329aca12e
 *                21d514b25466931c7d8f6a5aac84aa05
 *                1ba30b396a0aac973d58e091
 *              T 5bc94fbc3221a5db94fae95ae7121a47
 */

static const uint8_t ae_data_aes_gcm_vect4_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08
};
static const uint8_t ae_data_aes_gcm_vect4_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88
};
static const uint8_t ae_data_aes_gcm_vect4_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2
};
static const uint8_t ae_data_aes_gcm_vect4_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39
};
static const uint8_t ae_data_aes_gcm_vect4_ctx[] = {
	0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,
	0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,
	0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,
	0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,
	0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,
	0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,
	0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,
	0x3d, 0x58, 0xe0, 0x91
};
static const uint8_t ae_data_aes_gcm_vect4_tag[] = {
	0x5b, 0xc9, 0x4f, 0xbc, 0x32, 0x21, 0xa5, 0xdb,
	0x94, 0xfa, 0xe9, 0x5a, 0xe7, 0x12, 0x1a, 0x47
};

/*
 * Test case 5
 *                 K feffe9928665731c6d6a8f9467308308
 *                 P d9313225f88406e5a55909c5aff5269a
 *                   86a7a9531534f7da2e4c303d8a318a72
 *                   1c3c0c95956809532fcf0e2449a6b525
 *                   b16aedf5aa0de657ba637b39
 *                 A feedfacedeadbeeffeedfacedeadbeef
 *                   abaddad2
 *                IV cafebabefacedbad
 *                 H b83b533708bf535d0aa6e52980d53b78
 *                N1 6f288b846e5fed9a18376829c86a6a16
 * len({})||len(IV ) 00000000000000000000000000000040
 *                Y0 c43a83c4c4badec4354ca984db252f7d
 *          E(K, Y0) e94ab9535c72bea9e089c93d48e62fb0
 *                X1 ed56aaf8a72d67049fdb9228edba1322
 *                X2 cd47221ccef0554ee4bb044c88150352
 *                Y1 c43a83c4c4badec4354ca984db252f7e
 *          E(K, Y1) b8040969d08295afd226fcda0ddf61cf
 *                Y2 c43a83c4c4badec4354ca984db252f7f
 *          E(K, Y2) ef3c83225af93122192ad5c4f15dfe51
 *                Y3 c43a83c4c4badec4354ca984db252f80
 *          E(K, Y3) 6fbc659571f72de104c67b609d2fde67
 *                Y4 c43a83c4c4badec4354ca984db252f81
 *          E(K, Y4) f8e3581441a1e950785c3ea1430c6fa6
 *                X3 9379e2feae14649c86cf2250e3a81916
 *                X4 65dde904c92a6b3db877c4817b50a5f4
 *                X5 48c53cf863b49a1b0bbfc48c3baaa89d
 *                X6 08c873f1c8cec3effc209a07468caab1
 *    len(A)||len(C) 00000000000000a000000000000001e0
 *     GHASH(H, A, C) df586bb4c249b92cb6922877e444d37b
 *                 C 61353b4c2806934a777ff51fa22a4755
 *                   699b2a714fcdc6f83766e5f97b6c7423
 *                   73806900e49f24b22b097544d4896b42
 *                   4989b5e1ebac0f07c23f4598
 *    T              3612d2e79e3b0785561be14aaca2fccb
 */

static const uint8_t ae_data_aes_gcm_vect5_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08
};
static const uint8_t ae_data_aes_gcm_vect5_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad
};
static const uint8_t ae_data_aes_gcm_vect5_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2
};
static const uint8_t ae_data_aes_gcm_vect5_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39
};
static const uint8_t ae_data_aes_gcm_vect5_ctx[] = {
	0x61, 0x35, 0x3b, 0x4c, 0x28, 0x06, 0x93, 0x4a,
	0x77, 0x7f, 0xf5, 0x1f, 0xa2, 0x2a, 0x47, 0x55,
	0x69, 0x9b, 0x2a, 0x71, 0x4f, 0xcd, 0xc6, 0xf8,
	0x37, 0x66, 0xe5, 0xf9, 0x7b, 0x6c, 0x74, 0x23,
	0x73, 0x80, 0x69, 0x00, 0xe4, 0x9f, 0x24, 0xb2,
	0x2b, 0x09, 0x75, 0x44, 0xd4, 0x89, 0x6b, 0x42,
	0x49, 0x89, 0xb5, 0xe1, 0xeb, 0xac, 0x0f, 0x07,
	0xc2, 0x3f, 0x45, 0x98
};
static const uint8_t ae_data_aes_gcm_vect5_tag[] = {
	0x36, 0x12, 0xd2, 0xe7, 0x9e, 0x3b, 0x07, 0x85,
	0x56, 0x1b, 0xe1, 0x4a, 0xac, 0xa2, 0xfc, 0xcb
};

/*
 * Test case 6
 *                 K feffe9928665731c6d6a8f9467308308
 *                 P d9313225f88406e5a55909c5aff5269a
 *                   86a7a9531534f7da2e4c303d8a318a72
 *                   1c3c0c95956809532fcf0e2449a6b525
 *                   b16aedf5aa0de657ba637b39
 *                 A feedfacedeadbeeffeedfacedeadbeef
 *                   abaddad2
 *                IV 9313225df88406e555909c5aff5269aa
 *                   6a7a9538534f7da1e4c303d2a318a728
 *                   c3c0c95156809539fcf0e2429a6b5254
 *                   16aedbf5a0de6a57a637b39b
 *                 H b83b533708bf535d0aa6e52980d53b78
 *                N1 004d6599d7fb1634756e1e299d81630f
 *                N2 88ffe8a3c8033df4b54d732f7f88408e
 *                N3 24e694cfab657beabba8055aad495e23
 *                N4 d8349a5eda24943c8fbb2ef5168b20cb
 * len({})||len(IV ) 000000000000000000000000000001e0
 *                Y0 3bab75780a31c059f83d2a44752f9864
 *          E(K, Y0) 7dc63b399f2d98d57ab073b6baa4138e
 *                X1 ed56aaf8a72d67049fdb9228edba1322
 *                X2 cd47221ccef0554ee4bb044c88150352
 *                Y1 3bab75780a31c059f83d2a44752f9865
 *          E(K, Y1) 55d37bbd9ad21353a6f93a690eca9e0e
 *                Y2 3bab75780a31c059f83d2a44752f9866
 *          E(K, Y2) 3836bbf6d696e672946a1a01404fa6d5
 *                Y3 3bab75780a31c059f83d2a44752f9867
 *          E(K, Y3) 1dd8a5316ecc35c3e313bca59d2ac94a
 *                Y4 3bab75780a31c059f83d2a44752f9868
 *          E(K, Y4) 6742982706a9f154f657d5dc94b746db
 *                X3 31727669c63c6f078b5d22adbbbca384
 *                X4 480c00db2679065a7ed2f771a53acacd
 *                X5 1c1ae3c355e2214466a9923d2ba6ab35
 *                X6 0694c6f16bb0275a48891d06590344b0
 *    len(A)||len(C) 00000000000000a000000000000001e0
 *     GHASH(H, A, C) 1c5afe9760d3932f3c9a878aac3dc3de
 *                 C 8ce24998625615b603a033aca13fb894
 *                   be9112a5c3a211a8ba262a3cca7e2ca7
 *                   01e4a9a4fba43c90ccdcb281d48c7c6f
 *                   d62875d2aca417034c34aee5
 *                 T 619cc5aefffe0bfa462af43c1699d050
 */

static const uint8_t ae_data_aes_gcm_vect6_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t ae_data_aes_gcm_vect6_nonce[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};
static const uint8_t ae_data_aes_gcm_vect6_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect6_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect6_ctx[] = {
	0x8c, 0xe2, 0x49, 0x98, 0x62, 0x56, 0x15, 0xb6,
	0x03, 0xa0, 0x33, 0xac, 0xa1, 0x3f, 0xb8, 0x94,
	0xbe, 0x91, 0x12, 0xa5, 0xc3, 0xa2, 0x11, 0xa8,
	0xba, 0x26, 0x2a, 0x3c, 0xca, 0x7e, 0x2c, 0xa7,
	0x01, 0xe4, 0xa9, 0xa4, 0xfb, 0xa4, 0x3c, 0x90,
	0xcc, 0xdc, 0xb2, 0x81, 0xd4, 0x8c, 0x7c, 0x6f,
	0xd6, 0x28, 0x75, 0xd2, 0xac, 0xa4, 0x17, 0x03,
	0x4c, 0x34, 0xae, 0xe5,
};
static const uint8_t ae_data_aes_gcm_vect6_tag[] = {
	0x61, 0x9c, 0xc5, 0xae, 0xff, 0xfe, 0x0b, 0xfa,
	0x46, 0x2a, 0xf4, 0x3c, 0x16, 0x99, 0xd0, 0x50,
};

/*
 * Test case 7
 *              K 00000000000000000000000000000000
 *                0000000000000000
 *              P
 *             IV 000000000000000000000000
 *              H aae06992acbf52a3e8f4a96ec9300bd7
 *             Y0 00000000000000000000000000000001
 *       E(K, Y0) cd33b28ac773f74ba00ed1f312572435
 * len(A)||len(C) 00000000000000000000000000000000
 *  GHASH(H, A, C) 00000000000000000000000000000000
 *              C
 *              T cd33b28ac773f74ba00ed1f312572435
 */

static const uint8_t ae_data_aes_gcm_vect7_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect7_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};
#define ae_data_aes_gcm_vect7_aad NULL
#define ae_data_aes_gcm_vect7_ptx NULL
#define ae_data_aes_gcm_vect7_ctx NULL
static const uint8_t ae_data_aes_gcm_vect7_tag[] = {
	0xcd, 0x33, 0xb2, 0x8a, 0xc7, 0x73, 0xf7, 0x4b,
	0xa0, 0x0e, 0xd1, 0xf3, 0x12, 0x57, 0x24, 0x35,
};

/*
 * Test case 8
 *              K 00000000000000000000000000000000
 *                0000000000000000
 *              P 00000000000000000000000000000000
 *             IV 000000000000000000000000
 *              H aae06992acbf52a3e8f4a96ec9300bd7
 *             Y0 00000000000000000000000000000001
 *       E(K, Y0) cd33b28ac773f74ba00ed1f312572435
 *             Y1 00000000000000000000000000000002
 *       E(K, Y1) 98e7247c07f0fe411c267e4384b0f600
 *             X1 90e87315fb7d4e1b4092ec0cbfda5d7d
 * len(A)||len(C) 00000000000000000000000000000080
 *  GHASH(H, A, C) e2c63f0ac44ad0e02efa05ab6743d4ce
 *              C 98e7247c07f0fe411c267e4384b0f600
 *              T 2ff58d80033927ab8ef4d4587514f0fb
 */

static const uint8_t ae_data_aes_gcm_vect8_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect8_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};
#define ae_data_aes_gcm_vect8_aad NULL
static const uint8_t ae_data_aes_gcm_vect8_ptx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect8_ctx[] = {
	0x98, 0xe7, 0x24, 0x7c, 0x07, 0xf0, 0xfe, 0x41,
	0x1c, 0x26, 0x7e, 0x43, 0x84, 0xb0, 0xf6, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect8_tag[] = {
	0x2f, 0xf5, 0x8d, 0x80, 0x03, 0x39, 0x27, 0xab,
	0x8e, 0xf4, 0xd4, 0x58, 0x75, 0x14, 0xf0, 0xfb,
};

/* Test case 9 */
static const uint8_t ae_data_aes_gcm_vect9_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};
static const uint8_t ae_data_aes_gcm_vect9_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};
#define ae_data_aes_gcm_vect9_aad NULL
static const uint8_t ae_data_aes_gcm_vect9_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55,
};
static const uint8_t ae_data_aes_gcm_vect9_ctx[] = {
	0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,
	0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,
	0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,
	0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,
	0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,
	0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,
	0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,
	0xcc, 0xda, 0x27, 0x10, 0xac, 0xad, 0xe2, 0x56,
};
static const uint8_t ae_data_aes_gcm_vect9_tag[] = {
	0x99, 0x24, 0xa7, 0xc8, 0x58, 0x73, 0x36, 0xbf,
	0xb1, 0x18, 0x02, 0x4d, 0xb8, 0x67, 0x4a, 0x14,
};

/* Test case 10 */
static const uint8_t ae_data_aes_gcm_vect10_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};
static const uint8_t ae_data_aes_gcm_vect10_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};
static const uint8_t ae_data_aes_gcm_vect10_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect10_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect10_ctx[] = {
	0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,
	0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,
	0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,
	0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,
	0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,
	0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,
	0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,
	0xcc, 0xda, 0x27, 0x10,
};
static const uint8_t ae_data_aes_gcm_vect10_tag[] = {
	0x25, 0x19, 0x49, 0x8e, 0x80, 0xf1, 0x47, 0x8f,
	0x37, 0xba, 0x55, 0xbd, 0x6d, 0x27, 0x61, 0x8c,
};

/* Test case 11 */
static const uint8_t ae_data_aes_gcm_vect11_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};
static const uint8_t ae_data_aes_gcm_vect11_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
};
static const uint8_t ae_data_aes_gcm_vect11_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect11_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect11_ctx[] = {
	0x0f, 0x10, 0xf5, 0x99, 0xae, 0x14, 0xa1, 0x54,
	0xed, 0x24, 0xb3, 0x6e, 0x25, 0x32, 0x4d, 0xb8,
	0xc5, 0x66, 0x63, 0x2e, 0xf2, 0xbb, 0xb3, 0x4f,
	0x83, 0x47, 0x28, 0x0f, 0xc4, 0x50, 0x70, 0x57,
	0xfd, 0xdc, 0x29, 0xdf, 0x9a, 0x47, 0x1f, 0x75,
	0xc6, 0x65, 0x41, 0xd4, 0xd4, 0xda, 0xd1, 0xc9,
	0xe9, 0x3a, 0x19, 0xa5, 0x8e, 0x8b, 0x47, 0x3f,
	0xa0, 0xf0, 0x62, 0xf7,
};
static const uint8_t ae_data_aes_gcm_vect11_tag[] = {
	0x65, 0xdc, 0xc5, 0x7f, 0xcf, 0x62, 0x3a, 0x24,
	0x09, 0x4f, 0xcc, 0xa4, 0x0d, 0x35, 0x33, 0xf8,
};

/* Test case 12 */
static const uint8_t ae_data_aes_gcm_vect12_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
};
static const uint8_t ae_data_aes_gcm_vect12_nonce[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};
static const uint8_t ae_data_aes_gcm_vect12_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect12_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect12_ctx[] = {
	0xd2, 0x7e, 0x88, 0x68, 0x1c, 0xe3, 0x24, 0x3c,
	0x48, 0x30, 0x16, 0x5a, 0x8f, 0xdc, 0xf9, 0xff,
	0x1d, 0xe9, 0xa1, 0xd8, 0xe6, 0xb4, 0x47, 0xef,
	0x6e, 0xf7, 0xb7, 0x98, 0x28, 0x66, 0x6e, 0x45,
	0x81, 0xe7, 0x90, 0x12, 0xaf, 0x34, 0xdd, 0xd9,
	0xe2, 0xf0, 0x37, 0x58, 0x9b, 0x29, 0x2d, 0xb3,
	0xe6, 0x7c, 0x03, 0x67, 0x45, 0xfa, 0x22, 0xe7,
	0xe9, 0xb7, 0x37, 0x3b,
};
static const uint8_t ae_data_aes_gcm_vect12_tag[] = {
	0xdc, 0xf5, 0x66, 0xff, 0x29, 0x1c, 0x25, 0xbb,
	0xb8, 0x56, 0x8f, 0xc3, 0xd3, 0x76, 0xa6, 0xd9,
};

/* Test case 13 */
static const uint8_t ae_data_aes_gcm_vect13_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect13_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};
#define ae_data_aes_gcm_vect13_aad NULL
#define ae_data_aes_gcm_vect13_ptx NULL
#define ae_data_aes_gcm_vect13_ctx NULL
static const uint8_t ae_data_aes_gcm_vect13_tag[] = {
	0x53, 0x0f, 0x8a, 0xfb, 0xc7, 0x45, 0x36, 0xb9,
	0xa9, 0x63, 0xb4, 0xf1, 0xc4, 0xcb, 0x73, 0x8b,
};

/* Test case 14 */
static const uint8_t ae_data_aes_gcm_vect14_key[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect14_nonce[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
};
#define ae_data_aes_gcm_vect14_aad NULL
static const uint8_t ae_data_aes_gcm_vect14_ptx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t ae_data_aes_gcm_vect14_ctx[] = {
	0xce, 0xa7, 0x40, 0x3d, 0x4d, 0x60, 0x6b, 0x6e,
	0x07, 0x4e, 0xc5, 0xd3, 0xba, 0xf3, 0x9d, 0x18,
};
static const uint8_t ae_data_aes_gcm_vect14_tag[] = {
	0xd0, 0xd1, 0xc8, 0xa7, 0x99, 0x99, 0x6b, 0xf0,
	0x26, 0x5b, 0x98, 0xb5, 0xd4, 0x8a, 0xb9, 0x19,
};

/* Test case 15 */
static const uint8_t ae_data_aes_gcm_vect15_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t ae_data_aes_gcm_vect15_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};
#define ae_data_aes_gcm_vect15_aad NULL
static const uint8_t ae_data_aes_gcm_vect15_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55,
};
static const uint8_t ae_data_aes_gcm_vect15_ctx[] = {
	0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,
	0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,
	0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,
	0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,
	0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,
	0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,
	0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,
	0xbc, 0xc9, 0xf6, 0x62, 0x89, 0x80, 0x15, 0xad,
};
static const uint8_t ae_data_aes_gcm_vect15_tag[] = {
	0xb0, 0x94, 0xda, 0xc5, 0xd9, 0x34, 0x71, 0xbd,
	0xec, 0x1a, 0x50, 0x22, 0x70, 0xe3, 0xcc, 0x6c,
};

/* Test case 16 */
static const uint8_t ae_data_aes_gcm_vect16_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t ae_data_aes_gcm_vect16_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
	0xde, 0xca, 0xf8, 0x88,
};
static const uint8_t ae_data_aes_gcm_vect16_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect16_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect16_ctx[] = {
	0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,
	0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,
	0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,
	0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,
	0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,
	0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,
	0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,
	0xbc, 0xc9, 0xf6, 0x62,
};
static const uint8_t ae_data_aes_gcm_vect16_tag[] = {
	0x76, 0xfc, 0x6e, 0xce, 0x0f, 0x4e, 0x17, 0x68,
	0xcd, 0xdf, 0x88, 0x53, 0xbb, 0x2d, 0x55, 0x1b,
};

/* Test case 17 */
static const uint8_t ae_data_aes_gcm_vect17_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t ae_data_aes_gcm_vect17_nonce[] = {
	0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,
};
static const uint8_t ae_data_aes_gcm_vect17_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect17_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect17_ctx[] = {
	0xc3, 0x76, 0x2d, 0xf1, 0xca, 0x78, 0x7d, 0x32,
	0xae, 0x47, 0xc1, 0x3b, 0xf1, 0x98, 0x44, 0xcb,
	0xaf, 0x1a, 0xe1, 0x4d, 0x0b, 0x97, 0x6a, 0xfa,
	0xc5, 0x2f, 0xf7, 0xd7, 0x9b, 0xba, 0x9d, 0xe0,
	0xfe, 0xb5, 0x82, 0xd3, 0x39, 0x34, 0xa4, 0xf0,
	0x95, 0x4c, 0xc2, 0x36, 0x3b, 0xc7, 0x3f, 0x78,
	0x62, 0xac, 0x43, 0x0e, 0x64, 0xab, 0xe4, 0x99,
	0xf4, 0x7c, 0x9b, 0x1f,
};
static const uint8_t ae_data_aes_gcm_vect17_tag[] = {
	0x3a, 0x33, 0x7d, 0xbf, 0x46, 0xa7, 0x92, 0xc4,
	0x5e, 0x45, 0x49, 0x13, 0xfe, 0x2e, 0xa8, 0xf2,
};

/* Test case 18 */
static const uint8_t ae_data_aes_gcm_vect18_key[] = {
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
	0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
	0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t ae_data_aes_gcm_vect18_nonce[] = {
	0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,
	0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,
	0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,
	0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,
	0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,
	0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,
	0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,
	0xa6, 0x37, 0xb3, 0x9b,
};
static const uint8_t ae_data_aes_gcm_vect18_aad[] = {
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,
	0xab, 0xad, 0xda, 0xd2,
};
static const uint8_t ae_data_aes_gcm_vect18_ptx[] = {
	0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,
	0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,
	0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,
	0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,
	0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,
	0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,
	0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,
	0xba, 0x63, 0x7b, 0x39,
};
static const uint8_t ae_data_aes_gcm_vect18_ctx[] = {
	0x5a, 0x8d, 0xef, 0x2f, 0x0c, 0x9e, 0x53, 0xf1,
	0xf7, 0x5d, 0x78, 0x53, 0x65, 0x9e, 0x2a, 0x20,
	0xee, 0xb2, 0xb2, 0x2a, 0xaf, 0xde, 0x64, 0x19,
	0xa0, 0x58, 0xab, 0x4f, 0x6f, 0x74, 0x6b, 0xf4,
	0x0f, 0xc0, 0xc3, 0xb7, 0x80, 0xf2, 0x44, 0x45,
	0x2d, 0xa3, 0xeb, 0xf1, 0xc5, 0xd8, 0x2c, 0xde,
	0xa2, 0x41, 0x89, 0x97, 0x20, 0x0e, 0xf8, 0x2e,
	0x44, 0xae, 0x7e, 0x3f,
};
static const uint8_t ae_data_aes_gcm_vect18_tag[] = {
	0xa4, 0x4a, 0x82, 0x66, 0xee, 0x1c, 0x8e, 0xb0,
	0xc8, 0xb5, 0xd4, 0xcf, 0x5a, 0xe9, 0xf1, 0x9a,
};

/*
 * Test data generated with
 * http://www.mobilefish.com/services/rsa_key_generation/rsa_key_generation.php
 * selecting 1024 bit key
 */
static const uint8_t ac_rsassa_vect1_modulus[] = {
	0xab, 0x42, 0x30, 0x54, 0x02, 0x15, 0x19, 0x4f, 0x03, 0x15, 0x73, 0xdf,
	0x96, 0x4c, 0x23, 0xeb, 0xd3, 0xd5, 0xf2, 0xff, 0x17, 0xf4, 0x1f, 0x5c,
	0x41, 0x26, 0x3e, 0x20, 0x15, 0x6d, 0x0a, 0x70, 0x8d, 0x9e, 0x9e, 0x67,
	0x47, 0x87, 0x6a, 0x15, 0xb5, 0x40, 0x38, 0x99, 0x64, 0x90, 0xc1, 0x32,
	0x32, 0x95, 0xc7, 0x63, 0x0a, 0xac, 0x5b, 0xcc, 0x21, 0x6b, 0x51, 0x7b,
	0xa5, 0xef, 0x7b, 0x62, 0x12, 0x34, 0x2d, 0x8d, 0xb6, 0x0d, 0x24, 0x92,
	0xa4, 0x83, 0xd4, 0x3b, 0xa5, 0x29, 0xe2, 0x94, 0xfc, 0xcd, 0x5e, 0xcb,
	0xc6, 0x52, 0x7b, 0xf7, 0x65, 0x80, 0x1f, 0x63, 0xcb, 0x4f, 0x40, 0x27,
	0x5b, 0x2d, 0x2a, 0x9f, 0xce, 0x9b, 0x33, 0x97, 0xeb, 0xbe, 0xcb, 0x34,
	0x22, 0xff, 0x5f, 0x21, 0x21, 0xba, 0x75, 0xb3, 0xba, 0x8f, 0x00, 0x9e,
	0x08, 0x66, 0x86, 0x4a, 0x8e, 0x40, 0xb2, 0x5f
};
static const uint8_t ac_rsassa_vect1_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_vect1_priv_exp[] = {
	0x91, 0xaa, 0x4f, 0xae, 0xf4, 0xc2, 0x7b, 0x6f, 0x60, 0x21, 0x1c, 0x18,
	0xde, 0x1e, 0xcf, 0x22, 0xe4, 0x60, 0x83, 0x3a, 0x04, 0x66, 0xc9, 0x51,
	0xcf, 0xbc, 0x36, 0x75, 0x55, 0xa4, 0x14, 0x90, 0x1d, 0x75, 0x00, 0x28,
	0xba, 0x87, 0x6c, 0x6d, 0x20, 0x68, 0x8a, 0x7b, 0xb6, 0x35, 0x05, 0x8e,
	0xab, 0xc6, 0x07, 0xfc, 0xae, 0xf4, 0x61, 0x74, 0x24, 0x2c, 0xc2, 0xf6,
	0xd7, 0xf1, 0xf5, 0x4f, 0xd3, 0x68, 0x86, 0x9b, 0x40, 0x47, 0x74, 0x51,
	0x2a, 0xe3, 0x87, 0xe3, 0x6f, 0x8c, 0x2e, 0x71, 0xb9, 0xe1, 0x49, 0x62,
	0x8b, 0x1f, 0x00, 0x92, 0x51, 0x82, 0x5b, 0x56, 0xeb, 0x55, 0x4e, 0x17,
	0x67, 0x91, 0x74, 0xc3, 0x01, 0xdc, 0x34, 0xda, 0x56, 0x03, 0x3c, 0x5d,
	0x50, 0xb5, 0xa5, 0xf5, 0xd0, 0xe1, 0x84, 0x7f, 0x2c, 0x16, 0x86, 0x34,
	0x1d, 0xb1, 0x8f, 0xd9, 0xb4, 0x0b, 0x35, 0x79
};
static const uint8_t ac_rsassa_vect1_prime1[] = {
	0xec, 0xbb, 0x19, 0x15, 0xc6, 0x52, 0xee, 0xf2, 0x75, 0x0b, 0x2f, 0x4f,
	0x1b, 0x2e, 0xd5, 0x14, 0x13, 0x26, 0xb4, 0xb4, 0x8d, 0x1d, 0xbd, 0x27,
	0xbb, 0x38, 0xba, 0x2f, 0xa7, 0xc7, 0xb6, 0x76, 0x88, 0xad, 0x73, 0x24,
	0x56, 0xe4, 0xd6, 0x9e, 0xe1, 0x20, 0x50, 0x4e, 0x90, 0x09, 0xb1, 0xf7,
	0x58, 0x1f, 0x47, 0x82, 0x88, 0xe7, 0xd8, 0xab, 0x3c, 0x1c, 0x9d, 0xc1,
	0xa7, 0x79, 0x5c, 0x65
};
static const uint8_t ac_rsassa_vect1_prime2[] = {
	0xb9, 0x32, 0xce, 0x2d, 0x38, 0xb4, 0x21, 0x7f, 0x9e, 0x79, 0x36, 0xf8,
	0x6a, 0xf4, 0x99, 0xae, 0x57, 0x1b, 0xd6, 0x1c, 0x53, 0xf7, 0xf9, 0x61,
	0xed, 0x47, 0xca, 0x7d, 0x76, 0xd7, 0x4e, 0xc6, 0x59, 0x51, 0x2d, 0xea,
	0x91, 0x0f, 0xdf, 0x56, 0x77, 0xa9, 0x2e, 0xf7, 0x63, 0x57, 0x14, 0x93,
	0x3b, 0x6f, 0x39, 0x4d, 0x88, 0x18, 0x2f, 0x78, 0xfc, 0xa3, 0xdb, 0xf6,
	0xc0, 0x05, 0xdd, 0x73
};
static const uint8_t ac_rsassa_vect1_exp1[] = {
	0xaa, 0xa7, 0x45, 0xb2, 0x18, 0xc1, 0xf8, 0x56, 0xf8, 0x61, 0x13, 0xbd,
	0xa7, 0x0e, 0xdf, 0xb4, 0x15, 0x0a, 0x36, 0x02, 0x62, 0x28, 0x2a, 0x0f,
	0xd6, 0x3b, 0x52, 0x9c, 0xc0, 0x0a, 0x8c, 0x52, 0x6e, 0xbc, 0xfa, 0xe0,
	0x1b, 0x73, 0xe3, 0xf3, 0xac, 0xbe, 0xaa, 0xa5, 0xb7, 0xd8, 0x05, 0x5f,
	0x15, 0x3b, 0x97, 0x45, 0x56, 0x84, 0x2c, 0x01, 0x64, 0xd8, 0x0c, 0x31,
	0x6a, 0x15, 0x66, 0xb1
};
static const uint8_t ac_rsassa_vect1_exp2[] = {
	0x82, 0xec, 0x11, 0xa9, 0x12, 0x5e, 0xf5, 0x17, 0x7c, 0xf6, 0x80, 0x0f,
	0xd9, 0xbc, 0x95, 0x30, 0x14, 0x50, 0x8f, 0x6a, 0x73, 0x49, 0xe8, 0x38,
	0x7c, 0x3f, 0xb6, 0x3c, 0x3f, 0xd9, 0x31, 0xcd, 0x32, 0xb3, 0x1a, 0xdc,
	0xaa, 0x34, 0x28, 0x54, 0xbe, 0x3f, 0x11, 0xfe, 0xbd, 0x71, 0x80, 0x10,
	0x1d, 0x82, 0x21, 0x66, 0x58, 0x01, 0x90, 0xfd, 0xdc, 0xcc, 0x11, 0xe2,
	0x3c, 0x19, 0x69, 0x55
};
static const uint8_t ac_rsassa_vect1_coeff[] = {
	0x2b, 0x9b, 0x48, 0xc0, 0xe1, 0xcb, 0x28, 0x9c, 0x03, 0xb2, 0xcf, 0xc6,
	0xf6, 0xbb, 0xbe, 0x1b, 0xad, 0xe6, 0x3b, 0xd3, 0x65, 0xbb, 0xca, 0xb7,
	0x43, 0x17, 0x8e, 0x3d, 0xb1, 0x6d, 0xc3, 0x06, 0xad, 0x7d, 0xe8, 0x81,
	0xb9, 0x5a, 0x13, 0xad, 0x18, 0x46, 0xcd, 0x93, 0xb6, 0x44, 0x1f, 0xd0,
	0x4d, 0x73, 0xb1, 0x00, 0x4d, 0x46, 0xc8, 0x22, 0x4a, 0x7e, 0xb8, 0xe6,
	0xdd, 0xae, 0x5f, 0x40
};
static const uint8_t ac_rsassa_vect1_ptx[] = {
	0x91, 0x07, 0xf4, 0x49, 0x0a, 0xf9, 0x99, 0x12, 0xaa, 0x95, 0x02, 0x76,
	0x95, 0x1b, 0xfa, 0x94, 0x32, 0xbf
};
static const uint8_t ac_rsassa_vect1_out[] = {
	0x5f, 0xf8, 0xc0, 0x00, 0x4b, 0xd6, 0x5a, 0x3b, 0xf9, 0x34, 0xad, 0xca,
	0x24, 0x8f, 0x8f, 0x99, 0xba, 0x24, 0xb3, 0x84, 0x1b, 0x82, 0xff, 0xdb,
	0x35, 0x00, 0xa0, 0x66, 0x62, 0xc3, 0x85, 0x4d, 0xfc, 0x4b, 0x42, 0xce,
	0xd1, 0x29, 0x39, 0x04, 0x16, 0xcb, 0xa2, 0x53, 0x12, 0x5d, 0x71, 0x5c,
	0xcd, 0x37, 0xcb, 0x0a, 0x5d, 0x07, 0xdd, 0xb2, 0x18, 0x94, 0x47, 0x2a,
	0x82, 0x64, 0x7a, 0xd3, 0xbb, 0x83, 0xc5, 0x9c, 0x50, 0x85, 0x65, 0x94,
	0x0f, 0x01, 0xfe, 0x20, 0xa0, 0x83, 0x4f, 0x3b, 0x78, 0x99, 0x48, 0x94,
	0x36, 0xaf, 0x4a, 0xac, 0x89, 0xfa, 0xf6, 0xf8, 0x42, 0x86, 0xa5, 0xbe,
	0x0d, 0xb3, 0x39, 0x42, 0xa0, 0x70, 0x56, 0x5f, 0xea, 0xc6, 0x8f, 0x31,
	0xfe, 0x56, 0x56, 0xac, 0xf7, 0x4c, 0x9b, 0x8a, 0x06, 0x5a, 0xbd, 0x61,
	0x92, 0xfc, 0xef, 0x4b, 0x26, 0x36, 0x6d, 0x91
};


/*
 * Test data generated with
 * http://www.mobilefish.com/services/rsa_key_generation/rsa_key_generation.php
 * selecting 2048 bit key
 */
static const uint8_t ac_rsassa_vect2_modulus[] = {
	0x9a, 0x83, 0xda, 0x0e, 0xfb, 0xa1, 0x77, 0xc5, 0x34, 0x88, 0xac, 0x3d,
	0xd1, 0x3e, 0x89, 0x3e, 0xca, 0xad, 0x40, 0x47, 0xdc, 0xff, 0xc6, 0x18,
	0xc3, 0x1a, 0x95, 0xd3, 0x82, 0xb9, 0x98, 0xa8, 0xec, 0x90, 0xbe, 0xab,
	0xef, 0x74, 0xb7, 0x58, 0xa0, 0x0d, 0x0f, 0xb5, 0x13, 0xb8, 0x7e, 0xf7,
	0xdb, 0x19, 0x77, 0x55, 0xc5, 0xed, 0xa6, 0x60, 0xa7, 0xaf, 0xea, 0x83,
	0x69, 0xcf, 0xcf, 0x50, 0x51, 0x94, 0xa7, 0xc0, 0x96, 0x68, 0xe6, 0x63,
	0xef, 0xdf, 0xa8, 0x28, 0x4a, 0x50, 0xbf, 0xd7, 0x44, 0xbf, 0x0b, 0x0a,
	0x41, 0xd6, 0x02, 0xfc, 0x3f, 0x06, 0x51, 0x82, 0xe4, 0x56, 0x3f, 0xe9,
	0x37, 0x40, 0xe0, 0xaa, 0x18, 0x56, 0xcb, 0x2e, 0xd4, 0x02, 0x66, 0xcc,
	0xfb, 0xbd, 0x6b, 0x34, 0xfd, 0x3d, 0x2c, 0xad, 0xeb, 0x8c, 0x7c, 0x85,
	0x09, 0xd1, 0x00, 0x4f, 0xaf, 0xc7, 0x9d, 0x25, 0x19, 0x45, 0x3a, 0x54,
	0x9d, 0xda, 0x4b, 0x3b, 0x11, 0x6b, 0xbc, 0x66, 0xb7, 0xb1, 0xa2, 0x79,
	0x1c, 0xd5, 0x38, 0x7a, 0x7b, 0x62, 0xae, 0x8a, 0x35, 0xc7, 0x4b, 0xdd,
	0x0e, 0x23, 0x78, 0xa3, 0xec, 0xcf, 0xe9, 0xa4, 0x26, 0x33, 0xca, 0x48,
	0x08, 0xc1, 0x3c, 0xb0, 0xe8, 0xfa, 0x2f, 0xbb, 0x75, 0x8a, 0x3d, 0x45,
	0xf4, 0xe5, 0x7a, 0x2f, 0x4d, 0xd8, 0x6f, 0x05, 0x14, 0x21, 0xb1, 0xfd,
	0xd1, 0xbb, 0x3c, 0xa7, 0x1d, 0x2f, 0xe7, 0x79, 0xc2, 0x99, 0x49, 0x25,
	0xef, 0x73, 0xd4, 0xe9, 0xbb, 0xf9, 0x1b, 0xeb, 0x0e, 0xb7, 0xdf, 0x53,
	0xc1, 0xdc, 0x41, 0xf9, 0x92, 0x01, 0x68, 0x63, 0x84, 0x52, 0x78, 0xfc,
	0xf8, 0x7f, 0x84, 0xa1, 0x47, 0xe3, 0x7c, 0x5b, 0x53, 0x82, 0x1b, 0x3a,
	0x78, 0x7a, 0xae, 0x8d, 0x6a, 0xef, 0x87, 0x38, 0x28, 0x14, 0x4c, 0xf5,
	0xd7, 0xb9, 0xd0, 0xad
};
static const uint8_t ac_rsassa_vect2_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_vect2_priv_exp[] = {
	0x73, 0xdd, 0x01, 0x0b, 0x91, 0x26, 0xb0, 0x00, 0x01, 0x77, 0xa6, 0xe8,
	0xa7, 0xd9, 0xe3, 0xe2, 0x60, 0xea, 0x6f, 0x34, 0x34, 0x04, 0xdb, 0x8f,
	0xbf, 0xe5, 0x54, 0x8a, 0x09, 0x11, 0x90, 0xe6, 0xc2, 0x95, 0x7b, 0x54,
	0xc4, 0x37, 0x5a, 0x30, 0xab, 0xbb, 0x7f, 0x96, 0xc1, 0xd5, 0xeb, 0xe7,
	0x81, 0xb4, 0xe3, 0xe6, 0x3e, 0x88, 0x08, 0xe5, 0x9b, 0x78, 0x6f, 0x3a,
	0xe1, 0x82, 0x41, 0xab, 0xb1, 0xb0, 0xed, 0xe5, 0x9d, 0x23, 0xc5, 0xf7,
	0x14, 0x6d, 0x3a, 0xd4, 0x13, 0x7d, 0xdf, 0x8c, 0xd5, 0x71, 0x08, 0x1f,
	0x45, 0xe4, 0xeb, 0xd2, 0x28, 0x94, 0x5d, 0x54, 0xf0, 0x51, 0xb8, 0x94,
	0xf1, 0xa8, 0xc5, 0x8e, 0xe6, 0xb7, 0x56, 0x9e, 0xa3, 0xbd, 0xb5, 0x46,
	0x6a, 0x52, 0xcc, 0x6c, 0x2c, 0xa4, 0xcd, 0xb7, 0x10, 0xd5, 0x04, 0x9e,
	0x62, 0x11, 0x05, 0xd1, 0xbb, 0x36, 0xcc, 0x9f, 0x55, 0x91, 0x21, 0x2e,
	0xe7, 0x10, 0x4a, 0xe9, 0xb1, 0xd2, 0xc7, 0x16, 0x45, 0x46, 0xd8, 0x9e,
	0xd4, 0xe6, 0x7e, 0x90, 0xc9, 0x33, 0xf0, 0x4e, 0x9d, 0x1f, 0x46, 0x79,
	0xcf, 0xcd, 0xf6, 0x77, 0x6a, 0x6c, 0x97, 0x77, 0x00, 0x3a, 0x78, 0x24,
	0x81, 0xec, 0x2a, 0xae, 0x51, 0x77, 0xa0, 0xb2, 0xc9, 0xb8, 0x4a, 0xca,
	0xab, 0x7a, 0x28, 0x3f, 0x99, 0x53, 0xa3, 0xab, 0xe8, 0x60, 0x7a, 0x6d,
	0x2e, 0xda, 0xa6, 0x90, 0x24, 0xf6, 0x34, 0x51, 0x22, 0x7d, 0x32, 0x81,
	0x0c, 0x50, 0xa5, 0x14, 0x69, 0x8b, 0xbc, 0x4e, 0x06, 0xcc, 0xc3, 0xe1,
	0x69, 0x5f, 0xaa, 0xc3, 0x99, 0x46, 0x2f, 0xb7, 0x86, 0xc9, 0x39, 0xba,
	0x58, 0x97, 0x4e, 0x40, 0xc1, 0x29, 0xe6, 0x0e, 0xa4, 0x7d, 0x4a, 0xdf,
	0x87, 0x8c, 0x93, 0x7c, 0x22, 0x67, 0xae, 0xbb, 0x0e, 0xfc, 0x05, 0x67,
	0x5f, 0xde, 0xe2, 0x21
};
static const uint8_t ac_rsassa_vect2_prime1[] = {
	0xcd, 0xff, 0x70, 0x4b, 0x87, 0xc8, 0xd3, 0xad, 0x23, 0xb4, 0xe9, 0x63,
	0x91, 0x50, 0xbd, 0x78, 0x28, 0x4f, 0x23, 0x5a, 0xd5, 0x32, 0x53, 0xae,
	0x04, 0xe5, 0x87, 0x9c, 0xb4, 0x18, 0x07, 0x90, 0x6e, 0xaa, 0x8a, 0xfe,
	0x1c, 0xfe, 0x60, 0x77, 0x85, 0x27, 0x87, 0x4b, 0x91, 0x72, 0x43, 0x9d,
	0xe1, 0x71, 0x39, 0xe4, 0x0e, 0x7d, 0x03, 0xa9, 0x5d, 0xbc, 0xc2, 0x02,
	0x87, 0xd9, 0x39, 0x98, 0xf0, 0x51, 0xac, 0x6a, 0x96, 0x7c, 0x00, 0xf9,
	0xe4, 0x95, 0x02, 0xb8, 0xbd, 0xf1, 0xae, 0x2c, 0x15, 0x5a, 0x12, 0x30,
	0x6e, 0x1d, 0xe4, 0x1e, 0x65, 0x65, 0xde, 0x2e, 0xdc, 0x93, 0x02, 0xc2,
	0xbb, 0x9f, 0x7e, 0xec, 0xa3, 0xc4, 0x8f, 0x05, 0x07, 0xce, 0xbb, 0x9a,
	0x53, 0x1c, 0x57, 0x77, 0x89, 0xff, 0x6c, 0xcb, 0xf8, 0xa1, 0xde, 0xbe,
	0x14, 0x4b, 0xee, 0xd6, 0xad, 0x27, 0x04, 0x99
};
static const uint8_t ac_rsassa_vect2_prime2[] = {
	0xc0, 0x05, 0x4f, 0x58, 0xa0, 0x22, 0x58, 0x60, 0x7b, 0xef, 0x87, 0x1f,
	0x87, 0x39, 0x47, 0x48, 0xa8, 0x86, 0x15, 0xd5, 0xf9, 0xb5, 0xf8, 0x71,
	0x81, 0xf9, 0xb7, 0x3e, 0x4a, 0xe8, 0x5d, 0xbc, 0xbf, 0x8f, 0x17, 0xc0,
	0x96, 0xdc, 0xc2, 0x7f, 0x5e, 0x60, 0x65, 0xe7, 0xa2, 0xc6, 0x30, 0x25,
	0x8b, 0xe9, 0xdb, 0x28, 0x10, 0xac, 0x02, 0x0e, 0x23, 0x0f, 0x14, 0x6b,
	0xff, 0xd4, 0x09, 0xdd, 0x7c, 0x06, 0x5d, 0xb2, 0x6e, 0x32, 0x49, 0x62,
	0xb7, 0x93, 0x5d, 0x24, 0x99, 0x03, 0x69, 0x9b, 0x60, 0x2e, 0x34, 0xa3,
	0x9f, 0x62, 0x33, 0xaf, 0xc5, 0xdc, 0x8f, 0x10, 0x61, 0xfa, 0xc5, 0x8d,
	0xa9, 0xcc, 0x86, 0x93, 0x7d, 0x1e, 0xa6, 0x7d, 0xcb, 0x6e, 0x69, 0xfe,
	0xe1, 0x3c, 0x64, 0x01, 0x58, 0xd8, 0x1a, 0x0f, 0xf8, 0xcc, 0x34, 0xe5,
	0x01, 0x2c, 0xb8, 0xf9, 0x90, 0x71, 0xe5, 0x35
};
static const uint8_t ac_rsassa_vect2_exp1[] = {
	0x8b, 0x46, 0xc7, 0x8f, 0xe9, 0xb0, 0x78, 0x9d, 0xb9, 0x64, 0x99, 0xdf,
	0xbd, 0xe2, 0x4f, 0x18, 0x2c, 0x78, 0xc5, 0x38, 0xa6, 0xa8, 0xae, 0x37,
	0x1c, 0x0c, 0x6c, 0x52, 0x20, 0xd9, 0x96, 0x53, 0xaa, 0xdf, 0x17, 0xb6,
	0x93, 0xb7, 0xd1, 0x55, 0x3d, 0xeb, 0xe9, 0xe7, 0xc7, 0xe0, 0xef, 0xa2,
	0x91, 0x48, 0x52, 0x91, 0xc4, 0xd1, 0xf5, 0x65, 0xcf, 0x80, 0xcd, 0xd3,
	0x94, 0x31, 0xe4, 0x65, 0x69, 0x26, 0x6f, 0x62, 0x69, 0x78, 0x51, 0xd8,
	0xa3, 0x19, 0xb4, 0x8b, 0x5f, 0xb1, 0x45, 0xc7, 0x7c, 0x70, 0x37, 0x98,
	0x12, 0xfb, 0x96, 0xbe, 0x8e, 0x63, 0xff, 0x82, 0xc3, 0x93, 0x89, 0xec,
	0x4b, 0x9a, 0x9c, 0xe0, 0x36, 0x21, 0xb1, 0x68, 0xff, 0x4c, 0x61, 0x3f,
	0x08, 0x2e, 0x43, 0x5d, 0x09, 0x2a, 0x6f, 0x4e, 0xc1, 0x3e, 0x00, 0x31,
	0x97, 0xdb, 0x77, 0x12, 0x22, 0x64, 0x1d, 0x11
};
static const uint8_t ac_rsassa_vect2_exp2[] = {
	0x88, 0x05, 0xfa, 0xec, 0x44, 0x1b, 0xb0, 0x51, 0x40, 0xda, 0x2f, 0xf5,
	0x14, 0x9c, 0x6d, 0xb3, 0xb9, 0xb5, 0xaa, 0x58, 0x36, 0x99, 0x42, 0x52,
	0x5e, 0x09, 0x60, 0x56, 0x5f, 0x47, 0xf5, 0xc7, 0x14, 0x47, 0xb0, 0x42,
	0xbc, 0x5b, 0xcb, 0xe7, 0xe0, 0x1a, 0x17, 0x76, 0x1c, 0x27, 0x9a, 0xc9,
	0xae, 0x30, 0x4e, 0x10, 0x36, 0xa7, 0x32, 0x99, 0x83, 0x1a, 0x56, 0x94,
	0x1e, 0xd8, 0xbc, 0xd8, 0x49, 0xd8, 0x54, 0x9d, 0x66, 0x54, 0x77, 0x09,
	0xd8, 0x13, 0x2b, 0x03, 0x16, 0xe5, 0x84, 0xf5, 0x0d, 0x10, 0x0e, 0x37,
	0xee, 0x5a, 0xe9, 0x54, 0x55, 0xac, 0x65, 0x27, 0xec, 0xd0, 0x71, 0x0b,
	0x66, 0x42, 0x3c, 0xfe, 0xd3, 0xbe, 0x57, 0xa0, 0x7a, 0xf0, 0x4f, 0x63,
	0xbf, 0x78, 0x41, 0x3b, 0x77, 0x0d, 0x36, 0x81, 0x23, 0xf4, 0xbc, 0x6f,
	0x91, 0x02, 0x76, 0x52, 0x4b, 0x91, 0x73, 0x15
};
static const uint8_t ac_rsassa_vect2_coeff[] = {
	0xb1, 0x70, 0x9b, 0x0c, 0xec, 0xc7, 0x8b, 0xc3, 0x50, 0xe4, 0x3a, 0x85,
	0xda, 0x6c, 0xf6, 0x36, 0x30, 0x27, 0xe5, 0xf5, 0xa2, 0x96, 0x1d, 0x78,
	0xa2, 0xd5, 0x89, 0xce, 0xef, 0xba, 0xd9, 0xfc, 0x3e, 0x91, 0x0e, 0x63,
	0x42, 0x31, 0x2d, 0x99, 0xd7, 0x47, 0x1d, 0xb2, 0x42, 0x56, 0xd3, 0x07,
	0x76, 0x31, 0x35, 0x92, 0x23, 0xcd, 0x81, 0x7d, 0xc2, 0x14, 0xfd, 0x90,
	0x71, 0xbb, 0x43, 0x5e, 0x8b, 0xec, 0x1f, 0x8a, 0xf5, 0xe6, 0x08, 0xee,
	0x26, 0x79, 0xa1, 0xb4, 0xee, 0x58, 0x99, 0x4c, 0xad, 0x91, 0x6a, 0xaa,
	0x5c, 0x4b, 0xbc, 0xbc, 0xad, 0xf7, 0xe1, 0xdd, 0x48, 0xfd, 0x98, 0x82,
	0x06, 0x11, 0xac, 0xc5, 0x74, 0xb5, 0xa9, 0x16, 0x4a, 0x6c, 0xc1, 0xae,
	0x25, 0x70, 0xde, 0x96, 0xcf, 0xad, 0x2a, 0x8b, 0x89, 0x39, 0x77, 0x94,
	0xae, 0x4b, 0x84, 0x02, 0x92, 0x0c, 0x05, 0x42
};
static const uint8_t ac_rsassa_vect2_ptx[] = {
	0x91, 0x07, 0xf4, 0x49, 0x0a, 0xf9, 0x99, 0x12, 0xaa, 0x95, 0x02, 0x76,
	0x95, 0x1b, 0xfa, 0x94, 0x32, 0xbf
};
static const uint8_t ac_rsassa_vect2_out[] = {
	0x47, 0x16, 0xe1, 0xee, 0x54, 0xb7, 0xe0, 0x8a, 0xcc, 0x5d, 0x1b, 0xae,
	0xde, 0xc1, 0x43, 0x09, 0xd8, 0x4d, 0xe3, 0xcd, 0x5f, 0xd5, 0x48, 0x51,
	0xd3, 0x1c, 0x62, 0x5d, 0x1c, 0x13, 0x0b, 0x05, 0x89, 0x77, 0xd6, 0x95,
	0x4e, 0x8f, 0x4a, 0x0a, 0x51, 0xc2, 0x0c, 0xcf, 0xfe, 0x4c, 0x24, 0x6d,
	0x0c, 0x73, 0x33, 0x46, 0xd9, 0xdf, 0xfe, 0x6e, 0x06, 0xcb, 0x8c, 0x79,
	0x32, 0x3f, 0xbd, 0x1d, 0x10, 0x3a, 0x60, 0x3c, 0xe8, 0x1c, 0xbe, 0xd9,
	0xa8, 0x00, 0x76, 0x5b, 0x6d, 0x7a, 0x62, 0xdd, 0x3c, 0x21, 0x53, 0x16,
	0xab, 0x0b, 0x6c, 0x8d, 0x43, 0xfd, 0xba, 0x9a, 0xd9, 0x9a, 0xc1, 0x21,
	0x0c, 0x79, 0x78, 0x93, 0x86, 0xbd, 0xdf, 0x63, 0xca, 0xc8, 0xd6, 0xc6,
	0x20, 0xc9, 0x08, 0xf6, 0xc8, 0xfe, 0x22, 0xa4, 0xc6, 0xe3, 0x49, 0xe4,
	0x63, 0x01, 0x03, 0x5b, 0x78, 0x63, 0x3a, 0x02, 0x9c, 0xa1, 0xed, 0x20,
	0x01, 0x10, 0x79, 0x2e, 0x8d, 0xe5, 0x70, 0xae, 0x1a, 0x5f, 0x72, 0x9e,
	0x31, 0xab, 0x21, 0xd3, 0xd7, 0x59, 0x5f, 0x26, 0xbf, 0x45, 0x31, 0x6d,
	0xc3, 0xa6, 0x45, 0x7b, 0x6d, 0x8e, 0x3c, 0xb0, 0x42, 0xb4, 0xeb, 0x09,
	0xcf, 0x54, 0x0a, 0x72, 0x38, 0xf8, 0x67, 0x83, 0xa7, 0x7b, 0xce, 0x52,
	0x74, 0x0f, 0x03, 0x9d, 0x09, 0x1f, 0xe7, 0xf0, 0x85, 0x27, 0x3e, 0x1d,
	0x2f, 0xea, 0x2d, 0xa8, 0xdc, 0x58, 0x00, 0x9b, 0xdc, 0x10, 0x95, 0xe4,
	0x5f, 0x69, 0x20, 0x11, 0x1c, 0x3c, 0x58, 0x27, 0xcd, 0x1f, 0x23, 0xc9,
	0x28, 0xfa, 0x98, 0x53, 0xce, 0xa6, 0xe6, 0x64, 0x20, 0x2e, 0xe1, 0x2b,
	0x35, 0x30, 0x4e, 0xb2, 0x14, 0xaa, 0x7f, 0x89, 0x6f, 0xa8, 0xb1, 0xd6,
	0x30, 0x2c, 0x7c, 0xe5, 0x26, 0xe4, 0xce, 0x61, 0x6c, 0xc6, 0x06, 0xbc,
	0xea, 0x26, 0x6f, 0xe4
};

/*
 * 3072-bit RSA
 * Test data generated with:
 * openssl genrsa -out 3072.pem 3072
 * openssl rsa -in 3072.pem -text -noout
 * (dd if=/dev/zero bs=1 count=368; \
 *  printf '\x1\x2\x3\x4\x5\x6\x7\x8\x9\xa\xb\xc\xd\xe\xf\x10';) | \
 *  openssl rsautl -encrypt -raw -inkey 3072.pem | od -t x1
 */
static const uint8_t ac_rsassa_vect18_modulus[] = {
	0xca, 0x72, 0xcc, 0xef, 0xad, 0x0a, 0xbe, 0xd6, 0x35, 0x16, 0x23, 0x93,
	0x16, 0x8f, 0xee, 0x31, 0x4c, 0xc2, 0x6f, 0x20, 0x99, 0x38, 0x69, 0xc1,
	0xcb, 0x57, 0x5f, 0x7e, 0x35, 0xba, 0x85, 0xa7, 0xe9, 0xe1, 0xe6, 0x1d,
	0x39, 0xc2, 0x41, 0x7d, 0xc3, 0xa3, 0xea, 0x6a, 0xdb, 0x5a, 0x07, 0x4a,
	0x4a, 0x3a, 0xcb, 0xce, 0xf2, 0xa0, 0xdd, 0xcd, 0x4b, 0x99, 0x67, 0x0d,
	0x38, 0xf1, 0x40, 0x41, 0xed, 0x5b, 0xb8, 0xf8, 0xea, 0xc7, 0xd9, 0x91,
	0x30, 0x42, 0x8d, 0xee, 0x48, 0xc4, 0x7c, 0x7f, 0x0d, 0x33, 0x7b, 0x8f,
	0x38, 0x18, 0xed, 0x7f, 0x02, 0x8c, 0x44, 0x52, 0x6a, 0x93, 0x37, 0xfd,
	0x6a, 0x27, 0x3e, 0xbf, 0x03, 0x78, 0xe3, 0xfc, 0x29, 0x83, 0x20, 0x65,
	0xe3, 0xfa, 0x2c, 0x93, 0xcb, 0x83, 0x90, 0x61, 0xd3, 0x1a, 0x9a, 0x65,
	0x53, 0xf0, 0xea, 0x2c, 0xf8, 0x61, 0x8d, 0x9f, 0x54, 0x22, 0x7e, 0x2e,
	0x1e, 0x36, 0x62, 0xd9, 0x9f, 0x7d, 0x56, 0xf4, 0xad, 0x61, 0xb6, 0x1a,
	0x7b, 0x40, 0x59, 0x10, 0x04, 0xff, 0xea, 0x16, 0x98, 0x36, 0x61, 0x9d,
	0x5c, 0x62, 0xcb, 0xf6, 0xc2, 0x95, 0x3b, 0x91, 0xc9, 0xff, 0xf0, 0x65,
	0x7e, 0x0e, 0xa2, 0x43, 0x89, 0x24, 0xaa, 0xdd, 0x0e, 0xed, 0xb0, 0x8c,
	0xb0, 0xb2, 0x4d, 0x80, 0x2a, 0x11, 0xcf, 0x35, 0xe9, 0x82, 0xc6, 0x67,
	0x37, 0x3b, 0xc9, 0xd5, 0xa1, 0xd8, 0x8e, 0x07, 0x93, 0xfd, 0xe7, 0x5a,
	0x54, 0xc6, 0xf0, 0xae, 0x82, 0x43, 0x86, 0x62, 0x70, 0x44, 0x09, 0xb7,
	0x62, 0x58, 0xb2, 0x17, 0x9f, 0x3c, 0xa5, 0x10, 0x60, 0xc6, 0x61, 0x47,
	0x83, 0x1f, 0x3e, 0xa7, 0xf2, 0x26, 0x5b, 0x70, 0xd5, 0x81, 0x47, 0x6a,
	0x78, 0xe0, 0x85, 0x16, 0x36, 0xc0, 0x2e, 0xbb, 0x01, 0x6c, 0x99, 0x19,
	0xeb, 0x22, 0xf5, 0x13, 0xe3, 0x38, 0x67, 0x9f, 0x85, 0xed, 0x0f, 0x05,
	0x22, 0x29, 0x34, 0xda, 0x4b, 0x8f, 0x44, 0xfa, 0x30, 0xf8, 0xe6, 0xc1,
	0xf6, 0x9d, 0x9b, 0xd6, 0x56, 0x81, 0x2c, 0x58, 0x4d, 0xf8, 0x90, 0xef,
	0xf9, 0xea, 0x31, 0x6f, 0x04, 0xd2, 0x8d, 0xc1, 0xc9, 0x6e, 0x90, 0xd1,
	0xff, 0xce, 0xab, 0x58, 0x9f, 0x98, 0x57, 0x7c, 0x7a, 0x79, 0x8a, 0xb2,
	0x3d, 0x32, 0x0d, 0x0c, 0x3b, 0x6a, 0xd4, 0x33, 0x49, 0x50, 0xe1, 0x41,
	0x3d, 0x07, 0x32, 0xfc, 0x6d, 0x9f, 0xfc, 0x8c, 0xad, 0x05, 0x74, 0xa9,
	0x37, 0x5e, 0x70, 0x0b, 0xe9, 0xdf, 0xc1, 0x96, 0xca, 0x7c, 0xca, 0xbd,
	0xab, 0x8e, 0x68, 0xd0, 0xf9, 0x3f, 0x5f, 0x90, 0xb4, 0x30, 0x17, 0x4d,
	0x3a, 0xf9, 0xa1, 0xf0, 0xcb, 0xc7, 0x54, 0xb3, 0xa6, 0x0f, 0xd7, 0xe7,
	0x68, 0x43, 0x5f, 0x39, 0xa6, 0x05, 0x83, 0x74, 0xf9, 0xd9, 0x94, 0xab
};
static const uint8_t ac_rsassa_vect18_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_vect18_priv_exp[] = {
	0xaf, 0xb1, 0xa9, 0xc1, 0x67, 0x7f, 0xa7, 0xd6, 0xe7, 0x03, 0x6b, 0xa4,
	0x3f, 0x34, 0x72, 0x17, 0x3e, 0xf2, 0x8e, 0xd6, 0xcf, 0xa2, 0x71, 0xc5,
	0xc9, 0xde, 0xed, 0xf4, 0xee, 0x54, 0x0d, 0xa2, 0x88, 0x0b, 0x90, 0x55,
	0x54, 0xc7, 0x0d, 0x67, 0x43, 0xde, 0x81, 0x96, 0x72, 0xff, 0x52, 0xcc,
	0x5a, 0x57, 0x64, 0x81, 0x19, 0x78, 0x1a, 0x86, 0x0c, 0x51, 0xf9, 0x69,
	0x34, 0x3d, 0xca, 0xf2, 0x6c, 0x37, 0xe9, 0xf3, 0xbc, 0x6d, 0xec, 0x97,
	0x60, 0x36, 0xa2, 0x4e, 0x65, 0xc0, 0x7f, 0xfb, 0x13, 0x4d, 0xd6, 0xb1,
	0x98, 0x91, 0xa9, 0xab, 0x4c, 0x5e, 0xc6, 0xfc, 0x6f, 0x99, 0x8c, 0x41,
	0xd5, 0x5a, 0x71, 0xcd, 0xfc, 0x09, 0x72, 0x72, 0x68, 0xe4, 0x6f, 0xbd,
	0x7d, 0x78, 0xa4, 0x2f, 0x2f, 0xb3, 0xe2, 0x1d, 0xc3, 0xc3, 0x96, 0xb2,
	0xd1, 0x82, 0x86, 0xf8, 0xb8, 0x26, 0x91, 0x6d, 0xf0, 0xea, 0x6e, 0x6f,
	0x3f, 0xb1, 0x1b, 0x60, 0x9a, 0x55, 0x80, 0x9d, 0x9f, 0xca, 0xe8, 0xeb,
	0x5a, 0x83, 0xa1, 0xc7, 0x91, 0x4f, 0x37, 0xac, 0x9c, 0x34, 0xb5, 0xca,
	0x87, 0x5f, 0x06, 0x7c, 0x04, 0xaa, 0xd6, 0xa3, 0xd3, 0x96, 0xd6, 0xde,
	0x7d, 0xe3, 0xdd, 0x56, 0x97, 0x32, 0xc7, 0x46, 0x49, 0xaa, 0x66, 0x49,
	0xf3, 0x1f, 0x0a, 0xbb, 0x6b, 0xc7, 0x40, 0xf9, 0x1c, 0xca, 0x6d, 0xbb,
	0xa2, 0x9a, 0xf4, 0xae, 0x38, 0xf6, 0x53, 0x12, 0xb9, 0xea, 0xef, 0x97,
	0xbd, 0xfa, 0x1d, 0xb3, 0x85, 0x25, 0x0e, 0x24, 0x8c, 0xd2, 0x2d, 0x6e,
	0x2d, 0xeb, 0xd0, 0x4c, 0x1f, 0x82, 0x99, 0x96, 0x7f, 0x7f, 0x55, 0x13,
	0x20, 0x24, 0xd0, 0xa3, 0x62, 0x47, 0x84, 0x24, 0x3e, 0x61, 0xc1, 0x97,
	0xa8, 0x56, 0x1a, 0x60, 0x88, 0x13, 0x36, 0x82, 0xc8, 0xfe, 0x8e, 0x96,
	0x83, 0x47, 0x40, 0xc4, 0x89, 0x5d, 0x8d, 0xb4, 0xa8, 0x4e, 0x44, 0x7e,
	0xc1, 0x72, 0x79, 0xd5, 0xc8, 0x10, 0x72, 0x76, 0x38, 0x84, 0x43, 0x92,
	0x17, 0x6b, 0x9e, 0xbd, 0xa8, 0x35, 0xbf, 0xe8, 0xb3, 0xd5, 0x97, 0xbf,
	0xb7, 0x6a, 0x3c, 0xca, 0xb9, 0x9c, 0x3f, 0x92, 0x94, 0xb3, 0x5d, 0x82,
	0xca, 0xa7, 0x19, 0xa4, 0x96, 0xa7, 0xbe, 0xfa, 0xc5, 0xd0, 0xb0, 0xf3,
	0x93, 0x8d, 0x2f, 0x39, 0x4a, 0x08, 0x5d, 0xfc, 0x5d, 0xfe, 0x99, 0x2a,
	0x4e, 0x3a, 0x90, 0x10, 0xc6, 0xf8, 0x4c, 0xe3, 0xae, 0xcb, 0xd5, 0x7f,
	0x18, 0xab, 0xe6, 0x3b, 0x48, 0xf5, 0xdf, 0x25, 0x51, 0xe4, 0xad, 0x3e,
	0x77, 0x60, 0x5d, 0x68, 0xa5, 0x91, 0xcb, 0x09, 0x6b, 0x2d, 0x98, 0x51,
	0x73, 0x6b, 0x5b, 0xa9, 0x45, 0xfa, 0xf5, 0xa1, 0xdc, 0x3b, 0x12, 0x05,
	0x70, 0x1d, 0x73, 0x63, 0x2d, 0xa3, 0x28, 0xac, 0x51, 0xe6, 0x0d, 0x61
};
static const uint8_t ac_rsassa_vect18_prime1[] = {
	0xea, 0x1e, 0xe9, 0x51, 0xc9, 0x72, 0xdf, 0x9e, 0x72, 0x8e, 0xea, 0xe8,
	0x09, 0x78, 0x52, 0x2e, 0xfe, 0x7f, 0x87, 0x6e, 0xc5, 0x04, 0x88, 0x6b,
	0x67, 0xf6, 0x2b, 0x0d, 0xd2, 0x0b, 0xfb, 0x4f, 0xa2, 0x1c, 0x8c, 0xf6,
	0x8a, 0xbe, 0x8b, 0x1b, 0x1c, 0xec, 0x7e, 0x75, 0xf8, 0xd9, 0xed, 0x55,
	0x04, 0x08, 0xcc, 0x2c, 0x8b, 0x67, 0xa8, 0xc2, 0xfb, 0x2e, 0x0d, 0xd9,
	0x14, 0x70, 0x13, 0xf7, 0x94, 0x15, 0x74, 0xdd, 0x23, 0x66, 0x45, 0x43,
	0x41, 0x30, 0xc8, 0xec, 0x06, 0x23, 0xfc, 0xd6, 0xaa, 0x9d, 0x95, 0xa6,
	0x2b, 0xee, 0x53, 0xf5, 0xd5, 0x6c, 0x01, 0x23, 0x42, 0xa9, 0x36, 0x93,
	0xe1, 0x03, 0x96, 0x01, 0xce, 0x55, 0x14, 0xc0, 0xc0, 0x46, 0x9b, 0x93,
	0xca, 0x8d, 0x45, 0xf7, 0x6a, 0x2c, 0x4e, 0x5b, 0x25, 0x63, 0x7b, 0xef,
	0xdd, 0x38, 0x75, 0x51, 0xc6, 0x12, 0x5a, 0xbd, 0x4a, 0x4a, 0xee, 0xbf,
	0x0d, 0xc4, 0x42, 0x45, 0xcc, 0xf0, 0xb6, 0x05, 0x59, 0x21, 0x84, 0xb1,
	0x1f, 0x2a, 0x5c, 0x25, 0x22, 0xb8, 0xea, 0xc5, 0x60, 0x23, 0x68, 0x0d,
	0xa3, 0xf2, 0xe8, 0x1c, 0xfe, 0x6f, 0xfd, 0x95, 0x8a, 0x33, 0xef, 0x4f,
	0x2e, 0x24, 0x90, 0xa7, 0x60, 0xd6, 0x5c, 0x72, 0x5a, 0xc5, 0xd7, 0x5b,
	0xcf, 0x50, 0x76, 0x32, 0xe5, 0xc3, 0x3d, 0xa7, 0xda, 0x65, 0x86, 0x97
};
static const uint8_t ac_rsassa_vect18_prime2[] = {
	0xdd, 0x5e, 0x29, 0xbb, 0x78, 0x73, 0x74, 0x49, 0xec, 0xd1, 0x71, 0x91,
	0xa6, 0x74, 0x11, 0xae, 0x4b, 0x64, 0x6a, 0x5b, 0x60, 0x89, 0x70, 0x0c,
	0x1a, 0x3e, 0x3d, 0x42, 0x02, 0xd9, 0x16, 0x18, 0xb5, 0x33, 0xf8, 0xda,
	0x7f, 0x76, 0x6d, 0xc3, 0xf2, 0xc1, 0xf6, 0x90, 0x97, 0x2a, 0xbe, 0xeb,
	0x15, 0x8a, 0x05, 0xc2, 0xa4, 0xb8, 0xb0, 0x80, 0xe4, 0xc4, 0xc8, 0xc4,
	0xb5, 0xcc, 0x1e, 0xf0, 0x02, 0x6e, 0x02, 0xef, 0x5e, 0x35, 0xdb, 0x2e,
	0x41, 0x2d, 0xbc, 0x23, 0x44, 0x41, 0xbc, 0x29, 0xbd, 0xa7, 0x70, 0x0c,
	0x06, 0x53, 0x12, 0x78, 0x9b, 0x7f, 0x51, 0xfe, 0xb5, 0x82, 0x9c, 0xc9,
	0xf6, 0x40, 0x8d, 0xf9, 0x25, 0xd2, 0xae, 0x3f, 0x54, 0x22, 0x62, 0x80,
	0x03, 0x1f, 0xa3, 0x14, 0xc3, 0x13, 0x9c, 0x3a, 0xee, 0x3b, 0x34, 0xa3,
	0x7e, 0xe2, 0x71, 0xe8, 0x9d, 0x7c, 0xbc, 0x0e, 0x01, 0x34, 0xd5, 0x6d,
	0x89, 0x62, 0xd0, 0xaf, 0xe6, 0x03, 0x76, 0x94, 0xe2, 0xdc, 0xea, 0x1a,
	0xc7, 0x55, 0x68, 0x81, 0x9d, 0xdc, 0xf7, 0xc9, 0x81, 0xc8, 0x0f, 0x7a,
	0x03, 0xc2, 0x83, 0x98, 0xde, 0xc4, 0x4a, 0x1c, 0x7a, 0xc6, 0x13, 0x01,
	0x01, 0x04, 0x9a, 0x39, 0x14, 0xa5, 0x8d, 0x6a, 0x47, 0xef, 0xa5, 0xc4,
	0x35, 0xee, 0x72, 0x8e, 0x83, 0xe1, 0x74, 0x4e, 0xe2, 0x7b, 0x19, 0x0d
};
static const uint8_t ac_rsassa_vect18_exp1[] = {
	0x9d, 0xde, 0x7a, 0x36, 0x4c, 0x40, 0xc9, 0xc9, 0x6e, 0x36, 0x30, 0xf0,
	0x86, 0x72, 0x3b, 0xf8, 0xb4, 0x64, 0x0a, 0x4f, 0x07, 0x4b, 0x27, 0x32,
	0x45, 0xc8, 0x19, 0x00, 0x18, 0xc3, 0x3b, 0x93, 0x57, 0x1d, 0x29, 0x70,
	0x95, 0xde, 0x26, 0xaf, 0x01, 0xb1, 0xf7, 0x14, 0x55, 0xd9, 0x9d, 0xcf,
	0xd6, 0x08, 0x98, 0xa4, 0xf0, 0xdb, 0xd5, 0x50, 0xa5, 0x4f, 0x48, 0xc7,
	0x38, 0xa0, 0xda, 0xd5, 0xf7, 0x65, 0x00, 0x88, 0x9d, 0x76, 0x38, 0xfe,
	0x40, 0xd7, 0x44, 0xa4, 0xe2, 0xff, 0x21, 0x5f, 0x1f, 0x6d, 0x63, 0x9b,
	0xc9, 0xc3, 0xcb, 0x99, 0xd9, 0x70, 0x1a, 0xd4, 0x4b, 0xff, 0x0e, 0x6e,
	0x69, 0x2c, 0xa1, 0xda, 0x55, 0xe7, 0xc9, 0x36, 0xb0, 0x70, 0xec, 0x37,
	0x9c, 0x3d, 0xe7, 0x10, 0x0e, 0xe8, 0x11, 0x6e, 0x24, 0xa8, 0x10, 0xca,
	0x8d, 0xc1, 0xa4, 0x5a, 0x9f, 0xd5, 0x80, 0x9a, 0x63, 0x9e, 0x63, 0x9f,
	0x31, 0x09, 0x46, 0x27, 0x0b, 0x2a, 0xc5, 0x92, 0x95, 0xa7, 0xa4, 0x72,
	0x4b, 0x31, 0xa5, 0x30, 0xe5, 0x59, 0x0b, 0xf6, 0x4b, 0xfd, 0x94, 0x0c,
	0x9e, 0xa1, 0x0d, 0x23, 0x7f, 0xee, 0xc4, 0x70, 0x31, 0xe1, 0x13, 0x5d,
	0xb1, 0x1f, 0xb6, 0xeb, 0x26, 0xc1, 0x65, 0x55, 0x37, 0x20, 0x71, 0x37,
	0xd7, 0x73, 0xca, 0x40, 0x47, 0xee, 0x7f, 0x84, 0xd0, 0x1f, 0xe5, 0xc1
};
static const uint8_t ac_rsassa_vect18_exp2[] = {
	0x6d, 0xdb, 0xa9, 0x42, 0x4c, 0x48, 0x9f, 0xd1, 0x80, 0x21, 0x81, 0x07,
	0x13, 0x60, 0x4e, 0xd5, 0xfc, 0xbc, 0x5c, 0xbb, 0xf4, 0x70, 0xc0, 0x96,
	0x80, 0xff, 0x9a, 0x4f, 0x04, 0x32, 0xcf, 0xf0, 0x7b, 0x1c, 0xcb, 0xc7,
	0x43, 0xb2, 0x76, 0x4e, 0xe4, 0x4e, 0xb6, 0x1a, 0x93, 0xaa, 0xb7, 0x0c,
	0xdb, 0xa7, 0x9f, 0xac, 0x35, 0x2b, 0x23, 0x0d, 0x14, 0x7b, 0x44, 0x57,
	0xbb, 0x11, 0x0d, 0xd9, 0x76, 0x9b, 0x3a, 0x01, 0xa8, 0xf3, 0x79, 0x4e,
	0xbf, 0x31, 0xff, 0x48, 0x51, 0x3b, 0x7e, 0x32, 0x08, 0xd8, 0xeb, 0x96,
	0x4c, 0x1d, 0x35, 0xf1, 0x7c, 0xd9, 0xf6, 0xcb, 0x3d, 0x31, 0x10, 0xb6,
	0x79, 0xeb, 0x17, 0x8a, 0x29, 0xe7, 0x20, 0x6a, 0x75, 0x4a, 0x8b, 0x2f,
	0x94, 0x5d, 0x43, 0x05, 0xae, 0xba, 0x30, 0xb2, 0x5e, 0x40, 0x2b, 0xa3,
	0x67, 0xf8, 0xe1, 0x26, 0xdb, 0xe1, 0x67, 0x42, 0x5b, 0xfe, 0xe8, 0x5c,
	0x6f, 0xee, 0x06, 0x3b, 0x05, 0x1f, 0x7a, 0xdd, 0xf0, 0xa8, 0x49, 0xd5,
	0xf8, 0x4e, 0xbe, 0x8a, 0x74, 0xd9, 0x90, 0x6f, 0x04, 0x65, 0x50, 0xa8,
	0xf0, 0xec, 0xbb, 0x7a, 0x46, 0x33, 0x8b, 0xc4, 0x0e, 0x79, 0xf6, 0x3c,
	0x6d, 0x50, 0xe7, 0x68, 0xa4, 0x82, 0x74, 0x67, 0xe6, 0x43, 0x5c, 0x34,
	0xbf, 0xbf, 0x12, 0x42, 0xff, 0xd8, 0x07, 0x6c, 0x8e, 0xa1, 0x20, 0x91
};
static const uint8_t ac_rsassa_vect18_coeff[] = {
	0x83, 0x1f, 0x72, 0x3b, 0x3f, 0x9e, 0x46, 0x88, 0x83, 0xb3, 0xa0, 0xe2,
	0xa8, 0xf0, 0x56, 0x97, 0x3e, 0x4a, 0xed, 0x56, 0x46, 0xdf, 0xf8, 0x21,
	0xf5, 0xb8, 0xf9, 0xd8, 0x43, 0x3c, 0xf4, 0x39, 0x51, 0xd2, 0xf3, 0xa0,
	0x6f, 0x57, 0x18, 0xc0, 0xe1, 0x8a, 0x6a, 0xc0, 0x49, 0x34, 0xf6, 0x4d,
	0x60, 0xf6, 0xd0, 0x0f, 0x64, 0x58, 0xed, 0x17, 0x7d, 0x68, 0x47, 0x05,
	0x6f, 0x64, 0x2e, 0xa9, 0x53, 0xa8, 0x17, 0x65, 0x13, 0xdc, 0x27, 0x51,
	0xe3, 0x35, 0x01, 0xb8, 0x0c, 0x68, 0xfd, 0xaf, 0xa3, 0xf7, 0xb1, 0x9a,
	0xdc, 0x7b, 0x1b, 0xf7, 0xcc, 0x90, 0x8e, 0x93, 0xbc, 0x08, 0x15, 0xa7,
	0xc0, 0x92, 0xa0, 0xa3, 0xc9, 0x17, 0x9d, 0x8d, 0x3d, 0x10, 0x4f, 0xe6,
	0xa3, 0x4b, 0x91, 0x21, 0x42, 0x7c, 0xdf, 0x9c, 0x71, 0xed, 0xe1, 0x30,
	0x76, 0xf5, 0x1c, 0x71, 0xa0, 0x47, 0xc8, 0xa6, 0x2a, 0x94, 0x01, 0x49,
	0xae, 0x2e, 0x90, 0x47, 0x21, 0x17, 0xae, 0x10, 0x91, 0x53, 0x91, 0x88,
	0x88, 0xb4, 0x12, 0x50, 0x47, 0x7d, 0xf6, 0xfb, 0xde, 0x12, 0x6b, 0xc2,
	0x50, 0x4f, 0x59, 0x61, 0x81, 0x42, 0xe7, 0x19, 0x72, 0x73, 0xef, 0x9d,
	0x7c, 0xa0, 0xf4, 0x30, 0x91, 0xa8, 0x6a, 0x46, 0x9c, 0x5c, 0x0f, 0x9a,
	0xeb, 0x1f, 0x00, 0x1e, 0x0c, 0x49, 0x1f, 0xb8, 0x5f, 0x37, 0xd7, 0x4f
};
static const uint8_t ac_rsassa_vect18_ptx[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c,
	0x0d, 0x0e, 0x0f, 0x10 };
static const uint8_t ac_rsassa_vect18_out[] = {
	0x06, 0xe3, 0x94, 0xdc, 0x4b, 0xbc, 0xa5, 0x80, 0x7e, 0x65, 0x65, 0xe2,
	0x6c, 0x91, 0x8b, 0x57, 0x52, 0x29, 0xa0, 0x05, 0x20, 0xef, 0x49, 0xb1,
	0xf9, 0xdb, 0x9e, 0xd8, 0x2e, 0x65, 0x9d, 0x61, 0xa8, 0xda, 0x9a, 0x95,
	0xab, 0xa6, 0x8e, 0x7b, 0xfd, 0x89, 0x5f, 0x5b, 0xfc, 0x10, 0x12, 0x98,
	0x4a, 0x2b, 0x48, 0x38, 0x2d, 0x66, 0x4c, 0x5b, 0x2c, 0xe2, 0x4d, 0xaa,
	0xa3, 0x19, 0x64, 0xf1, 0xf1, 0x4b, 0xd5, 0x06, 0x14, 0x83, 0xf2, 0x71,
	0x5a, 0xef, 0x81, 0xa2, 0xaa, 0x5a, 0xfa, 0x48, 0x38, 0x4a, 0x46, 0x52,
	0xb2, 0xbd, 0x10, 0x1b, 0x11, 0xa1, 0x46, 0x2d, 0x51, 0x59, 0xc0, 0x49,
	0x32, 0x43, 0x83, 0x28, 0xe0, 0x59, 0x0b, 0x6a, 0xef, 0x5d, 0xee, 0x37,
	0xca, 0xd8, 0x8f, 0xd5, 0xcf, 0x57, 0x4b, 0xac, 0x80, 0x3d, 0x05, 0xa0,
	0x15, 0x0c, 0x27, 0xee, 0xa2, 0x91, 0xfb, 0x1d, 0x4f, 0xbd, 0x45, 0x39,
	0x34, 0x37, 0x05, 0x82, 0x8f, 0x19, 0x4e, 0x20, 0xb8, 0x3b, 0x7e, 0x60,
	0x0a, 0x2f, 0x48, 0xaa, 0xf9, 0xa3, 0x5e, 0xd5, 0xd8, 0xdb, 0xc1, 0x61,
	0xa3, 0x95, 0x72, 0x19, 0xba, 0x97, 0xd6, 0x5f, 0x5d, 0xb3, 0x50, 0x51,
	0xb8, 0x5a, 0x1a, 0x8a, 0x0f, 0xd2, 0x25, 0xdc, 0x12, 0xd1, 0x96, 0xac,
	0x8c, 0x70, 0x47, 0x46, 0x35, 0xdf, 0xb1, 0x15, 0xf6, 0x65, 0xc3, 0x6d,
	0xd5, 0xd7, 0x4c, 0xb2, 0xa3, 0xc7, 0x03, 0xd6, 0xc1, 0x8d, 0x33, 0x56,
	0x49, 0xf4, 0xf4, 0x4e, 0x44, 0x83, 0xee, 0x7a, 0xb9, 0xdc, 0x5f, 0x7c,
	0x85, 0x10, 0x0e, 0x30, 0x46, 0x73, 0x7e, 0x44, 0x42, 0x17, 0x8f, 0x20,
	0x12, 0x13, 0x39, 0x5d, 0x55, 0x6b, 0xb2, 0x3c, 0xde, 0xae, 0xb9, 0xa0,
	0xb3, 0x0a, 0x81, 0x08, 0x72, 0xf8, 0xb3, 0xc4, 0xb9, 0x79, 0x09, 0x5d,
	0x81, 0x56, 0x49, 0xab, 0x07, 0xbd, 0xce, 0xd7, 0x39, 0x94, 0xfb, 0xfc,
	0x73, 0x2d, 0xd6, 0x9f, 0x7f, 0x26, 0x39, 0x05, 0xe5, 0xc9, 0x0b, 0x67,
	0x71, 0x09, 0xac, 0xfd, 0x75, 0x26, 0x92, 0xd6, 0x02, 0xf1, 0xa8, 0x25,
	0xee, 0x7c, 0xb6, 0x46, 0x28, 0xb6, 0x92, 0xf0, 0x99, 0xdc, 0x6e, 0xf1,
	0xa4, 0x9d, 0xc1, 0x45, 0x9d, 0x19, 0xd5, 0x78, 0x93, 0xc0, 0x2c, 0x3c,
	0x8b, 0x3c, 0x96, 0xf9, 0x84, 0x26, 0xc9, 0xf0, 0xe0, 0xde, 0xce, 0x23,
	0x7e, 0xe4, 0x06, 0xef, 0x5a, 0xea, 0x24, 0x65, 0x97, 0x4c, 0xd8, 0x48,
	0x44, 0xb1, 0x59, 0x8a, 0x15, 0x95, 0x62, 0xc9, 0xee, 0x86, 0x63, 0x32,
	0xba, 0xe2, 0xfc, 0x05, 0x5e, 0x17, 0x5c, 0x69, 0x8f, 0x04, 0x02, 0x91,
	0xec, 0x46, 0xf8, 0x0a, 0xd1, 0xb0, 0x95, 0x40, 0x3d, 0x92, 0x6e, 0xdf,
	0xf6, 0xe7, 0x3e, 0xc6, 0x40, 0x05, 0xdf, 0x82, 0xe6, 0xe0, 0x9f, 0x1b
};

/*
 * 4096-bit RSA
 * Test data generated with:
 * openssl genrsa -out 4096.pem 4096
 * openssl rsa -in 4096.pem -text -noout
 * (dd if=/dev/zero bs=1 count=368; \
 *  printf '\x1\x2\x3\x4\x5\x6\x7\x8\x9\xa\xb\xc\xd\xe\xf\x10';) | \
 *  openssl rsautl -encrypt -raw -inkey 4096.pem | od -t x1
 */
static const uint8_t ac_rsassa_vect19_modulus[] = {
	0xf6, 0x48, 0x38, 0x0c, 0x61, 0xc5, 0xf2, 0x8f, 0x1d, 0x36, 0x78, 0x3b,
	0xfd, 0x03, 0x74, 0x2f, 0xe7, 0xb0, 0xab, 0xbd, 0x25, 0x88, 0x46, 0xd8,
	0x4f, 0x6b, 0xc8, 0xcb, 0xb8, 0x5d, 0x88, 0x16, 0x8c, 0x68, 0xf2, 0xda,
	0x34, 0x25, 0xc9, 0x8a, 0xcf, 0xf8, 0x34, 0xbd, 0xa3, 0xc9, 0x42, 0x9a,
	0xb7, 0x4d, 0xab, 0xc3, 0x87, 0xad, 0xa6, 0xa7, 0x02, 0x69, 0xdf, 0x58,
	0x84, 0xeb, 0x6e, 0xf7, 0x77, 0xd7, 0x4d, 0xf2, 0x01, 0x4e, 0x7b, 0x79,
	0x72, 0xb0, 0x23, 0xb3, 0xb2, 0x22, 0x15, 0x14, 0x05, 0xce, 0xea, 0x98,
	0x88, 0x9e, 0xe4, 0x03, 0x9d, 0x5b, 0x07, 0x56, 0xac, 0x77, 0x56, 0x3a,
	0xd7, 0x0c, 0x7f, 0x74, 0x2d, 0xd1, 0x48, 0xdd, 0x1c, 0x99, 0xe3, 0x53,
	0x3a, 0xa3, 0x9e, 0x4b, 0xb2, 0xd7, 0xe9, 0xfd, 0x04, 0x2c, 0xa2, 0x05,
	0x60, 0xae, 0x2d, 0xd0, 0x59, 0x2a, 0x90, 0xf6, 0xe4, 0x99, 0x4d, 0x7a,
	0xf8, 0xe5, 0x80, 0xeb, 0x77, 0xa5, 0xae, 0xe2, 0x40, 0xb7, 0x0e, 0x6c,
	0x02, 0xbe, 0x33, 0x04, 0xb0, 0xab, 0x01, 0xfe, 0x0c, 0xc1, 0xd1, 0x86,
	0x58, 0x6a, 0xc1, 0xb2, 0x3b, 0xfb, 0x03, 0x16, 0x72, 0xf3, 0xbb, 0xd6,
	0x43, 0xd3, 0xbf, 0xf0, 0x5b, 0xce, 0xa8, 0x39, 0x53, 0xee, 0x49, 0xc9,
	0x2c, 0x04, 0xb3, 0x4a, 0x4c, 0xd7, 0xd1, 0x9b, 0xf6, 0x51, 0x28, 0xd3,
	0x24, 0x03, 0xff, 0xa1, 0xcb, 0xb7, 0x7a, 0x73, 0xee, 0xfa, 0x2c, 0x1e,
	0x43, 0xc2, 0xb6, 0x3a, 0x4c, 0x68, 0x23, 0x1e, 0x88, 0x85, 0xf2, 0xcb,
	0x1d, 0xc9, 0x79, 0x3b, 0x4a, 0x72, 0xe7, 0xdb, 0xfa, 0x62, 0x8d, 0xf5,
	0x93, 0xfd, 0x32, 0x40, 0x09, 0x17, 0xa9, 0xda, 0x72, 0x02, 0xf4, 0xcb,
	0x8e, 0xb1, 0xe8, 0x64, 0x57, 0xf1, 0x94, 0xba, 0xe6, 0x24, 0x84, 0xf0,
	0xca, 0x0d, 0x6a, 0xeb, 0x1e, 0xde, 0x6e, 0xc6, 0x05, 0x55, 0x09, 0x99,
	0x18, 0x41, 0xe2, 0x55, 0x1a, 0x1f, 0xcc, 0xee, 0xae, 0x5f, 0x49, 0xb9,
	0x2b, 0x6a, 0xf8, 0xdd, 0x0e, 0x10, 0x9c, 0xef, 0x6e, 0xaa, 0xe9, 0x59,
	0x81, 0x1b, 0x4e, 0x8a, 0xac, 0x48, 0x6f, 0x7b, 0xc4, 0x62, 0x5f, 0x8c,
	0x59, 0x83, 0x96, 0xdb, 0x62, 0x88, 0x8f, 0x22, 0x57, 0x91, 0x0b, 0x9f,
	0xcd, 0xca, 0x6a, 0x3c, 0x71, 0x0b, 0x36, 0x8d, 0xf9, 0xbf, 0x3b, 0x37,
	0x05, 0xeb, 0xc3, 0x45, 0xc5, 0xeb, 0xe0, 0xdb, 0x12, 0x24, 0xe8, 0xad,
	0x83, 0xe8, 0x18, 0xd7, 0x67, 0x47, 0x0e, 0x53, 0x37, 0xf4, 0x16, 0xc5,
	0x5e, 0x82, 0x68, 0xfa, 0x8b, 0xe0, 0xde, 0xd1, 0x93, 0xea, 0x94, 0x70,
	0x4e, 0xfd, 0x5c, 0xd6, 0x4d, 0x99, 0x7b, 0xfc, 0x99, 0x2c, 0x65, 0x2b,
	0xe2, 0x29, 0xf1, 0x8f, 0x5c, 0x77, 0x30, 0x46, 0x11, 0x3f, 0x33, 0x2b,
	0xb1, 0x00, 0x50, 0x14, 0x97, 0x26, 0x39, 0xfd, 0xd5, 0xc2, 0x83, 0x0a,
	0x07, 0xe3, 0x4e, 0xa7, 0x82, 0x21, 0x4e, 0xb3, 0xef, 0xae, 0x0d, 0x7b,
	0xee, 0xe8, 0x1d, 0xf7, 0x31, 0xcb, 0x1e, 0x05, 0x4f, 0x8e, 0xf0, 0x67,
	0x36, 0x71, 0x23, 0x72, 0x11, 0x37, 0x0f, 0x4f, 0xf8, 0xc2, 0x04, 0xff,
	0x76, 0xb2, 0x77, 0xa2, 0xee, 0x79, 0xf1, 0x5f, 0x34, 0x6f, 0xf8, 0xda,
	0x93, 0xeb, 0x6f, 0x38, 0x7e, 0x14, 0xf0, 0xca, 0x14, 0x40, 0x5e, 0xb8,
	0x56, 0x7e, 0x61, 0x3e, 0xc0, 0x20, 0x3f, 0x2a, 0xac, 0x43, 0x69, 0xf2,
	0x10, 0xce, 0x33, 0x22, 0xe4, 0xdc, 0x9a, 0xac, 0x53, 0x95, 0x38, 0x16,
	0x81, 0xbc, 0xf0, 0x45, 0x64, 0x52, 0xbb, 0x20, 0x77, 0x3b, 0xa0, 0x92,
	0x40, 0xfd, 0x4b, 0x46, 0xe0, 0x5c, 0xaf, 0x3d, 0x87, 0xad, 0xf8, 0x90,
	0x2f, 0xdc, 0x27, 0x4f, 0x2d, 0xe6, 0xcd, 0x25
};
static const uint8_t ac_rsassa_vect19_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_vect19_priv_exp[] = {
	0xae, 0x48, 0xc9, 0x31, 0x29, 0xf7, 0xd5, 0x01, 0x26, 0x21, 0x27, 0xd0,
	0xfb, 0xe9, 0xf7, 0xcc, 0xf6, 0xde, 0xf5, 0x89, 0xf3, 0x07, 0x8f, 0x6b,
	0x00, 0x39, 0x3c, 0x6d, 0xbe, 0x58, 0xa2, 0x37, 0xa2, 0xc1, 0x9a, 0x2a,
	0x84, 0x80, 0xc1, 0x31, 0x74, 0x9f, 0x27, 0x63, 0x94, 0x86, 0x96, 0x95,
	0xba, 0x66, 0x42, 0xc9, 0x2a, 0x38, 0xdf, 0x18, 0x8d, 0x02, 0xb3, 0x45,
	0x87, 0x3a, 0xbc, 0xda, 0x6f, 0x7a, 0x73, 0xf4, 0x70, 0xac, 0x43, 0x80,
	0xdc, 0x82, 0x7d, 0xa1, 0x6a, 0xcb, 0xe7, 0xb2, 0xb5, 0xb1, 0x8a, 0x1e,
	0xcb, 0x7f, 0xf5, 0xc8, 0x01, 0x11, 0x2c, 0x0e, 0x50, 0x1a, 0x5b, 0x71,
	0x64, 0x41, 0xb9, 0xe8, 0x53, 0x8c, 0x29, 0x4e, 0x20, 0x31, 0x5e, 0xc7,
	0xc5, 0x55, 0x88, 0x6d, 0xf5, 0x70, 0x0a, 0x6c, 0x3d, 0x0a, 0x00, 0xd6,
	0x61, 0x66, 0xa1, 0x91, 0x31, 0xa8, 0x87, 0xd1, 0xd0, 0x50, 0x14, 0x9e,
	0x93, 0x88, 0x86, 0x45, 0x1b, 0xf4, 0xa9, 0xdf, 0xff, 0x00, 0x0c, 0x3a,
	0xaf, 0x6e, 0x3d, 0xd8, 0x71, 0xd5, 0x72, 0xa1, 0x80, 0x11, 0xa0, 0xde,
	0xbb, 0xaf, 0x40, 0xc7, 0x8a, 0xde, 0xc5, 0x7e, 0x9b, 0x76, 0x94, 0x54,
	0xba, 0xc7, 0x1c, 0xab, 0x51, 0xac, 0xdb, 0x2b, 0x46, 0x93, 0xf8, 0xaf,
	0x5e, 0x71, 0x2d, 0x17, 0xc5, 0x6d, 0x6d, 0x2e, 0x3b, 0x8f, 0x8f, 0x9e,
	0x6b, 0x7c, 0x50, 0xe9, 0x04, 0xab, 0x21, 0x02, 0xed, 0xf9, 0x28, 0x43,
	0x7a, 0x9c, 0x4e, 0x2c, 0xcf, 0x69, 0x5a, 0x80, 0xff, 0x08, 0x1b, 0x9b,
	0x55, 0xc6, 0xff, 0xfd, 0xcf, 0x5f, 0xa5, 0x68, 0xec, 0xb5, 0xd5, 0xd4,
	0x16, 0x18, 0x35, 0xf9, 0x4e, 0xf5, 0xea, 0x03, 0x66, 0x6f, 0x65, 0x20,
	0xb0, 0x28, 0x82, 0x56, 0x90, 0x4d, 0xab, 0x7c, 0xdf, 0xe4, 0xb4, 0x17,
	0x5a, 0x45, 0x48, 0x85, 0x1b, 0x7e, 0x08, 0x71, 0xef, 0x4c, 0xd0, 0xdd,
	0x2a, 0x19, 0x3a, 0xed, 0x1f, 0x96, 0xa1, 0xf9, 0xca, 0xe0, 0x52, 0x27,
	0xd8, 0xf7, 0x9b, 0x0d, 0x4c, 0x82, 0x08, 0x46, 0xb6, 0xef, 0x53, 0x1b,
	0x72, 0x63, 0xb6, 0xe7, 0x3f, 0xa4, 0x5b, 0xed, 0x89, 0xeb, 0xc8, 0x10,
	0x78, 0x61, 0x68, 0x98, 0x8f, 0x87, 0x2f, 0xb9, 0x41, 0x31, 0x47, 0x20,
	0xf2, 0xde, 0x52, 0x2a, 0x17, 0x3f, 0x84, 0xad, 0x39, 0xec, 0x42, 0x1c,
	0x37, 0xbc, 0xb2, 0x7c, 0x43, 0xdb, 0x2e, 0x65, 0x43, 0x17, 0x9e, 0x8f,
	0xa0, 0x5b, 0x96, 0xc3, 0xd4, 0x2d, 0xc0, 0x52, 0x3b, 0xe4, 0x0b, 0xe5,
	0xaa, 0xcc, 0x1f, 0x57, 0xf0, 0xd6, 0xdd, 0x9a, 0xd1, 0x77, 0xea, 0x0c,
	0x7a, 0x8b, 0x69, 0xdb, 0xe9, 0x36, 0x63, 0x1d, 0x46, 0x23, 0x51, 0x9f,
	0x45, 0xce, 0xa4, 0x68, 0xb4, 0x6e, 0x65, 0x32, 0xef, 0xdf, 0xe8, 0xce,
	0xb6, 0x91, 0x91, 0xbc, 0x3a, 0xc0, 0xd3, 0xb2, 0x7f, 0xf4, 0x14, 0xbf,
	0xb8, 0xc9, 0x3d, 0x60, 0x99, 0x5f, 0x14, 0x45, 0x22, 0x07, 0x77, 0x08,
	0x32, 0xdd, 0xc8, 0x46, 0x3a, 0x3d, 0x2d, 0xa1, 0x4d, 0xc2, 0xa0, 0x3f,
	0xa1, 0xe8, 0x9d, 0x28, 0x57, 0x4c, 0x65, 0x03, 0x54, 0x6f, 0xbb, 0x1c,
	0x86, 0x47, 0x29, 0x44, 0x5c, 0xd4, 0x17, 0xed, 0x84, 0x60, 0xbf, 0xb6,
	0xb6, 0x0d, 0x0e, 0x47, 0xe2, 0x73, 0x95, 0xf4, 0x4d, 0x6a, 0x6a, 0x04,
	0x1b, 0xd4, 0x98, 0xb4, 0xcf, 0x8f, 0xe4, 0x0d, 0x14, 0x66, 0xa0, 0xf5,
	0x8d, 0x65, 0xdc, 0xb9, 0xdd, 0x1a, 0x2c, 0x9e, 0x71, 0x78, 0x5a, 0x98,
	0x13, 0x0d, 0x91, 0x40, 0xd1, 0x6f, 0x1c, 0x7a, 0x06, 0xab, 0x0b, 0xc1,
	0xd1, 0x19, 0x00, 0xca, 0x7a, 0xde, 0x45, 0x5c, 0x50, 0x53, 0x83, 0x71,
	0x45, 0x0a, 0x4b, 0x0f, 0x2f, 0x67, 0x3b, 0x39
};
static const uint8_t ac_rsassa_vect19_prime1[] = {
	0xfc, 0x1e, 0xca, 0x69, 0x92, 0x80, 0xf8, 0x54, 0x87, 0x29, 0xd4, 0x68,
	0xcb, 0xd6, 0xba, 0x1d, 0x4a, 0x29, 0x4c, 0xa1, 0x49, 0xd7, 0x42, 0x68,
	0x09, 0xb0, 0x66, 0xa1, 0x1e, 0xf8, 0x8a, 0xf2, 0x8b, 0xdc, 0x57, 0x70,
	0xa2, 0x29, 0x7f, 0x18, 0xce, 0x18, 0x88, 0x8a, 0x02, 0x60, 0xcf, 0x05,
	0x15, 0xa0, 0x98, 0x23, 0x77, 0xf4, 0x1a, 0xba, 0xc5, 0x9e, 0x61, 0xea,
	0x42, 0xfd, 0x86, 0x88, 0xca, 0x93, 0xa1, 0xf3, 0xf4, 0x0c, 0x38, 0x62,
	0x3a, 0x6e, 0x30, 0x0d, 0x52, 0xce, 0xc8, 0xdd, 0xf2, 0xc4, 0x75, 0x8b,
	0x44, 0xf9, 0x14, 0xcd, 0x09, 0xd9, 0x37, 0x0d, 0x09, 0x75, 0x82, 0xd6,
	0x1d, 0x86, 0x23, 0x29, 0xc7, 0x6f, 0xea, 0x88, 0x5a, 0x88, 0xc5, 0x69,
	0x4e, 0x67, 0x8b, 0x90, 0xd5, 0xc6, 0xe8, 0xd8, 0xd6, 0x05, 0xc9, 0xfe,
	0x2c, 0x56, 0x8f, 0xcb, 0xb7, 0x7e, 0x59, 0xfa, 0x16, 0x60, 0x8a, 0xf6,
	0xdc, 0x63, 0xe5, 0xfc, 0x24, 0x87, 0xc6, 0x2d, 0x94, 0x3d, 0x29, 0x0d,
	0xe8, 0xc7, 0x75, 0xe6, 0x32, 0xa3, 0x74, 0x50, 0xae, 0xdd, 0x03, 0x14,
	0x70, 0xbc, 0x61, 0x04, 0x07, 0xf4, 0x62, 0xa8, 0x79, 0x2b, 0xf8, 0xc4,
	0x69, 0xdb, 0x9a, 0x78, 0x97, 0xa7, 0x71, 0x4c, 0xde, 0x78, 0x5b, 0xab,
	0x08, 0x85, 0x0e, 0x34, 0xad, 0x64, 0x24, 0x41, 0x75, 0x24, 0xe0, 0x9b,
	0xa8, 0x98, 0x14, 0xe6, 0xe3, 0xf9, 0x59, 0xcc, 0x06, 0x67, 0xf0, 0x5e,
	0x3c, 0x75, 0x03, 0xb3, 0xcf, 0x35, 0x57, 0x28, 0x02, 0x6b, 0x42, 0x0f,
	0x9b, 0x3d, 0x7d, 0xa0, 0x26, 0xc6, 0xe0, 0x06, 0x3b, 0x97, 0x07, 0x0d,
	0x9b, 0xa4, 0xc5, 0x16, 0x91, 0x9d, 0xa3, 0xec, 0x8b, 0x49, 0x47, 0x44,
	0xd2, 0xdd, 0xd4, 0xd3, 0xc9, 0x88, 0xe3, 0x88, 0x57, 0xce, 0x3f, 0xc2,
	0x08, 0x77, 0x8f, 0x13
};
static const uint8_t ac_rsassa_vect19_prime2[] = {
	0xfa, 0x12, 0x6d, 0xe1, 0x5b, 0x6b, 0x88, 0x0e, 0x28, 0x61, 0x4c, 0x18,
	0xc8, 0x2f, 0xf5, 0xe7, 0x0e, 0xc6, 0x1e, 0x14, 0x3b, 0x5a, 0xe1, 0x51,
	0xbf, 0x64, 0x6f, 0x9e, 0xb7, 0xca, 0x3f, 0x57, 0xdb, 0xc2, 0x87, 0x8a,
	0x41, 0x57, 0xfb, 0xcd, 0x5d, 0x1a, 0xe6, 0x2a, 0x50, 0x0f, 0x60, 0xe1,
	0x81, 0x4a, 0x7c, 0xc5, 0xbf, 0xba, 0x37, 0x6f, 0xec, 0x30, 0xba, 0xcf,
	0x13, 0x51, 0x43, 0x19, 0x29, 0xaf, 0xb8, 0xc9, 0xee, 0x8d, 0x56, 0xee,
	0x3d, 0x90, 0x8e, 0x5e, 0x4d, 0xe6, 0x01, 0xbe, 0x26, 0xf9, 0x7e, 0x3a,
	0xaf, 0xa0, 0x56, 0xda, 0x9f, 0x29, 0x42, 0x84, 0x1c, 0x4b, 0xde, 0x67,
	0x32, 0xc1, 0xf0, 0xde, 0x5f, 0x89, 0x01, 0xc7, 0xb1, 0x8e, 0x2b, 0x15,
	0xf1, 0x59, 0x80, 0xf1, 0x9a, 0x15, 0x20, 0xfd, 0x53, 0xc1, 0x9f, 0xb7,
	0x4a, 0xde, 0xe0, 0x58, 0xac, 0x6c, 0xd2, 0x44, 0xb7, 0x9a, 0x0f, 0x8e,
	0xdc, 0xa2, 0x57, 0xf6, 0x69, 0x61, 0x37, 0xe3, 0x8a, 0xb4, 0xa6, 0xf4,
	0x08, 0x41, 0xfb, 0x22, 0xd1, 0xe4, 0x62, 0x4d, 0xac, 0x2d, 0x71, 0x7b,
	0x32, 0xe1, 0x5d, 0xa4, 0x29, 0xbd, 0xde, 0xa4, 0x87, 0xb9, 0xe7, 0xe4,
	0xd1, 0x12, 0x81, 0x15, 0xfd, 0x13, 0xff, 0xf0, 0xce, 0x8b, 0x4c, 0x3f,
	0x66, 0xe8, 0xb4, 0xd5, 0xa7, 0x09, 0xb0, 0x31, 0x2e, 0xbd, 0x86, 0x56,
	0xb4, 0xa2, 0xee, 0xc4, 0x17, 0xda, 0x86, 0x26, 0xb1, 0x14, 0x27, 0x1a,
	0x12, 0xed, 0x6a, 0xe2, 0xb5, 0x3f, 0x53, 0x3a, 0x23, 0xf6, 0x19, 0xb6,
	0xcc, 0x3b, 0x72, 0xcc, 0xf8, 0xde, 0xec, 0xe0, 0x68, 0x62, 0x5c, 0xe0,
	0xff, 0x34, 0x80, 0xab, 0x4d, 0x65, 0x46, 0x06, 0x06, 0xce, 0xb5, 0xd6,
	0xb0, 0xca, 0x76, 0x82, 0xed, 0x13, 0x5d, 0x5b, 0xc9, 0x8c, 0xf0, 0x1e,
	0xfd, 0x47, 0xe1, 0xe7
};
static const uint8_t ac_rsassa_vect19_exp1[] = {
	0xa2, 0x90, 0xf0, 0x0f, 0x56, 0xca, 0x16, 0x55, 0xda, 0xb9, 0x9c, 0x1e,
	0xde, 0xa0, 0xdc, 0x6d, 0x1a, 0x6e, 0xba, 0xdc, 0x9d, 0x12, 0x51, 0xdd,
	0x67, 0xb1, 0xf8, 0xdb, 0x17, 0x6f, 0x47, 0x98, 0xd1, 0x9a, 0x08, 0x3f,
	0xb6, 0x30, 0x6f, 0xa5, 0x7c, 0xee, 0xd0, 0xcb, 0xbc, 0x70, 0xd3, 0xcc,
	0x01, 0x80, 0x05, 0xd9, 0x88, 0xf5, 0x3b, 0x6f, 0x07, 0x11, 0xf3, 0x2c,
	0xec, 0x79, 0x31, 0x10, 0x6f, 0x1e, 0xf6, 0xa4, 0xa8, 0xce, 0x60, 0x64,
	0xe6, 0x2c, 0x3a, 0x8b, 0xbc, 0xc3, 0x5d, 0x3d, 0xcf, 0xd5, 0xe1, 0xbd,
	0x25, 0x82, 0x3e, 0x69, 0x5f, 0x5a, 0x52, 0x66, 0xf3, 0x9c, 0x73, 0xfa,
	0xc0, 0x1a, 0xc7, 0xfd, 0x9e, 0x7d, 0x89, 0x8a, 0xd6, 0x65, 0xae, 0x75,
	0x12, 0x7b, 0x2d, 0xc0, 0xfc, 0x37, 0x3f, 0xd8, 0xe1, 0x57, 0xe6, 0x41,
	0x20, 0x31, 0xc8, 0x92, 0xa1, 0x04, 0xb5, 0xdb, 0xce, 0x25, 0xfe, 0x34,
	0xe3, 0x32, 0xff, 0x0e, 0xb0, 0x37, 0x64, 0x0f, 0xeb, 0xaf, 0xec, 0x12,
	0xed, 0xef, 0xff, 0x13, 0xa9, 0xbf, 0x3f, 0xb6, 0xee, 0xa9, 0xcf, 0xdc,
	0x94, 0x3c, 0xc3, 0x89, 0xa7, 0xdf, 0x6a, 0xe6, 0x1b, 0x0b, 0xc1, 0x62,
	0x54, 0xa7, 0xa7, 0x58, 0xee, 0xe0, 0xa6, 0xeb, 0xdb, 0xdf, 0x5b, 0xac,
	0x52, 0xd8, 0x08, 0xaa, 0xea, 0xca, 0xd1, 0x9d, 0xeb, 0x7d, 0x15, 0xdf,
	0x08, 0xbc, 0xd7, 0x6d, 0x71, 0xbe, 0x4c, 0xaa, 0x83, 0xce, 0xed, 0x6c,
	0xb6, 0x2a, 0xf5, 0x72, 0x31, 0xbf, 0xc1, 0x2d, 0x29, 0x32, 0x23, 0xec,
	0x90, 0x3a, 0xfc, 0x10, 0x12, 0x30, 0xd6, 0x2e, 0xee, 0xa9, 0x99, 0x80,
	0xaa, 0xc5, 0x79, 0xd7, 0xed, 0x98, 0xea, 0x24, 0x12, 0x43, 0xf3, 0xd2,
	0x6a, 0xed, 0x62, 0xd8, 0x14, 0xf1, 0x51, 0x55, 0x8e, 0xd8, 0x8c, 0xbf,
	0xfe, 0x59, 0xa9, 0x45
};
static const uint8_t ac_rsassa_vect19_exp2[] = {
	0xd8, 0x59, 0x37, 0x5d, 0x1f, 0xd5, 0xa1, 0x48, 0xf6, 0x60, 0x6f, 0x10,
	0x85, 0xa9, 0x10, 0xaa, 0x8d, 0x1a, 0x94, 0x0d, 0x56, 0xe8, 0xa2, 0x45,
	0x32, 0x3b, 0x77, 0x62, 0x2e, 0x89, 0xb8, 0x51, 0x8f, 0x9b, 0xf5, 0xdd,
	0x83, 0xf8, 0xd5, 0xad, 0x6f, 0x5e, 0x85, 0x40, 0x98, 0x31, 0x25, 0xd5,
	0x13, 0x21, 0x59, 0x5f, 0x50, 0x27, 0x90, 0x2c, 0xb1, 0x7f, 0xdb, 0x2e,
	0xa9, 0xfc, 0xc4, 0xfb, 0x31, 0x18, 0x88, 0xdb, 0x93, 0x1a, 0x0e, 0xda,
	0x60, 0xc2, 0xfe, 0x98, 0xd1, 0xf6, 0x2b, 0x0d, 0xd2, 0xf4, 0x48, 0xe4,
	0x06, 0xeb, 0xc6, 0x18, 0xb0, 0x58, 0x66, 0xe6, 0x9b, 0x00, 0x7c, 0x72,
	0x75, 0xf4, 0x5a, 0x2a, 0x59, 0x26, 0xd4, 0x36, 0x6b, 0x03, 0x9f, 0x7d,
	0x05, 0x68, 0x34, 0xe9, 0x51, 0x2f, 0xf4, 0x71, 0x96, 0x93, 0xce, 0x55,
	0x2a, 0x5e, 0x36, 0x64, 0x21, 0x10, 0xa8, 0xbd, 0xb0, 0xc6, 0x85, 0xad,
	0x48, 0x6e, 0xdf, 0x81, 0x1c, 0xdc, 0x72, 0x18, 0xd6, 0xf8, 0xc1, 0xf4,
	0x20, 0x6c, 0xcd, 0x13, 0xeb, 0xd9, 0x15, 0xbf, 0x33, 0x35, 0xc1, 0x97,
	0x1f, 0x86, 0xe0, 0x97, 0xd5, 0x51, 0x22, 0x1c, 0xe0, 0x1b, 0xd3, 0x67,
	0x20, 0x06, 0x4d, 0x4d, 0xb3, 0xbd, 0x28, 0xd1, 0xb2, 0x2f, 0xcb, 0x90,
	0x92, 0xbc, 0xc3, 0x2e, 0x90, 0xac, 0x0e, 0x16, 0x0e, 0xe5, 0x03, 0x23,
	0x62, 0x76, 0x0f, 0xf1, 0xf0, 0xdd, 0x2a, 0xf0, 0xb0, 0x84, 0xc9, 0xeb,
	0x81, 0xf2, 0x8b, 0x65, 0x85, 0xff, 0x3a, 0x46, 0xf3, 0xb3, 0xc7, 0xbd,
	0x61, 0x66, 0x11, 0x45, 0x0a, 0x0e, 0xfb, 0x8a, 0x8e, 0x64, 0x83, 0x0c,
	0x59, 0x5e, 0x97, 0xef, 0x1c, 0x2f, 0x80, 0xec, 0x57, 0xd9, 0x60, 0x72,
	0x54, 0x53, 0x65, 0x42, 0x92, 0x4f, 0x0d, 0x97, 0x0a, 0x81, 0x77, 0x80,
	0xa8, 0x0a, 0x17, 0x83
};
static const uint8_t ac_rsassa_vect19_coeff[] = {
	0x47, 0xcc, 0x01, 0x3c, 0xe5, 0xd4, 0x0f, 0xce, 0xd4, 0x07, 0x20, 0x80,
	0x3b, 0xb3, 0xfc, 0x46, 0x34, 0x46, 0x8f, 0xe7, 0xf4, 0x31, 0xf4, 0x13,
	0x7b, 0x13, 0x3c, 0xb4, 0x55, 0x3d, 0x77, 0xcb, 0x38, 0xb4, 0xe1, 0x56,
	0x27, 0x96, 0xcd, 0x55, 0x4b, 0x73, 0x2e, 0xf6, 0x13, 0x3b, 0x9d, 0x23,
	0x01, 0x4d, 0x05, 0xce, 0x44, 0x46, 0xc4, 0xa3, 0xc6, 0x1d, 0x86, 0x16,
	0xcc, 0xf0, 0xe5, 0x66, 0xcf, 0xc0, 0xed, 0x35, 0x44, 0xe9, 0x58, 0x42,
	0x32, 0x9a, 0x5b, 0x6d, 0x47, 0xcc, 0x11, 0x7a, 0x79, 0x47, 0x46, 0x82,
	0xda, 0x57, 0x80, 0x8f, 0xe2, 0xf6, 0xd5, 0xc4, 0x71, 0x57, 0x1e, 0x1a,
	0xe5, 0x04, 0x06, 0x3e, 0x9e, 0xec, 0xcd, 0x16, 0x17, 0xaf, 0x25, 0x85,
	0xcd, 0xdb, 0x55, 0xce, 0x9b, 0xab, 0xbc, 0x57, 0x36, 0x66, 0x48, 0xdb,
	0x6c, 0x3a, 0x96, 0x71, 0x83, 0x90, 0x7a, 0xa4, 0x87, 0xb5, 0xcd, 0x6a,
	0x8a, 0x27, 0x21, 0x2c, 0xa5, 0xba, 0x62, 0x07, 0x28, 0xe3, 0x77, 0xca,
	0x19, 0xed, 0x7a, 0x55, 0xb8, 0x0c, 0x1c, 0x17, 0x08, 0xa6, 0xf6, 0xd3,
	0xda, 0x2c, 0x20, 0x25, 0xb9, 0xb7, 0x3e, 0x2e, 0xe6, 0x25, 0x32, 0xb2,
	0xc3, 0x06, 0x63, 0xfb, 0xfb, 0x16, 0x3f, 0x66, 0x18, 0x82, 0x0d, 0x15,
	0x37, 0x35, 0x97, 0x17, 0x79, 0xad, 0xd8, 0x96, 0xa1, 0x20, 0x51, 0xd5,
	0xb8, 0xb9, 0x53, 0x85, 0x20, 0xbe, 0x71, 0xac, 0xa3, 0xe6, 0x8d, 0xeb,
	0xef, 0x1b, 0x8e, 0x42, 0x89, 0xf4, 0x5c, 0x10, 0x80, 0x8a, 0xac, 0xe4,
	0xbf, 0xd1, 0xbd, 0x40, 0x47, 0x62, 0x95, 0xfb, 0xab, 0xd1, 0xac, 0x28,
	0x6c, 0xa4, 0xfc, 0xbb, 0x77, 0x1f, 0xdb, 0x91, 0xa7, 0xff, 0x90, 0x49,
	0x74, 0xee, 0x32, 0x28, 0xbc, 0x15, 0x44, 0x17, 0xdf, 0x30, 0x5a, 0xb6,
	0x91, 0xe2, 0x87, 0x02
};
static const uint8_t ac_rsassa_vect19_ptx[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c,
	0x0d, 0x0e, 0x0f, 0x10
};
static const uint8_t ac_rsassa_vect19_out[] = {
	0x5c, 0x9c, 0x79, 0x1b, 0xd1, 0x64, 0x6a, 0xb5, 0xc7, 0xd9, 0xb1, 0x7c,
	0xd0, 0x3b, 0x05, 0xae, 0x9f, 0x93, 0x36, 0xcd, 0xa3, 0x38, 0x1b, 0xc6,
	0x23, 0x81, 0x72, 0xd7, 0x57, 0xa4, 0x16, 0x07, 0x2c, 0xc0, 0x63, 0x38,
	0x01, 0x51, 0x58, 0x6d, 0x24, 0xcd, 0x7b, 0x24, 0x86, 0xd4, 0x5a, 0xb5,
	0x44, 0x47, 0x13, 0xc4, 0xaf, 0xce, 0x1d, 0x1e, 0x5d, 0x23, 0xb2, 0xe8,
	0xae, 0x14, 0x2f, 0x61, 0xf5, 0xf4, 0x7f, 0x37, 0x83, 0x1c, 0x55, 0xdb,
	0xb8, 0xd9, 0x27, 0xf4, 0xa7, 0x39, 0x77, 0x3b, 0x73, 0xdb, 0x1a, 0x1d,
	0xf7, 0x21, 0x82, 0xb7, 0xda, 0xce, 0x76, 0x90, 0xf2, 0xda, 0x18, 0x0b,
	0xf9, 0x11, 0x4f, 0x64, 0xc4, 0x1d, 0xe2, 0xd4, 0xd0, 0x6a, 0xfb, 0x6f,
	0x1b, 0x32, 0x2f, 0x4a, 0xcc, 0x6f, 0x5b, 0x28, 0x7f, 0x26, 0xe8, 0x4b,
	0x6e, 0x0a, 0x4b, 0x62, 0xef, 0xd9, 0x88, 0x23, 0x1c, 0xea, 0x4f, 0x1a,
	0x0a, 0x3a, 0xbd, 0xf6, 0x7d, 0xdc, 0xca, 0x57, 0xc8, 0x68, 0xa6, 0xb3,
	0x16, 0xa2, 0xe9, 0x6e, 0x56, 0x69, 0xc9, 0x62, 0xf4, 0x12, 0xf5, 0x48,
	0xcf, 0x34, 0x2a, 0x5b, 0x4f, 0xf1, 0x0c, 0xb6, 0x24, 0x04, 0x9d, 0x4f,
	0xb0, 0xd3, 0x11, 0x43, 0x29, 0x89, 0x99, 0x9b, 0xb1, 0xe3, 0x8c, 0x00,
	0x83, 0xe3, 0xbe, 0x94, 0xbf, 0x1f, 0xf1, 0x5c, 0x83, 0xe9, 0x01, 0xb9,
	0xec, 0x41, 0x73, 0x23, 0x98, 0x5e, 0x20, 0x91, 0xca, 0x56, 0x3f, 0x6f,
	0x6b, 0x50, 0x6d, 0x94, 0x3e, 0x2e, 0x1b, 0xb3, 0xc5, 0x74, 0x8f, 0x3a,
	0xaf, 0x21, 0x49, 0x7e, 0x9a, 0xe8, 0x85, 0x95, 0xd5, 0x87, 0xb1, 0xd7,
	0x0a, 0xf2, 0x35, 0x59, 0x1d, 0xe5, 0x8e, 0x9e, 0xc8, 0xa0, 0x84, 0xd1,
	0xdf, 0xea, 0x20, 0x16, 0x16, 0x1c, 0x35, 0x69, 0x37, 0x3d, 0x38, 0x3a,
	0x53, 0x97, 0x1f, 0xa8, 0x3a, 0xa6, 0x41, 0xc6, 0xd4, 0x7e, 0xac, 0xd3,
	0x9e, 0x24, 0x22, 0x9b, 0xb9, 0x6e, 0xfb, 0xd9, 0x23, 0x65, 0xd5, 0xda,
	0x28, 0xb3, 0x0c, 0x74, 0x8b, 0xb6, 0xfa, 0x5b, 0xd4, 0x1e, 0x95, 0x1c,
	0x08, 0xd0, 0x38, 0x7c, 0xef, 0x6e, 0xb3, 0xee, 0x5b, 0x3b, 0x66, 0xa9,
	0x5f, 0x74, 0xab, 0x29, 0x3c, 0x6d, 0x58, 0x51, 0x95, 0x5f, 0xb0, 0x68,
	0x5d, 0xc5, 0x78, 0xe4, 0x7a, 0x1c, 0x1d, 0x37, 0xde, 0xdf, 0xd9, 0xae,
	0xa0, 0x9b, 0xcd, 0x42, 0x60, 0x74, 0x07, 0x6d, 0xbc, 0x37, 0x80, 0x49,
	0x8f, 0xdf, 0x7e, 0x6e, 0x7d, 0x54, 0xde, 0x7f, 0x0c, 0x06, 0xb9, 0xe8,
	0xc2, 0x5b, 0xed, 0xaa, 0xe5, 0x87, 0xc7, 0xed, 0xe5, 0x90, 0x98, 0xbb,
	0xf4, 0xf3, 0x76, 0x96, 0x7f, 0xc1, 0xe8, 0x49, 0xbc, 0x78, 0x56, 0xf1,
	0x5e, 0x87, 0xbd, 0xca, 0xd9, 0xdb, 0xf7, 0xa4, 0x13, 0xc5, 0x32, 0x51,
	0x27, 0xa4, 0xeb, 0xd8, 0x1b, 0xf5, 0x37, 0xcd, 0x1c, 0xba, 0x7b, 0xb5,
	0x0c, 0xce, 0x71, 0xcb, 0x18, 0xfb, 0x61, 0x60, 0xe7, 0xc0, 0x06, 0xd0,
	0x09, 0xc7, 0xbf, 0x3f, 0x7b, 0x55, 0x52, 0x88, 0xa8, 0x7a, 0x94, 0xcf,
	0x15, 0x5d, 0x97, 0xba, 0x9a, 0xa8, 0xe2, 0x37, 0xe6, 0xe7, 0xf3, 0x2b,
	0xc2, 0xec, 0x33, 0x0b, 0xe7, 0x60, 0xa2, 0xc3, 0x63, 0x89, 0xc6, 0xf1,
	0xe5, 0xda, 0x13, 0xd5, 0xcc, 0x27, 0x35, 0xf8, 0x9f, 0xa8, 0x21, 0x49,
	0x09, 0x5b, 0x6b, 0xaf, 0x65, 0xbf, 0xb8, 0x6e, 0x5b, 0xf1, 0x61, 0xf4,
	0xd3, 0xe9, 0xb5, 0x20, 0x01, 0x40, 0xd6, 0x81, 0x1e, 0x4f, 0xcd, 0x77,
	0x51, 0x80, 0x6d, 0x69, 0xc7, 0xba, 0xf8, 0x2b, 0x38, 0x02, 0xa1, 0x9b,
	0x36, 0x8d, 0x56, 0xcf, 0x88, 0xb8, 0x71, 0x29, 0x08, 0x69, 0xbe, 0x68,
	0x98, 0x84, 0xbb, 0x38, 0xe7, 0xc0, 0x0f, 0x05
};

/*
 * Test data from ftp://ftp.rsa.com/pub/rsalabs/tmp/pkcs1v15sign-vectors.txt
 *
 * As specified in PKCS#1, the block type for this operation
 * is 1. The digest algorithm is SHA-1; i.e. the given message
 * must be hashed and the SHA-1 hash must be encapsulated in a
 * DigestInfo structure as specified in PKCS#1 v1.5.
 */

/* PKCS#1 v1.5 Signature Example 1 1024-bit RSA key pair */
static const uint8_t ac_rsassa_example1_modulus[] = {
	0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc,
	0x7e, 0xa8, 0x41, 0xd1,
	0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6,
	0x1f, 0x7a, 0xd9, 0x91,
	0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83,
	0xa1, 0x2a, 0x88, 0xa3,
	0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab,
	0xfc, 0xe0, 0xb1, 0xdf,
	0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6,
	0x71, 0xef, 0x63, 0x77,
	0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f,
	0xf8, 0x9d, 0x19, 0xf1,
	0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38,
	0x6b, 0x6f, 0x64, 0xc4,
	0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49,
	0xbd, 0x9a, 0x21, 0x37,
};
static const uint8_t ac_rsassa_example1_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_example1_priv_exp[] = {
	0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b,
	0xbb, 0xd0, 0xb4, 0x47,
	0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a,
	0x4b, 0xbe, 0x92, 0xe8,
	0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0,
	0x7c, 0x02, 0x66, 0xc8,
	0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44,
	0x29, 0xfc, 0x4d, 0x9a,
	0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7,
	0x34, 0xe4, 0x47, 0x27,
	0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba,
	0xca, 0xba, 0x28, 0x3c,
	0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3,
	0x4f, 0x9e, 0x50, 0x3b,
	0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47,
	0xc6, 0xa3, 0xb3, 0x25,
};
static const uint8_t ac_rsassa_example1_prime1[] = {
	0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56,
	0x05, 0x3e, 0xa2, 0xa1,
	0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d,
	0xfc, 0x96, 0x79, 0x48,
	0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09,
	0xa1, 0xdf, 0x55, 0xa1,
	0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e,
	0xda, 0x8e, 0x64, 0x43,
};
static const uint8_t ac_rsassa_example1_prime2[] = {
	0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90,
	0xfc, 0xca, 0x87, 0x4a,
	0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b,
	0x6e, 0x48, 0xde, 0x8d,
	0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5,
	0x42, 0xcd, 0x20, 0xdc,
	0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26,
	0x9a, 0x67, 0x99, 0xfd,
};
static const uint8_t ac_rsassa_example1_exp1[] = {
	0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba,
	0xca, 0x5a, 0x72, 0xea,
	0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36,
	0xc4, 0xf6, 0xe1, 0x9f,
	0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3,
	0xed, 0xe2, 0x44, 0x83,
	0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0,
	0x27, 0x86, 0x19, 0x79,
};
static const uint8_t ac_rsassa_example1_exp2[] = {
	0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f,
	0xb7, 0x9e, 0xe0, 0xa7,
	0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07,
	0xac, 0xb2, 0x1e, 0xd7,
	0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1,
	0x67, 0x82, 0x55, 0x82,
	0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82,
	0xa3, 0xf2, 0xe7, 0x29,
};
static const uint8_t ac_rsassa_example1_coeff[] = {
	0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28,
	0xcb, 0xfb, 0x27, 0xf5,
	0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94,
	0xfe, 0x93, 0x19, 0x58,
	0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b,
	0xa8, 0xd8, 0x58, 0x41,
	0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d,
	0x24, 0xa7, 0x9f, 0x4d,
};

/* PKCS#1 v1.5 Signature Example 1.1 */
#define ac_rsassa_vect3_modulus ac_rsassa_example1_modulus
#define ac_rsassa_vect3_pub_exp ac_rsassa_example1_pub_exp
#define ac_rsassa_vect3_priv_exp ac_rsassa_example1_priv_exp
#define ac_rsassa_vect3_prime1 ac_rsassa_example1_prime1
#define ac_rsassa_vect3_prime2 ac_rsassa_example1_prime2
#define ac_rsassa_vect3_exp1 ac_rsassa_example1_exp1
#define ac_rsassa_vect3_exp2 ac_rsassa_example1_exp2
#define ac_rsassa_vect3_coeff ac_rsassa_example1_coeff
static const uint8_t ac_rsassa_vect3_ptx[] = {
	0xcd, 0xc8, 0x7d, 0xa2, 0x23, 0xd7, 0x86, 0xdf, 0x3b, 0x45, 0xe0, 0xbb,
	0xbc, 0x72, 0x13, 0x26,
	0xd1, 0xee, 0x2a, 0xf8, 0x06, 0xcc, 0x31, 0x54, 0x75, 0xcc, 0x6f, 0x0d,
	0x9c, 0x66, 0xe1, 0xb6,
	0x23, 0x71, 0xd4, 0x5c, 0xe2, 0x39, 0x2e, 0x1a, 0xc9, 0x28, 0x44, 0xc3,
	0x10, 0x10, 0x2f, 0x15,
	0x6a, 0x0d, 0x8d, 0x52, 0xc1, 0xf4, 0xc4, 0x0b, 0xa3, 0xaa, 0x65, 0x09,
	0x57, 0x86, 0xcb, 0x76,
	0x97, 0x57, 0xa6, 0x56, 0x3b, 0xa9, 0x58, 0xfe, 0xd0, 0xbc, 0xc9, 0x84,
	0xe8, 0xb5, 0x17, 0xa3,
	0xd5, 0xf5, 0x15, 0xb2, 0x3b, 0x8a, 0x41, 0xe7, 0x4a, 0xa8, 0x67, 0x69,
	0x3f, 0x90, 0xdf, 0xb0,
	0x61, 0xa6, 0xe8, 0x6d, 0xfa, 0xae, 0xe6, 0x44, 0x72, 0xc0, 0x0e, 0x5f,
	0x20, 0x94, 0x57, 0x29,
	0xcb, 0xeb, 0xe7, 0x7f, 0x06, 0xce, 0x78, 0xe0, 0x8f, 0x40, 0x98, 0xfb,
	0xa4, 0x1f, 0x9d, 0x61,
	0x93, 0xc0, 0x31, 0x7e, 0x8b, 0x60, 0xd4, 0xb6, 0x08, 0x4a, 0xcb, 0x42,
	0xd2, 0x9e, 0x38, 0x08,
	0xa3, 0xbc, 0x37, 0x2d, 0x85, 0xe3, 0x31, 0x17, 0x0f, 0xcb, 0xf7, 0xcc,
	0x72, 0xd0, 0xb7, 0x1c,
	0x29, 0x66, 0x48, 0xb3, 0xa4, 0xd1, 0x0f, 0x41, 0x62, 0x95, 0xd0, 0x80,
	0x7a, 0xa6, 0x25, 0xca,
	0xb2, 0x74, 0x4f, 0xd9, 0xea, 0x8f, 0xd2, 0x23, 0xc4, 0x25, 0x37, 0x02,
	0x98, 0x28, 0xbd, 0x16,
	0xbe, 0x02, 0x54, 0x6f, 0x13, 0x0f, 0xd2, 0xe3, 0x3b, 0x93, 0x6d, 0x26,
	0x76, 0xe0, 0x8a, 0xed,
	0x1b, 0x73, 0x31, 0x8b, 0x75, 0x0a, 0x01, 0x67, 0xd0,
};
static const uint8_t ac_rsassa_vect3_out[] = {
	0x6b, 0xc3, 0xa0, 0x66, 0x56, 0x84, 0x29, 0x30, 0xa2, 0x47, 0xe3, 0x0d,
	0x58, 0x64, 0xb4, 0xd8,
	0x19, 0x23, 0x6b, 0xa7, 0xc6, 0x89, 0x65, 0x86, 0x2a, 0xd7, 0xdb, 0xc4,
	0xe2, 0x4a, 0xf2, 0x8e,
	0x86, 0xbb, 0x53, 0x1f, 0x03, 0x35, 0x8b, 0xe5, 0xfb, 0x74, 0x77, 0x7c,
	0x60, 0x86, 0xf8, 0x50,
	0xca, 0xef, 0x89, 0x3f, 0x0d, 0x6f, 0xcc, 0x2d, 0x0c, 0x91, 0xec, 0x01,
	0x36, 0x93, 0xb4, 0xea,
	0x00, 0xb8, 0x0c, 0xd4, 0x9a, 0xac, 0x4e, 0xcb, 0x5f, 0x89, 0x11, 0xaf,
	0xe5, 0x39, 0xad, 0xa4,
	0xa8, 0xf3, 0x82, 0x3d, 0x1d, 0x13, 0xe4, 0x72, 0xd1, 0x49, 0x05, 0x47,
	0xc6, 0x59, 0xc7, 0x61,
	0x7f, 0x3d, 0x24, 0x08, 0x7d, 0xdb, 0x6f, 0x2b, 0x72, 0x09, 0x61, 0x67,
	0xfc, 0x09, 0x7c, 0xab,
	0x18, 0xe9, 0xa4, 0x58, 0xfc, 0xb6, 0x34, 0xcd, 0xce, 0x8e, 0xe3, 0x58,
	0x94, 0xc4, 0x84, 0xd7,
};

/* PKCS#1 v1.5 Signature Example 1.2 */
#define ac_rsassa_vect4_modulus ac_rsassa_example1_modulus
#define ac_rsassa_vect4_pub_exp ac_rsassa_example1_pub_exp
#define ac_rsassa_vect4_priv_exp ac_rsassa_example1_priv_exp
#define ac_rsassa_vect4_prime1 ac_rsassa_example1_prime1
#define ac_rsassa_vect4_prime2 ac_rsassa_example1_prime2
#define ac_rsassa_vect4_exp1 ac_rsassa_example1_exp1
#define ac_rsassa_vect4_exp2 ac_rsassa_example1_exp2
#define ac_rsassa_vect4_coeff ac_rsassa_example1_coeff
static const uint8_t ac_rsassa_vect4_ptx[] = {
	0x85, 0x13, 0x84, 0xcd, 0xfe, 0x81, 0x9c, 0x22, 0xed, 0x6c, 0x4c, 0xcb,
	0x30, 0xda, 0xeb, 0x5c,
	0xf0, 0x59, 0xbc, 0x8e, 0x11, 0x66, 0xb7, 0xe3, 0x53, 0x0c, 0x4c, 0x23,
	0x3e, 0x2b, 0x5f, 0x8f,
	0x71, 0xa1, 0xcc, 0xa5, 0x82, 0xd4, 0x3e, 0xcc, 0x72, 0xb1, 0xbc, 0xa1,
	0x6d, 0xfc, 0x70, 0x13,
	0x22, 0x6b, 0x9e,
};
static const uint8_t ac_rsassa_vect4_out[] = {
	0x84, 0xfd, 0x2c, 0xe7, 0x34, 0xec, 0x1d, 0xa8, 0x28, 0xd0, 0xf1, 0x5b,
	0xf4, 0x9a, 0x87, 0x07,
	0xc1, 0x5d, 0x05, 0x94, 0x81, 0x36, 0xde, 0x53, 0x7a, 0x3d, 0xb4, 0x21,
	0x38, 0x41, 0x67, 0xc8,
	0x6f, 0xae, 0x02, 0x25, 0x87, 0xee, 0x9e, 0x13, 0x7d, 0xae, 0xe7, 0x54,
	0x73, 0x82, 0x62, 0x93,
	0x2d, 0x27, 0x1c, 0x74, 0x4c, 0x6d, 0x3a, 0x18, 0x9a, 0xd4, 0x31, 0x1b,
	0xdb, 0x02, 0x04, 0x92,
	0xe3, 0x22, 0xfb, 0xdd, 0xc4, 0x04, 0x06, 0xea, 0x86, 0x0d, 0x4e, 0x8e,
	0xa2, 0xa4, 0x08, 0x4a,
	0xa9, 0x8b, 0x96, 0x22, 0xa4, 0x46, 0x75, 0x6f, 0xdb, 0x74, 0x0d, 0xdb,
	0x3d, 0x91, 0xdb, 0x76,
	0x70, 0xe2, 0x11, 0x66, 0x1b, 0xbf, 0x87, 0x09, 0xb1, 0x1c, 0x08, 0xa7,
	0x07, 0x71, 0x42, 0x2d,
	0x1a, 0x12, 0xde, 0xf2, 0x9f, 0x06, 0x88, 0xa1, 0x92, 0xae, 0xbd, 0x89,
	0xe0, 0xf8, 0x96, 0xf8,
};

/* PKCS#1 v1.5 Signature Example 1.3 */
#define ac_rsassa_vect5_modulus ac_rsassa_example1_modulus
#define ac_rsassa_vect5_pub_exp ac_rsassa_example1_pub_exp
#define ac_rsassa_vect5_priv_exp ac_rsassa_example1_priv_exp
#define ac_rsassa_vect5_prime1 ac_rsassa_example1_prime1
#define ac_rsassa_vect5_prime2 ac_rsassa_example1_prime2
#define ac_rsassa_vect5_exp1 ac_rsassa_example1_exp1
#define ac_rsassa_vect5_exp2 ac_rsassa_example1_exp2
#define ac_rsassa_vect5_coeff ac_rsassa_example1_coeff
static const uint8_t ac_rsassa_vect5_ptx[] = {
	0xa4, 0xb1, 0x59, 0x94, 0x17, 0x61, 0xc4, 0x0c, 0x6a, 0x82, 0xf2, 0xb8,
	0x0d, 0x1b, 0x94, 0xf5,
	0xaa, 0x26, 0x54, 0xfd, 0x17, 0xe1, 0x2d, 0x58, 0x88, 0x64, 0x67, 0x9b,
	0x54, 0xcd, 0x04, 0xef,
	0x8b, 0xd0, 0x30, 0x12, 0xbe, 0x8d, 0xc3, 0x7f, 0x4b, 0x83, 0xaf, 0x79,
	0x63, 0xfa, 0xff, 0x0d,
	0xfa, 0x22, 0x54, 0x77, 0x43, 0x7c, 0x48, 0x01, 0x7f, 0xf2, 0xbe, 0x81,
	0x91, 0xcf, 0x39, 0x55,
	0xfc, 0x07, 0x35, 0x6e, 0xab, 0x3f, 0x32, 0x2f, 0x7f, 0x62, 0x0e, 0x21,
	0xd2, 0x54, 0xe5, 0xdb,
	0x43, 0x24, 0x27, 0x9f, 0xe0, 0x67, 0xe0, 0x91, 0x0e, 0x2e, 0x81, 0xca,
	0x2c, 0xab, 0x31, 0xc7,
	0x45, 0xe6, 0x7a, 0x54, 0x05, 0x8e, 0xb5, 0x0d, 0x99, 0x3c, 0xdb, 0x9e,
	0xd0, 0xb4, 0xd0, 0x29,
	0xc0, 0x6d, 0x21, 0xa9, 0x4c, 0xa6, 0x61, 0xc3, 0xce, 0x27, 0xfa, 0xe1,
	0xd6, 0xcb, 0x20, 0xf4,
	0x56, 0x4d, 0x66, 0xce, 0x47, 0x67, 0x58, 0x3d, 0x0e, 0x5f, 0x06, 0x02,
	0x15, 0xb5, 0x90, 0x17,
	0xbe, 0x85, 0xea, 0x84, 0x89, 0x39, 0x12, 0x7b, 0xd8, 0xc9, 0xc4, 0xd4,
	0x7b, 0x51, 0x05, 0x6c,
	0x03, 0x1c, 0xf3, 0x36, 0xf1, 0x7c, 0x99, 0x80, 0xf3, 0xb8, 0xf5, 0xb9,
	0xb6, 0x87, 0x8e, 0x8b,
	0x79, 0x7a, 0xa4, 0x3b, 0x88, 0x26, 0x84, 0x33, 0x3e, 0x17, 0x89, 0x3f,
	0xe9, 0xca, 0xa6, 0xaa,
	0x29, 0x9f, 0x7e, 0xd1, 0xa1, 0x8e, 0xe2, 0xc5, 0x48, 0x64, 0xb7, 0xb2,
	0xb9, 0x9b, 0x72, 0x61,
	0x8f, 0xb0, 0x25, 0x74, 0xd1, 0x39, 0xef, 0x50, 0xf0, 0x19, 0xc9, 0xee,
	0xf4, 0x16, 0x97, 0x13,
	0x38, 0xe7, 0xd4, 0x70
};
static const uint8_t ac_rsassa_vect5_out[] = {
	0x0b, 0x1f, 0x2e, 0x51, 0x80, 0xe5, 0xc7, 0xb4, 0xb5, 0xe6, 0x72, 0x92,
	0x9f, 0x66, 0x4c, 0x48,
	0x96, 0xe5, 0x0c, 0x35, 0x13, 0x4b, 0x6d, 0xe4, 0xd5, 0xa9, 0x34, 0x25,
	0x2a, 0x3a, 0x24, 0x5f,
	0xf4, 0x83, 0x40, 0x92, 0x0e, 0x10, 0x34, 0xb7, 0xd5, 0xa5, 0xb5, 0x24,
	0xeb, 0x0e, 0x1c, 0xf1,
	0x2b, 0xef, 0xef, 0x49, 0xb2, 0x7b, 0x73, 0x2d, 0x2c, 0x19, 0xe1, 0xc4,
	0x32, 0x17, 0xd6, 0xe1,
	0x41, 0x73, 0x81, 0x11, 0x1a, 0x1d, 0x36, 0xde, 0x63, 0x75, 0xcf, 0x45,
	0x5b, 0x3c, 0x98, 0x12,
	0x63, 0x9d, 0xbc, 0x27, 0x60, 0x0c, 0x75, 0x19, 0x94, 0xfb, 0x61, 0x79,
	0x9e, 0xcf, 0x7d, 0xa6,
	0xbc, 0xf5, 0x15, 0x40, 0xaf, 0xd0, 0x17, 0x4d, 0xb4, 0x03, 0x31, 0x88,
	0x55, 0x66, 0x75, 0xb1,
	0xd7, 0x63, 0x36, 0x0a, 0xf4, 0x6f, 0xee, 0xca, 0x5b, 0x60, 0xf8, 0x82,
	0x82, 0x9e, 0xe7, 0xb2,
};

/* PKCS#1 v1.5 Signature Example 1.4 */
#define ac_rsassa_vect6_modulus ac_rsassa_example1_modulus
#define ac_rsassa_vect6_pub_exp ac_rsassa_example1_pub_exp
#define ac_rsassa_vect6_priv_exp ac_rsassa_example1_priv_exp
#define ac_rsassa_vect6_prime1 ac_rsassa_example1_prime1
#define ac_rsassa_vect6_prime2 ac_rsassa_example1_prime2
#define ac_rsassa_vect6_exp1 ac_rsassa_example1_exp1
#define ac_rsassa_vect6_exp2 ac_rsassa_example1_exp2
#define ac_rsassa_vect6_coeff ac_rsassa_example1_coeff
static const uint8_t ac_rsassa_vect6_ptx[] = {
	0xbc, 0x65, 0x67, 0x47, 0xfa, 0x9e, 0xaf, 0xb3, 0xf0
};
static const uint8_t ac_rsassa_vect6_out[] = {
	0x45, 0x60, 0x7a, 0xd6, 0x11, 0xcf, 0x57, 0x47, 0xa4, 0x1a, 0xc9, 0x4d,
	0x0f, 0xfe, 0xc8, 0x78,
	0xbd, 0xaf, 0x63, 0xf6, 0xb5, 0x7a, 0x4b, 0x08, 0x8b, 0xf3, 0x6e, 0x34,
	0xe1, 0x09, 0xf8, 0x40,
	0xf2, 0x4b, 0x74, 0x2a, 0xda, 0x16, 0x10, 0x2d, 0xab, 0xf9, 0x51, 0xcb,
	0xc4, 0x4f, 0x89, 0x82,
	0xe9, 0x4e, 0xd4, 0xcd, 0x09, 0x44, 0x8d, 0x20, 0xec, 0x0e, 0xfa, 0x73,
	0x54, 0x5f, 0x80, 0xb6,
	0x54, 0x06, 0xbe, 0xd6, 0x19, 0x4a, 0x61, 0xc3, 0x40, 0xb4, 0xad, 0x15,
	0x68, 0xcb, 0xb7, 0x58,
	0x51, 0x04, 0x9f, 0x11, 0xaf, 0x17, 0x34, 0x96, 0x40, 0x76, 0xe0, 0x20,
	0x29, 0xae, 0xe2, 0x00,
	0xe4, 0x0e, 0x80, 0xbe, 0x0f, 0x43, 0x61, 0xf6, 0x98, 0x41, 0xc4, 0xf9,
	0x2a, 0x44, 0x50, 0xa2,
	0x28, 0x6d, 0x43, 0x28, 0x9b, 0x40, 0x55, 0x54, 0xc5, 0x4d, 0x25, 0xc6,
	0xec, 0xb5, 0x84, 0xf4,
};

/* PKCS#1 v1.5 Signature Example 7 1025-bit RSA key pair */
static const uint8_t ac_rsassa_example2_modulus[] = {
	0x01, 0x69, 0x34, 0xcd, 0xff, 0x48, 0x50, 0xb6, 0x00, 0x2c, 0xc0, 0xf0,
	0xf4, 0x01, 0x0a, 0x32,
	0xc6, 0x55, 0xe5, 0xcf, 0x6e, 0x7c, 0x89, 0x93, 0x7f, 0xd7, 0x55, 0xef,
	0x6a, 0xbe, 0x37, 0x9d,
	0xad, 0xde, 0x70, 0xcc, 0x21, 0x77, 0x51, 0xf1, 0x4c, 0xba, 0x6d, 0x90,
	0xfe, 0x52, 0xdc, 0x0a,
	0xf5, 0x8b, 0x25, 0x2f, 0x26, 0xbf, 0x72, 0xda, 0x57, 0x9f, 0xda, 0xf5,
	0x7d, 0xdd, 0x6c, 0xd6,
	0x02, 0x18, 0x79, 0x94, 0x9a, 0x02, 0x76, 0xb4, 0x43, 0x3f, 0xf0, 0x1e,
	0xfc, 0xcc, 0xf3, 0x5a,
	0x11, 0xe7, 0xc7, 0x7b, 0x38, 0xc1, 0x8c, 0xca, 0x94, 0xae, 0x01, 0x2d,
	0x0f, 0x37, 0x04, 0x21,
	0x49, 0x1c, 0x52, 0xad, 0x15, 0xac, 0x76, 0xb1, 0x2e, 0xcd, 0x21, 0x8f,
	0x52, 0xe7, 0x57, 0x86,
	0x6e, 0x08, 0x9d, 0xd8, 0xad, 0xbb, 0x48, 0xe9, 0xba, 0x89, 0x43, 0x36,
	0xc5, 0x75, 0xc4, 0x06,
	0x55
};
static const uint8_t ac_rsassa_example2_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsassa_example2_priv_exp[] = {
	0x0d, 0x17, 0x19, 0xe5, 0xbd, 0x47, 0x6d, 0x87, 0xc7, 0xec, 0xc3, 0x1e,
	0xb8, 0xab, 0x42, 0x5d,
	0x4f, 0xe4, 0xc8, 0xf5, 0xc7, 0xae, 0x23, 0x0a, 0x10, 0x47, 0x55, 0x3f,
	0xfb, 0x53, 0x9f, 0xd3,
	0x85, 0x5a, 0xf5, 0xa4, 0x3b, 0x2d, 0xdd, 0x4e, 0x95, 0xa2, 0xb3, 0x0d,
	0x40, 0x7a, 0xa8, 0x81,
	0x59, 0xbb, 0xad, 0x2a, 0x87, 0x3d, 0x80, 0x93, 0xb4, 0x8a, 0x4b, 0xce,
	0x20, 0xad, 0x99, 0x26,
	0x25, 0x3e, 0xd3, 0x39, 0xac, 0x3b, 0x54, 0x3f, 0xc7, 0x42, 0x96, 0x95,
	0x33, 0x8d, 0xb0, 0xbc,
	0x1d, 0xc3, 0x68, 0x6c, 0xfd, 0x13, 0x9b, 0xb5, 0xb2, 0x87, 0x36, 0xbc,
	0x16, 0x60, 0xa9, 0x53,
	0x48, 0xfc, 0x91, 0xc3, 0x25, 0xd0, 0x3a, 0x7f, 0xb2, 0x16, 0xd2, 0xd9,
	0xcd, 0x93, 0x64, 0xde,
	0x4e, 0xe7, 0xd2, 0x11, 0x9c, 0x3b, 0x0f, 0xbb, 0xa8, 0xa7, 0x1f, 0x0d,
	0x3f, 0x5a, 0xb9, 0xb9,
};
static const uint8_t ac_rsassa_example2_prime1[] = {
	0x01, 0x58, 0xc0, 0x24, 0x6c, 0xd1, 0x69, 0xfc, 0x59, 0x3b, 0x25, 0x8b,
	0xbf, 0x45, 0x23, 0xab,
	0x2b, 0x55, 0xc4, 0x60, 0x73, 0x3a, 0x7f, 0xb4, 0x69, 0x10, 0x90, 0x77,
	0xb3, 0x0e, 0x4d, 0x35,
	0xf2, 0x1a, 0x35, 0xb1, 0xf4, 0x1e, 0x42, 0x04, 0xe8, 0x1d, 0x2e, 0x4c,
	0x46, 0x3c, 0x24, 0x11,
	0x39, 0x34, 0x09, 0x8b, 0x45, 0x2d, 0xab, 0x4b, 0xe1, 0x59, 0x97, 0x20,
	0xef, 0x68, 0x72, 0x83,
	0x3d
};
static const uint8_t ac_rsassa_example2_prime2[] = {
	0x01, 0x0c, 0x38, 0x2d, 0xea, 0x5e, 0x7d, 0x79, 0x29, 0x8c, 0x64, 0x1f,
	0xb2, 0xe4, 0xfa, 0x09,
	0xf2, 0x4f, 0x6a, 0x7a, 0x45, 0x9a, 0x88, 0x2c, 0x87, 0xa8, 0x03, 0x49,
	0x5f, 0x05, 0x6e, 0xcc,
	0x3b, 0x43, 0xc5, 0x37, 0x73, 0x1f, 0x85, 0xef, 0xc8, 0xfb, 0x53, 0x87,
	0xad, 0x67, 0x31, 0xa6,
	0x43, 0x53, 0x32, 0x15, 0xde, 0xcc, 0x38, 0x7d, 0x96, 0x76, 0x12, 0x2c,
	0x17, 0x0e, 0x91, 0xe0,
	0xf9
};
static const uint8_t ac_rsassa_example2_exp1[] = {
	0xd5, 0x78, 0xdc, 0xd5, 0x38, 0xf2, 0xfc, 0xdc, 0x30, 0x00, 0xb6, 0xc0,
	0xf0, 0x49, 0xfe, 0xe2,
	0xad, 0x90, 0x14, 0xfd, 0x24, 0xfb, 0x10, 0xb6, 0x82, 0x18, 0x42, 0xd6,
	0x70, 0x03, 0xa5, 0x64,
	0xcd, 0x8f, 0xf4, 0x2a, 0x2a, 0x56, 0x4c, 0xfd, 0x81, 0x9c, 0x3a, 0x84,
	0xbf, 0x16, 0xc2, 0x47,
	0x7e, 0x8e, 0x6e, 0x5b, 0x9e, 0xc4, 0xd4, 0x0e, 0xad, 0x50, 0x24, 0x87,
	0xba, 0x50, 0x36, 0x2d,
};
static const uint8_t ac_rsassa_example2_exp2[] = {
	0x88, 0x88, 0xdc, 0x8e, 0xae, 0x94, 0xee, 0xa5, 0x80, 0xca, 0xc2, 0xfc,
	0x1c, 0xe5, 0x4f, 0x44,
	0xe2, 0xba, 0x50, 0x0d, 0xb8, 0x71, 0x53, 0x41, 0xa6, 0xfc, 0x2d, 0x50,
	0x4a, 0x82, 0xb1, 0x42,
	0x05, 0xe8, 0x91, 0xa6, 0x6f, 0xc8, 0x8d, 0x5c, 0x60, 0xdb, 0x8f, 0x78,
	0x6c, 0xcc, 0x70, 0x57,
	0x5b, 0x35, 0x66, 0xbe, 0xa8, 0x74, 0xa5, 0x31, 0x7f, 0x5f, 0x16, 0xc4,
	0x91, 0xed, 0x1e, 0x79,
};
static const uint8_t ac_rsassa_example2_coeff[] = {
	0x17, 0xb0, 0xd6, 0x23, 0x36, 0x19, 0x1e, 0x63, 0xbc, 0xa1, 0x59, 0x93,
	0x4d, 0x06, 0x16, 0xcb,
	0x89, 0x97, 0x40, 0x9c, 0xbf, 0xca, 0x37, 0x05, 0x69, 0x5b, 0x14, 0xfb,
	0x64, 0xa0, 0x81, 0xc1,
	0xc9, 0xf5, 0x86, 0x19, 0x3e, 0x52, 0x3a, 0xbd, 0x0b, 0xeb, 0x8d, 0x72,
	0x0c, 0xfe, 0x53, 0x7d,
	0xfa, 0x1e, 0xde, 0xc4, 0xa6, 0x64, 0x37, 0xd2, 0x41, 0x19, 0x6b, 0x7a,
	0x2c, 0xe5, 0x56, 0xc4,
};


/* PKCS#1 v1.5 Signature Example 7.1 */
#define ac_rsassa_vect7_modulus ac_rsassa_example2_modulus
#define ac_rsassa_vect7_pub_exp ac_rsassa_example2_pub_exp
#define ac_rsassa_vect7_priv_exp ac_rsassa_example2_priv_exp
#define ac_rsassa_vect7_prime1 ac_rsassa_example2_prime1
#define ac_rsassa_vect7_prime2 ac_rsassa_example2_prime2
#define ac_rsassa_vect7_exp1 ac_rsassa_example2_exp1
#define ac_rsassa_vect7_exp2 ac_rsassa_example2_exp2
#define ac_rsassa_vect7_coeff ac_rsassa_example2_coeff
static const uint8_t ac_rsassa_vect7_ptx[] = {
	0x35, 0x39, 0x99, 0x7a, 0xe7, 0x09, 0xfe, 0x32, 0xc1, 0x03, 0x6a, 0x13,
	0x27, 0x57, 0xf2, 0xa1,
	0x66, 0x7a, 0x91, 0xcc, 0x83, 0xbe, 0x73, 0x3a, 0xad, 0xa1, 0xbd, 0xd2,
	0x17, 0x92, 0x4c, 0x9a,
	0x2c, 0x9f, 0xed, 0x1f, 0xec, 0xf6, 0x1d, 0x1c, 0xf7, 0x9d, 0xae, 0x9a,
	0x83, 0xf8, 0xae, 0x3f,
	0x4d, 0x05, 0x1b, 0x34, 0xfb, 0xb5, 0x59, 0xcb, 0xfd, 0xa4, 0x92, 0xf1,
	0xd8, 0x3b, 0x8b, 0xeb,
	0xa0, 0x45, 0xd4, 0xae, 0x1c, 0x8f, 0xea, 0x15, 0xb7, 0x57, 0x7a, 0x1b,
	0x8a, 0x3f, 0x55, 0xba,
	0xc1, 0x72, 0x7e, 0xdc, 0xa7, 0xf8, 0xf5, 0x2c, 0xb4, 0xba, 0x61, 0xca,
	0xf1, 0xfa, 0x8f, 0x8f,
	0xd9, 0xaa, 0xc7, 0x79, 0x09, 0x5c, 0xa8, 0x4c, 0x79, 0x91, 0x52, 0x9f,
	0xb8, 0x06, 0x99, 0xd0,
	0xd4, 0x68, 0x8d, 0xfd, 0xb1, 0x42, 0xed, 0x61, 0xa9, 0x5b, 0x89, 0xce,
	0x33, 0x06, 0xbf, 0x97,
	0x80, 0xe1, 0xb9, 0x1b, 0x84, 0x8c, 0x8d, 0x20, 0x03, 0x97, 0x0e, 0x52,
	0x70, 0x2a, 0x1f, 0x61,
	0x2e, 0x2f, 0x40, 0x17, 0xcf, 0xe0, 0xa9, 0x1d, 0xb9, 0xe4, 0x6d, 0xb9,
	0xdc
};
static const uint8_t ac_rsassa_vect7_out[] = {
	0x00, 0x08, 0x0f, 0x77, 0x0a, 0x2d, 0x1f, 0x6a, 0xbf, 0x5f, 0x22, 0x1f,
	0x62, 0xe1, 0x66, 0xab,
	0xd7, 0x9d, 0x06, 0xc7, 0xb9, 0xa8, 0x78, 0xd6, 0x1b, 0x80, 0xfc, 0x4d,
	0x5b, 0xa2, 0x90, 0xb2,
	0x3a, 0xba, 0xab, 0x51, 0x8f, 0x09, 0x44, 0x7e, 0x45, 0xae, 0xe6, 0xf3,
	0xbd, 0x06, 0x10, 0x24,
	0x44, 0x36, 0xa4, 0x73, 0x01, 0x60, 0xe6, 0xa6, 0x72, 0x11, 0x0c, 0x01,
	0xae, 0xb5, 0x62, 0x4b,
	0x71, 0x8d, 0xc7, 0xc0, 0x86, 0x1e, 0x58, 0x6b, 0xa8, 0xb6, 0x0a, 0x29,
	0xd6, 0xa5, 0x75, 0x5c,
	0xd2, 0xcc, 0x50, 0x85, 0x99, 0xc6, 0xe2, 0x8d, 0x73, 0x55, 0xb2, 0x7e,
	0x40, 0xb7, 0x40, 0xc6,
	0xfb, 0xbb, 0xb1, 0xa9, 0x18, 0x23, 0xb1, 0xc1, 0x24, 0x2b, 0xa6, 0x93,
	0xd4, 0x52, 0x69, 0x51,
	0x47, 0xdb, 0xb2, 0x3e, 0xa8, 0x9c, 0xbf, 0x11, 0xeb, 0x8b, 0x07, 0xec,
	0x3a, 0x02, 0x7b, 0x0f,
	0x17
};

/*
 * Test data from 186-2rsatestvectors.zip SigVet15_186-3.rsp with CRT
 * parameters created with:
 * http://sourceforge.net/projects/rsaconverter/
 */

/* SigGen15_186-2.txt line 9 mod 1024 */
static const uint8_t ac_siggen15_186_2_modulus[] = {
	0xc8, 0xa2, 0x06, 0x91, 0x82, 0x39, 0x4a, 0x2a, 0xb7, 0xc3, 0xf4, 0x19,
	0x0c, 0x15, 0x58, 0x9c, 0x56, 0xa2, 0xd4, 0xbc, 0x42, 0xdc, 0xa6, 0x75,
	0xb3, 0x4c, 0xc9, 0x50, 0xe2, 0x46, 0x63, 0x04, 0x84, 0x41, 0xe8, 0xaa,
	0x59, 0x3b, 0x2b, 0xc5, 0x9e, 0x19, 0x8b, 0x8c, 0x25, 0x7e, 0x88, 0x21,
	0x20, 0xc6, 0x23, 0x36, 0xe5, 0xcc, 0x74, 0x50, 0x12, 0xc7, 0xff, 0xb0,
	0x63, 0xee, 0xbe, 0x53, 0xf3, 0xc6, 0x50, 0x4c, 0xba, 0x6c, 0xfe, 0x51,
	0xba, 0xa3, 0xb6, 0xd1, 0x07, 0x4b, 0x2f, 0x39, 0x81, 0x71, 0xf4, 0xb1,
	0x98, 0x2f, 0x4d, 0x65, 0xca, 0xf8, 0x82, 0xea, 0x4d, 0x56, 0xf3, 0x2a,
	0xb5, 0x7d, 0x0c, 0x44, 0xe6, 0xad, 0x4e, 0x9c, 0xf5, 0x7a, 0x43, 0x39,
	0xeb, 0x69, 0x62, 0x40, 0x6e, 0x35, 0x0c, 0x1b, 0x15, 0x39, 0x71, 0x83,
	0xfb, 0xf1, 0xf0, 0x35, 0x3c, 0x9f, 0xc9, 0x91
};
static const uint8_t ac_siggen15_186_2_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_siggen15_186_2_priv_exp[] = {
	0x5d, 0xfc, 0xb1, 0x11, 0x07, 0x2d, 0x29, 0x56, 0x5b, 0xa1, 0xdb, 0x3e,
	0xc4, 0x8f, 0x57, 0x64, 0x5d, 0x9d, 0x88, 0x04, 0xed, 0x59, 0x8a, 0x4d,
	0x47, 0x02, 0x68, 0xa8, 0x90, 0x67, 0xa2, 0xc9, 0x21, 0xdf, 0xf2, 0x4b,
	0xa2, 0xe3, 0x7a, 0x3c, 0xe8, 0x34, 0x55, 0x50, 0x00, 0xdc, 0x86, 0x8e,
	0xe6, 0x58, 0x8b, 0x74, 0x93, 0x30, 0x35, 0x28, 0xb1, 0xb3, 0xa9, 0x4f,
	0x0b, 0x71, 0x73, 0x0c, 0xf1, 0xe8, 0x6f, 0xca, 0x5a, 0xee, 0xdc, 0x3a,
	0xfa, 0x16, 0xf6, 0x5c, 0x01, 0x89, 0xd8, 0x10, 0xdd, 0xcd, 0x81, 0x04,
	0x9e, 0xbb, 0xd0, 0x39, 0x18, 0x68, 0xc5, 0x0e, 0xde, 0xc9, 0x58, 0xb3,
	0xa2, 0xaa, 0xef, 0xf6, 0xa5, 0x75, 0x89, 0x7e, 0x2f, 0x20, 0xa3, 0xab,
	0x54, 0x55, 0xc1, 0xbf, 0xa5, 0x50, 0x10, 0xac, 0x51, 0xa7, 0x79, 0x9b,
	0x1f, 0xf8, 0x48, 0x36, 0x44, 0xa3, 0xd4, 0x25
};
static const uint8_t ac_siggen15_186_2_prime1[] = {
	0xF6, 0x6A, 0x24, 0x68, 0xB1, 0x48, 0x1A, 0x0D, 0x6B, 0x60, 0x49, 0x67,
	0xF0, 0x58, 0x03, 0x89, 0xD6, 0x06, 0x1F, 0x03, 0x3A, 0x9B, 0x57, 0xB7,
	0x4D, 0x1B, 0xEF, 0xE8, 0x10, 0x11, 0x98, 0x94, 0x5B, 0x80, 0x93, 0x04,
	0x24, 0x1D, 0x02, 0xFD, 0x5F, 0x92, 0x1F, 0xE9, 0x59, 0xFB, 0xEC, 0xDB,
	0x18, 0x00, 0x54, 0x86, 0x9A, 0xDB, 0x17, 0xD3, 0x21, 0xF9, 0xD5, 0xD5,
	0x98, 0x12, 0x3E, 0x73
};
static const uint8_t ac_siggen15_186_2_prime2[] = {
	0xD0, 0x6F, 0xFA, 0x56, 0x3B, 0xD0, 0xB8, 0xB9, 0x7F, 0x00, 0x72, 0xEA,
	0x07, 0x51, 0x03, 0xEC, 0x1F, 0xF0, 0xB1, 0x7F, 0xD6, 0xBD, 0xAF, 0x94,
	0xA7, 0x5A, 0xE6, 0x03, 0x59, 0x82, 0xF6, 0x80, 0x24, 0x9D, 0x77, 0xCC,
	0x15, 0x96, 0xA6, 0x54, 0xF1, 0x4C, 0x51, 0x7A, 0x13, 0xB9, 0x5F, 0x1A,
	0x8C, 0x5D, 0xE8, 0xCC, 0x84, 0xAD, 0x38, 0xD2, 0xE6, 0xAA, 0x4F, 0xCD,
	0x54, 0x1A, 0x32, 0xEB
};
static const uint8_t ac_siggen15_186_2_exp1[] = {
	0xD4, 0xD4, 0xB6, 0x9F, 0xCA, 0x47, 0x89, 0x60, 0xFF, 0xD6, 0x49, 0x70,
	0xC1, 0xD1, 0x73, 0x34, 0xF1, 0x2B, 0x96, 0x4B, 0xB6, 0xAA, 0x07, 0xA8,
	0x25, 0xAC, 0xB4, 0x98, 0xCE, 0x90, 0x34, 0x26, 0x27, 0xA6, 0x34, 0xD5,
	0x05, 0xD0, 0x1D, 0x0D, 0xF5, 0x27, 0x03, 0xF3, 0x0C, 0x2A, 0xA0, 0xD8,
	0x57, 0xB1, 0xA9, 0x50, 0x1D, 0x9E, 0x90, 0xC4, 0x66, 0x7B, 0x20, 0x6B,
	0x7D, 0x0E, 0x7C, 0xEB
};
static const uint8_t ac_siggen15_186_2_exp2[] = {
	0x28, 0x4F, 0xEF, 0xE7, 0xAB, 0xAB, 0xE3, 0x7E, 0x24, 0xBC, 0xEE, 0x7C,
	0xAA, 0xAB, 0x95, 0x89, 0x9E, 0x67, 0xCB, 0xBC, 0x80, 0xC8, 0xB0, 0xE3,
	0x9C, 0x36, 0x6D, 0x53, 0xEA, 0x84, 0xF4, 0xAD, 0xB5, 0xE7, 0x2A, 0x9B,
	0x32, 0xF5, 0xAE, 0xF7, 0xB0, 0xAF, 0x64, 0xF6, 0xAA, 0x47, 0xE8, 0xC7,
	0xD6, 0xAB, 0xF6, 0xF1, 0x4F, 0x1B, 0xBD, 0x68, 0xB4, 0xA9, 0xED, 0xC3,
	0x35, 0x67, 0xD7, 0xBF
};
static const uint8_t ac_siggen15_186_2_coeff[] = {
	0xE3, 0xBD, 0x88, 0x1C, 0x5A, 0x8F, 0x4A, 0xFC, 0xA0, 0x8C, 0xBC, 0x04,
	0x7C, 0xF0, 0xE3, 0x89, 0x7C, 0x85, 0x18, 0x9A, 0xF4, 0xF9, 0xA7, 0x00,
	0x93, 0x2C, 0xF4, 0x9E, 0x72, 0xF6, 0x44, 0x04, 0x39, 0x0D, 0xA5, 0x04,
	0x82, 0x79, 0xCE, 0x47, 0xF5, 0xAF, 0x58, 0x9B, 0x1B, 0xE9, 0xE4, 0x61,
	0xBB, 0xD8, 0xCC, 0x07, 0xAB, 0x8B, 0xC6, 0x8B, 0xAF, 0x6C, 0xC9, 0x13,
	0xB2, 0xE6, 0x26, 0x72
};

/* SigGen15_186-2.txt line 13 SHA-1*/
#define ac_rsassa_vect8_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect8_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect8_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect8_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect8_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect8_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect8_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect8_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect8_ptx[] = {
	0xe8, 0x31, 0x27, 0x42, 0xae, 0x23, 0xc4, 0x56, 0xef, 0x28, 0xa2, 0x31,
	0x42, 0xc4, 0x49, 0x08, 0x95, 0x83, 0x27, 0x65, 0xda, 0xdc, 0xe0, 0x2a,
	0xfe, 0x5b, 0xe5, 0xd3, 0x1b, 0x00, 0x48, 0xfb, 0xee, 0xe2, 0xcf, 0x21,
	0x8b, 0x17, 0x47, 0xad, 0x4f, 0xd8, 0x1a, 0x2e, 0x17, 0xe1, 0x24, 0xe6,
	0xaf, 0x17, 0xc3, 0x88, 0x8e, 0x6d, 0x2d, 0x40, 0xc0, 0x08, 0x07, 0xf4,
	0x23, 0xa2, 0x33, 0xca, 0xd6, 0x2c, 0xe9, 0xea, 0xef, 0xb7, 0x09, 0x85,
	0x6c, 0x94, 0xaf, 0x16, 0x6d, 0xba, 0x08, 0xe7, 0xa0, 0x69, 0x65, 0xd7,
	0xfc, 0x0d, 0x8e, 0x5c, 0xb2, 0x65, 0x59, 0xc4, 0x60, 0xe4, 0x7b, 0xc0,
	0x88, 0x58, 0x9d, 0x22, 0x42, 0xc9, 0xb3, 0xe6, 0x2d, 0xa4, 0x89, 0x6f,
	0xab, 0x19, 0x9e, 0x14, 0x4e, 0xc1, 0x36, 0xdb, 0x8d, 0x84, 0xab, 0x84,
	0xbc, 0xba, 0x04, 0xca, 0x3b, 0x90, 0xc8, 0xe5
};
static const uint8_t ac_rsassa_vect8_out[] = {
	0x28, 0x92, 0x8e, 0x19, 0xeb, 0x86, 0xf9, 0xc0, 0x00, 0x70, 0xa5, 0x9e,
	0xdf, 0x6b, 0xf8, 0x43, 0x3a, 0x45, 0xdf, 0x49, 0x5c, 0xd1, 0xc7, 0x36,
	0x13, 0xc2, 0x12, 0x98, 0x40, 0xf4, 0x8c, 0x4a, 0x2c, 0x24, 0xf1, 0x1d,
	0xf7, 0x9b, 0xc5, 0xc0, 0x78, 0x2b, 0xce, 0xdd, 0xe9, 0x7d, 0xbb, 0xb2,
	0xac, 0xc6, 0xe5, 0x12, 0xd1, 0x9f, 0x08, 0x50, 0x27, 0xcd, 0x57, 0x50,
	0x38, 0x45, 0x3d, 0x04, 0x90, 0x54, 0x13, 0xe9, 0x47, 0xe6, 0xe1, 0xdd,
	0xdb, 0xeb, 0x35, 0x35, 0xcd, 0xb3, 0xd8, 0x97, 0x1f, 0xe0, 0x20, 0x05,
	0x06, 0x94, 0x10, 0x56, 0xf2, 0x12, 0x43, 0x50, 0x3c, 0x83, 0xea, 0xdd,
	0xe0, 0x53, 0xed, 0x86, 0x6c, 0x0e, 0x02, 0x50, 0xbe, 0xdd, 0xd9, 0x27,
	0xa0, 0x82, 0x12, 0xaa, 0x8a, 0xc0, 0xef, 0xd6, 0x16, 0x31, 0xef, 0x89,
	0xd8, 0xd0, 0x49, 0xef, 0xb3, 0x6b, 0xb3, 0x5f
};

/* SigGen15_186-2.txt line 54 SHA-224*/
#define ac_rsassa_vect16_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect16_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect16_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect16_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect16_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect16_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect16_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect16_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect16_ptx[] = {
	0xe5, 0x67, 0xa3, 0x9a, 0xe4, 0xe5, 0xef, 0x9b, 0x68, 0x01, 0xea, 0x05,
	0x61, 0xb7, 0x2a, 0x5d, 0x4b, 0x5f, 0x38, 0x5f, 0x05, 0x32, 0xfc, 0x9f,
	0xe1, 0x0a, 0x75, 0x70, 0xf8, 0x69, 0xae, 0x05, 0xc0, 0xbd, 0xed, 0xd6,
	0xe0, 0xe2, 0x2d, 0x45, 0x42, 0xe9, 0xce, 0x82, 0x6a, 0x18, 0x8c, 0xac,
	0x07, 0x31, 0xae, 0x39, 0xc8, 0xf8, 0x7f, 0x97, 0x71, 0xef, 0x02, 0x13,
	0x2e, 0x64, 0xe2, 0xfb, 0x27, 0xad, 0xa8, 0xff, 0x54, 0xb3, 0x30, 0xdd,
	0x93, 0xad, 0x5e, 0x3e, 0xf8, 0x2e, 0x0d, 0xda, 0x64, 0x62, 0x48, 0xe3,
	0x59, 0x94, 0xbd, 0xa1, 0x0c, 0xf4, 0x6e, 0x5a, 0xbc, 0x98, 0xaa, 0x74,
	0x43, 0xc0, 0x3c, 0xdd, 0xeb, 0x5e, 0xe2, 0xab, 0x82, 0xd6, 0x01, 0x00,
	0xb1, 0x02, 0x96, 0x31, 0x89, 0x79, 0x70, 0x27, 0x5f, 0x11, 0x9d, 0x05,
	0xda, 0xa2, 0x22, 0x0a, 0x4a, 0x0d, 0xef, 0xba
};
static const uint8_t ac_rsassa_vect16_out[] = {
	0x5a, 0xa5, 0x03, 0x33, 0x81, 0xbd, 0xd0, 0xac, 0xce, 0x33, 0x2d, 0xd3,
	0x14, 0xda, 0xf0, 0x08, 0xac, 0xaa, 0x9e, 0x83, 0x5f, 0x83, 0x29, 0x79,
	0x89, 0x1d, 0x1b, 0xda, 0x2b, 0x55, 0xd5, 0xea, 0xe3, 0x5c, 0x47, 0x9c,
	0x06, 0xca, 0xc5, 0xbf, 0x33, 0xf4, 0x32, 0xc8, 0xc0, 0xa5, 0x54, 0x9d,
	0x1d, 0x1b, 0x29, 0xc5, 0xe2, 0x58, 0x90, 0x24, 0xd2, 0x78, 0x00, 0xa0,
	0xc2, 0x35, 0xa6, 0x15, 0x32, 0xc2, 0x03, 0xcb, 0xc4, 0x06, 0xac, 0x6e,
	0xcf, 0x63, 0xf5, 0x2a, 0xe7, 0x71, 0xb9, 0x7c, 0x08, 0xe4, 0xb1, 0x08,
	0xec, 0x91, 0x69, 0x00, 0xe5, 0xa1, 0x1b, 0x1d, 0x48, 0xcc, 0xa8, 0x6c,
	0xa5, 0xa5, 0xa7, 0x99, 0xed, 0x32, 0xe9, 0x9c, 0x81, 0x5c, 0xef, 0x04,
	0xcf, 0x8e, 0xb5, 0x52, 0x23, 0xbf, 0xd4, 0xd9, 0xc3, 0x44, 0x92, 0x64,
	0xb6, 0x00, 0x61, 0xbc, 0x36, 0x84, 0xbc, 0x82
};

/* SigGen15_186-2.txt line 93 SHA-256 */
#define ac_rsassa_vect9_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect9_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect9_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect9_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect9_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect9_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect9_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect9_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect9_ptx[] = {
	0xe5, 0x67, 0xa3, 0x9a, 0xe4, 0xe5, 0xef, 0x9b, 0x68, 0x01, 0xea, 0x05,
	0x61, 0xb7, 0x2a, 0x5d, 0x4b, 0x5f, 0x38, 0x5f, 0x05, 0x32, 0xfc, 0x9f,
	0xe1, 0x0a, 0x75, 0x70, 0xf8, 0x69, 0xae, 0x05, 0xc0, 0xbd, 0xed, 0xd6,
	0xe0, 0xe2, 0x2d, 0x45, 0x42, 0xe9, 0xce, 0x82, 0x6a, 0x18, 0x8c, 0xac,
	0x07, 0x31, 0xae, 0x39, 0xc8, 0xf8, 0x7f, 0x97, 0x71, 0xef, 0x02, 0x13,
	0x2e, 0x64, 0xe2, 0xfb, 0x27, 0xad, 0xa8, 0xff, 0x54, 0xb3, 0x30, 0xdd,
	0x93, 0xad, 0x5e, 0x3e, 0xf8, 0x2e, 0x0d, 0xda, 0x64, 0x62, 0x48, 0xe3,
	0x59, 0x94, 0xbd, 0xa1, 0x0c, 0xf4, 0x6e, 0x5a, 0xbc, 0x98, 0xaa, 0x74,
	0x43, 0xc0, 0x3c, 0xdd, 0xeb, 0x5e, 0xe2, 0xab, 0x82, 0xd6, 0x01, 0x00,
	0xb1, 0x02, 0x96, 0x31, 0x89, 0x79, 0x70, 0x27, 0x5f, 0x11, 0x9d, 0x05,
	0xda, 0xa2, 0x22, 0x0a, 0x4a, 0x0d, 0xef, 0xba
};
static const uint8_t ac_rsassa_vect9_out[] = {
	0x0e, 0x7c, 0xdd, 0x12, 0x1e, 0x40, 0x32, 0x3c, 0xa6, 0x11, 0x5d, 0x1e,
	0xc6, 0xd1, 0xf9, 0x56, 0x17, 0x38, 0x45, 0x5f, 0x0e, 0x9e, 0x1c, 0xd8,
	0x58, 0xe8, 0xb5, 0x66, 0xae, 0x2d, 0xa5, 0xe8, 0xee, 0x63, 0xd8, 0xf1,
	0x5c, 0x3c, 0xdd, 0x88, 0x02, 0x7e, 0x13, 0x40, 0x6d, 0xb6, 0x09, 0x36,
	0x9c, 0x88, 0xca, 0x99, 0xb3, 0x4f, 0xa1, 0x56, 0xc7, 0xee, 0x62, 0xbc,
	0x5a, 0x39, 0x23, 0xbb, 0x5a, 0x1e, 0xda, 0xbd, 0x45, 0xc1, 0xa4, 0x22,
	0xaa, 0xfc, 0xbb, 0x47, 0xe0, 0x94, 0x7f, 0x35, 0xcf, 0xef, 0x87, 0x97,
	0x0b, 0x4b, 0x71, 0x31, 0x62, 0xb2, 0x19, 0x16, 0xca, 0xfb, 0x8c, 0x86,
	0x4a, 0x3e, 0x5b, 0x9f, 0xfc, 0x98, 0x94, 0x01, 0xd4, 0xea, 0xe9, 0x92,
	0x31, 0x2a, 0x32, 0xc5, 0xbc, 0x88, 0xab, 0xbb, 0x45, 0xf9, 0x9a, 0xc8,
	0x85, 0xb5, 0x4d, 0x6b, 0x8e, 0x61, 0xb6, 0xec
};

/* SigGen15_186-2.txt line 93 SHA-256 without ASN.1 */
#define ac_rsassa_vect20_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect20_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect20_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect20_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect20_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect20_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect20_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect20_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect20_ptx[] = {
	0xe5, 0x67, 0xa3, 0x9a, 0xe4, 0xe5, 0xef, 0x9b, 0x68, 0x01, 0xea, 0x05,
	0x61, 0xb7, 0x2a, 0x5d, 0x4b, 0x5f, 0x38, 0x5f, 0x05, 0x32, 0xfc, 0x9f,
	0xe1, 0x0a, 0x75, 0x70, 0xf8, 0x69, 0xae, 0x05, 0xc0, 0xbd, 0xed, 0xd6,
	0xe0, 0xe2, 0x2d, 0x45, 0x42, 0xe9, 0xce, 0x82, 0x6a, 0x18, 0x8c, 0xac,
	0x07, 0x31, 0xae, 0x39, 0xc8, 0xf8, 0x7f, 0x97, 0x71, 0xef, 0x02, 0x13,
	0x2e, 0x64, 0xe2, 0xfb, 0x27, 0xad, 0xa8, 0xff, 0x54, 0xb3, 0x30, 0xdd,
	0x93, 0xad, 0x5e, 0x3e, 0xf8, 0x2e, 0x0d, 0xda, 0x64, 0x62, 0x48, 0xe3,
	0x59, 0x94, 0xbd, 0xa1, 0x0c, 0xf4, 0x6e, 0x5a, 0xbc, 0x98, 0xaa, 0x74,
	0x43, 0xc0, 0x3c, 0xdd, 0xeb, 0x5e, 0xe2, 0xab, 0x82, 0xd6, 0x01, 0x00,
	0xb1, 0x02, 0x96, 0x31, 0x89, 0x79, 0x70, 0x27, 0x5f, 0x11, 0x9d, 0x05,
	0xda, 0xa2, 0x22, 0x0a, 0x4a, 0x0d, 0xef, 0xba
};
static const uint8_t ac_rsassa_vect20_out[] = {
	0xbe, 0x03, 0x14, 0xbb, 0x4e, 0x73, 0xae, 0xa0, 0x8c, 0x3b, 0xd3, 0x47,
	0xc5, 0x71, 0x81, 0x6a, 0xb6, 0x0d, 0xc8, 0xd4, 0xbd, 0x6d, 0x8e, 0x5c,
	0xa3, 0x59, 0xd7, 0x31, 0xb3, 0x44, 0xa8, 0x17, 0x09, 0xc5, 0x00, 0x96,
	0x1a, 0xaa, 0x8b, 0xb2, 0xb4, 0xdc, 0x63, 0xda, 0xa2, 0x66, 0xe1, 0xf6,
	0xbb, 0x73, 0xb3, 0x03, 0x6d, 0x9a, 0x2d, 0x65, 0x9e, 0x10, 0x9c, 0x0c,
	0x46, 0xa3, 0xf4, 0xd3, 0x91, 0x23, 0x6d, 0x40, 0xb5, 0x0d, 0xd3, 0x31,
	0xea, 0xd3, 0x0d, 0x22, 0xf5, 0xfc, 0xfa, 0x8d, 0x67, 0x08, 0x65, 0x76,
	0xd4, 0x41, 0x24, 0xd6, 0x74, 0x2b, 0xfe, 0x44, 0xe5, 0x88, 0xde, 0x28,
	0xca, 0x2f, 0xb8, 0xd1, 0xc8, 0xb4, 0x65, 0xb3, 0x8a, 0x4e, 0x1d, 0xdd,
	0x43, 0x80, 0x68, 0x72, 0xf7, 0x52, 0x46, 0x56, 0xa0, 0x9e, 0x1d, 0x76,
	0x89, 0xee, 0x20, 0x71, 0x66, 0xd1, 0x19, 0xb7
};

/* SigGen15_186-2.txt line 133 SHA-384*/
#define ac_rsassa_vect10_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect10_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect10_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect10_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect10_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect10_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect10_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect10_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect10_ptx[] = {
	0xe5, 0x67, 0xa3, 0x9a, 0xe4, 0xe5, 0xef, 0x9b, 0x68, 0x01, 0xea, 0x05,
	0x61, 0xb7, 0x2a, 0x5d, 0x4b, 0x5f, 0x38, 0x5f, 0x05, 0x32, 0xfc, 0x9f,
	0xe1, 0x0a, 0x75, 0x70, 0xf8, 0x69, 0xae, 0x05, 0xc0, 0xbd, 0xed, 0xd6,
	0xe0, 0xe2, 0x2d, 0x45, 0x42, 0xe9, 0xce, 0x82, 0x6a, 0x18, 0x8c, 0xac,
	0x07, 0x31, 0xae, 0x39, 0xc8, 0xf8, 0x7f, 0x97, 0x71, 0xef, 0x02, 0x13,
	0x2e, 0x64, 0xe2, 0xfb, 0x27, 0xad, 0xa8, 0xff, 0x54, 0xb3, 0x30, 0xdd,
	0x93, 0xad, 0x5e, 0x3e, 0xf8, 0x2e, 0x0d, 0xda, 0x64, 0x62, 0x48, 0xe3,
	0x59, 0x94, 0xbd, 0xa1, 0x0c, 0xf4, 0x6e, 0x5a, 0xbc, 0x98, 0xaa, 0x74,
	0x43, 0xc0, 0x3c, 0xdd, 0xeb, 0x5e, 0xe2, 0xab, 0x82, 0xd6, 0x01, 0x00,
	0xb1, 0x02, 0x96, 0x31, 0x89, 0x79, 0x70, 0x27, 0x5f, 0x11, 0x9d, 0x05,
	0xda, 0xa2, 0x22, 0x0a, 0x4a, 0x0d, 0xef, 0xba
};
static const uint8_t ac_rsassa_vect10_out[] = {
	0x16, 0x89, 0xa8, 0x52, 0x39, 0x19, 0xac, 0x77, 0xcc, 0x99, 0x7e, 0xbc,
	0x59, 0xcb, 0x90, 0x88, 0x72, 0xd8, 0x8b, 0x28, 0x55, 0xa3, 0x09, 0xea,
	0xd2, 0x77, 0x9b, 0x88, 0x8b, 0x22, 0xb4, 0x23, 0x2d, 0xa9, 0xb9, 0x3b,
	0xb1, 0x9b, 0x32, 0xc1, 0xdb, 0x77, 0xad, 0x73, 0x8c, 0x6e, 0x43, 0x36,
	0x1e, 0x9e, 0xb6, 0xb1, 0xa3, 0x7c, 0x49, 0xa8, 0xf3, 0xc7, 0xc7, 0xae,
	0x7e, 0x78, 0x4d, 0x19, 0xa6, 0x21, 0x38, 0x74, 0x12, 0x93, 0xe4, 0x9b,
	0x18, 0x31, 0xc0, 0xc3, 0x61, 0x7e, 0xb4, 0x3c, 0x56, 0x70, 0x6d, 0x83,
	0x31, 0x49, 0x53, 0x47, 0x06, 0x36, 0x44, 0x10, 0x86, 0x41, 0x9a, 0xb9,
	0xe6, 0xfd, 0x1e, 0xc4, 0xf9, 0xd5, 0xcc, 0x65, 0x44, 0x81, 0x5d, 0x1e,
	0x02, 0xed, 0x96, 0xa3, 0xae, 0x64, 0xc6, 0x99, 0x8b, 0x2c, 0xf2, 0x38,
	0xe7, 0x9a, 0x12, 0x16, 0x43, 0x52, 0xd1, 0x2a
};

/* SigGen15_186-2.txt line 173 SHA-512*/
#define ac_rsassa_vect11_modulus ac_siggen15_186_2_modulus
#define ac_rsassa_vect11_pub_exp ac_siggen15_186_2_pub_exp
#define ac_rsassa_vect11_priv_exp ac_siggen15_186_2_priv_exp
#define ac_rsassa_vect11_prime1 ac_siggen15_186_2_prime1
#define ac_rsassa_vect11_prime2 ac_siggen15_186_2_prime2
#define ac_rsassa_vect11_exp1 ac_siggen15_186_2_exp1
#define ac_rsassa_vect11_exp2 ac_siggen15_186_2_exp2
#define ac_rsassa_vect11_coeff ac_siggen15_186_2_coeff
static const uint8_t ac_rsassa_vect11_ptx[] = {
	0xe5, 0x67, 0xa3, 0x9a, 0xe4, 0xe5, 0xef, 0x9b, 0x68, 0x01, 0xea, 0x05,
	0x61, 0xb7, 0x2a, 0x5d, 0x4b, 0x5f, 0x38, 0x5f, 0x05, 0x32, 0xfc, 0x9f,
	0xe1, 0x0a, 0x75, 0x70, 0xf8, 0x69, 0xae, 0x05, 0xc0, 0xbd, 0xed, 0xd6,
	0xe0, 0xe2, 0x2d, 0x45, 0x42, 0xe9, 0xce, 0x82, 0x6a, 0x18, 0x8c, 0xac,
	0x07, 0x31, 0xae, 0x39, 0xc8, 0xf8, 0x7f, 0x97, 0x71, 0xef, 0x02, 0x13,
	0x2e, 0x64, 0xe2, 0xfb, 0x27, 0xad, 0xa8, 0xff, 0x54, 0xb3, 0x30, 0xdd,
	0x93, 0xad, 0x5e, 0x3e, 0xf8, 0x2e, 0x0d, 0xda, 0x64, 0x62, 0x48, 0xe3,
	0x59, 0x94, 0xbd, 0xa1, 0x0c, 0xf4, 0x6e, 0x5a, 0xbc, 0x98, 0xaa, 0x74,
	0x43, 0xc0, 0x3c, 0xdd, 0xeb, 0x5e, 0xe2, 0xab, 0x82, 0xd6, 0x01, 0x00,
	0xb1, 0x02, 0x96, 0x31, 0x89, 0x79, 0x70, 0x27, 0x5f, 0x11, 0x9d, 0x05,
	0xda, 0xa2, 0x22, 0x0a, 0x4a, 0x0d, 0xef, 0xba
};
static const uint8_t ac_rsassa_vect11_out[] = {
	0xbf, 0x3f, 0xf2, 0xc6, 0x96, 0x75, 0xf1, 0xb8, 0xed, 0x42, 0x10, 0x21,
	0x80, 0x1f, 0xb4, 0xce, 0x29, 0xa7, 0x57, 0xf7, 0xf8, 0x86, 0x9c, 0xe4,
	0x36, 0xd0, 0xd7, 0x5a, 0xb7, 0x49, 0xef, 0xc8, 0xb9, 0x03, 0xd9, 0xf9,
	0xcb, 0x21, 0x46, 0x86, 0x14, 0x7f, 0x12, 0xf3, 0x33, 0x5f, 0xa9, 0x36,
	0x68, 0x9c, 0x19, 0x2f, 0x31, 0x0a, 0xe3, 0xc5, 0xd7, 0x54, 0x93, 0xf4,
	0x4b, 0x24, 0xbc, 0x1c, 0xd3, 0x50, 0x15, 0x84, 0xaa, 0xa5, 0x00, 0x4b,
	0x65, 0xa8, 0x71, 0x6d, 0x1e, 0xda, 0x72, 0x40, 0xad, 0x8a, 0x52, 0x9d,
	0x5a, 0x0c, 0xf1, 0x69, 0xf4, 0x05, 0x4b, 0x45, 0x0e, 0x07, 0x6e, 0xe0,
	0xd4, 0x1a, 0x00, 0x11, 0xc5, 0x57, 0xaa, 0x69, 0xa8, 0x4a, 0x81, 0x04,
	0xc9, 0x09, 0x20, 0x1d, 0x60, 0xfe, 0x39, 0xc7, 0x9e, 0x68, 0x43, 0x47,
	0xef, 0x4d, 0x14, 0x4e, 0xa1, 0x8f, 0x7a, 0x4e
};


/* SigGenPSS_186-2.txt line 9 mod 1024 */
static const uint8_t ac_siggenpss_186_2_modulus[] = {
	0xbc, 0xb4, 0x7b, 0x2e, 0x0d, 0xaf, 0xcb, 0xa8, 0x1f, 0xf2, 0xa2, 0xb5,
	0xcb, 0x11, 0x5c, 0xa7, 0xe7, 0x57, 0x18, 0x4c, 0x9d, 0x72, 0xbc, 0xdc,
	0xda, 0x70, 0x7a, 0x14, 0x6b, 0x3b, 0x4e, 0x29, 0x98, 0x9d, 0xdc, 0x66,
	0x0b, 0xd6, 0x94, 0x86, 0x5b, 0x93, 0x2b, 0x71, 0xca, 0x24, 0xa3, 0x35,
	0xcf, 0x4d, 0x33, 0x9c, 0x71, 0x91, 0x83, 0xe6, 0x22, 0x2e, 0x4c, 0x9e,
	0xa6, 0x87, 0x5a, 0xcd, 0x52, 0x8a, 0x49, 0xba, 0x21, 0x86, 0x3f, 0xe0,
	0x81, 0x47, 0xc3, 0xa4, 0x7e, 0x41, 0x99, 0x0b, 0x51, 0xa0, 0x3f, 0x77,
	0xd2, 0x21, 0x37, 0xf8, 0xd7, 0x4c, 0x43, 0xa5, 0xa4, 0x5f, 0x4e, 0x9e,
	0x18, 0xa2, 0xd1, 0x5d, 0xb0, 0x51, 0xdc, 0x89, 0x38, 0x5d, 0xb9, 0xcf,
	0x83, 0x74, 0xb6, 0x3a, 0x8c, 0xc8, 0x81, 0x13, 0x71, 0x0e, 0x6d, 0x81,
	0x79, 0x07, 0x5b, 0x7d, 0xc7, 0x9e, 0xe7, 0x6b
};
static const uint8_t ac_siggenpss_186_2_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_siggenpss_186_2_priv_exp[] = {
	0x38, 0x3a, 0x6f, 0x19, 0xe1, 0xea, 0x27, 0xfd, 0x08, 0xc7, 0xfb, 0xc3,
	0xbf, 0xa6, 0x84, 0xbd, 0x63, 0x29, 0x88, 0x8c, 0x0b, 0xbe, 0x4c, 0x98,
	0x62, 0x5e, 0x71, 0x81, 0xf4, 0x11, 0xcf, 0xd0, 0x85, 0x31, 0x44, 0xa3,
	0x03, 0x94, 0x04, 0xdd, 0xa4, 0x1b, 0xce, 0x2e, 0x31, 0xd5, 0x88, 0xec,
	0x57, 0xc0, 0xe1, 0x48, 0x14, 0x6f, 0x0f, 0xa6, 0x5b, 0x39, 0x00, 0x8b,
	0xa5, 0x83, 0x5f, 0x82, 0x9b, 0xa3, 0x5a, 0xe2, 0xf1, 0x55, 0xd6, 0x1b,
	0x8a, 0x12, 0x58, 0x1b, 0x99, 0xc9, 0x27, 0xfd, 0x2f, 0x22, 0x25, 0x2c,
	0x5e, 0x73, 0xcb, 0xa4, 0xa6, 0x10, 0xdb, 0x39, 0x73, 0xe0, 0x19, 0xee,
	0x0f, 0x95, 0x13, 0x0d, 0x43, 0x19, 0xed, 0x41, 0x34, 0x32, 0xf2, 0xe5,
	0xe2, 0x0d, 0x52, 0x15, 0xcd, 0xd2, 0x7c, 0x21, 0x64, 0x20, 0x6b, 0x3f,
	0x80, 0xed, 0xee, 0x51, 0x93, 0x8a, 0x25, 0xc1
};
static const uint8_t ac_siggenpss_186_2_prime1[] = {
	0xE5, 0x56, 0x3B, 0x14, 0x5D, 0xB6, 0xFF, 0x5A, 0x16, 0x28, 0x0D, 0x3E,
	0x80, 0xEF, 0xF0, 0x2F, 0x18, 0x1D, 0xBD, 0x03, 0x32, 0x4E, 0xF2, 0x47,
	0xF5, 0x96, 0xA4, 0xD4, 0xA7, 0xB8, 0xDA, 0xA3, 0x2B, 0x99, 0x34, 0xE3,
	0xC7, 0xF4, 0xDC, 0xF6, 0xA3, 0x10, 0x54, 0x62, 0xDE, 0xC6, 0x38, 0x39,
	0x63, 0x86, 0x18, 0x41, 0x8B, 0x51, 0xDB, 0x02, 0x69, 0x3F, 0xAB, 0xB4,
	0xE6, 0x83, 0x87, 0x25
};
static const uint8_t ac_siggenpss_186_2_prime2[] = {
	0xD2, 0xA4, 0xEC, 0x0F, 0xA2, 0x22, 0x6C, 0xDE, 0x82, 0xDA, 0x77, 0x65,
	0x3B, 0x07, 0x2C, 0xD0, 0x98, 0x53, 0x5D, 0x3E, 0x90, 0xED, 0x4D, 0x72,
	0x24, 0xDC, 0xB8, 0xCB, 0x8B, 0x93, 0x14, 0x76, 0x8D, 0xC5, 0x17, 0xE2,
	0x2D, 0x7C, 0x8F, 0xA1, 0x3F, 0x25, 0x3D, 0xAA, 0x74, 0x65, 0xA7, 0x99,
	0x56, 0x09, 0x8A, 0xA4, 0xCC, 0x3A, 0x6E, 0x35, 0xE8, 0xB1, 0xFC, 0xC4,
	0xF9, 0x7E, 0x77, 0x4F
};
static const uint8_t ac_siggenpss_186_2_exp1[] = {
	0x1F, 0x6A, 0xCA, 0xB9, 0x25, 0x85, 0x76, 0x41, 0xCF, 0x1B, 0x39, 0x85,
	0x40, 0x80, 0x9E, 0x34, 0xB5, 0x67, 0x0D, 0x87, 0xAC, 0x92, 0xA8, 0x1A,
	0x37, 0x88, 0xA5, 0x98, 0x04, 0x4A, 0x0C, 0x99, 0xA1, 0xD5, 0x61, 0x2B,
	0x7B, 0x2F, 0x0E, 0x3E, 0x33, 0x64, 0x7F, 0x4A, 0xF4, 0x1D, 0xCF, 0x81,
	0xFD, 0x22, 0x57, 0x9C, 0x53, 0x0B, 0xA9, 0xA7, 0x10, 0xE8, 0x0A, 0x0B,
	0xC4, 0x30, 0x6C, 0x89
};
static const uint8_t ac_siggenpss_186_2_exp2[] = {
	0x59, 0xF2, 0x84, 0xBE, 0xD4, 0x3C, 0x21, 0x03, 0x0F, 0x1B, 0x5C, 0xDA,
	0x84, 0x4F, 0x37, 0x0A, 0xC7, 0xD0, 0xE9, 0x43, 0x3B, 0x3D, 0xA9, 0xD1,
	0x70, 0xFE, 0x33, 0x86, 0xEF, 0x4D, 0xD9, 0xF2, 0x19, 0xED, 0xAC, 0x9A,
	0x2F, 0x54, 0x3E, 0x3C, 0xDB, 0xAA, 0xFA, 0x5F, 0x1C, 0x1F, 0x00, 0x67,
	0x50, 0xBE, 0xF8, 0x4E, 0x10, 0xCB, 0x6E, 0x9E, 0x64, 0x84, 0x04, 0x6C,
	0xD4, 0x20, 0xF5, 0xAF
};
static const uint8_t ac_siggenpss_186_2_coeff[] = {
	0x83, 0x5F, 0xC1, 0xB6, 0x52, 0x1C, 0x83, 0xE7, 0x6F, 0x80, 0x64, 0xFF,
	0xF8, 0x38, 0x80, 0xE1, 0xC9, 0x8F, 0x81, 0x13, 0x1E, 0xE8, 0x6E, 0x5D,
	0xF8, 0x57, 0x6A, 0xDA, 0x7D, 0x75, 0xC2, 0x6F, 0x8D, 0xB8, 0xBA, 0x8B,
	0x46, 0xF4, 0x6C, 0x69, 0xA5, 0x9D, 0xC5, 0xF2, 0x11, 0x8A, 0x9A, 0x90,
	0x8E, 0xC0, 0x8F, 0x45, 0xB0, 0x50, 0x4D, 0x2A, 0x42, 0x86, 0x49, 0x5E,
	0x2A, 0x1B, 0x78, 0x2E
};
/* Salt: 6f2841166a64471d4f0b8ed0dbb7db32161da13b */
#define ac_siggenpss_186_2_salt_len 20


/* SigGen15_186-2.txt line 173 SHA-1 */
#define ac_rsassa_vect12_modulus ac_siggenpss_186_2_modulus
#define ac_rsassa_vect12_pub_exp ac_siggenpss_186_2_pub_exp
#define ac_rsassa_vect12_priv_exp ac_siggenpss_186_2_priv_exp
#define ac_rsassa_vect12_prime1 ac_siggenpss_186_2_prime1
#define ac_rsassa_vect12_prime2 ac_siggenpss_186_2_prime2
#define ac_rsassa_vect12_exp1 ac_siggenpss_186_2_exp1
#define ac_rsassa_vect12_exp2 ac_siggenpss_186_2_exp2
#define ac_rsassa_vect12_coeff ac_siggenpss_186_2_coeff
#define ac_rsassa_vect12_salt_len ac_siggenpss_186_2_salt_len
static const uint8_t ac_rsassa_vect12_ptx[] = {
	0x12, 0x48, 0xf6, 0x2a, 0x43, 0x89, 0xf4, 0x2f, 0x7b, 0x4b, 0xb1, 0x31,
	0x05, 0x3d, 0x6c, 0x88, 0xa9, 0x94, 0xdb, 0x20, 0x75, 0xb9, 0x12, 0xcc,
	0xbe, 0x3e, 0xa7, 0xdc, 0x61, 0x17, 0x14, 0xf1, 0x4e, 0x07, 0x5c, 0x10,
	0x48, 0x58, 0xf2, 0xf6, 0xe6, 0xcf, 0xd6, 0xab, 0xde, 0xdf, 0x01, 0x5a,
	0x82, 0x1d, 0x03, 0x60, 0x8b, 0xf4, 0xeb, 0xa3, 0x16, 0x9a, 0x67, 0x25,
	0xec, 0x42, 0x2c, 0xd9, 0x06, 0x94, 0x98, 0xb5, 0x51, 0x5a, 0x96, 0x08,
	0xae, 0x7c, 0xc3, 0x0e, 0x3d, 0x2e, 0xcf, 0xc1, 0xdb, 0x68, 0x25, 0xf3,
	0xe9, 0x96, 0xce, 0x9a, 0x50, 0x92, 0x92, 0x6b, 0xc1, 0xcf, 0x61, 0xaa,
	0x42, 0xd7, 0xf2, 0x40, 0xe6, 0xf7, 0xaa, 0x0e, 0xdb, 0x38, 0xbf, 0x81,
	0xaa, 0x92, 0x9d, 0x66, 0xbb, 0x5d, 0x89, 0x00, 0x18, 0x08, 0x84, 0x58,
	0x72, 0x0d, 0x72, 0xd5, 0x69, 0x24, 0x7b, 0x0c
};
static const uint8_t ac_rsassa_vect12_out[] = {
	0x68, 0x2c, 0xf5, 0x3c, 0x11, 0x45, 0xd2, 0x2a, 0x50, 0xca, 0xa9, 0xeb,
	0x1a, 0x9b, 0xa7, 0x06, 0x70, 0xc5, 0x91, 0x5e, 0x0f, 0xdf, 0xde, 0x64,
	0x57, 0xa7, 0x65, 0xde, 0x2a, 0x8f, 0xe1, 0x2d, 0xe9, 0x79, 0x41, 0x72,
	0xa7, 0x8d, 0x14, 0xe6, 0x68, 0xd4, 0x98, 0xac, 0xed, 0xad, 0x61, 0x65,
	0x04, 0xbb, 0x17, 0x64, 0xd0, 0x94, 0x60, 0x70, 0x70, 0x08, 0x05, 0x92,
	0xc3, 0xa6, 0x9c, 0x34, 0x3d, 0x98, 0x2b, 0xd7, 0x78, 0x65, 0x87, 0x3d,
	0x35, 0xe2, 0x48, 0x22, 0xca, 0xf4, 0x34, 0x43, 0xcc, 0x10, 0x24, 0x9a,
	0xf6, 0xa1, 0xe2, 0x6e, 0xf3, 0x44, 0xf2, 0x8b, 0x9e, 0xf6, 0xf1, 0x4e,
	0x09, 0xad, 0x83, 0x97, 0x48, 0xe5, 0x14, 0x8b, 0xcc, 0xeb, 0x0f, 0xd2,
	0xaa, 0x63, 0x70, 0x9c, 0xb4, 0x89, 0x75, 0xcb, 0xf9, 0xc7, 0xb4, 0x9a,
	0xbc, 0x66, 0xa1, 0xdc, 0x6c, 0xb5, 0xb3, 0x1a
};

/* SigGenPSS_186-2.txt line 66 SHA-224 */
#define ac_rsassa_vect17_modulus ac_siggenpss_186_2_modulus
#define ac_rsassa_vect17_pub_exp ac_siggenpss_186_2_pub_exp
#define ac_rsassa_vect17_priv_exp ac_siggenpss_186_2_priv_exp
#define ac_rsassa_vect17_prime1 ac_siggenpss_186_2_prime1
#define ac_rsassa_vect17_prime2 ac_siggenpss_186_2_prime2
#define ac_rsassa_vect17_exp1 ac_siggenpss_186_2_exp1
#define ac_rsassa_vect17_exp2 ac_siggenpss_186_2_exp2
#define ac_rsassa_vect17_coeff ac_siggenpss_186_2_coeff
#define ac_rsassa_vect17_salt_len ac_siggenpss_186_2_salt_len
static const uint8_t ac_rsassa_vect17_ptx[] = {
	0x12, 0x48, 0xf6, 0x2a, 0x43, 0x89, 0xf4, 0x2f, 0x7b, 0x4b, 0xb1, 0x31,
	0x05, 0x3d, 0x6c, 0x88, 0xa9, 0x94, 0xdb, 0x20, 0x75, 0xb9, 0x12, 0xcc,
	0xbe, 0x3e, 0xa7, 0xdc, 0x61, 0x17, 0x14, 0xf1, 0x4e, 0x07, 0x5c, 0x10,
	0x48, 0x58, 0xf2, 0xf6, 0xe6, 0xcf, 0xd6, 0xab, 0xde, 0xdf, 0x01, 0x5a,
	0x82, 0x1d, 0x03, 0x60, 0x8b, 0xf4, 0xeb, 0xa3, 0x16, 0x9a, 0x67, 0x25,
	0xec, 0x42, 0x2c, 0xd9, 0x06, 0x94, 0x98, 0xb5, 0x51, 0x5a, 0x96, 0x08,
	0xae, 0x7c, 0xc3, 0x0e, 0x3d, 0x2e, 0xcf, 0xc1, 0xdb, 0x68, 0x25, 0xf3,
	0xe9, 0x96, 0xce, 0x9a, 0x50, 0x92, 0x92, 0x6b, 0xc1, 0xcf, 0x61, 0xaa,
	0x42, 0xd7, 0xf2, 0x40, 0xe6, 0xf7, 0xaa, 0x0e, 0xdb, 0x38, 0xbf, 0x81,
	0xaa, 0x92, 0x9d, 0x66, 0xbb, 0x5d, 0x89, 0x00, 0x18, 0x08, 0x84, 0x58,
	0x72, 0x0d, 0x72, 0xd5, 0x69, 0x24, 0x7b, 0x0c,
};
static const uint8_t ac_rsassa_vect17_out[] = {
	0x53, 0xd8, 0x59, 0xc9, 0xf1, 0x0a, 0xbf, 0x1c, 0x00, 0x28, 0x4a, 0x4b,
	0x55, 0xbf, 0x2b, 0xd8, 0x4d, 0x8e, 0x31, 0x3b, 0x4f, 0x3c, 0x35, 0xb8,
	0xde, 0xc7, 0xbc, 0x3a, 0xfe, 0x39, 0xb9, 0xb8, 0xa1, 0x55, 0x41, 0x8e,
	0xad, 0x19, 0x31, 0x89, 0x57, 0x69, 0xce, 0x23, 0x40, 0xbe, 0x20, 0x91,
	0xf2, 0x38, 0x5b, 0xbc, 0xf1, 0x0d, 0x9e, 0x92, 0xbc, 0xf5, 0xd0, 0xe2,
	0x96, 0x0d, 0x10, 0xe7, 0x92, 0xe7, 0xd8, 0x65, 0xc6, 0x4e, 0x50, 0xd1,
	0x9f, 0xfa, 0x13, 0xe5, 0x28, 0x17, 0xd7, 0xd8, 0xd8, 0xdb, 0x34, 0x39,
	0x2c, 0x23, 0x74, 0xa2, 0xe9, 0xb6, 0x91, 0x84, 0xf9, 0x2a, 0x4a, 0xd9,
	0xb1, 0xb8, 0xba, 0xe9, 0x9c, 0xa6, 0x14, 0xd2, 0x04, 0xb6, 0x5a, 0x43,
	0x8e, 0x38, 0xdb, 0xbf, 0xc8, 0xc7, 0xcc, 0x44, 0xed, 0x56, 0x77, 0xaf,
	0x70, 0xce, 0x6c, 0x4f, 0x95, 0x1f, 0x02, 0x44,
};

/* SigGen15_186-2.txt line 114 SHA-256 */
#define ac_rsassa_vect13_modulus ac_siggenpss_186_2_modulus
#define ac_rsassa_vect13_pub_exp ac_siggenpss_186_2_pub_exp
#define ac_rsassa_vect13_priv_exp ac_siggenpss_186_2_priv_exp
#define ac_rsassa_vect13_prime1 ac_siggenpss_186_2_prime1
#define ac_rsassa_vect13_prime2 ac_siggenpss_186_2_prime2
#define ac_rsassa_vect13_exp1 ac_siggenpss_186_2_exp1
#define ac_rsassa_vect13_exp2 ac_siggenpss_186_2_exp2
#define ac_rsassa_vect13_coeff ac_siggenpss_186_2_coeff
#define ac_rsassa_vect13_salt_len ac_siggenpss_186_2_salt_len
static const uint8_t ac_rsassa_vect13_ptx[] = {
	0x12, 0x48, 0xf6, 0x2a, 0x43, 0x89, 0xf4, 0x2f, 0x7b, 0x4b, 0xb1, 0x31,
	0x05, 0x3d, 0x6c, 0x88, 0xa9, 0x94, 0xdb, 0x20, 0x75, 0xb9, 0x12, 0xcc,
	0xbe, 0x3e, 0xa7, 0xdc, 0x61, 0x17, 0x14, 0xf1, 0x4e, 0x07, 0x5c, 0x10,
	0x48, 0x58, 0xf2, 0xf6, 0xe6, 0xcf, 0xd6, 0xab, 0xde, 0xdf, 0x01, 0x5a,
	0x82, 0x1d, 0x03, 0x60, 0x8b, 0xf4, 0xeb, 0xa3, 0x16, 0x9a, 0x67, 0x25,
	0xec, 0x42, 0x2c, 0xd9, 0x06, 0x94, 0x98, 0xb5, 0x51, 0x5a, 0x96, 0x08,
	0xae, 0x7c, 0xc3, 0x0e, 0x3d, 0x2e, 0xcf, 0xc1, 0xdb, 0x68, 0x25, 0xf3,
	0xe9, 0x96, 0xce, 0x9a, 0x50, 0x92, 0x92, 0x6b, 0xc1, 0xcf, 0x61, 0xaa,
	0x42, 0xd7, 0xf2, 0x40, 0xe6, 0xf7, 0xaa, 0x0e, 0xdb, 0x38, 0xbf, 0x81,
	0xaa, 0x92, 0x9d, 0x66, 0xbb, 0x5d, 0x89, 0x00, 0x18, 0x08, 0x84, 0x58,
	0x72, 0x0d, 0x72, 0xd5, 0x69, 0x24, 0x7b, 0x0c
};
static const uint8_t ac_rsassa_vect13_out[] = {
	0x7b, 0x1d, 0x37, 0x27, 0x8e, 0x54, 0x98, 0x98, 0xd4, 0x08, 0x4e, 0x22,
	0x10, 0xc4, 0xa9, 0x96, 0x1e, 0xdf, 0xe7, 0xb5, 0x96, 0x35, 0x50, 0xcc,
	0xa1, 0x90, 0x42, 0x48, 0xc8, 0x68, 0x15, 0x13, 0x53, 0x90, 0x17, 0x82,
	0x0f, 0x0e, 0x9b, 0xd0, 0x74, 0xb9, 0xf8, 0xa0, 0x67, 0xb9, 0xfe, 0xff,
	0xf7, 0xf1, 0xfa, 0x20, 0xbf, 0x2d, 0x0c, 0x75, 0x01, 0x5f, 0xf0, 0x20,
	0xb2, 0x21, 0x0c, 0xc7, 0xf7, 0x90, 0x34, 0xfe, 0xdf, 0x68, 0xe8, 0xd4,
	0x4a, 0x00, 0x7a, 0xbf, 0x4d, 0xd8, 0x2c, 0x26, 0xe8, 0xb0, 0x03, 0x93,
	0x72, 0x3a, 0xea, 0x15, 0xab, 0xfb, 0xc2, 0x29, 0x41, 0xc8, 0xcf, 0x79,
	0x48, 0x17, 0x18, 0xc0, 0x08, 0xda, 0x71, 0x3f, 0xb8, 0xf5, 0x4c, 0xb3,
	0xfc, 0xa8, 0x90, 0xbd, 0xe1, 0x13, 0x73, 0x14, 0x33, 0x4b, 0x9b, 0x0a,
	0x18, 0x51, 0x5b, 0xfa, 0x48, 0xe5, 0xcc, 0xd0
};

/* SigGen15_186-2.txt line 164 SHA-384 */
#define ac_rsassa_vect14_modulus ac_siggenpss_186_2_modulus
#define ac_rsassa_vect14_pub_exp ac_siggenpss_186_2_pub_exp
#define ac_rsassa_vect14_priv_exp ac_siggenpss_186_2_priv_exp
#define ac_rsassa_vect14_prime1 ac_siggenpss_186_2_prime1
#define ac_rsassa_vect14_prime2 ac_siggenpss_186_2_prime2
#define ac_rsassa_vect14_exp1 ac_siggenpss_186_2_exp1
#define ac_rsassa_vect14_exp2 ac_siggenpss_186_2_exp2
#define ac_rsassa_vect14_coeff ac_siggenpss_186_2_coeff
#define ac_rsassa_vect14_salt_len ac_siggenpss_186_2_salt_len
static const uint8_t ac_rsassa_vect14_ptx[] = {
	0x12, 0x48, 0xf6, 0x2a, 0x43, 0x89, 0xf4, 0x2f, 0x7b, 0x4b, 0xb1, 0x31,
	0x05, 0x3d, 0x6c, 0x88, 0xa9, 0x94, 0xdb, 0x20, 0x75, 0xb9, 0x12, 0xcc,
	0xbe, 0x3e, 0xa7, 0xdc, 0x61, 0x17, 0x14, 0xf1, 0x4e, 0x07, 0x5c, 0x10,
	0x48, 0x58, 0xf2, 0xf6, 0xe6, 0xcf, 0xd6, 0xab, 0xde, 0xdf, 0x01, 0x5a,
	0x82, 0x1d, 0x03, 0x60, 0x8b, 0xf4, 0xeb, 0xa3, 0x16, 0x9a, 0x67, 0x25,
	0xec, 0x42, 0x2c, 0xd9, 0x06, 0x94, 0x98, 0xb5, 0x51, 0x5a, 0x96, 0x08,
	0xae, 0x7c, 0xc3, 0x0e, 0x3d, 0x2e, 0xcf, 0xc1, 0xdb, 0x68, 0x25, 0xf3,
	0xe9, 0x96, 0xce, 0x9a, 0x50, 0x92, 0x92, 0x6b, 0xc1, 0xcf, 0x61, 0xaa,
	0x42, 0xd7, 0xf2, 0x40, 0xe6, 0xf7, 0xaa, 0x0e, 0xdb, 0x38, 0xbf, 0x81,
	0xaa, 0x92, 0x9d, 0x66, 0xbb, 0x5d, 0x89, 0x00, 0x18, 0x08, 0x84, 0x58,
	0x72, 0x0d, 0x72, 0xd5, 0x69, 0x24, 0x7b, 0x0c
};
static const uint8_t ac_rsassa_vect14_out[] = {
	0x8f, 0x16, 0xc8, 0x07, 0xbe, 0xf3, 0xed, 0x6f, 0x74, 0xee, 0x7f, 0xf5,
	0xc3, 0x60, 0xa5, 0x42, 0x8c, 0x6c, 0x2f, 0x10, 0x51, 0x78, 0xb5, 0x8f,
	0xf7, 0xd0, 0x73, 0xe5, 0x66, 0xda, 0xd6, 0xe7, 0x71, 0x8d, 0x31, 0x29,
	0xc7, 0x68, 0xcd, 0x5a, 0x96, 0x66, 0xde, 0x2b, 0x6c, 0x94, 0x71, 0x77,
	0xb4, 0x57, 0x09, 0xdc, 0x7c, 0xd0, 0xf4, 0x3b, 0x0b, 0xa6, 0xfc, 0x75,
	0x57, 0x8e, 0x11, 0x96, 0xac, 0xc1, 0x5c, 0xa3, 0xaf, 0xe4, 0xa7, 0x8c,
	0x14, 0x4c, 0xb6, 0x88, 0x5c, 0x1c, 0xc8, 0x15, 0xf7, 0xf9, 0x89, 0x25,
	0xbc, 0x04, 0xad, 0x2f, 0xf2, 0x0f, 0xc1, 0x06, 0x8b, 0x04, 0x5d, 0x94,
	0x50, 0xe2, 0xa1, 0xdc, 0xf5, 0xa1, 0x61, 0xce, 0xab, 0xba, 0x2b, 0x0b,
	0x66, 0xc7, 0x35, 0x4f, 0xdb, 0x80, 0xfa, 0x1d, 0x72, 0x9e, 0x5f, 0x97,
	0x63, 0x87, 0xf2, 0x4a, 0x69, 0x7a, 0x7e, 0x56
};

/* SigGen15_186-2.txt line 214 SHA-512 */
#define ac_rsassa_vect15_modulus ac_siggenpss_186_2_modulus
#define ac_rsassa_vect15_pub_exp ac_siggenpss_186_2_pub_exp
#define ac_rsassa_vect15_priv_exp ac_siggenpss_186_2_priv_exp
#define ac_rsassa_vect15_prime1 ac_siggenpss_186_2_prime1
#define ac_rsassa_vect15_prime2 ac_siggenpss_186_2_prime2
#define ac_rsassa_vect15_exp1 ac_siggenpss_186_2_exp1
#define ac_rsassa_vect15_exp2 ac_siggenpss_186_2_exp2
#define ac_rsassa_vect15_coeff ac_siggenpss_186_2_coeff
#define ac_rsassa_vect15_salt_len ac_siggenpss_186_2_salt_len
static const uint8_t ac_rsassa_vect15_ptx[] = {
	0x12, 0x48, 0xf6, 0x2a, 0x43, 0x89, 0xf4, 0x2f, 0x7b, 0x4b, 0xb1, 0x31,
	0x05, 0x3d, 0x6c, 0x88, 0xa9, 0x94, 0xdb, 0x20, 0x75, 0xb9, 0x12, 0xcc,
	0xbe, 0x3e, 0xa7, 0xdc, 0x61, 0x17, 0x14, 0xf1, 0x4e, 0x07, 0x5c, 0x10,
	0x48, 0x58, 0xf2, 0xf6, 0xe6, 0xcf, 0xd6, 0xab, 0xde, 0xdf, 0x01, 0x5a,
	0x82, 0x1d, 0x03, 0x60, 0x8b, 0xf4, 0xeb, 0xa3, 0x16, 0x9a, 0x67, 0x25,
	0xec, 0x42, 0x2c, 0xd9, 0x06, 0x94, 0x98, 0xb5, 0x51, 0x5a, 0x96, 0x08,
	0xae, 0x7c, 0xc3, 0x0e, 0x3d, 0x2e, 0xcf, 0xc1, 0xdb, 0x68, 0x25, 0xf3,
	0xe9, 0x96, 0xce, 0x9a, 0x50, 0x92, 0x92, 0x6b, 0xc1, 0xcf, 0x61, 0xaa,
	0x42, 0xd7, 0xf2, 0x40, 0xe6, 0xf7, 0xaa, 0x0e, 0xdb, 0x38, 0xbf, 0x81,
	0xaa, 0x92, 0x9d, 0x66, 0xbb, 0x5d, 0x89, 0x00, 0x18, 0x08, 0x84, 0x58,
	0x72, 0x0d, 0x72, 0xd5, 0x69, 0x24, 0x7b, 0x0c
};
static const uint8_t ac_rsassa_vect15_out[] = {
	0xa8, 0x33, 0xba, 0x31, 0x63, 0x4f, 0x87, 0x73, 0xe4, 0xfe, 0x6e, 0xa0,
	0xc6, 0x9e, 0x1a, 0x23, 0x76, 0x6a, 0x93, 0x9d, 0x34, 0xb3, 0x2f, 0xc7,
	0x8b, 0x77, 0x4b, 0x22, 0xe4, 0x6a, 0x64, 0x6c, 0x25, 0xe6, 0xe1, 0x06,
	0x2d, 0x23, 0x4e, 0xd4, 0x8b, 0x1a, 0xba, 0x0f, 0x83, 0x05, 0x29, 0xff,
	0x6a, 0xfc, 0x29, 0x6c, 0xc8, 0xdc, 0x20, 0x7b, 0xbc, 0x15, 0x39, 0x16,
	0x23, 0xbe, 0xac, 0x5f, 0x6c, 0x3d, 0xb5, 0x57, 0xca, 0x49, 0xd0, 0xe4,
	0x2c, 0x96, 0x2d, 0xe9, 0x5b, 0x5f, 0xf5, 0x48, 0xcf, 0xf9, 0x70, 0xf5,
	0xc7, 0x3f, 0x43, 0x9c, 0xfe, 0x82, 0xd3, 0x90, 0x7b, 0xe6, 0x02, 0x40,
	0xf5, 0x6b, 0x6a, 0x42, 0x59, 0xcc, 0x96, 0xdf, 0xd8, 0xfe, 0x02, 0xa0,
	0xbf, 0xa2, 0x6e, 0x02, 0x23, 0xf6, 0x82, 0x14, 0x42, 0x8f, 0xff, 0x0a,
	0xe4, 0x01, 0x62, 0x19, 0x8c, 0xc5, 0xcb, 0xd1
};

/*
 * Test data from ftp://ftp.rsa.com/pub/rsalabs/tmp/pkcs1v15crypt-vectors.txt
 *
 * As specified in PKCS#1, the block type for this operation is 2.
 * The seed value of each example provides the pseudo random bytes
 * to be used for padding. This makes the result predictable.
 */

/* PKCS#1 v1.5 Signature Example 1 1024-bit RSA key pair */
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_modulus[] = {
	0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8,
	0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55,
	0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0,
	0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85,
	0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5,
	0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58,
	0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55,
	0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14,
	0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66,
	0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf,
	0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_pub_exp[] = {
	0x01, 0x00, 0x01
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_priv_exp[] = {
	0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73,
	0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf,
	0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9,
	0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b,
	0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5,
	0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26,
	0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16,
	0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf,
	0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7,
	0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd,
	0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_prime1[] = {
	0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0,
	0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d,
	0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48,
	0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1,
	0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e,
	0xac, 0x7c, 0xa3, 0x9d
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_prime2[] = {
	0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4,
	0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed,
	0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d,
	0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe,
	0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0,
	0x28, 0x8b, 0x5d, 0x77
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_exp1[] = {
	0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3,
	0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c,
	0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae,
	0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d,
	0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78,
	0x78, 0xe6, 0x95, 0xc1
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_exp2[] = {
	0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6,
	0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e,
	0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7,
	0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a,
	0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca,
	0x85, 0xd7, 0x15, 0x83
};
static const uint8_t ac_rsaes_pkcs1_v1_5_example1_coeff[] = {
	0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56,
	0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9,
	0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d,
	0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81,
	0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2,
	0xf4, 0xfb, 0xd8, 0xe1
};


/* PKCS#1 v1.5 Encrypt Example 1.1 */
#define ac_rsaes_pkcs1_v1_5_vect1_modulus ac_rsaes_pkcs1_v1_5_example1_modulus
#define ac_rsaes_pkcs1_v1_5_vect1_pub_exp ac_rsaes_pkcs1_v1_5_example1_pub_exp
#define ac_rsaes_pkcs1_v1_5_vect1_priv_exp ac_rsaes_pkcs1_v1_5_example1_priv_exp
#define ac_rsaes_pkcs1_v1_5_vect1_prime1 ac_rsaes_pkcs1_v1_5_example1_prime1
#define ac_rsaes_pkcs1_v1_5_vect1_prime2 ac_rsaes_pkcs1_v1_5_example1_prime2
#define ac_rsaes_pkcs1_v1_5_vect1_exp1 ac_rsaes_pkcs1_v1_5_example1_exp1
#define ac_rsaes_pkcs1_v1_5_vect1_exp2 ac_rsaes_pkcs1_v1_5_example1_exp2
#define ac_rsaes_pkcs1_v1_5_vect1_coeff ac_rsaes_pkcs1_v1_5_example1_coeff
static const uint8_t ac_rsaes_pkcs1_v1_5_vect1_ptx[] = {
	0x66, 0x28, 0x19, 0x4e, 0x12, 0x07, 0x3d, 0xb0, 0x3b, 0xa9, 0x4c, 0xda,
	0x9e, 0xf9, 0x53, 0x23,
	0x97, 0xd5, 0x0d, 0xba, 0x79, 0xb9, 0x87, 0x00, 0x4a, 0xfe, 0xfe, 0x34,
};
static const uint8_t ac_rsaes_pkcs1_v1_5_vect1_out[] = {
	0x50, 0xb4, 0xc1, 0x41, 0x36, 0xbd, 0x19, 0x8c, 0x2f, 0x3c, 0x3e, 0xd2,
	0x43, 0xfc, 0xe0, 0x36,
	0xe1, 0x68, 0xd5, 0x65, 0x17, 0x98, 0x4a, 0x26, 0x3c, 0xd6, 0x64, 0x92,
	0xb8, 0x08, 0x04, 0xf1,
	0x69, 0xd2, 0x10, 0xf2, 0xb9, 0xbd, 0xfb, 0x48, 0xb1, 0x2f, 0x9e, 0xa0,
	0x50, 0x09, 0xc7, 0x7d,
	0xa2, 0x57, 0xcc, 0x60, 0x0c, 0xce, 0xfe, 0x3a, 0x62, 0x83, 0x78, 0x9d,
	0x8e, 0xa0, 0xe6, 0x07,
	0xac, 0x58, 0xe2, 0x69, 0x0e, 0xc4, 0xeb, 0xc1, 0x01, 0x46, 0xe8, 0xcb,
	0xaa, 0x5e, 0xd4, 0xd5,
	0xcc, 0xe6, 0xfe, 0x7b, 0x0f, 0xf9, 0xef, 0xc1, 0xea, 0xbb, 0x56, 0x4d,
	0xbf, 0x49, 0x82, 0x85,
	0xf4, 0x49, 0xee, 0x61, 0xdd, 0x7b, 0x42, 0xee, 0x5b, 0x58, 0x92, 0xcb,
	0x90, 0x60, 0x1f, 0x30,
	0xcd, 0xa0, 0x7b, 0xf2, 0x64, 0x89, 0x31, 0x0b, 0xcd, 0x23, 0xb5, 0x28,
	0xce, 0xab, 0x3c, 0x31,
};


/* PKCS#1 v1.5 Encrypt Example 1.2 */
#define ac_rsaes_pkcs1_v1_5_vect2_modulus ac_rsaes_pkcs1_v1_5_example1_modulus
#define ac_rsaes_pkcs1_v1_5_vect2_pub_exp ac_rsaes_pkcs1_v1_5_example1_pub_exp
#define ac_rsaes_pkcs1_v1_5_vect2_priv_exp ac_rsaes_pkcs1_v1_5_example1_priv_exp
#define ac_rsaes_pkcs1_v1_5_vect2_prime1 ac_rsaes_pkcs1_v1_5_example1_prime1
#define ac_rsaes_pkcs1_v1_5_vect2_prime2 ac_rsaes_pkcs1_v1_5_example1_prime2
#define ac_rsaes_pkcs1_v1_5_vect2_exp1 ac_rsaes_pkcs1_v1_5_example1_exp1
#define ac_rsaes_pkcs1_v1_5_vect2_exp2 ac_rsaes_pkcs1_v1_5_example1_exp2
#define ac_rsaes_pkcs1_v1_5_vect2_coeff ac_rsaes_pkcs1_v1_5_example1_coeff
static const uint8_t ac_rsaes_pkcs1_v1_5_vect2_ptx[] = {
	0x75, 0x0c, 0x40, 0x47, 0xf5, 0x47, 0xe8, 0xe4, 0x14, 0x11, 0x85, 0x65,
	0x23, 0x29, 0x8a, 0xc9, 0xba, 0xe2, 0x45, 0xef, 0xaf, 0x13, 0x97, 0xfb,
	0xe5, 0x6f, 0x9d, 0xd5
};
static const uint8_t ac_rsaes_pkcs1_v1_5_vect2_out[] = {
	0x68, 0x42, 0xe5, 0xe2, 0xcc, 0x00, 0x41, 0xd6, 0xb0, 0xc8, 0x1a, 0x56,
	0x2c, 0x39, 0xa6, 0x17, 0x37, 0x9a, 0x51, 0x5c, 0xab, 0x74, 0xab, 0xcb,
	0x26, 0x19, 0xc7, 0x74, 0x0a, 0x54, 0x1d, 0x95, 0x55, 0xdd, 0x91, 0x65,
	0x97, 0x5b, 0xf8, 0xa3, 0xeb, 0xd0, 0xd0, 0x45, 0x66, 0x61, 0xdf, 0xb1,
	0xa6, 0x86, 0x1b, 0xa2, 0x33, 0x22, 0x69, 0x93, 0x0e, 0x0d, 0xb5, 0x14,
	0xfc, 0xa0, 0x73, 0x3e, 0xeb, 0x9c, 0x40, 0x57, 0x13, 0xeb, 0x1f, 0x9d,
	0x76, 0x80, 0x33, 0xed, 0x29, 0x3e, 0x1e, 0x08, 0x1a, 0x12, 0x5f, 0x32,
	0xdd, 0xb9, 0xea, 0x52, 0xed, 0xbe, 0x27, 0x5c, 0x4a, 0xf6, 0x0f, 0x8a,
	0x7b, 0xf8, 0x32, 0xbd, 0x22, 0x75, 0x61, 0xc2, 0x08, 0xdc, 0x00, 0x31,
	0xa8, 0x4b, 0x50, 0x12, 0xc9, 0xdd, 0x9f, 0x74, 0x45, 0x9d, 0xcb, 0x07,
	0x0b, 0xdb, 0xe1, 0x3c, 0xfa, 0x8c, 0x2d, 0x50
};

/*
 * Test data from ftp://ftp.rsasecurity.com/pub/pkcs/pkcs-1/pkcs-1v2-1-vec.zip
 *
 * The underlying hash function is SHA-1; the mask generation function is
 * MGF1 with SHA-1 as specified in PKCS #1 v2.1.
 */

/* Example 1: A 1024-bit RSA Key Pair */
#define ac_rsaes_oaep_example1_modulus  ac_rsaes_pkcs1_v1_5_example1_modulus
#define ac_rsaes_oaep_example1_pub_exp  ac_rsaes_pkcs1_v1_5_example1_pub_exp
#define ac_rsaes_oaep_example1_priv_exp ac_rsaes_pkcs1_v1_5_example1_priv_exp
#define ac_rsaes_oaep_example1_prime1   ac_rsaes_pkcs1_v1_5_example1_prime1
#define ac_rsaes_oaep_example1_prime2   ac_rsaes_pkcs1_v1_5_example1_prime2
#define ac_rsaes_oaep_example1_exp1     ac_rsaes_pkcs1_v1_5_example1_exp1
#define ac_rsaes_oaep_example1_exp2     ac_rsaes_pkcs1_v1_5_example1_exp2
#define ac_rsaes_oaep_example1_coeff    ac_rsaes_pkcs1_v1_5_example1_coeff


/* RSAES-OAEP Encryption Example 1.1 */
#define ac_rsaes_oaep_vect1_modulus ac_rsaes_oaep_example1_modulus
#define ac_rsaes_oaep_vect1_pub_exp ac_rsaes_oaep_example1_pub_exp
#define ac_rsaes_oaep_vect1_priv_exp ac_rsaes_oaep_example1_priv_exp
#define ac_rsaes_oaep_vect1_prime1 ac_rsaes_oaep_example1_prime1
#define ac_rsaes_oaep_vect1_prime2 ac_rsaes_oaep_example1_prime2
#define ac_rsaes_oaep_vect1_exp1 ac_rsaes_oaep_example1_exp1
#define ac_rsaes_oaep_vect1_exp2 ac_rsaes_oaep_example1_exp2
#define ac_rsaes_oaep_vect1_coeff ac_rsaes_oaep_example1_coeff
static const uint8_t ac_rsaes_oaep_vect1_ptx[] = {
	0x66, 0x28, 0x19, 0x4e, 0x12, 0x07, 0x3d, 0xb0, 0x3b, 0xa9, 0x4c, 0xda,
	0x9e, 0xf9, 0x53, 0x23, 0x97, 0xd5, 0x0d, 0xba, 0x79, 0xb9, 0x87, 0x00,
	0x4a, 0xfe, 0xfe, 0x34,
};
static const uint8_t ac_rsaes_oaep_vect1_out[] = {
	0x35, 0x4f, 0xe6, 0x7b, 0x4a, 0x12, 0x6d, 0x5d, 0x35, 0xfe, 0x36, 0xc7,
	0x77, 0x79, 0x1a, 0x3f, 0x7b, 0xa1, 0x3d, 0xef, 0x48, 0x4e, 0x2d, 0x39,
	0x08, 0xaf, 0xf7, 0x22, 0xfa, 0xd4, 0x68, 0xfb, 0x21, 0x69, 0x6d, 0xe9,
	0x5d, 0x0b, 0xe9, 0x11, 0xc2, 0xd3, 0x17, 0x4f, 0x8a, 0xfc, 0xc2, 0x01,
	0x03, 0x5f, 0x7b, 0x6d, 0x8e, 0x69, 0x40, 0x2d, 0xe5, 0x45, 0x16, 0x18,
	0xc2, 0x1a, 0x53, 0x5f, 0xa9, 0xd7, 0xbf, 0xc5, 0xb8, 0xdd, 0x9f, 0xc2,
	0x43, 0xf8, 0xcf, 0x92, 0x7d, 0xb3, 0x13, 0x22, 0xd6, 0xe8, 0x81, 0xea,
	0xa9, 0x1a, 0x99, 0x61, 0x70, 0xe6, 0x57, 0xa0, 0x5a, 0x26, 0x64, 0x26,
	0xd9, 0x8c, 0x88, 0x00, 0x3f, 0x84, 0x77, 0xc1, 0x22, 0x70, 0x94, 0xa0,
	0xd9, 0xfa, 0x1e, 0x8c, 0x40, 0x24, 0x30, 0x9c, 0xe1, 0xec, 0xcc, 0xb5,
	0x21, 0x00, 0x35, 0xd4, 0x7a, 0xc7, 0x2e, 0x8a
};

/* RSAES-OAEP Encryption Example 1.2 */
#define ac_rsaes_oaep_vect2_modulus ac_rsaes_oaep_example1_modulus
#define ac_rsaes_oaep_vect2_pub_exp ac_rsaes_oaep_example1_pub_exp
#define ac_rsaes_oaep_vect2_priv_exp ac_rsaes_oaep_example1_priv_exp
#define ac_rsaes_oaep_vect2_prime1 ac_rsaes_oaep_example1_prime1
#define ac_rsaes_oaep_vect2_prime2 ac_rsaes_oaep_example1_prime2
#define ac_rsaes_oaep_vect2_exp1 ac_rsaes_oaep_example1_exp1
#define ac_rsaes_oaep_vect2_exp2 ac_rsaes_oaep_example1_exp2
#define ac_rsaes_oaep_vect2_coeff ac_rsaes_oaep_example1_coeff
static const uint8_t ac_rsaes_oaep_vect2_ptx[] = {
	0x75, 0x0c, 0x40, 0x47, 0xf5, 0x47, 0xe8, 0xe4, 0x14, 0x11, 0x85, 0x65,
	0x23, 0x29, 0x8a, 0xc9, 0xba, 0xe2, 0x45, 0xef, 0xaf, 0x13, 0x97, 0xfb,
	0xe5, 0x6f, 0x9d, 0xd5
};
static const uint8_t ac_rsaes_oaep_vect2_out[] = {
	0x64, 0x0d, 0xb1, 0xac, 0xc5, 0x8e, 0x05, 0x68, 0xfe, 0x54, 0x07, 0xe5,
	0xf9, 0xb7, 0x01, 0xdf, 0xf8, 0xc3, 0xc9, 0x1e, 0x71, 0x6c, 0x53, 0x6f,
	0xc7, 0xfc, 0xec, 0x6c, 0xb5, 0xb7, 0x1c, 0x11, 0x65, 0x98, 0x8d, 0x4a,
	0x27, 0x9e, 0x15, 0x77, 0xd7, 0x30, 0xfc, 0x7a, 0x29, 0x93, 0x2e, 0x3f,
	0x00, 0xc8, 0x15, 0x15, 0x23, 0x6d, 0x8d, 0x8e, 0x31, 0x01, 0x7a, 0x7a,
	0x09, 0xdf, 0x43, 0x52, 0xd9, 0x04, 0xcd, 0xeb, 0x79, 0xaa, 0x58, 0x3a,
	0xdc, 0xc3, 0x1e, 0xa6, 0x98, 0xa4, 0xc0, 0x52, 0x83, 0xda, 0xba, 0x90,
	0x89, 0xbe, 0x54, 0x91, 0xf6, 0x7c, 0x1a, 0x4e, 0xe4, 0x8d, 0xc7, 0x4b,
	0xbb, 0xe6, 0x64, 0x3a, 0xef, 0x84, 0x66, 0x79, 0xb4, 0xcb, 0x39, 0x5a,
	0x35, 0x2d, 0x5e, 0xd1, 0x15, 0x91, 0x2d, 0xf6, 0x96, 0xff, 0xe0, 0x70,
	0x29, 0x32, 0x94, 0x6d, 0x71, 0x49, 0x2b, 0x44
};

/*
 * RSA-OAEP decryption (SHA-256 + MGF1 SHA-1) test vectors from
 * https://github.com/C2SP/wycheproof/blob/master/testvectors/rsa_oaep_2048_sha256_mgf1sha1_test.json
 */
static const uint8_t ac_rsaes_oaep_vect3_modulus[] = {
	0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
	0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
	0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
	0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
	0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
	0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
	0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
	0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
	0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
	0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
	0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
	0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
	0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
	0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
	0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
	0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
	0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
	0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
	0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
	0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
	0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
	0xf7, 0x42, 0xb9, 0xd5
};

#define ac_rsaes_oaep_vect3_pub_exp	ac_rsaes_oaep_example1_pub_exp

static const uint8_t ac_rsaes_oaep_vect3_priv_exp[] = {
	0x76, 0x27, 0xee, 0xf3, 0x56, 0x7b, 0x2a, 0x27, 0x26, 0x8e, 0x52, 0x05,
	0x3e, 0xcd, 0x31, 0xc3, 0xa7, 0x17, 0x2c, 0xcb, 0x9d, 0xdc, 0xee, 0x81,
	0x9b, 0x30, 0x6a, 0x5b, 0x3c, 0x66, 0xb7, 0x57, 0x3c, 0xa4, 0xfa, 0x88,
	0xef, 0xc6, 0xf3, 0xc4, 0xa0, 0x0b, 0xfa, 0x0a, 0xe7, 0x13, 0x9f, 0x64,
	0x54, 0x3a, 0x4d, 0xac, 0x3d, 0x05, 0x82, 0x3f, 0x6f, 0xf4, 0x77, 0xcf,
	0xce, 0xc8, 0x4f, 0xe2, 0xac, 0x7a, 0x68, 0xb1, 0x72, 0x04, 0xb3, 0x90,
	0x23, 0x2e, 0x11, 0x03, 0x10, 0xc4, 0xe8, 0x99, 0xc4, 0xe7, 0xc1, 0x09,
	0x67, 0xdb, 0x4a, 0xcd, 0xe0, 0x42, 0xdb, 0xbf, 0x19, 0xdb, 0xe0, 0x0b,
	0x4b, 0x47, 0x41, 0xde, 0x10, 0x20, 0xaa, 0xaa, 0xff, 0xb5, 0x05, 0x4c,
	0x79, 0x7c, 0x9f, 0x13, 0x6f, 0x7d, 0x93, 0xac, 0x3f, 0xc8, 0xca, 0xff,
	0x66, 0x54, 0x24, 0x2d, 0x78, 0x21, 0xeb, 0xee, 0x51, 0x7b, 0xf5, 0x37,
	0xf4, 0x43, 0x66, 0xa0, 0xfd, 0xd4, 0x5a, 0xe0, 0x5b, 0x99, 0x09, 0xc2,
	0xe6, 0xcc, 0x1e, 0xd9, 0x28, 0x1e, 0xff, 0x43, 0x99, 0xf7, 0x6c, 0x96,
	0xb9, 0x62, 0x33, 0xec, 0x29, 0xae, 0x0b, 0xbf, 0x0d, 0x75, 0x2b, 0x23,
	0x4f, 0xc1, 0x97, 0x38, 0x9f, 0x51, 0x05, 0x0a, 0xa1, 0xac, 0xd0, 0x1c,
	0x07, 0x4c, 0x3a, 0xc8, 0xfb, 0xdb, 0x9e, 0xa8, 0xb6, 0x51, 0xa9, 0x59,
	0x95, 0xe8, 0xdb, 0x4a, 0xd5, 0xc4, 0x3b, 0x6c, 0x86, 0x73, 0xe5, 0xa1,
	0x26, 0xe7, 0xee, 0x94, 0xb8, 0xdf, 0xf4, 0xc5, 0xaf, 0xc0, 0x12, 0x59,
	0xbc, 0x8d, 0xa7, 0x69, 0x50, 0xba, 0xe6, 0xf8, 0xba, 0xe7, 0x15, 0xf5,
	0x09, 0x85, 0xb0, 0xd6, 0xf6, 0x6d, 0x04, 0xc6, 0xfe, 0xf3, 0xb7, 0x00,
	0x72, 0x0e, 0xec, 0xdc, 0xdf, 0x17, 0x1b, 0xb7, 0xb1, 0xec, 0xbe, 0x72,
	0x89, 0xc4, 0x67, 0xc1
};

static const uint8_t ac_rsaes_oaep_vect3_prime1[] = {
	0xdc, 0x43, 0x10, 0x50, 0xf7, 0x82, 0xe8, 0x94, 0xfb, 0x52, 0x48, 0x24,
	0x7d, 0x98, 0xcb, 0x7d, 0x58, 0xb8, 0xd1, 0xe2, 0x4f, 0x3b, 0x55, 0xd0,
	0x41, 0xc5, 0x6e, 0x4d, 0xe0, 0x86, 0xb0, 0xd5, 0xbb, 0x02, 0x8b, 0xda,
	0x42, 0xee, 0xb5, 0xd2, 0x34, 0xd5, 0x68, 0x1e, 0x58, 0x09, 0xd4, 0x15,
	0xe6, 0xa2, 0x89, 0xad, 0x4c, 0xfb, 0xf7, 0x8f, 0x97, 0x8f, 0x6c, 0x35,
	0x81, 0x4f, 0x50, 0xee, 0xbf, 0xf1, 0xc5, 0xb8, 0x0a, 0x69, 0xf7, 0x88,
	0xe8, 0x1e, 0x6b, 0xab, 0x5d, 0xda, 0xa7, 0x83, 0x69, 0xd6, 0x59, 0xd1,
	0x43, 0xec, 0x6f, 0x17, 0xe7, 0x98, 0x13, 0xa5, 0x75, 0xcf, 0xad, 0x9c,
	0x56, 0x91, 0x56, 0xb9, 0x01, 0x13, 0xe2, 0xe9, 0x11, 0x0a, 0xd9, 0xe7,
	0xb4, 0x8a, 0x1c, 0x93, 0x48, 0xa6, 0xe6, 0x53, 0x32, 0x11, 0x91, 0x29,
	0x0e, 0xa3, 0x6c, 0xfb, 0x3a, 0x5b, 0x18, 0xf1
};

static const uint8_t ac_rsaes_oaep_vect3_prime2[] = {
	0xbd, 0x1a, 0x81, 0xe7, 0x97, 0x7f, 0x98, 0x98, 0x12, 0x22, 0x73, 0xae,
	0x32, 0x22, 0xb5, 0x98, 0xea, 0x5f, 0xb1, 0x9e, 0xb4, 0xea, 0xbc, 0x38,
	0x30, 0x8a, 0x5e, 0x32, 0x19, 0x66, 0x03, 0xb2, 0xe5, 0x00, 0xff, 0xb7,
	0x9f, 0x5b, 0x88, 0x68, 0x16, 0x61, 0x1d, 0xeb, 0xc4, 0x72, 0xfa, 0xc4,
	0x55, 0x44, 0x07, 0x0b, 0xeb, 0x05, 0x7c, 0x94, 0x13, 0x78, 0xa6, 0x86,
	0x8a, 0xf3, 0xb7, 0xa0, 0x3d, 0x3f, 0x98, 0x80, 0xec, 0x47, 0xd5, 0xe0,
	0x89, 0xb9, 0x4f, 0xbd, 0xe5, 0x42, 0xab, 0xa9, 0xae, 0x8d, 0x72, 0xc5,
	0x70, 0x88, 0xd7, 0xab, 0xf5, 0xb1, 0x31, 0xf3, 0x90, 0x98, 0xf7, 0xbc,
	0x16, 0x0f, 0x90, 0x53, 0x6a, 0xbc, 0x94, 0x92, 0xfd, 0x4e, 0x06, 0xf3,
	0xed, 0x72, 0x99, 0xd4, 0xb9, 0x7b, 0xb0, 0x36, 0x77, 0x20, 0x7d, 0x95,
	0x66, 0x9f, 0x14, 0x0c, 0xfb, 0xc2, 0x0f, 0x25
};

static const uint8_t ac_rsaes_oaep_vect3_exp1[] = {
	0xa9, 0x4b, 0x52, 0x8b, 0x28, 0xf2, 0x91, 0x59, 0x91, 0x21, 0xd9, 0x19,
	0x52, 0xff, 0xd1, 0xc7, 0xf2, 0x1d, 0x7c, 0x14, 0x79, 0xd9, 0x9d, 0x47,
	0x88, 0x85, 0xfb, 0x16, 0x18, 0x70, 0xee, 0x12, 0x18, 0xbf, 0x08, 0x47,
	0x26, 0x12, 0xdb, 0xe5, 0x49, 0x7e, 0x8d, 0x9c, 0x65, 0x06, 0x88, 0xe0,
	0x9c, 0x78, 0x69, 0x61, 0xae, 0x3e, 0x2c, 0x35, 0x4d, 0xc4, 0x8a, 0xe3,
	0x45, 0x14, 0x75, 0x9c, 0x4c, 0x23, 0xc4, 0x58, 0x84, 0x88, 0x96, 0x1d,
	0xc0, 0x6b, 0x41, 0x4e, 0x61, 0xc0, 0xe1, 0xe7, 0xfb, 0xbd, 0x29, 0x23,
	0xd3, 0x15, 0x32, 0xfe, 0x28, 0x9f, 0x96, 0xda, 0x22, 0x07, 0x11, 0xe5,
	0x8c, 0x14, 0x01, 0x98, 0x08, 0xe0, 0x04, 0x14, 0x27, 0x69, 0x33, 0xbb,
	0x07, 0xe4, 0xef, 0xb9, 0xb4, 0xa9, 0xb3, 0x76, 0x56, 0x91, 0x72, 0x05,
	0x20, 0x9f, 0x33, 0xf0, 0x95, 0x15, 0xd7, 0xc1
};

static const uint8_t ac_rsaes_oaep_vect3_exp2[] = {
	0x3a, 0xf0, 0xe7, 0x2a, 0x93, 0x3a, 0xef, 0x09, 0xff, 0x25, 0x03, 0xdf,
	0x78, 0xba, 0xfe, 0xd5, 0x31, 0xc0, 0x2f, 0xf1, 0xa2, 0xbc, 0x43, 0x7c,
	0x54, 0x0c, 0xdc, 0xbd, 0x4a, 0xd3, 0x54, 0x35, 0xcf, 0x51, 0x17, 0x63,
	0x59, 0x65, 0x43, 0x48, 0x06, 0x29, 0xb1, 0x14, 0xca, 0x7f, 0x78, 0x0f,
	0xf7, 0xef, 0xa3, 0x2e, 0xa0, 0xcb, 0x6e, 0x00, 0x0d, 0x6d, 0x9e, 0xa1,
	0xf2, 0xef, 0x71, 0xfd, 0x9c, 0xf9, 0x94, 0x84, 0x22, 0xa1, 0x65, 0x55,
	0x7e, 0x37, 0xe7, 0x55, 0xed, 0xfe, 0x70, 0xd9, 0x0b, 0x92, 0x05, 0x02,
	0xeb, 0x47, 0x8b, 0xc9, 0x8a, 0x63, 0xf7, 0x88, 0xce, 0x3a, 0x0f, 0x85,
	0x6d, 0x6e, 0xde, 0x72, 0x51, 0xa3, 0x83, 0xbf, 0xa8, 0xfa, 0x48, 0x0a,
	0x81, 0xa9, 0x25, 0xaf, 0x7b, 0x3c, 0xc5, 0x38, 0xc4, 0xba, 0xb8, 0xc9,
	0xf7, 0x59, 0x7f, 0xfb, 0x68, 0x01, 0x1d, 0x8d
};

static const uint8_t ac_rsaes_oaep_vect3_coeff[] = {
	0x26, 0x40, 0xfb, 0xfb, 0xcf, 0xef, 0xb1, 0x63, 0xee, 0x7a, 0x87, 0xb6,
	0x48, 0x3a, 0x66, 0xee, 0x41, 0xf9, 0x56, 0xd9, 0x0f, 0xa8, 0xa7, 0x93,
	0x9b, 0xfc, 0x04, 0x2e, 0xe0, 0x92, 0x4b, 0x1b, 0x79, 0x93, 0xd0, 0x44,
	0x5f, 0x75, 0x8d, 0x51, 0x93, 0x3e, 0x85, 0x17, 0x9c, 0x03, 0x20, 0xb0,
	0xc9, 0x68, 0xb4, 0x8a, 0x91, 0xc3, 0x8b, 0x5b, 0xe9, 0x23, 0xe1, 0x09,
	0x7c, 0x0c, 0x56, 0x2f, 0x88, 0xd4, 0x22, 0x94, 0xb6, 0xa2, 0x75, 0x9b,
	0xaf, 0xa5, 0x42, 0x8a, 0x74, 0xf1, 0x27, 0x08, 0x74, 0xe4, 0x5f, 0x6f,
	0xcc, 0x60, 0xf2, 0x16, 0x02, 0xde, 0x5e, 0xcc, 0xd1, 0x43, 0xcf, 0x31,
	0x24, 0x1f, 0x59, 0x21, 0xb5, 0xad, 0x39, 0x83, 0xfb, 0x54, 0xef, 0x17,
	0xbe, 0x3b, 0x28, 0x53, 0x67, 0xe5, 0x0c, 0x99, 0x9c, 0x67, 0x24, 0x7b,
	0x55, 0x2f, 0xe4, 0xbf, 0xce, 0x94, 0x5f, 0x7b
};

/* "tcId" : 7 */
static const uint8_t ac_rsaes_oaep_vect3_ptx[] = {
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb,
	0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};
static const uint8_t ac_rsaes_oaep_vect3_out[] = {
	0x76, 0xf7, 0xb6, 0xe1, 0xcf, 0x45, 0xb0, 0x05, 0xad, 0x58, 0xb5, 0x35,
	0x4c, 0xfc, 0x57, 0x99, 0xf7, 0x4e, 0xdf, 0xb2, 0x7f, 0x27, 0xb4, 0x14,
	0xb4, 0xd2, 0x55, 0x00, 0xa1, 0xec, 0x4b, 0xcd, 0x46, 0xc6, 0xb6, 0x56,
	0x03, 0xb2, 0x04, 0xf6, 0x9a, 0x2a, 0x71, 0xb8, 0xd1, 0x09, 0x9c, 0xe9,
	0x6c, 0x8e, 0xe5, 0x2e, 0x11, 0x9e, 0xd9, 0xb0, 0x80, 0xd8, 0x6d, 0x82,
	0x78, 0x9e, 0x3e, 0x57, 0x77, 0xcc, 0x5f, 0x92, 0x0b, 0x14, 0x71, 0x26,
	0xec, 0x86, 0x12, 0xb2, 0x06, 0xbc, 0x57, 0x34, 0xe8, 0x28, 0xac, 0x81,
	0x9f, 0x90, 0xea, 0x71, 0x91, 0x83, 0x2d, 0x57, 0x0d, 0x37, 0x6d, 0xf2,
	0xc4, 0xe3, 0xeb, 0x50, 0x70, 0xfd, 0x83, 0x82, 0xf8, 0xc0, 0xa9, 0xb8,
	0x9d, 0xa9, 0x28, 0xbf, 0xbd, 0xd2, 0x4b, 0xf1, 0xd1, 0x7e, 0xbc, 0x83,
	0xf9, 0x23, 0x7a, 0x51, 0x35, 0x2f, 0xf0, 0x4b, 0x6b, 0xb3, 0x84, 0x8c,
	0xb6, 0xa9, 0xc1, 0x95, 0xe5, 0x36, 0x9f, 0x4b, 0x6e, 0xd9, 0xb4, 0xcc,
	0x16, 0x63, 0x77, 0xf8, 0x8c, 0x7e, 0x6d, 0xb6, 0xef, 0x78, 0xc0, 0xe1,
	0xbf, 0xba, 0xc5, 0xa3, 0x82, 0x58, 0x67, 0xaf, 0x9b, 0x22, 0x68, 0x9b,
	0x62, 0x7d, 0xcd, 0x8d, 0x14, 0x41, 0xb5, 0x15, 0xb1, 0x5b, 0x78, 0x68,
	0x8b, 0x52, 0xb0, 0x4d, 0xf4, 0x15, 0x7a, 0x88, 0x8a, 0xab, 0xdb, 0x9e,
	0x79, 0x2c, 0x65, 0xfc, 0xbd, 0xcd, 0x03, 0x74, 0x3f, 0xe4, 0x5e, 0x63,
	0x7a, 0xfa, 0x7e, 0x42, 0x27, 0x82, 0xe6, 0xda, 0x58, 0xb9, 0x51, 0x63,
	0xac, 0xd5, 0x93, 0x53, 0xe6, 0x34, 0x33, 0x7a, 0xbb, 0x1c, 0x15, 0xb8,
	0x31, 0xa9, 0xde, 0xc7, 0x9c, 0x51, 0x7a, 0x5b, 0xe0, 0xb4, 0xee, 0x43,
	0xf7, 0x54, 0x4a, 0x2e, 0x9b, 0xf6, 0xaf, 0x2b, 0xc5, 0x3b, 0x08, 0x0c,
	0x60, 0xdc, 0x2b, 0xc6
};

/*
 * PKCS#1 v1.5 Signature Example 15 2048-bit RSA key pair
 * from http://armcryptolib.das-labor.org/trac/browser/testvectors/rsa-pkcs-1v2-1-vec/oaep-vect.txt
 */
static const uint8_t ac_rsaes_pkcs1_v1_5_example15_modulus[] = {
	0xdc, 0xfa, 0x10, 0xff, 0xa7, 0x46, 0x65, 0xae, 0xef, 0x87, 0x09, 0x74, 0xea, 0x99, 0xb2, 0xce,
	0x54, 0x54, 0x7c, 0x67, 0xf4, 0x2a, 0xaa, 0x6d, 0xd0, 0x1a, 0x2e, 0xd3, 0x1f, 0xd2, 0xc2, 0x42,
	0xaf, 0x5d, 0x96, 0x0b, 0x1f, 0x89, 0x6e, 0xfb, 0xa3, 0x54, 0x3d, 0x65, 0x54, 0xb7, 0xb1, 0x26,
	0x87, 0xa5, 0xc6, 0x88, 0x56, 0x8f, 0x32, 0xe0, 0x26, 0xc5, 0x32, 0xd2, 0x59, 0x93, 0xb9, 0x7a,
	0x7c, 0x28, 0x42, 0xec, 0x2b, 0x8e, 0x12, 0x35, 0xee, 0xe2, 0x41, 0x4d, 0x25, 0x80, 0x6c, 0x6f,
	0xba, 0xe4, 0x38, 0x95, 0x4e, 0xba, 0x9d, 0x27, 0x55, 0xdf, 0xfe, 0xeb, 0x1b, 0x47, 0x70, 0x09,
	0x57, 0x81, 0x5a, 0x8a, 0x23, 0x3f, 0x97, 0xb1, 0xa2, 0xc7, 0x14, 0xb3, 0xe2, 0xbe, 0x2e, 0x42,
	0xd8, 0xbe, 0x30, 0xb1, 0x96, 0x15, 0x82, 0xea, 0x99, 0x48, 0x91, 0x0e, 0x0c, 0x79, 0x7c, 0x50,
	0xfc, 0x4b, 0xb4, 0x55, 0xf0, 0xfc, 0x45, 0xe5, 0xe3, 0x4e, 0x63, 0x96, 0xac, 0x5b, 0x2d, 0x46,
	0x23, 0x93, 0x65, 0xc7, 0xf3, 0xda, 0xaf, 0x09, 0x09, 0x40, 0x0d, 0x61, 0xcf, 0x9e, 0x0c, 0xa8,
	0x08, 0x3e, 0xaf, 0x33, 0x5a, 0x6f, 0xce, 0xb6, 0x86, 0x3c, 0x1c, 0xc0, 0xcf, 0x5a, 0x17, 0x1a,
	0xff, 0x35, 0xd9, 0x7e, 0xcb, 0x60, 0xef, 0x25, 0x1c, 0x7e, 0xc2, 0xc8, 0xa5, 0x88, 0x36, 0x1d,
	0xc4, 0x12, 0x66, 0xa4, 0xb7, 0xed, 0x38, 0xb0, 0x26, 0xce, 0x0d, 0x53, 0x78, 0x64, 0x49, 0xdb,
	0xb1, 0x1a, 0x06, 0xea, 0x33, 0xcc, 0xf1, 0xec, 0xa5, 0x75, 0x20, 0x1e, 0xd1, 0xaa, 0x47, 0x3e,
	0xd1, 0x18, 0x7e, 0xc1, 0xd8, 0xa7, 0x44, 0xea, 0x34, 0x5b, 0xed, 0x7e, 0xa0, 0x0e, 0xe4, 0xe8,
	0x1b, 0xba, 0x46, 0x48, 0x60, 0x1d, 0xd5, 0x37, 0xdc, 0x91, 0x01, 0x5d, 0x31, 0xf0, 0xc2, 0xc1,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_pub_exp[] = {
	0x01, 0x00, 0x01,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_priv_exp[] = {
	0x21, 0x95, 0x08, 0x51, 0xcd, 0xf2, 0x53, 0x20, 0x31, 0x8b, 0x30, 0x5a, 0xfa, 0x0f, 0x37, 0x1f,
	0x07, 0xae, 0x5a, 0x44, 0xb3, 0x14, 0xeb, 0xd7, 0x29, 0xf5, 0xdc, 0xb1, 0x5d, 0xa7, 0xfa, 0x39,
	0x47, 0xac, 0xdd, 0x91, 0x5d, 0xae, 0xd5, 0x74, 0xbd, 0x16, 0xdf, 0x88, 0xbf, 0x85, 0xf6, 0x10,
	0x60, 0xb3, 0x87, 0x17, 0x2f, 0xae, 0x6e, 0x01, 0x26, 0x2b, 0x38, 0x64, 0xc2, 0xd3, 0xc2, 0x2f,
	0x94, 0xe0, 0x4a, 0x81, 0x59, 0x42, 0x2b, 0x4e, 0xd2, 0x79, 0xc4, 0x8a, 0x4c, 0x9d, 0x76, 0x7d,
	0x49, 0x66, 0x07, 0x1a, 0x5b, 0xbf, 0x5d, 0x04, 0x3e, 0x16, 0xff, 0x46, 0xec, 0x1b, 0xa0, 0x71,
	0x6f, 0x00, 0xbb, 0xc9, 0x7b, 0xff, 0x5d, 0x56, 0x93, 0xe2, 0x14, 0xe9, 0x9c, 0x97, 0x21, 0xf1,
	0x2b, 0x3e, 0xc6, 0x28, 0x2a, 0xe2, 0xa4, 0x85, 0x72, 0x1b, 0x96, 0xdd, 0xcf, 0x74, 0x03, 0xfa,
	0x03, 0x7d, 0x0c, 0x57, 0xab, 0x46, 0x3c, 0x44, 0x8d, 0xe5, 0xcc, 0x12, 0x26, 0x5a, 0xdd, 0x88,
	0x6d, 0x31, 0x1e, 0xa8, 0xd8, 0xa5, 0x90, 0x3f, 0xa5, 0x6c, 0x5f, 0x1c, 0x9c, 0xf2, 0xeb, 0x11,
	0xcb, 0x65, 0x7a, 0x1a, 0x7d, 0x3e, 0x41, 0x35, 0x2d, 0xc3, 0xe6, 0x86, 0x89, 0x8c, 0x4c, 0xe4,
	0x30, 0x5e, 0x8b, 0x63, 0x8e, 0x1b, 0x08, 0xa2, 0xa8, 0x6c, 0xc9, 0xeb, 0x98, 0x66, 0xf3, 0x49,
	0x9a, 0xc7, 0x7b, 0x61, 0x36, 0xb8, 0x1c, 0xb2, 0x76, 0xd6, 0x14, 0xcf, 0xeb, 0x7b, 0x6e, 0xd3,
	0xf3, 0xbc, 0x77, 0x5e, 0x46, 0xc0, 0x00, 0x66, 0xeb, 0xee, 0xe2, 0xcf, 0xf7, 0x16, 0x6b, 0x57,
	0x52, 0x05, 0x98, 0x94, 0x7f, 0xf6, 0x21, 0x03, 0x20, 0xb2, 0x88, 0xfb, 0x4f, 0x2c, 0x3f, 0x8f,
	0xe9, 0x7b, 0x27, 0x94, 0x14, 0xeb, 0xf7, 0x20, 0x30, 0x00, 0xa1, 0x9f, 0xc0, 0x42, 0x48, 0x75,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_prime1[] = {
	0xf1, 0x23, 0xbf, 0xe5, 0x3d, 0xe9, 0x7a, 0x56, 0x9d, 0x91, 0xad, 0xcf, 0x55, 0x6f, 0xa6, 0x25,
	0xad, 0x30, 0xf3, 0xfd, 0x3d, 0x81, 0x1f, 0x9e, 0x91, 0xe6, 0xaf, 0x44, 0xb6, 0xe7, 0x80, 0xcb,
	0x0f, 0x32, 0x78, 0x29, 0xfb, 0x21, 0x19, 0x0a, 0xe2, 0x80, 0x66, 0x46, 0xd7, 0x28, 0xcd, 0x9b,
	0x65, 0x31, 0x13, 0x2b, 0x1e, 0xbf, 0xef, 0x12, 0x72, 0x99, 0x30, 0x60, 0xf1, 0xce, 0x70, 0xb1,
	0x24, 0x39, 0x30, 0x91, 0xee, 0x85, 0x93, 0xb7, 0x27, 0x36, 0x7e, 0xdb, 0xba, 0x00, 0x9e, 0xc5,
	0xbe, 0x17, 0xc4, 0xac, 0xee, 0x12, 0x0c, 0x84, 0x12, 0x67, 0xd4, 0x76, 0x31, 0xa1, 0x6c, 0x36,
	0xa6, 0xd1, 0xc9, 0x99, 0x73, 0xc1, 0xb0, 0xb5, 0xa8, 0x35, 0xbf, 0x39, 0xfe, 0xaf, 0xe8, 0xf6,
	0x42, 0x1f, 0xd9, 0xc2, 0xa9, 0x0b, 0xc2, 0x79, 0x76, 0x65, 0x9e, 0x67, 0xbc, 0x83, 0x12, 0x4d,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_prime2[] = {
	0xea, 0x98, 0x39, 0xb7, 0xe3, 0x7e, 0xa8, 0x9b, 0xbd, 0xa2, 0x7e, 0x4c, 0x93, 0x47, 0x1c, 0xb4,
	0xfd, 0x92, 0x18, 0x9a, 0x0a, 0x96, 0xbc, 0xb4, 0xd7, 0x56, 0x93, 0xf1, 0x8a, 0x5c, 0x2f, 0x74,
	0x2a, 0xf9, 0xe3, 0x6f, 0xde, 0x67, 0x9f, 0xbd, 0x9e, 0xae, 0x34, 0x5f, 0xa2, 0x69, 0x52, 0x7b,
	0x69, 0x65, 0x02, 0x1c, 0x4b, 0xdf, 0x54, 0xd6, 0x85, 0xbf, 0x08, 0x96, 0x0c, 0xc9, 0x76, 0xf6,
	0x8d, 0xca, 0x21, 0xce, 0xbf, 0x44, 0xf2, 0x68, 0xa5, 0x9d, 0xab, 0x8d, 0x1a, 0x25, 0xe5, 0x19,
	0xf5, 0x14, 0x7e, 0x1f, 0x45, 0xfe, 0x28, 0x7d, 0x74, 0xcf, 0x72, 0x5b, 0xec, 0x13, 0x26, 0xd3,
	0x42, 0x12, 0xc5, 0x6c, 0xf4, 0xff, 0xfa, 0x20, 0x2f, 0x57, 0xb6, 0x8e, 0xe8, 0xcc, 0xa9, 0x43,
	0xf3, 0xc1, 0x38, 0xc4, 0xcd, 0xe3, 0x3b, 0xdf, 0x2c, 0x94, 0x40, 0xdf, 0x65, 0x32, 0x24, 0x45,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_exp1[] = {
	0xca, 0x0c, 0x9b, 0x60, 0xb8, 0xe4, 0xa6, 0x06, 0x67, 0x56, 0xc6, 0x5d, 0x20, 0x88, 0x41, 0x9d,
	0xf6, 0x25, 0x3b, 0x7b, 0x68, 0x8a, 0x85, 0xf4, 0xf6, 0xe9, 0x64, 0xd8, 0x5d, 0xad, 0x52, 0xa4,
	0x52, 0x62, 0x86, 0x7f, 0x1e, 0x96, 0x18, 0x06, 0x9f, 0xcc, 0xd8, 0x65, 0xe9, 0x28, 0x9e, 0x46,
	0xe3, 0x9e, 0x20, 0x22, 0x94, 0x4c, 0x5c, 0x44, 0x87, 0xd3, 0x45, 0xcf, 0x25, 0x2d, 0x46, 0x0d,
	0x97, 0x7d, 0x77, 0xed, 0xfe, 0xfe, 0xdb, 0xcb, 0xae, 0x46, 0xa2, 0x3a, 0xf7, 0xfa, 0x47, 0x0f,
	0x07, 0x7d, 0xa0, 0xe5, 0x09, 0x42, 0x04, 0x4c, 0xb1, 0xa3, 0x60, 0x49, 0x7c, 0xc2, 0x76, 0x0a,
	0xc0, 0xf2, 0xad, 0x4a, 0x2f, 0xcd, 0x0e, 0x84, 0xd7, 0xa1, 0xd9, 0x4d, 0xfd, 0xd2, 0x65, 0x8f,
	0xd9, 0xce, 0x18, 0x47, 0x5c, 0x1f, 0xa7, 0x5e, 0xe0, 0xce, 0xba, 0xd0, 0xcf, 0x0a, 0xc0, 0x4d,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_exp2[] = {
	0x52, 0x81, 0x71, 0x23, 0x3c, 0x4e, 0x4a, 0x6c, 0x63, 0xb8, 0x67, 0x64, 0xf5, 0x13, 0x38, 0x84,
	0x6a, 0xfd, 0xdb, 0xcb, 0x29, 0x58, 0x34, 0x4c, 0x01, 0xc4, 0x00, 0x4a, 0x1d, 0xd8, 0x28, 0x14,
	0x5a, 0x1d, 0x02, 0xa1, 0x50, 0x7d, 0xef, 0x4f, 0x58, 0x24, 0x7a, 0x64, 0xfc, 0x10, 0xc0, 0xa2,
	0x88, 0xc1, 0xae, 0x89, 0x57, 0x21, 0xd7, 0x8b, 0x8f, 0x04, 0x4d, 0xb7, 0xc0, 0x0d, 0x86, 0xda,
	0x55, 0xa9, 0xb6, 0x54, 0x29, 0x2e, 0xcd, 0x76, 0x82, 0x70, 0xbe, 0x69, 0xe4, 0xbd, 0x59, 0x22,
	0xd4, 0xef, 0xfd, 0x1f, 0x70, 0x95, 0x5f, 0x96, 0x27, 0xe3, 0xe1, 0x9b, 0x74, 0x9e, 0x93, 0xb4,
	0x0e, 0xf3, 0xdd, 0x1d, 0x61, 0xd9, 0x39, 0x15, 0xe2, 0xb0, 0x9d, 0x93, 0x0b, 0x4b, 0x17, 0x68,
	0xbf, 0xac, 0xc0, 0x13, 0x6f, 0x39, 0xb0, 0xcf, 0xdf, 0xb4, 0xd0, 0x50, 0x01, 0x1e, 0x2e, 0x65,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_example15_coeff[] = {
	0xdf, 0x2e, 0xb2, 0x32, 0x2c, 0xc2, 0xda, 0xab, 0xf4, 0xd1, 0x46, 0x55, 0x08, 0xf4, 0x15, 0x21,
	0xcd, 0xa7, 0xce, 0xff, 0x23, 0xeb, 0xe6, 0x1d, 0x00, 0xd4, 0x41, 0xee, 0x72, 0x8d, 0xda, 0x5d,
	0x16, 0xc7, 0xbf, 0x92, 0x0c, 0xd9, 0x5f, 0x34, 0xbe, 0xb4, 0xfe, 0x32, 0xee, 0x81, 0x7e, 0xf3,
	0x36, 0x2e, 0x0b, 0xcd, 0x1d, 0x12, 0x45, 0xf7, 0xb0, 0x77, 0x93, 0xea, 0xa1, 0x90, 0xdc, 0x5a,
	0x37, 0xfd, 0xaf, 0x4c, 0x68, 0xe2, 0xca, 0x13, 0x97, 0x2d, 0x7f, 0x51, 0x48, 0xb7, 0x96, 0xb6,
	0xfb, 0x6d, 0x7a, 0xdd, 0xa0, 0x7b, 0xd2, 0xcd, 0x13, 0xbe, 0x98, 0xce, 0xbe, 0xd1, 0xed, 0xc6,
	0xca, 0x41, 0x2e, 0x39, 0x53, 0x50, 0xc5, 0x9a, 0x1d, 0x84, 0x2b, 0xc4, 0xaa, 0x2f, 0x3c, 0x0b,
	0x24, 0x3f, 0xde, 0x7d, 0xfd, 0x95, 0x35, 0x6f, 0x24, 0x39, 0x25, 0x1a, 0x11, 0x72, 0xc4, 0x5e,
};

/* PKCS#1 v1.5 Encrypt Example 15.9 */
#define ac_rsaes_pkcs1_v1_5_vect15_modulus ac_rsaes_pkcs1_v1_5_example15_modulus
#define ac_rsaes_pkcs1_v1_5_vect15_pub_exp ac_rsaes_pkcs1_v1_5_example15_pub_exp
#define ac_rsaes_pkcs1_v1_5_vect15_priv_exp ac_rsaes_pkcs1_v1_5_example15_priv_exp
#define ac_rsaes_pkcs1_v1_5_vect15_prime1 ac_rsaes_pkcs1_v1_5_example15_prime1
#define ac_rsaes_pkcs1_v1_5_vect15_prime2 ac_rsaes_pkcs1_v1_5_example15_prime2
#define ac_rsaes_pkcs1_v1_5_vect15_exp1 ac_rsaes_pkcs1_v1_5_example15_exp1
#define ac_rsaes_pkcs1_v1_5_vect15_exp2 ac_rsaes_pkcs1_v1_5_example15_exp2
#define ac_rsaes_pkcs1_v1_5_vect15_coeff ac_rsaes_pkcs1_v1_5_example15_coeff

/*
 * PKCS#1 v1.5 Encryption Example 15.9
 * from ftp://ftp.rsa.com/pub/rsalabs/tmp/pkcs1v15crypt-vectors.txt
 */
static const uint8_t ac_rsaes_pkcs1_v1_5_vect15_ptx[] = {
	0x9a, 0x13, 0x96, 0x62, 0x2d, 0x06, 0x6c, 0x10, 0x56, 0x08, 0x58, 0xc2, 0xc4, 0xcd, 0x5c, 0x04,
	0x44, 0x9e, 0x2b, 0x95, 0x50, 0xc5, 0xbc, 0x92, 0x93, 0x76, 0x1a, 0x91, 0x04, 0x41, 0x1d, 0xa1,
	0x8a, 0x57, 0xd9, 0xb6, 0xa9, 0x97, 0x33, 0x3c, 0xdb, 0xce, 0x77, 0xe9, 0xfd, 0xbe, 0x6b, 0xb8,
	0x31,
};

static const uint8_t ac_rsaes_pkcs1_v1_5_vect15_out[] = {
	0x10, 0x0e, 0xce, 0x63, 0x45, 0x25, 0xd4, 0x67, 0xf6, 0xd4, 0xa6, 0xb6, 0x6e, 0xde, 0x1c, 0xc2,
	0x37, 0xf6, 0x1f, 0xb2, 0xb6, 0x70, 0x23, 0xa8, 0x3d, 0xc4, 0x56, 0xb9, 0x2c, 0xda, 0x18, 0x3e,
	0xd6, 0x62, 0x0f, 0xe5, 0x7d, 0x5a, 0x67, 0x33, 0x2c, 0x77, 0x23, 0x3a, 0xc1, 0xe8, 0x72, 0x5b,
	0x36, 0xf8, 0xe1, 0xb1, 0x08, 0x41, 0x2c, 0xa6, 0xfb, 0x35, 0xdc, 0xd4, 0xd8, 0x16, 0x77, 0xa2,
	0xb3, 0x0d, 0x5e, 0xaf, 0x25, 0xe0, 0xb9, 0x19, 0x1b, 0x38, 0xf7, 0xee, 0xf8, 0x3f, 0x91, 0x21,
	0xa8, 0x08, 0x43, 0x8c, 0x92, 0xab, 0x03, 0xf5, 0x20, 0x80, 0x7b, 0xc9, 0xa8, 0x94, 0x70, 0x5e,
	0xaf, 0x4e, 0xed, 0x06, 0x68, 0x23, 0xa6, 0x7a, 0xa2, 0xa5, 0x59, 0x9c, 0xd9, 0x5e, 0x58, 0xda,
	0x7c, 0x09, 0x48, 0x36, 0xd2, 0xaf, 0xeb, 0xa3, 0x9d, 0xd0, 0x09, 0xa6, 0x4a, 0xde, 0x03, 0x05,
	0x33, 0x76, 0xf0, 0x29, 0x36, 0xcf, 0x3f, 0x56, 0xbf, 0x64, 0xc1, 0xf3, 0xbd, 0xc0, 0x7c, 0x45,
	0xa9, 0x5b, 0x9f, 0xcd, 0x93, 0x96, 0xcd, 0x9a, 0x8d, 0x41, 0xbc, 0xc5, 0x64, 0x24, 0x93, 0x7a,
	0x13, 0x71, 0xb3, 0x84, 0x7c, 0x90, 0x5b, 0x9a, 0xb5, 0x84, 0x02, 0x39, 0x3d, 0x40, 0x46, 0xe4,
	0xa0, 0x15, 0xc1, 0x47, 0x08, 0xf7, 0x4c, 0xe7, 0x79, 0x0e, 0xba, 0x8a, 0xf7, 0x92, 0x07, 0x24,
	0x40, 0xbc, 0xaf, 0xb1, 0x4c, 0x0f, 0x81, 0x08, 0x97, 0x11, 0x87, 0xc8, 0x0f, 0x46, 0x3a, 0x1f,
	0xff, 0x25, 0x86, 0x46, 0xea, 0x16, 0xe5, 0x1c, 0x6e, 0xe3, 0x61, 0xb6, 0x61, 0xa1, 0x4f, 0x07,
	0xcd, 0x4f, 0x5a, 0x82, 0xc7, 0x09, 0xf4, 0x94, 0xf1, 0xdf, 0x0f, 0x80, 0x3b, 0x6f, 0x64, 0xa7,
	0x2f, 0xb9, 0xc4, 0x50, 0xff, 0xe2, 0x68, 0xfc, 0xab, 0x48, 0x7d, 0x4d, 0x63, 0x01, 0x3e, 0x41,
};

/*
 * PKCS#1 v1.5 Encryption Example 10.1
 * from http://armcryptolib.das-labor.org/trac/browser/testvectors/rsa-pkcs-1v2-1-vec/oaep-vect.txt
 */

static const uint8_t ac_rsaes_oaep_vect10_modulus[] = {
	0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d,
	0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8,
	0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4,
	0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5,
	0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d,
	0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f,
	0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1,
	0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0,
	0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a,
	0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00,
	0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8,
	0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef,
	0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76,
	0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88,
	0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc,
	0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb,
};

static const uint8_t ac_rsaes_oaep_vect10_pub_exp[] = {
	0x01, 0x00, 0x01,
};

static const uint8_t ac_rsaes_oaep_vect10_priv_exp[] = {
	0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85,
	0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59,
	0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0,
	0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d,
	0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80,
	0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe,
	0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19,
	0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10,
	0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2,
	0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64,
	0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1,
	0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43,
	0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87,
	0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01,
	0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e,
	0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79,
};

static const uint8_t ac_rsaes_oaep_vect10_prime1[] = {
	0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb,
	0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09,
	0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16,
	0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7,
	0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e,
	0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98,
	0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17,
	0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69,
};

static const uint8_t ac_rsaes_oaep_vect10_prime2[] = {
	0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b,
	0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e,
	0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59,
	0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7,
	0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b,
	0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c,
	0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7,
	0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83,
};

static const uint8_t ac_rsaes_oaep_vect10_exp1[] = {
	0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91,
	0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff,
	0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b,
	0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63,
	0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78,
	0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6,
	0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef,
	0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1,
};

static const uint8_t ac_rsaes_oaep_vect10_exp2[] = {
	0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8,
	0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6,
	0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8,
	0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92,
	0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60,
	0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c,
	0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b,
	0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49,
};

static const uint8_t ac_rsaes_oaep_vect10_coeff[] = {
	0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde,
	0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68,
	0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea,
	0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce,
	0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93,
	0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3,
	0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e,
	0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8,
};

static const uint8_t ac_rsaes_oaep_vect10_ptx[] = {
	0x8b, 0xba, 0x6b, 0xf8, 0x2a, 0x6c, 0x0f, 0x86, 0xd5, 0xf1, 0x75, 0x6e, 0x97, 0x95, 0x68, 0x70,
	0xb0, 0x89, 0x53, 0xb0, 0x6b, 0x4e, 0xb2, 0x05, 0xbc, 0x16, 0x94, 0xee,
};

static const uint8_t ac_rsaes_oaep_vect10_out[] = {
	0x53, 0xea, 0x5d, 0xc0, 0x8c, 0xd2, 0x60, 0xfb, 0x3b, 0x85, 0x85, 0x67, 0x28, 0x7f, 0xa9, 0x15,
	0x52, 0xc3, 0x0b, 0x2f, 0xeb, 0xfb, 0xa2, 0x13, 0xf0, 0xae, 0x87, 0x70, 0x2d, 0x06, 0x8d, 0x19,
	0xba, 0xb0, 0x7f, 0xe5, 0x74, 0x52, 0x3d, 0xfb, 0x42, 0x13, 0x9d, 0x68, 0xc3, 0xc5, 0xaf, 0xee,
	0xe0, 0xbf, 0xe4, 0xcb, 0x79, 0x69, 0xcb, 0xf3, 0x82, 0xb8, 0x04, 0xd6, 0xe6, 0x13, 0x96, 0x14,
	0x4e, 0x2d, 0x0e, 0x60, 0x74, 0x1f, 0x89, 0x93, 0xc3, 0x01, 0x4b, 0x58, 0xb9, 0xb1, 0x95, 0x7a,
	0x8b, 0xab, 0xcd, 0x23, 0xaf, 0x85, 0x4f, 0x4c, 0x35, 0x6f, 0xb1, 0x66, 0x2a, 0xa7, 0x2b, 0xfc,
	0xc7, 0xe5, 0x86, 0x55, 0x9d, 0xc4, 0x28, 0x0d, 0x16, 0x0c, 0x12, 0x67, 0x85, 0xa7, 0x23, 0xeb,
	0xee, 0xbe, 0xff, 0x71, 0xf1, 0x15, 0x94, 0x44, 0x0a, 0xae, 0xf8, 0x7d, 0x10, 0x79, 0x3a, 0x87,
	0x74, 0xa2, 0x39, 0xd4, 0xa0, 0x4c, 0x87, 0xfe, 0x14, 0x67, 0xb9, 0xda, 0xf8, 0x52, 0x08, 0xec,
	0x6c, 0x72, 0x55, 0x79, 0x4a, 0x96, 0xcc, 0x29, 0x14, 0x2f, 0x9a, 0x8b, 0xd4, 0x18, 0xe3, 0xc1,
	0xfd, 0x67, 0x34, 0x4b, 0x0c, 0xd0, 0x82, 0x9d, 0xf3, 0xb2, 0xbe, 0xc6, 0x02, 0x53, 0x19, 0x62,
	0x93, 0xc6, 0xb3, 0x4d, 0x3f, 0x75, 0xd3, 0x2f, 0x21, 0x3d, 0xd4, 0x5c, 0x62, 0x73, 0xd5, 0x05,
	0xad, 0xf4, 0xcc, 0xed, 0x10, 0x57, 0xcb, 0x75, 0x8f, 0xc2, 0x6a, 0xee, 0xfa, 0x44, 0x12, 0x55,
	0xed, 0x4e, 0x64, 0xc1, 0x99, 0xee, 0x07, 0x5e, 0x7f, 0x16, 0x64, 0x61, 0x82, 0xfd, 0xb4, 0x64,
	0x73, 0x9b, 0x68, 0xab, 0x5d, 0xaf, 0xf0, 0xe6, 0x3e, 0x95, 0x52, 0x01, 0x68, 0x24, 0xf0, 0x54,
	0xbf, 0x4d, 0x3c, 0x8c, 0x90, 0xa9, 0x7b, 0xb6, 0xb6, 0x55, 0x32, 0x84, 0xeb, 0x42, 0x9f, 0xcc,
};

/* diffie hellman test data */
/* p and g testdata generated using the following line:
 * for i in {256..2048..64}; do openssl dhparam -C -5 $i; done
 */
static const uint8_t keygen_dh256_p[] = {
	0xB6, 0x73, 0x91, 0xB5, 0xD6, 0xBC, 0x95, 0x73, 0x0D, 0x53, 0x64, 0x13,
	0xB0, 0x51, 0xC6, 0xB4, 0xEB, 0x9D, 0x74, 0x57, 0x8D, 0x65, 0x3A, 0x4B,
	0x7A, 0xB2, 0x93, 0x27, 0xA6, 0xC1, 0xBC, 0xAB,
};

static const uint8_t keygen_dh256_g[] = {
	0x05,
};

static const uint8_t keygen_dh320_p[] = {
	0x80, 0x72, 0x50, 0x4F, 0x85, 0xD2, 0x32, 0x70, 0xA3, 0x11, 0xF4, 0x46,
	0x01, 0x72, 0xD0, 0x72, 0x96, 0xA5, 0x1B, 0xFA, 0x8F, 0x35, 0x49, 0x75,
	0x04, 0xA5, 0x5A, 0x62, 0xB6, 0x33, 0xD6, 0x3C, 0x46, 0xD1, 0xED, 0xD7,
	0xB1, 0xD4, 0xBA, 0xF3,
};

static const uint8_t keygen_dh320_g[] = {
	0x05,
};

static const uint8_t keygen_dh384_p[] = {
	0xC2, 0x04, 0xC8, 0x0E, 0xE8, 0x3F, 0x02, 0x1F, 0xDE, 0x0C, 0xAA, 0x2E,
	0x67, 0x13, 0xF4, 0x33, 0x67, 0x82, 0x59, 0xE7, 0x80, 0xE5, 0x42, 0xEA,
	0x2F, 0xC4, 0x71, 0x93, 0xA7, 0x1C, 0x86, 0xEC, 0x8C, 0x39, 0xF8, 0xC7,
	0xF1, 0xE3, 0xE0, 0xEE, 0xC4, 0x55, 0xF5, 0x4F, 0xE7, 0x98, 0xF0, 0x47,
};

static const uint8_t keygen_dh384_g[] = {
	0x05,
};

static const uint8_t keygen_dh448_p[] = {
	0x91, 0xB9, 0x28, 0x8F, 0x01, 0x62, 0xA1, 0x40, 0x4D, 0x53, 0xC7, 0xD5,
	0xEE, 0x97, 0x40, 0x03, 0x39, 0x39, 0x41, 0x5F, 0x17, 0x0F, 0xA2, 0x78,
	0xBF, 0x3D, 0x6B, 0x33, 0x33, 0x39, 0x3B, 0x57, 0x21, 0x5B, 0xF9, 0xB1,
	0x6C, 0xE3, 0xB8, 0x19, 0xBE, 0x81, 0xBD, 0xC4, 0xFF, 0x4C, 0xFA, 0x48,
	0x63, 0x24, 0x10, 0x33, 0xDE, 0x3A, 0xFD, 0x3B,
};

static const uint8_t keygen_dh448_g[] = {
	0x05,
};

static const uint8_t keygen_dh512_p[] = {
	0xCF, 0x09, 0xB8, 0xCD, 0x0B, 0xC5, 0x9D, 0xBD, 0x7A, 0x34, 0x50, 0x55,
	0xEC, 0xD4, 0xED, 0x92, 0x9D, 0x63, 0x92, 0xF9, 0x1D, 0x42, 0xF3, 0x64,
	0x04, 0x3D, 0xCC, 0xAA, 0x5F, 0xD1, 0xBB, 0xEA, 0x44, 0x12, 0xFC, 0xF0,
	0xFB, 0xFF, 0x26, 0x57, 0xE3, 0x6E, 0xA8, 0x3F, 0x45, 0x43, 0x11, 0x81,
	0xC6, 0x79, 0xF0, 0x0B, 0x11, 0x23, 0x1D, 0x7B, 0x1E, 0x59, 0xA8, 0xB8,
	0x69, 0x44, 0xA7, 0xE3,
};

static const uint8_t keygen_dh512_g[] = {
	0x05,
};

static const uint8_t keygen_dh576_p[] = {
	0xEF, 0xA2, 0xD7, 0x81, 0x88, 0xAA, 0xBF, 0x70, 0x03, 0x70, 0xD4, 0x75,
	0xA6, 0x3E, 0x5B, 0xCF, 0x73, 0xDE, 0x7D, 0x45, 0x67, 0x47, 0xB1, 0xCF,
	0xA8, 0x62, 0xA9, 0x13, 0x9F, 0xC3, 0x9B, 0x96, 0xCE, 0xB9, 0x0C, 0x24,
	0xAC, 0xCB, 0xB6, 0x40, 0x30, 0x25, 0x26, 0x4E, 0x9D, 0x50, 0xA7, 0x8F,
	0x09, 0x1C, 0x9B, 0xDE, 0x77, 0x8A, 0xE8, 0xAA, 0xDA, 0xC2, 0x31, 0x08,
	0x55, 0x2C, 0xC1, 0x13, 0x24, 0x6E, 0x5A, 0xE7, 0xA1, 0xBC, 0xE5, 0x5B,
};

static const uint8_t keygen_dh576_g[] = {
	0x05,
};

static const uint8_t keygen_dh640_p[] = {
	0xED, 0xB6, 0x90, 0x9C, 0x72, 0x5C, 0x63, 0x11, 0x17, 0xA9, 0xB6, 0x0E,
	0x6C, 0x80, 0xA9, 0xF3, 0x15, 0x36, 0x9D, 0x49, 0x02, 0x2B, 0x4F, 0x12,
	0x1A, 0xFD, 0x00, 0xC0, 0x9B, 0x12, 0x10, 0x96, 0x18, 0x55, 0x3F, 0x0C,
	0x75, 0x46, 0x6E, 0xDF, 0x0A, 0x58, 0x8E, 0x1B, 0x4B, 0xFF, 0x24, 0x70,
	0xFC, 0x29, 0xE8, 0x67, 0x8F, 0x0B, 0x72, 0x14, 0x80, 0x6F, 0xE9, 0xCD,
	0x30, 0x3C, 0x16, 0xB9, 0xB0, 0x32, 0xBE, 0x6A, 0x1D, 0x06, 0xEE, 0x6D,
	0x15, 0x44, 0x49, 0x55, 0xA8, 0x08, 0x2D, 0x0F,
};

static const uint8_t keygen_dh640_g[] = {
	0x05,
};

static const uint8_t keygen_dh704_p[] = {
	0xA6, 0xBF, 0xA1, 0x02, 0x02, 0xA7, 0x7A, 0x6E, 0xFC, 0x48, 0x55, 0x81,
	0x23, 0x3F, 0x08, 0x8E, 0x83, 0xE9, 0x10, 0x92, 0x96, 0x82, 0x5F, 0xB8,
	0x88, 0x28, 0x0C, 0x6A, 0x04, 0x41, 0xEF, 0x4C, 0xCC, 0x2F, 0x16, 0xCD,
	0xA4, 0x2F, 0x24, 0x3B, 0xB6, 0x8A, 0x45, 0x76, 0xB3, 0xFA, 0x23, 0x83,
	0x53, 0xB2, 0x8F, 0x0C, 0xAE, 0xF9, 0xE8, 0xDB, 0x46, 0x5B, 0xBF, 0x7E,
	0xC3, 0x6F, 0x4F, 0xE6, 0xE7, 0x51, 0x75, 0x49, 0xB5, 0x4B, 0xBE, 0x48,
	0x51, 0x64, 0x9F, 0x5D, 0x56, 0xC7, 0x28, 0x9C, 0xC5, 0xBD, 0x0C, 0xD2,
	0x3A, 0x63, 0x49, 0x57,
};

static const uint8_t keygen_dh704_g[] = {
	0x05,
};

static const uint8_t keygen_dh768_p[] = {
	0xEA, 0x9B, 0x0E, 0xD5, 0xDF, 0xC6, 0x9C, 0x8A, 0x26, 0x29, 0xD4, 0x2A,
	0x94, 0x4F, 0xD5, 0x3E, 0xEA, 0xEC, 0xCD, 0x89, 0xDA, 0x9C, 0x12, 0x52,
	0x94, 0xA7, 0x1A, 0x7D, 0x14, 0x94, 0xB1, 0x89, 0x79, 0xF3, 0x4A, 0xC3,
	0xD6, 0xF5, 0x52, 0xA6, 0x65, 0xC6, 0x0C, 0xD2, 0x2B, 0x16, 0xCB, 0x4F,
	0x69, 0x4C, 0x41, 0x6C, 0xA6, 0xAF, 0xCE, 0xFD, 0x50, 0x0E, 0x8C, 0x9E,
	0xA7, 0x19, 0x46, 0x6E, 0xC2, 0x27, 0xB9, 0xAF, 0x61, 0x4B, 0xDA, 0x3A,
	0x60, 0xBA, 0x6D, 0xCE, 0xBA, 0x39, 0x1C, 0x02, 0xBF, 0x09, 0xF0, 0xF9,
	0x87, 0xBE, 0xA1, 0xDE, 0x4E, 0x34, 0x7B, 0x28, 0x3A, 0xC2, 0x9E, 0x83,
};

static const uint8_t keygen_dh768_g[] = {
	0x05,
};

static const uint8_t keygen_dh832_p[] = {
	0xB9, 0x0C, 0x79, 0x82, 0x7B, 0x23, 0xB7, 0x2F, 0x5A, 0x7B, 0xB1, 0xB9,
	0x63, 0x30, 0x7C, 0xD4, 0x0B, 0xEB, 0x7B, 0x8A, 0x67, 0x3E, 0x3B, 0x67,
	0xF1, 0x72, 0x90, 0x0E, 0xBF, 0x67, 0xEF, 0xBB, 0x95, 0xC1, 0x47, 0xED,
	0x89, 0x11, 0x79, 0x40, 0x63, 0x02, 0xF0, 0x41, 0x0C, 0xD1, 0x76, 0x15,
	0xAA, 0x24, 0x6A, 0xAE, 0x98, 0xFB, 0x19, 0x1F, 0x43, 0xB9, 0x92, 0xC7,
	0xB6, 0x33, 0xD8, 0x85, 0xBD, 0x06, 0x7D, 0x68, 0x32, 0xEE, 0xDB, 0x41,
	0xEF, 0x7B, 0xBD, 0xB4, 0xFE, 0x53, 0x4F, 0x6C, 0xA8, 0x26, 0xE0, 0x62,
	0x7D, 0x06, 0x06, 0xC5, 0xFB, 0x47, 0xD0, 0x3F, 0x4B, 0xC1, 0x7A, 0xC4,
	0x2A, 0xF3, 0x69, 0xF2, 0xDE, 0x77, 0xCD, 0x03,
};

static const uint8_t keygen_dh832_g[] = {
	0x05,
};

static const uint8_t keygen_dh896_p[] = {
	0xA8, 0x1A, 0xFB, 0xF4, 0x12, 0xF8, 0x17, 0x16, 0x89, 0x20, 0xAE, 0x6F,
	0x07, 0x55, 0x13, 0xCA, 0x99, 0x66, 0xA3, 0x1F, 0x07, 0xAC, 0x32, 0x5C,
	0xF5, 0xF0, 0x39, 0xA3, 0xDA, 0xF5, 0x55, 0xF9, 0x3C, 0xF3, 0x15, 0xF8,
	0x44, 0xC1, 0x10, 0x6A, 0x3D, 0x2F, 0x97, 0xFD, 0xAC, 0x74, 0x1E, 0xEE,
	0xCF, 0xDD, 0xEE, 0x70, 0x57, 0xBA, 0x4B, 0x41, 0xD6, 0x3F, 0xDD, 0x01,
	0xFB, 0x0C, 0x26, 0xA9, 0x06, 0xCD, 0x1B, 0xA2, 0xD3, 0x3E, 0xAD, 0x2D,
	0x29, 0xFB, 0x79, 0xB8, 0x8E, 0x50, 0xCC, 0xA1, 0x85, 0x37, 0xFA, 0xF1,
	0xBB, 0xB1, 0x5D, 0x3B, 0x51, 0x54, 0x16, 0x4C, 0x98, 0x2B, 0x26, 0xAD,
	0x70, 0x0B, 0x01, 0x87, 0x5C, 0xF1, 0xE8, 0x02, 0xF3, 0x57, 0xA9, 0x40,
	0x5C, 0xC5, 0xE0, 0xFF,
};

static const uint8_t keygen_dh896_g[] = {
	0x05,
};

static const uint8_t keygen_dh960_p[] = {
	0xD9, 0x31, 0xE0, 0xF3, 0x80, 0xED, 0xBD, 0xEC, 0x35, 0x99, 0xC9, 0x28,
	0xA8, 0x88, 0x3C, 0x84, 0x41, 0x8A, 0x6C, 0xC7, 0x83, 0x09, 0xCE, 0x07,
	0x51, 0x72, 0xBE, 0xE9, 0x21, 0x4F, 0xCB, 0x92, 0xAE, 0xA5, 0xF0, 0x9A,
	0x40, 0x9B, 0x02, 0x1D, 0xA5, 0x5E, 0xAB, 0x17, 0x25, 0x5B, 0x70, 0x0F,
	0xF9, 0x27, 0xEF, 0x49, 0xCD, 0x7F, 0x6E, 0x9A, 0x62, 0x51, 0xE6, 0xEA,
	0x4B, 0x7E, 0xBE, 0xB3, 0x72, 0xFB, 0xAF, 0x98, 0xA1, 0x7D, 0x77, 0x7E,
	0x53, 0xF9, 0xFC, 0x7A, 0xEB, 0xC7, 0xB0, 0x84, 0x2F, 0x70, 0xCC, 0xA2,
	0x34, 0x52, 0x9F, 0xD3, 0x46, 0xE3, 0x32, 0x2F, 0xE0, 0x6F, 0x83, 0x3B,
	0x8B, 0x17, 0x01, 0x0C, 0x1D, 0xEA, 0x04, 0x7D, 0xB1, 0xD4, 0xB2, 0x2D,
	0xC7, 0xD3, 0x2D, 0xE0, 0x47, 0x00, 0x6D, 0xE8, 0x1F, 0xAA, 0x39, 0x67,
};

static const uint8_t keygen_dh960_g[] = {
	0x05,
};

static const uint8_t keygen_dh1024_p[] = {
	0xB9, 0xF5, 0xB6, 0xFF, 0x49, 0xA7, 0x31, 0x3C, 0xD3, 0xAA, 0x42, 0xAE,
	0x3D, 0xA6, 0xD4, 0xC1, 0x92, 0xB0, 0x1C, 0xD5, 0x24, 0x9D, 0x67, 0x04,
	0xFA, 0xED, 0x0B, 0x2D, 0x8B, 0xA1, 0xB8, 0x72, 0x43, 0x48, 0xC2, 0x75,
	0x00, 0x9F, 0x43, 0xD7, 0xF0, 0x8F, 0xD8, 0xCD, 0x1C, 0x64, 0x48, 0x82,
	0x63, 0x52, 0x89, 0x78, 0x43, 0xEF, 0x00, 0xF6, 0x62, 0x04, 0x26, 0xD5,
	0x69, 0x2C, 0x2B, 0x9B, 0x53, 0x72, 0x57, 0xD5, 0x05, 0xA6, 0x53, 0x24,
	0x43, 0x81, 0x49, 0xEC, 0xBB, 0x43, 0x58, 0x66, 0x6A, 0xBD, 0xAC, 0xBA,
	0xD9, 0xC8, 0xC9, 0x95, 0x93, 0xCB, 0x79, 0x89, 0x86, 0x30, 0x0D, 0x45,
	0x3F, 0x89, 0x04, 0xC4, 0xEC, 0x96, 0xBF, 0x4E, 0x8E, 0x88, 0x51, 0xED,
	0xEF, 0x91, 0x8A, 0x03, 0xDC, 0x4E, 0x28, 0x69, 0x46, 0xDA, 0x1B, 0xD4,
	0x7E, 0xC5, 0xEB, 0x95, 0xBC, 0x9D, 0x14, 0x77,
};

static const uint8_t keygen_dh1024_g[] = {
	0x05,
};

static const uint8_t keygen_dh1088_p[] = {
	0xE3, 0x67, 0x7B, 0x2C, 0x68, 0xE3, 0x7C, 0xDB, 0x30, 0x3A, 0xF3, 0x20,
	0x33, 0x02, 0xB5, 0x08, 0x83, 0xC5, 0x8B, 0x07, 0xDD, 0x08, 0x92, 0x82,
	0xD6, 0x2A, 0x2B, 0x7F, 0xC6, 0xF0, 0xBD, 0xB8, 0x01, 0xF8, 0xCF, 0x78,
	0x4F, 0xFE, 0xE2, 0x9D, 0x2F, 0xF4, 0x2D, 0xC5, 0x48, 0xE0, 0xFD, 0x8A,
	0xC2, 0xCF, 0x1B, 0xD9, 0xE1, 0x23, 0xC6, 0xDA, 0xFC, 0x1C, 0x9B, 0xA4,
	0x70, 0x91, 0x1A, 0x6A, 0x35, 0x00, 0x5E, 0x63, 0x14, 0x04, 0xAB, 0x3B,
	0x00, 0xEE, 0x44, 0xE6, 0xAE, 0x49, 0xDB, 0xB7, 0xEF, 0xE1, 0x6E, 0xF9,
	0x88, 0xCC, 0xAB, 0x5E, 0x0A, 0x20, 0x84, 0x09, 0x03, 0xFA, 0xAA, 0x8C,
	0xFE, 0xB8, 0xEA, 0x31, 0x78, 0xD2, 0x92, 0xF3, 0x77, 0xCF, 0xEC, 0xB9,
	0xF8, 0x3C, 0x79, 0x4A, 0x9B, 0xB6, 0xCC, 0xC0, 0x5E, 0xAB, 0x92, 0xE6,
	0x39, 0x74, 0x5E, 0x8D, 0x2B, 0x28, 0x3B, 0x4D, 0x26, 0x6B, 0x2F, 0xF6,
	0xA8, 0xB1, 0x01, 0x53,
};

static const uint8_t keygen_dh1088_g[] = {
	0x05,
};

static const uint8_t keygen_dh1152_p[] = {
	0xCA, 0xD6, 0x34, 0x4F, 0xAE, 0x99, 0x47, 0x51, 0x14, 0x5D, 0xF4, 0xCA,
	0x47, 0xE2, 0xE7, 0x62, 0x7D, 0xB9, 0xC9, 0xE7, 0xF7, 0xEE, 0xD4, 0xF0,
	0x04, 0xC1, 0x93, 0x06, 0xC2, 0xC8, 0x5E, 0x9D, 0xD3, 0x9F, 0x4A, 0x87,
	0xF2, 0x22, 0x5A, 0x72, 0x8D, 0xEB, 0x8B, 0x12, 0x26, 0x82, 0x3A, 0xA7,
	0x6B, 0xE1, 0x55, 0xB0, 0x9F, 0x97, 0x4C, 0xC5, 0xEC, 0x5C, 0x1C, 0x23,
	0xAB, 0x95, 0xDC, 0x17, 0xD5, 0x80, 0x0A, 0xE6, 0x53, 0x9E, 0xD8, 0xC6,
	0xB9, 0x9E, 0xFA, 0x62, 0x60, 0x2A, 0x8D, 0xD5, 0x3D, 0x36, 0x5E, 0x4E,
	0x42, 0x1F, 0xAF, 0x2B, 0x87, 0x0E, 0xC6, 0x44, 0xB7, 0x55, 0x1C, 0x81,
	0x7E, 0x48, 0x96, 0x1B, 0xF9, 0x73, 0x1C, 0x3D, 0x80, 0xDF, 0x43, 0xDB,
	0x93, 0xB6, 0x1E, 0xC1, 0x04, 0x12, 0x9E, 0x33, 0x21, 0xCE, 0xF7, 0x49,
	0x41, 0x7E, 0x97, 0x31, 0xC3, 0x74, 0x1D, 0x95, 0x85, 0x6F, 0x3A, 0xA1,
	0xCF, 0x61, 0xD9, 0xEB, 0x67, 0x67, 0xED, 0x91, 0xDF, 0x23, 0xCD, 0xC3,
};

static const uint8_t keygen_dh1152_g[] = {
	0x05,
};

static const uint8_t keygen_dh1216_p[] = {
	0xB1, 0xFC, 0x4E, 0xF5, 0xDE, 0xC5, 0xDD, 0x33, 0xDD, 0xB2, 0x2E, 0x44,
	0x52, 0xDD, 0x74, 0x2F, 0x1F, 0x61, 0x20, 0x21, 0x72, 0x65, 0xC5, 0xEC,
	0x5A, 0xAA, 0xF1, 0x24, 0xA1, 0xD0, 0xEB, 0x4B, 0x4C, 0x32, 0x8A, 0xDD,
	0x4F, 0x9F, 0xEE, 0xFA, 0x5F, 0x81, 0xD4, 0x18, 0x3D, 0xCD, 0x39, 0x38,
	0xDC, 0x3D, 0x2E, 0x37, 0xEB, 0xFE, 0x73, 0xEF, 0x99, 0x53, 0x54, 0xA6,
	0xAB, 0x25, 0xFE, 0x9A, 0x10, 0xAE, 0x3E, 0xC9, 0x63, 0x45, 0x75, 0xAF,
	0xCA, 0xD9, 0x57, 0xF7, 0x71, 0xE0, 0xBE, 0x0D, 0x90, 0xE9, 0xC5, 0x5A,
	0xC6, 0x2E, 0x3D, 0xDE, 0xE4, 0x8B, 0x38, 0x8E, 0x83, 0x06, 0xA6, 0xE2,
	0x38, 0xA6, 0x88, 0x81, 0xDE, 0x8E, 0xA6, 0x6A, 0xBF, 0xF4, 0x75, 0xFB,
	0xAB, 0xAA, 0x02, 0xEA, 0x0E, 0xCF, 0xCA, 0xEA, 0x45, 0xFE, 0x1C, 0xC2,
	0xF9, 0xBE, 0x26, 0x31, 0xA6, 0x8F, 0xFE, 0x07, 0x9E, 0x79, 0x47, 0x11,
	0xA1, 0x25, 0xA4, 0xE5, 0xFB, 0xEA, 0xE7, 0xC1, 0xFF, 0x12, 0x12, 0x71,
	0x5D, 0xC1, 0x99, 0x44, 0xD1, 0xCE, 0x82, 0xA7,
};

static const uint8_t keygen_dh1216_g[] = {
	0x05,
};

static const uint8_t keygen_dh1280_p[] = {
	0xF0, 0x10, 0x04, 0x04, 0x08, 0x13, 0x79, 0x15, 0x62, 0x5C, 0xFA, 0x2A,
	0x6D, 0xFC, 0x3F, 0x23, 0x4C, 0x47, 0x83, 0x45, 0xE7, 0x6F, 0x64, 0x04,
	0x1A, 0xFD, 0xBF, 0xD2, 0xB9, 0x0A, 0x98, 0x14, 0x16, 0xA4, 0xB5, 0x03,
	0x13, 0xBB, 0xFB, 0x72, 0x1E, 0xF5, 0x23, 0x12, 0xB8, 0x74, 0x49, 0x3F,
	0x84, 0xF3, 0x02, 0x3A, 0x50, 0x6F, 0xB7, 0xC7, 0x6F, 0x37, 0x8F, 0x61,
	0x88, 0x60, 0x7C, 0xF1, 0xE7, 0x1E, 0xED, 0x55, 0xF1, 0xCD, 0x64, 0x93,
	0xA7, 0x12, 0xB7, 0x74, 0x5F, 0x23, 0x20, 0xF7, 0x87, 0xC2, 0x83, 0x2A,
	0x86, 0x0C, 0xF3, 0x4B, 0x88, 0x32, 0xF5, 0xB7, 0x86, 0x2F, 0xBF, 0xEE,
	0xA1, 0x59, 0xC4, 0xDB, 0x0F, 0xEF, 0x06, 0xC8, 0xF2, 0xEE, 0x39, 0xB4,
	0x19, 0x24, 0x8A, 0x2C, 0xE7, 0xF8, 0xA0, 0x34, 0x2A, 0x15, 0xA9, 0x54,
	0x4D, 0x04, 0x1B, 0xC0, 0xC5, 0x15, 0xCF, 0x38, 0x96, 0x83, 0x3E, 0xEE,
	0xD0, 0xFD, 0xBC, 0x62, 0xD9, 0x84, 0xA3, 0x02, 0x6D, 0x2A, 0x7B, 0x4B,
	0x3E, 0xCC, 0xAD, 0xA1, 0xF0, 0xA0, 0x44, 0xDD, 0x7E, 0x4B, 0xBD, 0x75,
	0xAD, 0x8F, 0xF1, 0x57,
};

static const uint8_t keygen_dh1280_g[] = {
	0x05,
};

static const uint8_t keygen_dh1344_p[] = {
	0x8E, 0x0F, 0xCC, 0x61, 0x96, 0xCA, 0xF2, 0x3A, 0x13, 0xD5, 0xF9, 0x2A,
	0xD0, 0xF0, 0x5A, 0x4C, 0x1B, 0xC2, 0xD2, 0xDE, 0xD6, 0x54, 0x53, 0x83,
	0x70, 0x1E, 0x0A, 0x17, 0x6D, 0x4C, 0xBA, 0xCD, 0xEE, 0x32, 0x08, 0x55,
	0xD8, 0xD3, 0x80, 0x81, 0x07, 0x04, 0xF3, 0x19, 0xDD, 0x20, 0x30, 0x6A,
	0x6C, 0x74, 0x25, 0x56, 0xEB, 0xA0, 0x9E, 0x0A, 0x08, 0x94, 0x88, 0xE8,
	0xD2, 0xFD, 0xC3, 0x16, 0x27, 0x51, 0xE2, 0xF8, 0xAE, 0x8B, 0x2B, 0xFF,
	0x2A, 0x75, 0xEC, 0x21, 0xEB, 0xA9, 0xE2, 0x24, 0x8A, 0xAE, 0xF9, 0x7D,
	0x90, 0x8B, 0x31, 0x10, 0x6B, 0x14, 0x97, 0x2D, 0xB2, 0x93, 0x59, 0xFF,
	0x4B, 0x9A, 0x0A, 0x90, 0xA8, 0x0E, 0xDE, 0x19, 0x2B, 0x74, 0xF2, 0xCC,
	0x2D, 0x5B, 0x4F, 0x91, 0xBE, 0x43, 0x86, 0xA2, 0x91, 0xDD, 0x01, 0xDD,
	0x24, 0x75, 0xD8, 0x9F, 0x85, 0x53, 0xC3, 0xDB, 0x08, 0x5F, 0x01, 0x24,
	0xA7, 0x45, 0xAA, 0x6E, 0xB4, 0xFB, 0x05, 0x1C, 0x58, 0x51, 0x3D, 0xFD,
	0x39, 0x57, 0xD4, 0xF9, 0x11, 0x81, 0x60, 0x48, 0xF1, 0xD7, 0x7C, 0xAE,
	0xDE, 0x58, 0x6E, 0x6A, 0x02, 0xC5, 0x51, 0x69, 0x47, 0xF3, 0xAC, 0x47,
};

static const uint8_t keygen_dh1344_g[] = {
	0x05,
};

static const uint8_t keygen_dh1408_p[] = {
	0xE1, 0xE7, 0xA6, 0xF3, 0x5C, 0x06, 0x00, 0x8B, 0x4B, 0x3C, 0x7A, 0xF9,
	0x4D, 0x30, 0x08, 0x73, 0x69, 0xCF, 0x79, 0x6F, 0xAB, 0x66, 0x47, 0x05,
	0x65, 0xA8, 0x4A, 0x5C, 0xA6, 0x5E, 0x3D, 0x46, 0x10, 0x0A, 0x58, 0x3E,
	0x7C, 0x3F, 0x0F, 0x3A, 0xE1, 0xFF, 0x2C, 0x7D, 0xE1, 0x40, 0x05, 0xED,
	0xC3, 0x0B, 0x6C, 0x36, 0x90, 0xDC, 0x10, 0x94, 0x9B, 0xEB, 0xA9, 0x31,
	0xD9, 0x1F, 0x46, 0xBF, 0xC0, 0xF4, 0x49, 0x44, 0x39, 0xF2, 0xE9, 0xB8,
	0x86, 0x52, 0xCB, 0x60, 0xAC, 0xAF, 0x2C, 0x38, 0x9A, 0x63, 0xCE, 0xB7,
	0x30, 0x17, 0x81, 0xA9, 0x1C, 0x3D, 0x73, 0x0D, 0x3F, 0xCE, 0xC8, 0xA6,
	0x95, 0x65, 0x8F, 0x9F, 0x5C, 0xE8, 0xEB, 0x5C, 0x69, 0x59, 0x8B, 0xA5,
	0x1D, 0x74, 0x23, 0x35, 0x3C, 0x35, 0x08, 0x50, 0x53, 0xE5, 0xDB, 0x93,
	0x69, 0x8F, 0x17, 0xF7, 0xA0, 0xBA, 0xED, 0xD6, 0xE9, 0x7C, 0x4F, 0x97,
	0xAB, 0x25, 0x26, 0x39, 0xF9, 0xF3, 0x12, 0x0A, 0xB1, 0xE0, 0x7C, 0xCD,
	0x60, 0x5C, 0x46, 0x2E, 0x22, 0xAB, 0xEF, 0x8D, 0x09, 0xB8, 0x3D, 0xB1,
	0xA6, 0xB0, 0x1C, 0x5D, 0x75, 0x66, 0x02, 0x0E, 0xFD, 0xB9, 0xD6, 0x47,
	0x5F, 0x80, 0xF3, 0xAF, 0xB3, 0x39, 0x7B, 0xF7,
};

static const uint8_t keygen_dh1408_g[] = {
	0x05,
};

static const uint8_t keygen_dh1472_p[] = {
	0x9D, 0x8A, 0x3D, 0x5A, 0xC0, 0x90, 0x55, 0x02, 0x4E, 0x28, 0xB7, 0x8F,
	0x33, 0x91, 0xDC, 0xEB, 0xD2, 0x81, 0x00, 0x16, 0x2D, 0x89, 0x9A, 0x3C,
	0x83, 0xD5, 0xF3, 0x2A, 0x59, 0x5D, 0x63, 0x86, 0xFB, 0xEB, 0xA8, 0xFD,
	0x27, 0x1E, 0x18, 0x9F, 0x3C, 0xF7, 0xEF, 0xAE, 0xDE, 0x6C, 0xA5, 0x30,
	0x16, 0x93, 0xF0, 0x00, 0xB3, 0x36, 0xD2, 0xF6, 0x2C, 0x95, 0xF1, 0x31,
	0x4A, 0x75, 0xA8, 0x4F, 0xF6, 0xA8, 0x0F, 0xE9, 0x0B, 0xB4, 0xAF, 0xEE,
	0xFF, 0x50, 0x6D, 0xE8, 0xFC, 0x3A, 0xCC, 0x04, 0x71, 0x21, 0x74, 0x38,
	0xEB, 0x7E, 0x66, 0x70, 0x85, 0xA7, 0x35, 0x50, 0x07, 0x21, 0x2D, 0x24,
	0x45, 0xCC, 0x00, 0xB1, 0x7F, 0x7A, 0x73, 0x54, 0x9B, 0x96, 0x7B, 0x60,
	0x46, 0xDE, 0x57, 0x4B, 0xE3, 0xF5, 0xEA, 0x0E, 0xFC, 0x7A, 0xC1, 0xFE,
	0x8D, 0x13, 0xD8, 0x2D, 0xAB, 0xDD, 0xA6, 0x61, 0x5C, 0x95, 0xB4, 0x15,
	0x6F, 0x2A, 0x40, 0x6C, 0xB3, 0xC6, 0xC2, 0x1C, 0xC6, 0x74, 0x6F, 0x31,
	0x73, 0x47, 0x94, 0x95, 0x23, 0x8D, 0xCD, 0x4F, 0x4D, 0xA8, 0xF3, 0x67,
	0x5D, 0xDE, 0x83, 0x49, 0x9C, 0xD3, 0xD9, 0xB5, 0x0D, 0xD4, 0x0E, 0xD1,
	0x99, 0xB7, 0x53, 0x2E, 0xE5, 0xFD, 0xB5, 0x75, 0xFD, 0xE6, 0xD6, 0xC6,
	0xA2, 0x43, 0x33, 0x83,
};

static const uint8_t keygen_dh1472_g[] = {
	0x05,
};

static const uint8_t keygen_dh1536_p[] = {
	0xE2, 0x5A, 0x3F, 0x8E, 0xE8, 0x72, 0x92, 0x84, 0x2F, 0xB2, 0xC0, 0x01,
	0x1F, 0xE9, 0x42, 0x0A, 0x0B, 0x1A, 0x71, 0x27, 0x51, 0xD8, 0xB5, 0xD8,
	0x31, 0x7B, 0xEE, 0xEE, 0xAA, 0xA5, 0x67, 0x67, 0x36, 0xAF, 0xAB, 0x55,
	0xB9, 0x07, 0xA7, 0xF7, 0x55, 0xE3, 0x08, 0x52, 0x7C, 0x55, 0xF3, 0x28,
	0x6F, 0x37, 0x84, 0xC7, 0x26, 0x66, 0x2F, 0x84, 0x8C, 0x09, 0xA5, 0x0C,
	0x5A, 0x60, 0x45, 0x7A, 0xDC, 0x11, 0x11, 0xB6, 0xF8, 0x6B, 0x2A, 0x63,
	0x6E, 0x86, 0x00, 0x65, 0x92, 0x8F, 0xE8, 0xB8, 0x4A, 0x2F, 0xDC, 0x62,
	0xE0, 0x2C, 0x1F, 0x95, 0x8F, 0x16, 0x7D, 0xB9, 0xC2, 0xCE, 0x58, 0x9A,
	0x12, 0x55, 0xC2, 0x01, 0xE2, 0xBE, 0xE5, 0xF0, 0x80, 0x04, 0xFD, 0xDD,
	0x95, 0x04, 0x11, 0xCA, 0xE3, 0xAA, 0x9E, 0x3F, 0x4C, 0x9A, 0xE9, 0x8C,
	0x11, 0xD9, 0x1C, 0x3A, 0x22, 0xEF, 0xEC, 0xB0, 0x9D, 0x73, 0x0C, 0xBB,
	0x4E, 0x3F, 0xFC, 0xF4, 0xFF, 0x63, 0x85, 0x7C, 0xE6, 0x5C, 0x22, 0x60,
	0x0A, 0x92, 0x32, 0xEC, 0x7C, 0x6B, 0x01, 0x72, 0x93, 0x42, 0x9D, 0x8D,
	0xC5, 0x78, 0x88, 0x8F, 0xCB, 0xA8, 0x93, 0xD1, 0x8F, 0x67, 0x74, 0x7A,
	0xA2, 0x93, 0x18, 0xDB, 0x84, 0xA5, 0xA6, 0xB9, 0x35, 0x0C, 0xCD, 0x8B,
	0x85, 0x2F, 0xC0, 0xBA, 0x27, 0x3D, 0x9C, 0x55, 0xDA, 0xB8, 0x94, 0x1F,
};

static const uint8_t keygen_dh1536_g[] = {
	0x05,
};

static const uint8_t keygen_dh1600_p[] = {
	0xAC, 0xF5, 0x91, 0x7E, 0xA3, 0x07, 0xD1, 0x24, 0x69, 0x38, 0x4D, 0x1B,
	0x1D, 0x60, 0x81, 0xF5, 0x22, 0x71, 0xE3, 0xEC, 0x17, 0x7B, 0x22, 0x81,
	0x22, 0xC7, 0x55, 0xBC, 0x61, 0x41, 0x03, 0xA5, 0x9D, 0xDC, 0x58, 0x28,
	0x6C, 0xE6, 0xF7, 0x9B, 0x0D, 0x2F, 0xD5, 0x4F, 0x3E, 0x4D, 0x6B, 0x26,
	0x5B, 0x09, 0x09, 0x79, 0x58, 0xC4, 0x39, 0x33, 0x8C, 0x29, 0x9E, 0x9F,
	0x5C, 0x76, 0xA5, 0xC8, 0x99, 0xF8, 0x69, 0xEE, 0x8F, 0xBA, 0x2C, 0xD4,
	0x68, 0x4F, 0xB2, 0xDC, 0xE6, 0xD9, 0x20, 0xE8, 0x02, 0xF2, 0x43, 0x9C,
	0xDD, 0x31, 0x79, 0xBD, 0x39, 0x78, 0x31, 0xC6, 0x03, 0x66, 0x69, 0x05,
	0xD6, 0x1E, 0xFE, 0x11, 0x1D, 0x9E, 0x01, 0xB8, 0xCB, 0xE8, 0xC7, 0x51,
	0xD9, 0xCD, 0x49, 0xEA, 0xD6, 0xC3, 0xC7, 0xF1, 0xC0, 0xA2, 0x6B, 0xD1,
	0x52, 0xD3, 0x80, 0xFD, 0x52, 0x35, 0x5C, 0x3D, 0xD3, 0x97, 0x61, 0x58,
	0x69, 0x1B, 0x4F, 0x9C, 0xF9, 0xC9, 0x34, 0xDA, 0x9B, 0x8B, 0x04, 0x18,
	0x12, 0x2F, 0xF1, 0x22, 0x78, 0x0F, 0xD3, 0xAA, 0x85, 0x06, 0xA9, 0xCA,
	0x9E, 0x80, 0x39, 0x25, 0x12, 0x41, 0xDD, 0x86, 0x58, 0x1F, 0x4D, 0x1F,
	0x9B, 0xDB, 0x63, 0xD0, 0x80, 0x5E, 0x53, 0xAC, 0x86, 0x0C, 0x1E, 0x11,
	0xB1, 0x0D, 0xB6, 0x1F, 0xFE, 0x7C, 0x23, 0x6A, 0x71, 0x47, 0xA5, 0xC2,
	0x20, 0x23, 0x9F, 0x1D, 0xDF, 0xB9, 0x91, 0x4B,
};

static const uint8_t keygen_dh1600_g[] = {
	0x05,
};

static const uint8_t keygen_dh1664_p[] = {
	0xAB, 0xF8, 0x74, 0x92, 0xCE, 0x1A, 0x3F, 0x89, 0xE1, 0xB7, 0x75, 0x5E,
	0x99, 0xBE, 0xFF, 0x73, 0x3E, 0x78, 0x86, 0xB0, 0x5E, 0x2F, 0x5C, 0xA4,
	0xB2, 0xE4, 0x72, 0x2C, 0x59, 0xB6, 0x64, 0x6F, 0x63, 0x72, 0xE3, 0x82,
	0xA4, 0xFB, 0x03, 0x57, 0x40, 0x6D, 0x6B, 0x1E, 0x2B, 0xB9, 0x8C, 0xB0,
	0x19, 0xB0, 0xE8, 0xC3, 0x3D, 0xEC, 0xC2, 0xA0, 0x91, 0x15, 0x02, 0x79,
	0x93, 0x31, 0xE4, 0x3A, 0x17, 0x9D, 0x9F, 0x68, 0xCD, 0x73, 0x28, 0x83,
	0xC3, 0x07, 0x43, 0x15, 0x05, 0x50, 0x9F, 0x78, 0x91, 0x2A, 0x98, 0x35,
	0xA3, 0xE4, 0x84, 0x84, 0x55, 0xDF, 0x32, 0x29, 0x27, 0x91, 0xC8, 0xFF,
	0x8B, 0x7B, 0x4E, 0x1B, 0xA1, 0x02, 0xBA, 0x31, 0x33, 0x79, 0x2E, 0x73,
	0x1D, 0x00, 0x30, 0xF2, 0x1E, 0x83, 0xB4, 0x7B, 0xD1, 0x76, 0xD4, 0x9E,
	0x2E, 0x32, 0xB6, 0xA5, 0x69, 0xB2, 0x28, 0x8E, 0xC4, 0xE3, 0xB0, 0x33,
	0x7E, 0x59, 0x90, 0x92, 0x40, 0x3F, 0x2C, 0x98, 0xC6, 0xEE, 0x26, 0xF1,
	0xE0, 0xE2, 0xB0, 0xA6, 0x50, 0xB0, 0x2E, 0xF1, 0xE3, 0x2D, 0x4F, 0xB5,
	0x58, 0xDA, 0x07, 0xBE, 0x9D, 0x20, 0x7C, 0x10, 0x23, 0x6D, 0x60, 0x96,
	0x11, 0xC9, 0xB4, 0xD4, 0x9C, 0xF0, 0x01, 0x8F, 0x9B, 0xC4, 0x83, 0xC6,
	0x47, 0x53, 0x74, 0xDD, 0x74, 0x01, 0x03, 0x9C, 0x99, 0xA0, 0x5E, 0xE2,
	0xA0, 0x05, 0x6E, 0x66, 0xB0, 0x01, 0xDD, 0x44, 0xFF, 0xA6, 0x65, 0x96,
	0x92, 0x2B, 0x89, 0x57,
};

static const uint8_t keygen_dh1664_g[] = {
	0x05,
};

static const uint8_t keygen_dh1728_p[] = {
	0xED, 0x9F, 0xF6, 0x0C, 0xD6, 0x18, 0x33, 0xE8, 0x26, 0x13, 0xF2, 0x56,
	0xE7, 0x9D, 0x03, 0x45, 0x99, 0xA0, 0x12, 0xB1, 0xBC, 0x45, 0xAD, 0xA7,
	0x14, 0xCC, 0x37, 0x97, 0x4D, 0x21, 0x6D, 0x52, 0x16, 0x6B, 0x20, 0x0B,
	0x8D, 0xA6, 0x43, 0xDF, 0x6C, 0x5C, 0x5A, 0xF2, 0x24, 0xBF, 0x04, 0x03,
	0x2E, 0xF6, 0xFE, 0x45, 0x30, 0x88, 0x2B, 0x07, 0x5C, 0xAA, 0xAE, 0x7E,
	0x33, 0xEF, 0xE6, 0x92, 0xD6, 0xFD, 0x61, 0x5F, 0xEF, 0xAC, 0xFB, 0x64,
	0x8D, 0x41, 0xE7, 0x52, 0xD2, 0x56, 0x74, 0x3A, 0xE5, 0x5E, 0x7E, 0x88,
	0x8D, 0xCD, 0xEA, 0xA8, 0xEF, 0x09, 0x9E, 0xDC, 0xBB, 0xC2, 0x10, 0xA8,
	0xE8, 0x7B, 0x24, 0x1B, 0x28, 0xA7, 0x1C, 0x0C, 0x53, 0xB8, 0xC2, 0xF3,
	0x01, 0x32, 0xBA, 0xE5, 0x8B, 0x6F, 0x3B, 0xB9, 0x36, 0x44, 0x5B, 0x3A,
	0x73, 0x44, 0x8F, 0xDE, 0x99, 0x69, 0x22, 0xE0, 0x2C, 0x45, 0x71, 0xA9,
	0x52, 0x1C, 0xCD, 0x19, 0x02, 0xBD, 0x06, 0xD2, 0x57, 0x45, 0xE3, 0x6C,
	0x96, 0x6D, 0x0B, 0x25, 0x56, 0x4C, 0x40, 0x2E, 0x7E, 0x83, 0xEE, 0xE1,
	0xB2, 0x65, 0x51, 0x04, 0x8D, 0x6A, 0x08, 0x44, 0xF0, 0x80, 0xB1, 0xFE,
	0x13, 0x15, 0x9B, 0x82, 0x65, 0xF0, 0x89, 0xBC, 0x7E, 0x63, 0xF6, 0x08,
	0xD3, 0xBA, 0xA9, 0x66, 0x35, 0x5F, 0x0C, 0xF7, 0xE9, 0x52, 0xA3, 0x4D,
	0x66, 0x01, 0xE7, 0x28, 0xF4, 0xDC, 0xF2, 0x46, 0xBB, 0x02, 0x95, 0x21,
	0x6A, 0x8F, 0x97, 0xA7, 0x3F, 0x06, 0x2E, 0xB2, 0x97, 0xEC, 0x5A, 0xFB,
};


static const uint8_t keygen_dh1728_g[] = {
	0x05,
};

static const uint8_t keygen_dh1792_p[] = {
	0x9A, 0x87, 0x16, 0x1D, 0x23, 0x55, 0xC7, 0x06, 0x55, 0xD7, 0xB1, 0xB3,
	0x71, 0x66, 0x9A, 0x16, 0x5A, 0xA6, 0x8F, 0x54, 0x50, 0x99, 0xBD, 0x90,
	0x8C, 0x84, 0xB3, 0xBC, 0x02, 0xFE, 0xCB, 0x07, 0x3A, 0x7E, 0x97, 0x12,
	0x32, 0xEC, 0xA0, 0x0B, 0xEA, 0x96, 0x51, 0xB4, 0x50, 0x4E, 0x3A, 0xCB,
	0x27, 0xA9, 0x42, 0x51, 0x49, 0x35, 0x9F, 0x45, 0x6B, 0xDA, 0xE0, 0x6C,
	0x10, 0x80, 0x00, 0x41, 0xC2, 0xFC, 0x91, 0xB6, 0x59, 0xCE, 0x76, 0x7F,
	0x21, 0xC6, 0x10, 0x8A, 0x68, 0x68, 0x54, 0x76, 0xCE, 0x33, 0xA6, 0x37,
	0xCF, 0x80, 0xDF, 0x37, 0x12, 0x77, 0xBA, 0xBF, 0x15, 0x10, 0x22, 0x4A,
	0xA1, 0x9B, 0xA6, 0x6B, 0x8E, 0x14, 0x4F, 0x64, 0xF4, 0x87, 0x64, 0xAA,
	0x6E, 0xBC, 0xB5, 0xB2, 0x96, 0x27, 0xD1, 0x1A, 0x6E, 0x6D, 0x4B, 0xC6,
	0x43, 0x28, 0xE9, 0xFC, 0xA4, 0xCB, 0x61, 0x8F, 0xEA, 0xE8, 0x40, 0xF2,
	0x0A, 0x19, 0xBA, 0x17, 0x49, 0x9A, 0x9F, 0xEF, 0x65, 0xBC, 0x70, 0x85,
	0xDD, 0x98, 0xB9, 0x8B, 0x25, 0x2C, 0xE1, 0x89, 0xC4, 0x60, 0xA0, 0xA9,
	0x7E, 0xFB, 0xEC, 0xBC, 0x4C, 0x1D, 0x25, 0x5D, 0x70, 0x2E, 0x73, 0x29,
	0x22, 0xA7, 0x83, 0x11, 0xC0, 0x64, 0xA9, 0xB6, 0xFA, 0x11, 0xC8, 0xC4,
	0x14, 0x30, 0x64, 0xE4, 0x76, 0xBE, 0x41, 0x62, 0xE6, 0x9F, 0xD6, 0x2A,
	0xEC, 0x60, 0xCF, 0xBD, 0x25, 0x2E, 0x3C, 0x6C, 0x40, 0x16, 0x32, 0x5C,
	0xB5, 0x3D, 0xFB, 0xD7, 0x3C, 0x59, 0x06, 0xBE, 0x37, 0x54, 0x40, 0x90,
	0x3D, 0x51, 0x01, 0x9A, 0x1E, 0x87, 0x05, 0xE3,
};

static const uint8_t keygen_dh1792_g[] = {
	0x05,
};

static const uint8_t keygen_dh1856_p[] = {
	0xA8, 0xD1, 0xC4, 0xCA, 0x89, 0xB5, 0xB3, 0x17, 0xEB, 0x4D, 0xB1, 0x58,
	0x73, 0x28, 0xDD, 0x7F, 0x67, 0x78, 0x13, 0x7D, 0x0D, 0x0E, 0x77, 0x43,
	0xB8, 0xA5, 0xCD, 0x84, 0xD3, 0x29, 0x3F, 0x00, 0xD7, 0xB0, 0x66, 0x95,
	0x52, 0x9D, 0x49, 0xAD, 0x9C, 0xCE, 0x83, 0xB1, 0xDB, 0x86, 0x90, 0x9A,
	0x40, 0xAD, 0x0A, 0xB0, 0x3A, 0x93, 0x33, 0x07, 0xC8, 0x32, 0x4D, 0x75,
	0x1E, 0x7B, 0xDC, 0xD3, 0x23, 0x5C, 0xCB, 0x83, 0x62, 0x79, 0x3A, 0x88,
	0xE8, 0xD0, 0x9B, 0x75, 0x4D, 0xA0, 0x1F, 0x3E, 0x08, 0x61, 0x5D, 0xEF,
	0x7C, 0xF0, 0x4D, 0xF8, 0xDD, 0x95, 0xEC, 0x31, 0xDD, 0x50, 0xA5, 0x4B,
	0xAA, 0x8E, 0xED, 0x45, 0x34, 0xCB, 0x87, 0x09, 0x4F, 0x36, 0xF6, 0xF4,
	0xF7, 0x08, 0x0D, 0xBA, 0xBC, 0x06, 0x22, 0x59, 0x83, 0x93, 0xF6, 0x4B,
	0xBC, 0x35, 0xAD, 0x48, 0x82, 0x40, 0x55, 0x51, 0xBC, 0xF8, 0xE2, 0x9A,
	0x11, 0xF2, 0x08, 0x1E, 0xCA, 0x55, 0x40, 0x36, 0x00, 0xBE, 0x1C, 0xC8,
	0x94, 0x2E, 0x35, 0x7D, 0xB0, 0xA4, 0xCD, 0x1C, 0xC1, 0xFF, 0x58, 0xE1,
	0xBB, 0x31, 0xE9, 0x13, 0x16, 0x7F, 0x43, 0x88, 0xB2, 0x43, 0x62, 0x2A,
	0x79, 0xE3, 0x61, 0xDF, 0xF5, 0xC9, 0x9C, 0x33, 0xDD, 0x93, 0x58, 0xFC,
	0x08, 0x51, 0xE8, 0xA8, 0x30, 0x61, 0x64, 0x83, 0xB3, 0x20, 0xC4, 0x53,
	0x95, 0xD6, 0xB3, 0x74, 0xB5, 0xFA, 0xB1, 0x65, 0xD1, 0xF9, 0xED, 0xB1,
	0x9B, 0x97, 0x86, 0xC6, 0xDE, 0x6E, 0x5F, 0xF4, 0x6A, 0x42, 0xFA, 0x1F,
	0x6E, 0xEA, 0x5B, 0x43, 0x4C, 0xCC, 0x62, 0x76, 0xFE, 0x9B, 0xA0, 0xB9,
	0x7C, 0x50, 0x5E, 0x8B,
};

static const uint8_t keygen_dh1856_g[] = {
	0x05,
};

static const uint8_t keygen_dh1920_p[] = {
	0xC2, 0x68, 0xB1, 0x2E, 0x41, 0xB7, 0xA3, 0xCC, 0xE8, 0x10, 0x48, 0xE8,
	0x80, 0xA5, 0x56, 0x82, 0x3C, 0x05, 0xA3, 0xC4, 0x20, 0xD5, 0xD7, 0x19,
	0x54, 0x60, 0xA4, 0x97, 0x95, 0x09, 0x3D, 0xDF, 0x10, 0xFF, 0x21, 0x0D,
	0x68, 0x19, 0x15, 0x89, 0xD1, 0x44, 0x14, 0x1E, 0xF2, 0xD8, 0xFD, 0x9D,
	0x35, 0x8C, 0xA6, 0x2B, 0x7D, 0x73, 0x9A, 0xEB, 0x86, 0x28, 0x4D, 0x3B,
	0x22, 0xEF, 0x1A, 0x35, 0xB6, 0x95, 0xA2, 0xFF, 0x03, 0x40, 0x49, 0x60,
	0x59, 0xD2, 0x2D, 0xAD, 0x00, 0xEF, 0x6A, 0x5B, 0xFB, 0xA6, 0x16, 0x01,
	0x92, 0x5E, 0x7D, 0x95, 0x2E, 0x18, 0xD5, 0x23, 0x9E, 0x9E, 0x87, 0xF2,
	0x2F, 0xFC, 0xE4, 0xF7, 0xC2, 0x28, 0x44, 0x97, 0xAB, 0xB5, 0xC1, 0xD3,
	0x8A, 0x53, 0xD7, 0xE5, 0x04, 0x78, 0xF2, 0xD9, 0x21, 0xD5, 0x46, 0x17,
	0x8A, 0xFC, 0xDB, 0x57, 0x29, 0xDD, 0x78, 0x5B, 0x05, 0xA9, 0xB0, 0x13,
	0x45, 0x1C, 0x84, 0xEE, 0x46, 0x73, 0x1B, 0x8E, 0x80, 0x45, 0x73, 0x04,
	0xF9, 0x23, 0x96, 0xBA, 0xBD, 0x51, 0x69, 0x81, 0xE4, 0xAE, 0x0D, 0x0A,
	0xC4, 0x93, 0xD9, 0x67, 0x14, 0x92, 0x5A, 0x96, 0x86, 0x9F, 0xCD, 0x6E,
	0x9A, 0x2A, 0x17, 0xA9, 0x1A, 0xDD, 0x00, 0x7C, 0x78, 0xD8, 0x06, 0xC5,
	0xB4, 0xA4, 0xF6, 0xCF, 0x22, 0xCD, 0xCA, 0x0E, 0x27, 0x97, 0xDD, 0x22,
	0x02, 0x31, 0x2B, 0x9C, 0xFF, 0x7E, 0x35, 0x3C, 0xDA, 0xAB, 0x51, 0x68,
	0x5A, 0x81, 0xF3, 0xA5, 0xA9, 0x04, 0xDA, 0x45, 0x07, 0xC6, 0x4A, 0xEF,
	0x5D, 0x0E, 0xC3, 0x41, 0xD6, 0xAC, 0xD0, 0x8D, 0x56, 0xAC, 0xB4, 0x89,
	0x53, 0x41, 0x06, 0x99, 0x83, 0x04, 0xBE, 0x6D, 0x2B, 0x28, 0xEB, 0x47,
};

static const uint8_t keygen_dh1920_g[] = {
	0x05,
};

static const uint8_t keygen_dh1984_p[] = {
	0xD8, 0xF3, 0xDC, 0x89, 0xE0, 0x6E, 0xD4, 0x07, 0xC3, 0x95, 0xC0, 0x17,
	0x39, 0xCE, 0xF6, 0xD0, 0x8A, 0xD7, 0x85, 0xD3, 0x83, 0x4D, 0xDC, 0x0B,
	0x85, 0x3B, 0xB7, 0x47, 0xEA, 0xDF, 0xE3, 0x34, 0xCA, 0xA9, 0x60, 0x9A,
	0x4F, 0x8E, 0x8B, 0xAE, 0x8A, 0xAF, 0xD3, 0x96, 0x56, 0xFC, 0x1D, 0x37,
	0x9A, 0x96, 0x57, 0x21, 0x32, 0xF0, 0x22, 0xE8, 0x68, 0x8B, 0x73, 0xAE,
	0x1B, 0xAB, 0xFB, 0x79, 0x1B, 0x7E, 0xDC, 0xAD, 0x9D, 0xA2, 0xF3, 0x5E,
	0x11, 0x46, 0x54, 0x4E, 0x88, 0x92, 0x2B, 0x79, 0x3B, 0xBB, 0x14, 0xD8,
	0x3B, 0x0B, 0xB0, 0x55, 0xE5, 0x9A, 0xA9, 0xA0, 0x94, 0x3C, 0x72, 0xE0,
	0x47, 0x58, 0xA5, 0x85, 0xDC, 0x4A, 0x6D, 0x50, 0x98, 0x28, 0x9B, 0xA1,
	0xB2, 0x95, 0xBB, 0x1A, 0x41, 0x05, 0xBC, 0x32, 0x02, 0x72, 0xBB, 0xF7,
	0x1A, 0x48, 0xC3, 0xD9, 0x4F, 0xBD, 0x32, 0xC8, 0x82, 0xAB, 0xCE, 0xDE,
	0x24, 0x6A, 0x0C, 0x92, 0xF8, 0xFB, 0xFF, 0x18, 0x33, 0x48, 0xAC, 0xD7,
	0xA3, 0x12, 0x0D, 0x52, 0x15, 0x3A, 0xA4, 0x6D, 0x85, 0x0A, 0xBF, 0x19,
	0x63, 0x82, 0x3E, 0xB9, 0x52, 0x98, 0xEA, 0xCC, 0x56, 0x66, 0x0F, 0x96,
	0x90, 0x1D, 0x35, 0xD6, 0xE1, 0xF6, 0x2B, 0x5B, 0xF7, 0x75, 0x12, 0xE5,
	0xD9, 0xED, 0x2E, 0x20, 0xA0, 0xF5, 0x68, 0xA8, 0xC9, 0x6E, 0x08, 0xD0,
	0xD2, 0xE7, 0xB6, 0xCB, 0x51, 0xA2, 0x5A, 0x34, 0x0B, 0xF3, 0x13, 0xAF,
	0x5A, 0x46, 0x8B, 0xCB, 0xC9, 0x46, 0x02, 0x15, 0xFE, 0x96, 0x45, 0x25,
	0x7D, 0x76, 0x56, 0x16, 0x8C, 0x97, 0xF3, 0x74, 0xFC, 0x2F, 0x5D, 0xFA,
	0xCD, 0x62, 0x23, 0x02, 0xF8, 0x19, 0x94, 0xEE, 0xE6, 0x18, 0x09, 0xDE,
	0x64, 0xB4, 0x3A, 0xDC, 0x0A, 0x5E, 0x26, 0x83,
};

static const uint8_t keygen_dh1984_g[] = {
	0x05,
};

static const uint8_t keygen_dh2048_p[] = {
	0x8F, 0x3E, 0xC1, 0x36, 0xCA, 0x60, 0xCE, 0xD1, 0xC5, 0xFD, 0x22, 0x05,
	0xD6, 0x94, 0x38, 0x20, 0x4F, 0xE1, 0xAF, 0xBC, 0xA6, 0x82, 0xBD, 0x71,
	0xFD, 0xD6, 0xC2, 0x61, 0xE8, 0xC1, 0xBD, 0xA9, 0x5E, 0xFD, 0x02, 0x51,
	0xB6, 0x1F, 0x38, 0x30, 0x44, 0x76, 0x94, 0xB3, 0x26, 0x79, 0x35, 0xC4,
	0xDF, 0x51, 0x80, 0xAF, 0x0D, 0x81, 0xCC, 0xA2, 0x33, 0xD1, 0x1E, 0x77,
	0xB8, 0x06, 0xD7, 0xE5, 0x83, 0x34, 0x04, 0xF2, 0x96, 0x24, 0x37, 0xFE,
	0xBC, 0x20, 0x9C, 0x66, 0x4C, 0xEB, 0x4F, 0xFD, 0x1F, 0x99, 0x56, 0x40,
	0xD9, 0xE8, 0x6B, 0x2A, 0x8D, 0x6B, 0x56, 0xB2, 0xB4, 0x6D, 0x83, 0x47,
	0x4C, 0x18, 0x53, 0x8B, 0xB1, 0xA3, 0x51, 0xC2, 0x07, 0xA3, 0x36, 0x43,
	0x4B, 0x94, 0x10, 0xFD, 0x24, 0xA3, 0x77, 0x74, 0x77, 0xFA, 0x98, 0x4B,
	0x43, 0x0B, 0xB6, 0xEC, 0x7F, 0x5C, 0x7E, 0xBA, 0xB7, 0xC7, 0xAA, 0x72,
	0x11, 0x9F, 0x73, 0x14, 0x45, 0x03, 0x7A, 0x4E, 0xE5, 0xE7, 0x5C, 0x64,
	0xB8, 0x66, 0x66, 0xCE, 0xEE, 0xF8, 0xFF, 0x61, 0x0F, 0x5D, 0x4E, 0xF6,
	0xED, 0xB1, 0xE5, 0x2F, 0x52, 0xAC, 0x2B, 0x8F, 0x34, 0x0D, 0x13, 0xF6,
	0x4A, 0x3A, 0x6C, 0x56, 0xB3, 0x3C, 0x52, 0xA8, 0xB9, 0xBC, 0x27, 0xCA,
	0x3B, 0xFB, 0x6E, 0xE7, 0x52, 0xFB, 0xB0, 0x2B, 0x4F, 0xC4, 0xBD, 0x24,
	0x36, 0xE4, 0x71, 0x07, 0x74, 0x69, 0x5F, 0xE0, 0xB8, 0x59, 0x5F, 0x74,
	0x2F, 0xCC, 0x03, 0xB0, 0x6D, 0x90, 0xD8, 0xD3, 0x7C, 0x5A, 0x31, 0x46,
	0x5C, 0x7D, 0x1C, 0xC8, 0x0D, 0x18, 0x80, 0x8E, 0x5A, 0xA8, 0x5E, 0x4D,
	0x11, 0x2B, 0x76, 0xAC, 0x1E, 0x00, 0x51, 0x80, 0xE3, 0xED, 0x7A, 0xC0,
	0x4F, 0x80, 0xFA, 0x5F, 0xD5, 0xD7, 0x4F, 0xA7, 0x14, 0xE1, 0x60, 0x3C,
	0x95, 0x77, 0xCA, 0x3B,
};

static const uint8_t keygen_dh2048_g[] = {
	0x05,
};

static const uint8_t keygen_dh2048_subprime_p[] = {
	0x8F, 0x3E, 0xC1, 0x36, 0xCA, 0x60, 0xCE, 0xD1, 0xC5, 0xFD, 0x22, 0x05,
	0xD6, 0x94, 0x38, 0x20, 0x4F, 0xE1, 0xAF, 0xBC, 0xA6, 0x82, 0xBD, 0x71,
	0xFD, 0xD6, 0xC2, 0x61, 0xE8, 0xC1, 0xBD, 0xA9, 0x5E, 0xFD, 0x02, 0x51,
	0xB6, 0x1F, 0x38, 0x30, 0x44, 0x76, 0x94, 0xB3, 0x26, 0x79, 0x35, 0xC4,
	0xDF, 0x51, 0x80, 0xAF, 0x0D, 0x81, 0xCC, 0xA2, 0x33, 0xD1, 0x1E, 0x77,
	0xB8, 0x06, 0xD7, 0xE5, 0x83, 0x34, 0x04, 0xF2, 0x96, 0x24, 0x37, 0xFE,
	0xBC, 0x20, 0x9C, 0x66, 0x4C, 0xEB, 0x4F, 0xFD, 0x1F, 0x99, 0x56, 0x40,
	0xD9, 0xE8, 0x6B, 0x2A, 0x8D, 0x6B, 0x56, 0xB2, 0xB4, 0x6D, 0x83, 0x47,
	0x4C, 0x18, 0x53, 0x8B, 0xB1, 0xA3, 0x51, 0xC2, 0x07, 0xA3, 0x36, 0x43,
	0x4B, 0x94, 0x10, 0xFD, 0x24, 0xA3, 0x77, 0x74, 0x77, 0xFA, 0x98, 0x4B,
	0x43, 0x0B, 0xB6, 0xEC, 0x7F, 0x5C, 0x7E, 0xBA, 0xB7, 0xC7, 0xAA, 0x72,
	0x11, 0x9F, 0x73, 0x14, 0x45, 0x03, 0x7A, 0x4E, 0xE5, 0xE7, 0x5C, 0x64,
	0xB8, 0x66, 0x66, 0xCE, 0xEE, 0xF8, 0xFF, 0x61, 0x0F, 0x5D, 0x4E, 0xF6,
	0xED, 0xB1, 0xE5, 0x2F, 0x52, 0xAC, 0x2B, 0x8F, 0x34, 0x0D, 0x13, 0xF6,
	0x4A, 0x3A, 0x6C, 0x56, 0xB3, 0x3C, 0x52, 0xA8, 0xB9, 0xBC, 0x27, 0xCA,
	0x3B, 0xFB, 0x6E, 0xE7, 0x52, 0xFB, 0xB0, 0x2B, 0x4F, 0xC4, 0xBD, 0x24,
	0x36, 0xE4, 0x71, 0x07, 0x74, 0x69, 0x5F, 0xE0, 0xB8, 0x59, 0x5F, 0x74,
	0x2F, 0xCC, 0x03, 0xB0, 0x6D, 0x90, 0xD8, 0xD3, 0x7C, 0x5A, 0x31, 0x46,
	0x5C, 0x7D, 0x1C, 0xC8, 0x0D, 0x18, 0x80, 0x8E, 0x5A, 0xA8, 0x5E, 0x4D,
	0x11, 0x2B, 0x76, 0xAC, 0x1E, 0x00, 0x51, 0x80, 0xE3, 0xED, 0x7A, 0xC0,
	0x4F, 0x80, 0xFA, 0x5F, 0xD5, 0xD7, 0x4F, 0xA7, 0x14, 0xE1, 0x60, 0x3C,
	0x95, 0x77, 0xCA, 0x3B,
};

static const uint8_t keygen_dh2048_subprime_g[] = {
	0x05,
};
static const uint32_t keygen_dh256_private_bits;

static const uint32_t keygen_dh320_private_bits = 256;

static const uint32_t keygen_dh384_private_bits;

static const uint32_t keygen_dh448_private_bits = 256;

static const uint32_t keygen_dh512_private_bits;

static const uint32_t keygen_dh576_private_bits = 288;

static const uint32_t keygen_dh640_private_bits;

static const uint32_t keygen_dh704_private_bits = 352;

static const uint32_t keygen_dh768_private_bits;

static const uint32_t keygen_dh832_private_bits = 416;

static const uint32_t keygen_dh896_private_bits;

static const uint32_t keygen_dh960_private_bits = 480;

static const uint32_t keygen_dh1024_private_bits;

static const uint32_t keygen_dh1088_private_bits = 544;

static const uint32_t keygen_dh1152_private_bits;

static const uint32_t keygen_dh1216_private_bits = 608;

static const uint32_t keygen_dh1280_private_bits;

static const uint32_t keygen_dh1344_private_bits = 672;

static const uint32_t keygen_dh1408_private_bits;

static const uint32_t keygen_dh1472_private_bits = 736;

static const uint32_t keygen_dh1536_private_bits;

static const uint32_t keygen_dh1600_private_bits = 800;

static const uint32_t keygen_dh1664_private_bits;

static const uint32_t keygen_dh1728_private_bits = 864;

static const uint32_t keygen_dh1792_private_bits;

static const uint32_t keygen_dh1856_private_bits = 928;

static const uint32_t keygen_dh1920_private_bits;

static const uint32_t keygen_dh1984_private_bits = 992;

static const uint32_t keygen_dh2048_private_bits;

static const uint32_t keygen_dh2048_subprime_private_bits;

static const uint8_t keygen_dh2048_subprime_subprime[] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/*
 * Test data from 186-3dsatestvectors.zip KeyPair.rsp
 * http://csrc.nist.gov/groups/STM/cavp/documents/dss/186-3dsatestvectors.zip
 */
/* [mod = L=1024, N=160] */
static const uint8_t keygen_dsa_test1_p[] = {
	0xd3, 0x83, 0x11, 0xe2, 0xcd, 0x38, 0x8c, 0x3e, 0xd6, 0x98, 0xe8, 0x2f,
	0xdf, 0x88, 0xeb, 0x92, 0xb5, 0xa9, 0xa4, 0x83, 0xdc, 0x88, 0x00, 0x5d,
	0x4b, 0x72, 0x5e, 0xf3, 0x41, 0xea, 0xbb, 0x47, 0xcf, 0x8a, 0x7a, 0x8a,
	0x41, 0xe7, 0x92, 0xa1, 0x56, 0xb7, 0xce, 0x97, 0x20, 0x6c, 0x4f, 0x9c,
	0x5c, 0xe6, 0xfc, 0x5a, 0xe7, 0x91, 0x21, 0x02, 0xb6, 0xb5, 0x02, 0xe5,
	0x90, 0x50, 0xb5, 0xb2, 0x1c, 0xe2, 0x63, 0xdd, 0xdb, 0x20, 0x44, 0xb6,
	0x52, 0x23, 0x6f, 0x4d, 0x42, 0xab, 0x4b, 0x5d, 0x6a, 0xa7, 0x31, 0x89,
	0xce, 0xf1, 0xac, 0xe7, 0x78, 0xd7, 0x84, 0x5a, 0x5c, 0x1c, 0x1c, 0x71,
	0x47, 0x12, 0x31, 0x88, 0xf8, 0xdc, 0x55, 0x10, 0x54, 0xee, 0x16, 0x2b,
	0x63, 0x4d, 0x60, 0xf0, 0x97, 0xf7, 0x19, 0x07, 0x66, 0x40, 0xe2, 0x09,
	0x80, 0xa0, 0x09, 0x31, 0x13, 0xa8, 0xbd, 0x73
};

static const uint8_t keygen_dsa_test1_q[] = {
	0x96, 0xc5, 0x39, 0x0a, 0x8b, 0x61, 0x2c, 0x0e, 0x42, 0x2b, 0xb2, 0xb0,
	0xea, 0x19, 0x4a, 0x3e, 0xc9, 0x35, 0xa2, 0x81
};

static const uint8_t keygen_dsa_test1_g[] = {
	0x06, 0xb7, 0x86, 0x1a, 0xbb, 0xd3, 0x5c, 0xc8, 0x9e, 0x79, 0xc5, 0x2f,
	0x68, 0xd2, 0x08, 0x75, 0x38, 0x9b, 0x12, 0x73, 0x61, 0xca, 0x66, 0x82,
	0x21, 0x38, 0xce, 0x49, 0x91, 0xd2, 0xb8, 0x62, 0x25, 0x9d, 0x6b, 0x45,
	0x48, 0xa6, 0x49, 0x5b, 0x19, 0x5a, 0xa0, 0xe0, 0xb6, 0x13, 0x7c, 0xa3,
	0x7e, 0xb2, 0x3b, 0x94, 0x07, 0x4d, 0x3c, 0x3d, 0x30, 0x00, 0x42, 0xbd,
	0xf1, 0x57, 0x62, 0x81, 0x2b, 0x63, 0x33, 0xef, 0x7b, 0x07, 0xce, 0xba,
	0x78, 0x60, 0x76, 0x10, 0xfc, 0xc9, 0xee, 0x68, 0x49, 0x1d, 0xbc, 0x1e,
	0x34, 0xcd, 0x12, 0x61, 0x54, 0x74, 0xe5, 0x2b, 0x18, 0xbc, 0x93, 0x4f,
	0xb0, 0x0c, 0x61, 0xd3, 0x9e, 0x7d, 0xa8, 0x90, 0x22, 0x91, 0xc4, 0x43,
	0x4a, 0x4e, 0x22, 0x24, 0xc3, 0xf4, 0xfd, 0x9f, 0x93, 0xcd, 0x6f, 0x4f,
	0x17, 0xfc, 0x07, 0x63, 0x41, 0xa7, 0xe7, 0xd9
};

/* for i in {512..1024..64}; do openssl dsaparam -C $i; done */
static const uint8_t keygen_dsa512_p[] = {
	0xC8, 0x6B, 0xB7, 0x91, 0xD6, 0x63, 0xCE, 0xC0, 0xC6, 0xB8, 0xAC, 0x5B,
	0xEB, 0xA7, 0xEF, 0x17, 0xBE, 0x1A, 0x1A, 0x36, 0x6B, 0x38, 0x40, 0x0E,
	0x69, 0x13, 0x32, 0xD4, 0x4B, 0xBE, 0x00, 0xB5, 0x29, 0x7F, 0x6B, 0x87,
	0xAA, 0x1D, 0x98, 0x37, 0xD2, 0xAC, 0x62, 0x26, 0xD7, 0xFD, 0xE1, 0xC9,
	0x13, 0x4F, 0x2A, 0xF2, 0x82, 0xEC, 0xA8, 0x83, 0x6F, 0x29, 0xD3, 0xF5,
	0x16, 0xB9, 0x13, 0xCD,
};

static const uint8_t keygen_dsa512_q[] = {
	0x8D, 0xF9, 0x8B, 0x8A, 0xDA, 0x3B, 0x0B, 0x1C, 0xFA, 0x1C, 0xA7, 0xE8,
	0x9A, 0xA2, 0xD7, 0xC3, 0x2D, 0xD5, 0x9D, 0x1B,
};

static const uint8_t keygen_dsa512_g[] = {
	0xB3, 0xE2, 0xFD, 0x38, 0xE0, 0x9A, 0x21, 0x64, 0x8F, 0x6D, 0x7E, 0x4F,
	0xC2, 0x24, 0x18, 0x88, 0xEC, 0xA4, 0xCB, 0xB0, 0x5F, 0x43, 0xD8, 0x2B,
	0x5B, 0xDE, 0x01, 0xB4, 0xD2, 0x24, 0x1F, 0x80, 0xE7, 0xFC, 0xF3, 0x15,
	0xFA, 0x0C, 0x5B, 0x6F, 0x81, 0x55, 0x8C, 0x80, 0x36, 0xFB, 0x4D, 0xB5,
	0x8C, 0x5A, 0x26, 0xBE, 0xFB, 0x78, 0xEA, 0x62, 0x6A, 0x9D, 0x5E, 0xD0,
	0x21, 0x0C, 0xD9, 0x4E,
};

static const uint8_t keygen_dsa576_p[] = {
	0xF7, 0x85, 0x23, 0x2C, 0x2C, 0x86, 0xD4, 0x2B, 0xE5, 0x09, 0xAB, 0x60,
	0xD6, 0x79, 0x05, 0x13, 0x75, 0x78, 0x1E, 0xAE, 0xEB, 0x5F, 0xBA, 0xFA,
	0x6E, 0x05, 0xE7, 0xB3, 0x8D, 0x33, 0x4B, 0xE5, 0xB5, 0xAA, 0xD4, 0xE6,
	0xA3, 0x9B, 0xA2, 0xF5, 0x7B, 0xF6, 0x32, 0xE6, 0x31, 0x6F, 0x34, 0x46,
	0x16, 0xEA, 0xD8, 0x94, 0x79, 0xD7, 0x69, 0x23, 0xA4, 0x04, 0xE2, 0x25,
	0xBB, 0x6D, 0xCC, 0x6E, 0x99, 0xB7, 0x90, 0x90, 0x89, 0xB9, 0x88, 0x19,
};

static const uint8_t keygen_dsa576_q[] = {
	0xF0, 0xD8, 0x71, 0x31, 0xB5, 0x01, 0xC1, 0x6B, 0x09, 0xCE, 0x7D, 0x2F,
	0x82, 0x48, 0xB0, 0x21, 0x9C, 0xD6, 0xB5, 0xB1,
};

static const uint8_t keygen_dsa576_g[] = {
	0x33, 0x45, 0xB8, 0x9A, 0x17, 0x4B, 0xBF, 0xD3, 0xB2, 0xBA, 0xD2, 0xE4,
	0xAC, 0x54, 0xA0, 0x9B, 0x5F, 0x5D, 0x95, 0x88, 0x9C, 0x0C, 0x59, 0xCE,
	0x40, 0x0C, 0x05, 0xFD, 0xC4, 0x9D, 0x22, 0x27, 0xDA, 0xA6, 0xD1, 0x10,
	0x61, 0x46, 0x31, 0x5C, 0x7D, 0x4E, 0xF6, 0x01, 0x38, 0x9A, 0x7E, 0x72,
	0x4E, 0x7A, 0x07, 0xFB, 0x6D, 0x20, 0x9D, 0x59, 0xC6, 0x33, 0x6A, 0x64,
	0xBF, 0x14, 0x30, 0x4E, 0x0C, 0x64, 0x9D, 0x11, 0xCF, 0x64, 0xCE, 0x29,
};

static const uint8_t keygen_dsa640_p[] = {
	0x88, 0x8C, 0x58, 0x99, 0xF4, 0x78, 0xEA, 0x31, 0x56, 0xB7, 0x2C, 0x70,
	0xDC, 0x09, 0x5D, 0xB9, 0x13, 0x16, 0xCE, 0xDF, 0xFD, 0x8C, 0x4E, 0xF8,
	0x32, 0x59, 0x00, 0x58, 0xD6, 0x44, 0x4F, 0x95, 0xF7, 0x85, 0x14, 0xC3,
	0x10, 0x5A, 0xA2, 0x44, 0x2F, 0xA2, 0xC9, 0xB4, 0x88, 0x89, 0xA1, 0xAE,
	0x0E, 0x82, 0xE1, 0xC1, 0x45, 0x09, 0x98, 0xF7, 0xCB, 0xF2, 0xD8, 0xA0,
	0x6E, 0x32, 0x02, 0xE4, 0x0E, 0x7A, 0x43, 0x3A, 0xE1, 0x04, 0x4C, 0xC5,
	0x78, 0x0E, 0x02, 0x27, 0xC4, 0xD0, 0xCA, 0x29,
};

static const uint8_t keygen_dsa640_q[] = {
	0xD7, 0x63, 0x4F, 0x3E, 0x6D, 0x52, 0x93, 0x69, 0xFA, 0xFF, 0xDE, 0x0D,
	0x57, 0x3F, 0x24, 0xBB, 0x01, 0xF8, 0x01, 0xAD,
};

static const uint8_t keygen_dsa640_g[] = {
	0x76, 0xCB, 0x07, 0xB9, 0xE9, 0x3F, 0x3C, 0xA5, 0x18, 0x43, 0x83, 0xE6,
	0xBC, 0x42, 0x09, 0xD9, 0xC5, 0x1C, 0x56, 0x57, 0x0B, 0x5B, 0x46, 0x65,
	0x00, 0x67, 0xCA, 0x33, 0xC0, 0xA6, 0x37, 0xEA, 0x89, 0xAE, 0xDF, 0x1D,
	0x79, 0x96, 0xC7, 0x0C, 0xD2, 0xAC, 0xD3, 0x2C, 0x46, 0xC2, 0xA0, 0x9D,
	0x4B, 0x06, 0xB5, 0xDF, 0xAE, 0x73, 0xEB, 0x9A, 0x6A, 0x54, 0x39, 0x2C,
	0xB1, 0x98, 0xAD, 0x44, 0xF3, 0x29, 0xC9, 0xC5, 0x75, 0xF1, 0x3C, 0xD8,
	0x3B, 0xA1, 0x85, 0x29, 0x38, 0xB9, 0x17, 0xA5,
};

static const uint8_t keygen_dsa704_p[] = {
	0xDA, 0xEA, 0x9B, 0x6B, 0x35, 0x06, 0x2E, 0x7E, 0x71, 0xB2, 0x11, 0xD0,
	0x37, 0x84, 0x88, 0xC0, 0x50, 0x94, 0x73, 0x78, 0xA8, 0x9C, 0xBD, 0x8C,
	0xB1, 0x0A, 0xD5, 0x89, 0x52, 0x39, 0xBF, 0x41, 0xDC, 0xB9, 0xE5, 0x16,
	0x1A, 0x86, 0xD5, 0xCF, 0xD6, 0x26, 0x84, 0x95, 0xE9, 0x0D, 0xCD, 0x98,
	0x21, 0x6B, 0x3C, 0xFE, 0x6D, 0x2D, 0x42, 0x1A, 0x3F, 0xE0, 0xFF, 0x07,
	0x41, 0x82, 0x30, 0x15, 0x17, 0xF3, 0x0F, 0x7B, 0xA0, 0xD3, 0x46, 0xFA,
	0x1F, 0x1E, 0xEC, 0xBD, 0x26, 0xCE, 0x4C, 0xE3, 0xBD, 0x73, 0xA3, 0xA6,
	0xA0, 0x12, 0xE1, 0xFD,
};

static const uint8_t keygen_dsa704_q[] = {
	0xCE, 0xB3, 0x2E, 0x41, 0xEB, 0xFD, 0x22, 0x2A, 0xCE, 0x9A, 0xAF, 0x24,
	0xE3, 0x02, 0x50, 0xDE, 0x47, 0xBC, 0x4C, 0x1F,
};

static const uint8_t keygen_dsa704_g[] = {
	0x08, 0x83, 0x72, 0x6D, 0x0A, 0x8F, 0x19, 0x61, 0xE4, 0x62, 0x40, 0x29,
	0x66, 0x6B, 0xDE, 0xBD, 0xAB, 0xE3, 0x5B, 0x58, 0x3F, 0xF5, 0xEA, 0xDE,
	0x8E, 0x7A, 0x34, 0xAF, 0x1C, 0x99, 0x03, 0x1A, 0x51, 0x17, 0xFC, 0xE0,
	0xA3, 0x22, 0x43, 0x63, 0xB6, 0x7E, 0x29, 0x4B, 0x23, 0x6C, 0xD1, 0xDE,
	0x59, 0xEC, 0x1D, 0x67, 0x94, 0xDD, 0x2E, 0x88, 0x86, 0xD3, 0xD6, 0x68,
	0x58, 0x36, 0x48, 0xF8, 0xEF, 0x38, 0x3F, 0xF5, 0x87, 0x96, 0x38, 0xD3,
	0x48, 0x50, 0x1F, 0xA3, 0x4A, 0xCA, 0xD7, 0x4D, 0xC3, 0x84, 0x83, 0xB1,
	0x8A, 0x95, 0xE0, 0xB3,
};

static const uint8_t keygen_dsa768_p[] = {
	0xF0, 0xB1, 0x93, 0xFD, 0x53, 0x98, 0x23, 0x43, 0xFB, 0x04, 0xB1, 0x31,
	0x80, 0x3D, 0xD3, 0x95, 0x56, 0x51, 0xCC, 0x32, 0xA4, 0x51, 0x00, 0x8A,
	0x80, 0xB6, 0x87, 0x70, 0xD7, 0x77, 0x8D, 0xA6, 0xC2, 0xB5, 0x85, 0xE1,
	0xE0, 0x9E, 0x11, 0x28, 0x72, 0xE9, 0x45, 0x5B, 0x4D, 0xC9, 0xDC, 0x46,
	0x64, 0x2F, 0x44, 0xD8, 0x24, 0xE3, 0x9B, 0xCC, 0xF9, 0x66, 0x31, 0x9C,
	0x40, 0x64, 0xED, 0xC5, 0x48, 0x30, 0x84, 0x0C, 0xF9, 0x1F, 0xBC, 0x75,
	0xD8, 0x8C, 0x53, 0x30, 0x25, 0xB6, 0xBD, 0xDA, 0xBE, 0xBC, 0xBA, 0x86,
	0xB3, 0x7D, 0x27, 0x74, 0x9D, 0x68, 0xEA, 0xB8, 0xE0, 0x09, 0x3A, 0x7F,
};

static const uint8_t keygen_dsa768_q[] = {
	0xC9, 0x8C, 0x79, 0x7B, 0x98, 0xB5, 0xFD, 0x80, 0x5D, 0x4B, 0x26, 0x30,
	0x42, 0x63, 0xDE, 0x37, 0xAB, 0x4B, 0xB7, 0xAF,
};

static const uint8_t keygen_dsa768_g[] = {
	0xD4, 0xE8, 0xF1, 0xB9, 0x6D, 0x40, 0x26, 0x19, 0x72, 0x39, 0x5C, 0x6F,
	0x68, 0x4C, 0x8C, 0x18, 0xD8, 0x49, 0x3C, 0xB6, 0x5D, 0x72, 0xE3, 0xF4,
	0x89, 0x24, 0x69, 0xC8, 0x76, 0x83, 0x38, 0xA2, 0x23, 0xF5, 0xB3, 0xD5,
	0xCB, 0x0F, 0xC4, 0xFE, 0x45, 0x65, 0x2F, 0x2C, 0x3D, 0x32, 0x02, 0x28,
	0xE5, 0xCA, 0x34, 0xEC, 0x1A, 0xBB, 0x82, 0x93, 0x2A, 0xD9, 0x64, 0x1E,
	0xC5, 0x91, 0x34, 0x60, 0xF2, 0xE2, 0x2D, 0x64, 0x4E, 0x46, 0xAA, 0x00,
	0x6F, 0x26, 0xD8, 0x98, 0x97, 0xBF, 0xCC, 0xF1, 0x1B, 0x4A, 0x8A, 0x7D,
	0x39, 0xA4, 0xA4, 0x23, 0x82, 0x64, 0x78, 0x40, 0xED, 0x4C, 0x96, 0xB9,
};

static const uint8_t keygen_dsa832_p[] = {
	0x93, 0x47, 0x85, 0x69, 0x79, 0xF2, 0xAA, 0xC2, 0x83, 0xA4, 0x08, 0x2F,
	0x3C, 0xE5, 0x4D, 0x3B, 0xFF, 0x4D, 0xC5, 0xF4, 0x03, 0x20, 0xFA, 0x15,
	0xA8, 0x27, 0x80, 0x55, 0x29, 0x57, 0x60, 0x0B, 0x75, 0x01, 0x7B, 0x65,
	0xCE, 0x4D, 0x7C, 0xF6, 0x7C, 0x4F, 0x1D, 0xC3, 0x67, 0xF2, 0xC1, 0x64,
	0x38, 0x49, 0x54, 0x60, 0x57, 0x05, 0xEB, 0x31, 0xFA, 0x7B, 0x50, 0xA1,
	0x0F, 0xCB, 0xC4, 0x4E, 0xDF, 0x92, 0x5A, 0x8B, 0x11, 0xBA, 0x6B, 0x7E,
	0x7A, 0xB4, 0x80, 0xD0, 0x9A, 0xE2, 0x88, 0x7D, 0x83, 0xA6, 0x81, 0x81,
	0x71, 0xD0, 0x06, 0xDE, 0xCC, 0xA4, 0xB9, 0x0A, 0x6B, 0x81, 0x31, 0x28,
	0x1D, 0xEF, 0x5F, 0x99, 0xDE, 0xEC, 0xDA, 0x4D,
};

static const uint8_t keygen_dsa832_q[] = {
	0xF8, 0xF5, 0xAF, 0x31, 0x0D, 0xBE, 0x6F, 0x4B, 0x79, 0x87, 0xA2, 0x98,
	0xED, 0xF1, 0x2A, 0x93, 0x3D, 0x12, 0x5D, 0x25,
};

static const uint8_t keygen_dsa832_g[] = {
	0x11, 0x21, 0xBC, 0x83, 0x7A, 0xD9, 0x5F, 0x0E, 0xA2, 0xF7, 0x96, 0xB7,
	0x6A, 0xDD, 0xAE, 0xBA, 0x11, 0x26, 0x58, 0xF6, 0xB1, 0xCF, 0x94, 0x35,
	0x3B, 0xFB, 0x9C, 0x9B, 0x16, 0xB8, 0x58, 0xBA, 0x2F, 0x5C, 0xE5, 0x18,
	0xE1, 0x29, 0xA6, 0xA3, 0x1C, 0x0C, 0xA5, 0xC7, 0xAE, 0xE8, 0x31, 0x26,
	0x8C, 0xCD, 0xA5, 0x69, 0xB2, 0x74, 0x31, 0x15, 0xCE, 0x82, 0xCD, 0x32,
	0xF7, 0xC8, 0x90, 0x60, 0x96, 0x61, 0x07, 0x60, 0x63, 0x6B, 0x48, 0x03,
	0xCD, 0x1F, 0x58, 0x7D, 0x8E, 0xAF, 0x26, 0x16, 0x3B, 0xC6, 0xA6, 0x03,
	0xB4, 0xE1, 0x3E, 0xBE, 0x5B, 0xC9, 0xD3, 0xBD, 0xB6, 0x31, 0xC9, 0x34,
	0x2C, 0x2B, 0x08, 0x3C, 0xE0, 0x1C, 0x1E, 0x01,
};

static const uint8_t keygen_dsa896_p[] = {
	0xCA, 0x16, 0xD2, 0xB2, 0x7C, 0xC5, 0x25, 0x99, 0x3A, 0xCC, 0xCB, 0x3F,
	0x72, 0xAE, 0xD4, 0xA0, 0x1E, 0xE0, 0x19, 0x6A, 0x8A, 0xC2, 0xFC, 0xD5,
	0xB2, 0xCC, 0xD1, 0x6F, 0xA3, 0x95, 0x30, 0xEC, 0x2B, 0x4A, 0x46, 0x6C,
	0x72, 0xC3, 0x31, 0xFD, 0x94, 0x00, 0x55, 0xE7, 0x03, 0xC3, 0xDE, 0xD7,
	0xE3, 0xF8, 0xAF, 0x32, 0x0A, 0x29, 0x32, 0xC5, 0x97, 0x93, 0x2A, 0xE6,
	0xC6, 0x82, 0x49, 0x5C, 0x76, 0xB3, 0xCB, 0x47, 0xD7, 0xFF, 0xEA, 0xE5,
	0x47, 0x87, 0x08, 0x6C, 0xEA, 0x6D, 0x1A, 0xF6, 0x47, 0xBA, 0xE3, 0x94,
	0xE9, 0xFE, 0xF6, 0x06, 0xA1, 0x99, 0xDC, 0xCB, 0x3D, 0x7A, 0x06, 0x31,
	0xAC, 0x25, 0xD3, 0x3C, 0x35, 0xAD, 0x36, 0x8D, 0x25, 0x41, 0xE9, 0x21,
	0xD1, 0xF9, 0xC3, 0xC9,
};

static const uint8_t keygen_dsa896_q[] = {
	0xAE, 0x42, 0x0A, 0x1D, 0x76, 0xA9, 0xFB, 0xF1, 0xCB, 0x2D, 0x73, 0x35,
	0x3F, 0x98, 0x63, 0x34, 0xE1, 0xCD, 0x3C, 0xCF,
};

static const uint8_t keygen_dsa896_g[] = {
	0x12, 0xD0, 0x15, 0x32, 0x0B, 0x7D, 0xE3, 0xD0, 0x36, 0x51, 0x79, 0x3E,
	0xB4, 0x4E, 0xE2, 0x1E, 0x5E, 0x3E, 0x43, 0x4C, 0x5D, 0x49, 0x9D, 0xD4,
	0xA3, 0xE3, 0xC8, 0x1F, 0x46, 0xA2, 0xCE, 0x95, 0xF9, 0x8D, 0xFC, 0xFD,
	0x50, 0x48, 0xBF, 0xB5, 0x25, 0xB6, 0xFD, 0xF9, 0xF1, 0x97, 0xD5, 0x82,
	0xEE, 0xE7, 0xDF, 0xC6, 0xDD, 0x09, 0x96, 0x15, 0xC0, 0x95, 0x60, 0xF4,
	0x53, 0xF6, 0x19, 0xA4, 0x84, 0x53, 0xE4, 0x87, 0xB6, 0x0C, 0x6C, 0x01,
	0x31, 0x72, 0x56, 0xA4, 0x2E, 0x25, 0xFC, 0x46, 0xB0, 0x47, 0xF3, 0x5A,
	0x90, 0x69, 0xAC, 0x64, 0x02, 0xCB, 0x1F, 0x5F, 0x10, 0x70, 0x2B, 0x71,
	0xF7, 0x9B, 0x70, 0x22, 0x7F, 0x05, 0xEB, 0xCB, 0x6D, 0x66, 0xDE, 0xFC,
	0xED, 0x51, 0xC2, 0x4D,
};

static const uint8_t keygen_dsa960_p[] = {
	0xCA, 0x86, 0x31, 0x0C, 0x62, 0xC7, 0x25, 0x2F, 0xAA, 0x8D, 0xA5, 0x51,
	0x97, 0x81, 0xB8, 0xC5, 0xFD, 0xDB, 0x47, 0xC4, 0x8E, 0xDF, 0x06, 0xAA,
	0x76, 0xAD, 0x47, 0xDD, 0x56, 0x6C, 0x97, 0xEB, 0x8C, 0xEC, 0x59, 0x79,
	0x1B, 0xBF, 0x96, 0x80, 0x50, 0x72, 0x8E, 0x2F, 0x34, 0x71, 0x5B, 0x03,
	0x2D, 0xB0, 0x31, 0x37, 0x8C, 0xC4, 0x62, 0x99, 0x9D, 0xC2, 0xDF, 0x68,
	0x35, 0xD5, 0x3F, 0xC1, 0x4B, 0xC4, 0x2F, 0xFA, 0xBD, 0x7E, 0xA5, 0x20,
	0x8F, 0xB9, 0x5F, 0x98, 0xA9, 0x1B, 0xAF, 0x8A, 0xF8, 0x29, 0xEB, 0x44,
	0xB6, 0x50, 0x96, 0xE2, 0xB4, 0x3D, 0x3C, 0xE6, 0x8B, 0xD5, 0x15, 0x39,
	0x4F, 0xF4, 0xC3, 0x32, 0xD3, 0xE6, 0x36, 0x0D, 0x23, 0xFF, 0x76, 0x15,
	0x05, 0xC1, 0xDF, 0xC2, 0x82, 0xCE, 0xDD, 0x60, 0x05, 0x92, 0x56, 0xE5,
};

static const uint8_t keygen_dsa960_q[] = {
	0xCE, 0x0A, 0x68, 0xA4, 0xAC, 0x5E, 0x8E, 0x4C, 0xA6, 0x8A, 0xAB, 0xA9,
	0x39, 0xC7, 0xB4, 0x10, 0xCC, 0xF6, 0x1E, 0x2F,
};

static const uint8_t keygen_dsa960_g[] = {
	0x8A, 0x50, 0x28, 0x45, 0x69, 0x0E, 0x55, 0xB8, 0x86, 0xB5, 0xCB, 0xBC,
	0x49, 0x8D, 0x73, 0x79, 0xE3, 0x26, 0x4E, 0x90, 0x71, 0xF2, 0xBB, 0x50,
	0x18, 0xF8, 0x6D, 0x14, 0x8F, 0xCA, 0x20, 0xF7, 0x02, 0x31, 0x71, 0x8A,
	0x7E, 0xF0, 0xFE, 0x9C, 0xAD, 0x05, 0x5E, 0x11, 0xB3, 0x40, 0x66, 0xE1,
	0x2B, 0x0D, 0x84, 0x15, 0x18, 0x65, 0x00, 0xFA, 0x0D, 0x8A, 0x87, 0xC9,
	0xBF, 0x4A, 0x5C, 0x53, 0x29, 0xEB, 0x44, 0xCA, 0xAE, 0x86, 0x50, 0x3B,
	0xBB, 0x73, 0x06, 0x83, 0x72, 0x77, 0x17, 0xDB, 0x6E, 0x14, 0xAD, 0xCE,
	0xD2, 0x51, 0xE6, 0x1F, 0xA2, 0x64, 0xE4, 0x5F, 0x35, 0x7D, 0x7A, 0xBE,
	0x55, 0x9B, 0xB6, 0x0F, 0x3C, 0xA1, 0xD2, 0x45, 0xDD, 0xF8, 0xC4, 0x03,
	0x45, 0xAA, 0x12, 0xE4, 0x90, 0x8C, 0xAC, 0x04, 0x45, 0x74, 0x11, 0x28,
};

static const uint8_t keygen_dsa1024_p[] = {
	0xAF, 0xA6, 0x9C, 0x37, 0x47, 0xD4, 0x65, 0xA6, 0xB1, 0x8D, 0xAC, 0x2E,
	0xAB, 0xD5, 0x36, 0xCC, 0x83, 0x47, 0xDD, 0xB6, 0x12, 0xCC, 0x93, 0xA5,
	0xBF, 0x7B, 0x24, 0xE7, 0x4A, 0xED, 0xEC, 0x63, 0x9E, 0x0B, 0x2D, 0xF8,
	0xB3, 0x6B, 0xBB, 0xF9, 0x40, 0x8D, 0x56, 0x26, 0x60, 0xD0, 0xDD, 0x03,
	0xF8, 0xC3, 0x82, 0x00, 0x2C, 0x27, 0x82, 0x5E, 0x30, 0x8B, 0x9D, 0xF1,
	0xF7, 0xB2, 0x61, 0x01, 0x31, 0x30, 0xF3, 0x05, 0x2F, 0xF4, 0xB7, 0x1C,
	0x1C, 0x3C, 0xB0, 0x2D, 0x2F, 0x1F, 0xE6, 0x2E, 0x21, 0x81, 0x0D, 0xFD,
	0x66, 0x36, 0x90, 0x39, 0x4D, 0xA0, 0xCF, 0xFA, 0xDD, 0xF7, 0xD5, 0xE4,
	0x09, 0xAA, 0x45, 0xDB, 0xE1, 0x55, 0x39, 0xD9, 0xF7, 0xDF, 0x34, 0x67,
	0xBF, 0x95, 0x9B, 0xF2, 0x4A, 0x15, 0x42, 0x6F, 0x32, 0x1F, 0xDE, 0xA6,
	0xFE, 0x18, 0x46, 0x6B, 0x8C, 0x4E, 0x01, 0x7F,
};

static const uint8_t keygen_dsa1024_q[] = {
	0xCC, 0x18, 0x69, 0xCE, 0x9E, 0x92, 0xE7, 0xCD, 0xBF, 0x94, 0xB5, 0xAD,
	0x83, 0x5A, 0x56, 0xD6, 0x4E, 0xC4, 0xF7, 0xED,
};

static const uint8_t keygen_dsa1024_g[] = {
	0x14, 0x1D, 0x91, 0xAB, 0x8F, 0xFF, 0xFB, 0x2D, 0xD3, 0x2A, 0x43, 0xB5,
	0x01, 0x40, 0xA4, 0xC7, 0x48, 0x0E, 0xE0, 0x10, 0xA9, 0xF7, 0x8B, 0x7E,
	0x45, 0x90, 0xE0, 0x17, 0xC1, 0xB4, 0xE9, 0xBA, 0xC0, 0x04, 0xEF, 0x0F,
	0xD6, 0x07, 0x78, 0x05, 0x25, 0xCF, 0x9D, 0x39, 0x66, 0x59, 0x53, 0xF8,
	0xCE, 0x1C, 0x61, 0x1B, 0x7F, 0x95, 0x9B, 0xD5, 0xB6, 0xF9, 0xC7, 0xE3,
	0xB8, 0x00, 0x78, 0x50, 0xE3, 0x4C, 0x76, 0xF8, 0x0E, 0x96, 0x11, 0xDB,
	0x28, 0x53, 0xA5, 0xBB, 0x22, 0xC5, 0x71, 0x97, 0x09, 0xBC, 0xEE, 0x55,
	0x9B, 0x6B, 0x22, 0x64, 0xE4, 0x49, 0x2C, 0xCD, 0x9E, 0xA5, 0x86, 0xF0,
	0x3F, 0x08, 0xCD, 0x88, 0x07, 0xF6, 0x6E, 0x3F, 0x8E, 0x99, 0x31, 0xBA,
	0x1A, 0xB9, 0x8E, 0xEC, 0xA3, 0x13, 0xC2, 0x85, 0xA5, 0xDC, 0xA4, 0xF0,
	0x1F, 0xB2, 0xC8, 0xD5, 0x19, 0x79, 0xCA, 0x6A,
};

/* derive key test data, taken from GP test specifikation */
static const uint8_t derive_key_dh_prime[] = {
	0xe0, 0x01, 0xe8, 0x96, 0x7d, 0xb4, 0x93, 0x53, 0xe1, 0x6f, 0x8e, 0x89,
	0x22, 0x0c, 0xce, 0xfc, 0x5c, 0x5f, 0x12, 0xe3, 0xdf, 0xf8, 0xf1, 0xd1,
	0x49, 0x90, 0x12, 0xe6, 0xef, 0x53, 0xe3, 0x1f, 0x02, 0xea, 0xcc, 0x5a,
	0xdd, 0xf3, 0x37, 0x89, 0x35, 0xc9, 0x5b, 0x21, 0xea, 0x3d, 0x6f, 0x1c,
	0xd7, 0xce, 0x63, 0x75, 0x52, 0xec, 0x38, 0x6c, 0x0e, 0x34, 0xf7, 0x36,
	0xad, 0x95, 0x17, 0xef, 0xfe, 0x5e, 0x4d, 0xa7, 0xa8, 0x6a, 0xf9, 0x0e,
	0x2c, 0x22, 0x8f, 0xe4, 0xb9, 0xe6, 0xd8, 0xf8, 0xf0, 0x2d, 0x20, 0xaf,
	0x78, 0xab, 0xb6, 0x92, 0xac, 0xbc, 0x4b, 0x23, 0xfa, 0xf2, 0xc5, 0xcc,
	0xd4, 0x9a, 0x0c, 0x9a, 0x8b, 0xcd, 0x91, 0xac, 0x0c, 0x55, 0x92, 0x01,
	0xe6, 0xc2, 0xfd, 0x1f, 0x47, 0xc2, 0xcb, 0x2a, 0x88, 0xa8, 0x3c, 0x21,
	0x0f, 0xc0, 0x54, 0xdb, 0x29, 0x2d, 0xbc, 0x45
};

static const uint8_t derive_key_dh_base[] = {
	0x1c, 0xe0, 0xf6, 0x69, 0x26, 0x46, 0x11, 0x97, 0xef, 0x45, 0xc4, 0x65,
	0x8b, 0x83, 0xb8, 0xab
};

static const uint8_t derive_key_dh_public_value[] = {
	0xbb, 0xe9, 0x18, 0xdd, 0x4b, 0x2b, 0x94, 0x1b, 0x10, 0x0e, 0x88, 0x35,
	0x28, 0x68, 0xfc, 0x62, 0x04, 0x38, 0xa6, 0xdb, 0x32, 0xa6, 0x9e, 0xee,
	0x6c, 0x6f, 0x45, 0x1c, 0xa3, 0xa6, 0xd5, 0x37, 0x77, 0x75, 0x5b, 0xc1,
	0x37, 0x0a, 0xce, 0xfe, 0x2b, 0x8f, 0x13, 0xa9, 0x14, 0x2c, 0x5b, 0x44,
	0x15, 0x78, 0x86, 0x30, 0xd6, 0x95, 0xb1, 0x92, 0x20, 0x63, 0xa3, 0xcf,
	0x9d, 0xef, 0x65, 0x61, 0x27, 0x4d, 0x24, 0x01, 0xe7, 0xa1, 0x45, 0xf2,
	0xd8, 0xb9, 0x3a, 0x45, 0x17, 0xf4, 0x19, 0xd0, 0x5e, 0xf8, 0xcb, 0x35,
	0x59, 0x37, 0x9d, 0x04, 0x20, 0xa3, 0xbf, 0x02, 0xad, 0xfe, 0xa8, 0x60,
	0xb2, 0xc3, 0xee, 0x85, 0x58, 0x90, 0xf3, 0xb5, 0x57, 0x2b, 0xb4, 0xef,
	0xd7, 0x8f, 0x37, 0x68, 0x78, 0x7c, 0x71, 0x52, 0x9d, 0x5e, 0x0a, 0x61,
	0x4f, 0x09, 0x89, 0x92, 0x39, 0xf7, 0x4b, 0x01
};

static const uint8_t derive_key_dh_private_value[] = {
	0x53, 0x8d, 0x3d, 0x64, 0x27, 0x4a, 0x40, 0x05, 0x9b, 0x9c, 0x26, 0xe9,
	0x13, 0xe6, 0x91, 0x53, 0x23, 0x7b, 0x55, 0x83
};

static const uint8_t derive_key_dh_public_value_2[] = {
	0xa3, 0xf5, 0x7d, 0xbe, 0x9e, 0x2f, 0x0a, 0xda, 0xa9, 0x4e, 0x4e, 0x6a,
	0xf0, 0xe0, 0x71, 0x47, 0x0e, 0x2e, 0x41, 0x2e, 0xde, 0x73, 0x2a, 0x62,
	0x14, 0xc3, 0x7c, 0x26, 0xd4, 0xe9, 0x9a, 0x54, 0xba, 0x3d, 0xe7, 0x49,
	0x85, 0x95, 0x0e, 0xe9, 0x14, 0xb2, 0x90, 0x22, 0x91, 0xdc, 0xff, 0x61,
	0xb2, 0xfc, 0xd1, 0xd0, 0x1b, 0x11, 0x14, 0xb6, 0x02, 0x64, 0x2b, 0x26,
	0x5d, 0x88, 0xea, 0x8d, 0xbb, 0xe2, 0x07, 0x0b, 0x48, 0xfb, 0x01, 0x53,
	0x55, 0x1e, 0x59, 0x51, 0x36, 0xf2, 0xf9, 0xd1, 0x97, 0xfb, 0x66, 0x12,
	0x84, 0x5d, 0xed, 0xb8, 0x9b, 0x2d, 0x3e, 0x2b, 0x8c, 0xeb, 0x2a, 0x72,
	0x40, 0x9d, 0x55, 0x4c, 0xed, 0xeb, 0x55, 0x02, 0xff, 0x8c, 0xb0, 0x2e,
	0x03, 0x65, 0x3f, 0x41, 0xb1, 0xac, 0xa3, 0x30, 0x6b, 0xff, 0x6d, 0xf4,
	0x6d, 0xe6, 0xe1, 0x0f, 0x86, 0x7c, 0x43, 0x64
};

static const uint8_t derive_key_dh_shared_secret[] = {
	0x4e, 0x6a, 0xcf, 0xfd, 0x7d, 0x14, 0x27, 0x65, 0xeb, 0xf4, 0xc7, 0x12,
	0x41, 0x4f, 0xe4, 0xb6, 0xab, 0x95, 0x7f, 0x4c, 0xb4, 0x66, 0xb4, 0x66,
	0x01, 0x28, 0x9b, 0xb8, 0x20, 0x60, 0x42, 0x82, 0x72, 0x84, 0x2e, 0xe2,
	0x8f, 0x11, 0x3c, 0xd1, 0x1f, 0x39, 0x43, 0x1c, 0xbf, 0xfd, 0x82, 0x32,
	0x54, 0xce, 0x47, 0x2e, 0x21, 0x05, 0xe4, 0x9b, 0x3d, 0x7f, 0x11, 0x3b,
	0x82, 0x50, 0x76, 0xe6, 0x26, 0x45, 0x85, 0x80, 0x7b, 0xc4, 0x64, 0x54,
	0x66, 0x5f, 0x27, 0xc5, 0xe4, 0xe1, 0xa4, 0xbd, 0x03, 0x47, 0x04, 0x86,
	0x32, 0x29, 0x81, 0xfd, 0xc8, 0x94, 0xcc, 0xa1, 0xe2, 0x93, 0x09, 0x87,
	0xc9, 0x2c, 0x15, 0xa3, 0x8b, 0xc4, 0x2e, 0xb3, 0x88, 0x10, 0xe8, 0x67,
	0xc4, 0x43, 0x2f, 0x07, 0x25, 0x9e, 0xc0, 0x0c, 0xdb, 0xbb, 0x0f, 0xb9,
	0x9e, 0x17, 0x27, 0xc7, 0x06, 0xda, 0x58, 0xdd
};

static const uint32_t derive_key_max_keysize = 1024;

static struct derive_key_ecdh_t {
	uint32_t level;		/* test suite level */
	uint32_t algo;		/* TEE_ALG_ECDH_DERIVE_SHARED_SECRET */
	uint32_t curve;		/* TEE_ECC_CURVE_NIST_P192,... */
	uint32_t keysize;	/* key size, in bits */
	const uint8_t *public_x;	/* public key - x == QCAVSx */
	const uint8_t *public_y;	/* public key - y == QCAVSy */
	const uint8_t *private;	/* private key == dIUT */
	const uint8_t *out;		/* expected result - ZIUT */
} const derive_key_ecdh[] = {
	/* [P-192] */
	{
		.level    = 0,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_1_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_1_public_y,
		.private  = nist_kas_ecc_cdh_testvector_1_private,
		.out      = nist_kas_ecc_cdh_testvector_1_out,
	},
	{
		.level    = 1,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_2_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_2_public_y,
		.private  = nist_kas_ecc_cdh_testvector_2_private,
		.out      = nist_kas_ecc_cdh_testvector_2_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_3_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_3_public_y,
		.private  = nist_kas_ecc_cdh_testvector_3_private,
		.out      = nist_kas_ecc_cdh_testvector_3_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_4_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_4_public_y,
		.private  = nist_kas_ecc_cdh_testvector_4_private,
		.out      = nist_kas_ecc_cdh_testvector_4_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_5_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_5_public_y,
		.private  = nist_kas_ecc_cdh_testvector_5_private,
		.out      = nist_kas_ecc_cdh_testvector_5_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_6_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_6_public_y,
		.private  = nist_kas_ecc_cdh_testvector_6_private,
		.out      = nist_kas_ecc_cdh_testvector_6_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_7_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_7_public_y,
		.private  = nist_kas_ecc_cdh_testvector_7_private,
		.out      = nist_kas_ecc_cdh_testvector_7_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_8_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_8_public_y,
		.private  = nist_kas_ecc_cdh_testvector_8_private,
		.out      = nist_kas_ecc_cdh_testvector_8_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_9_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_9_public_y,
		.private  = nist_kas_ecc_cdh_testvector_9_private,
		.out      = nist_kas_ecc_cdh_testvector_9_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_10_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_10_public_y,
		.private  = nist_kas_ecc_cdh_testvector_10_private,
		.out      = nist_kas_ecc_cdh_testvector_10_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_11_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_11_public_y,
		.private  = nist_kas_ecc_cdh_testvector_11_private,
		.out      = nist_kas_ecc_cdh_testvector_11_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_12_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_12_public_y,
		.private  = nist_kas_ecc_cdh_testvector_12_private,
		.out      = nist_kas_ecc_cdh_testvector_12_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_13_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_13_public_y,
		.private  = nist_kas_ecc_cdh_testvector_13_private,
		.out      = nist_kas_ecc_cdh_testvector_13_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_14_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_14_public_y,
		.private  = nist_kas_ecc_cdh_testvector_14_private,
		.out      = nist_kas_ecc_cdh_testvector_14_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_15_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_15_public_y,
		.private  = nist_kas_ecc_cdh_testvector_15_private,
		.out      = nist_kas_ecc_cdh_testvector_15_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_16_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_16_public_y,
		.private  = nist_kas_ecc_cdh_testvector_16_private,
		.out      = nist_kas_ecc_cdh_testvector_16_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_17_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_17_public_y,
		.private  = nist_kas_ecc_cdh_testvector_17_private,
		.out      = nist_kas_ecc_cdh_testvector_17_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_18_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_18_public_y,
		.private  = nist_kas_ecc_cdh_testvector_18_private,
		.out      = nist_kas_ecc_cdh_testvector_18_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_19_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_19_public_y,
		.private  = nist_kas_ecc_cdh_testvector_19_private,
		.out      = nist_kas_ecc_cdh_testvector_19_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_20_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_20_public_y,
		.private  = nist_kas_ecc_cdh_testvector_20_private,
		.out      = nist_kas_ecc_cdh_testvector_20_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_21_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_21_public_y,
		.private  = nist_kas_ecc_cdh_testvector_21_private,
		.out      = nist_kas_ecc_cdh_testvector_21_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_22_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_22_public_y,
		.private  = nist_kas_ecc_cdh_testvector_22_private,
		.out      = nist_kas_ecc_cdh_testvector_22_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_23_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_23_public_y,
		.private  = nist_kas_ecc_cdh_testvector_23_private,
		.out      = nist_kas_ecc_cdh_testvector_23_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_24_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_24_public_y,
		.private  = nist_kas_ecc_cdh_testvector_24_private,
		.out      = nist_kas_ecc_cdh_testvector_24_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P192,
		.keysize  = 192,
		.public_x = nist_kas_ecc_cdh_testvector_25_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_25_public_y,
		.private  = nist_kas_ecc_cdh_testvector_25_private,
		.out      = nist_kas_ecc_cdh_testvector_25_out,
	},
	/* [P-224] */
	{
		.level    = 0,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_26_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_26_public_y,
		.private  = nist_kas_ecc_cdh_testvector_26_private,
		.out      = nist_kas_ecc_cdh_testvector_26_out,
	},
	{
		.level    = 1,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_27_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_27_public_y,
		.private  = nist_kas_ecc_cdh_testvector_27_private,
		.out      = nist_kas_ecc_cdh_testvector_27_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_28_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_28_public_y,
		.private  = nist_kas_ecc_cdh_testvector_28_private,
		.out      = nist_kas_ecc_cdh_testvector_28_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_29_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_29_public_y,
		.private  = nist_kas_ecc_cdh_testvector_29_private,
		.out      = nist_kas_ecc_cdh_testvector_29_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_30_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_30_public_y,
		.private  = nist_kas_ecc_cdh_testvector_30_private,
		.out      = nist_kas_ecc_cdh_testvector_30_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_31_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_31_public_y,
		.private  = nist_kas_ecc_cdh_testvector_31_private,
		.out      = nist_kas_ecc_cdh_testvector_31_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_32_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_32_public_y,
		.private  = nist_kas_ecc_cdh_testvector_32_private,
		.out      = nist_kas_ecc_cdh_testvector_32_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_33_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_33_public_y,
		.private  = nist_kas_ecc_cdh_testvector_33_private,
		.out      = nist_kas_ecc_cdh_testvector_33_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_34_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_34_public_y,
		.private  = nist_kas_ecc_cdh_testvector_34_private,
		.out      = nist_kas_ecc_cdh_testvector_34_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_35_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_35_public_y,
		.private  = nist_kas_ecc_cdh_testvector_35_private,
		.out      = nist_kas_ecc_cdh_testvector_35_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_36_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_36_public_y,
		.private  = nist_kas_ecc_cdh_testvector_36_private,
		.out      = nist_kas_ecc_cdh_testvector_36_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_37_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_37_public_y,
		.private  = nist_kas_ecc_cdh_testvector_37_private,
		.out      = nist_kas_ecc_cdh_testvector_37_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_38_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_38_public_y,
		.private  = nist_kas_ecc_cdh_testvector_38_private,
		.out      = nist_kas_ecc_cdh_testvector_38_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_39_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_39_public_y,
		.private  = nist_kas_ecc_cdh_testvector_39_private,
		.out      = nist_kas_ecc_cdh_testvector_39_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_40_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_40_public_y,
		.private  = nist_kas_ecc_cdh_testvector_40_private,
		.out      = nist_kas_ecc_cdh_testvector_40_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_41_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_41_public_y,
		.private  = nist_kas_ecc_cdh_testvector_41_private,
		.out      = nist_kas_ecc_cdh_testvector_41_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_42_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_42_public_y,
		.private  = nist_kas_ecc_cdh_testvector_42_private,
		.out      = nist_kas_ecc_cdh_testvector_42_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_43_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_43_public_y,
		.private  = nist_kas_ecc_cdh_testvector_43_private,
		.out      = nist_kas_ecc_cdh_testvector_43_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_44_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_44_public_y,
		.private  = nist_kas_ecc_cdh_testvector_44_private,
		.out      = nist_kas_ecc_cdh_testvector_44_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_45_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_45_public_y,
		.private  = nist_kas_ecc_cdh_testvector_45_private,
		.out      = nist_kas_ecc_cdh_testvector_45_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_46_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_46_public_y,
		.private  = nist_kas_ecc_cdh_testvector_46_private,
		.out      = nist_kas_ecc_cdh_testvector_46_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_47_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_47_public_y,
		.private  = nist_kas_ecc_cdh_testvector_47_private,
		.out      = nist_kas_ecc_cdh_testvector_47_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_48_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_48_public_y,
		.private  = nist_kas_ecc_cdh_testvector_48_private,
		.out      = nist_kas_ecc_cdh_testvector_48_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_49_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_49_public_y,
		.private  = nist_kas_ecc_cdh_testvector_49_private,
		.out      = nist_kas_ecc_cdh_testvector_49_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P224,
		.keysize  = 224,
		.public_x = nist_kas_ecc_cdh_testvector_50_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_50_public_y,
		.private  = nist_kas_ecc_cdh_testvector_50_private,
		.out      = nist_kas_ecc_cdh_testvector_50_out,
	},
	/* [P-256] */
	{
		.level    = 0,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_51_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_51_public_y,
		.private  = nist_kas_ecc_cdh_testvector_51_private,
		.out      = nist_kas_ecc_cdh_testvector_51_out,
	},
	{
		.level    = 1,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_52_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_52_public_y,
		.private  = nist_kas_ecc_cdh_testvector_52_private,
		.out      = nist_kas_ecc_cdh_testvector_52_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_53_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_53_public_y,
		.private  = nist_kas_ecc_cdh_testvector_53_private,
		.out      = nist_kas_ecc_cdh_testvector_53_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_54_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_54_public_y,
		.private  = nist_kas_ecc_cdh_testvector_54_private,
		.out      = nist_kas_ecc_cdh_testvector_54_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_55_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_55_public_y,
		.private  = nist_kas_ecc_cdh_testvector_55_private,
		.out      = nist_kas_ecc_cdh_testvector_55_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_56_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_56_public_y,
		.private  = nist_kas_ecc_cdh_testvector_56_private,
		.out      = nist_kas_ecc_cdh_testvector_56_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_57_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_57_public_y,
		.private  = nist_kas_ecc_cdh_testvector_57_private,
		.out      = nist_kas_ecc_cdh_testvector_57_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_58_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_58_public_y,
		.private  = nist_kas_ecc_cdh_testvector_58_private,
		.out      = nist_kas_ecc_cdh_testvector_58_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_59_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_59_public_y,
		.private  = nist_kas_ecc_cdh_testvector_59_private,
		.out      = nist_kas_ecc_cdh_testvector_59_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_60_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_60_public_y,
		.private  = nist_kas_ecc_cdh_testvector_60_private,
		.out      = nist_kas_ecc_cdh_testvector_60_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_61_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_61_public_y,
		.private  = nist_kas_ecc_cdh_testvector_61_private,
		.out      = nist_kas_ecc_cdh_testvector_61_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_62_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_62_public_y,
		.private  = nist_kas_ecc_cdh_testvector_62_private,
		.out      = nist_kas_ecc_cdh_testvector_62_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_63_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_63_public_y,
		.private  = nist_kas_ecc_cdh_testvector_63_private,
		.out      = nist_kas_ecc_cdh_testvector_63_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_64_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_64_public_y,
		.private  = nist_kas_ecc_cdh_testvector_64_private,
		.out      = nist_kas_ecc_cdh_testvector_64_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_65_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_65_public_y,
		.private  = nist_kas_ecc_cdh_testvector_65_private,
		.out      = nist_kas_ecc_cdh_testvector_65_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_66_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_66_public_y,
		.private  = nist_kas_ecc_cdh_testvector_66_private,
		.out      = nist_kas_ecc_cdh_testvector_66_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_67_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_67_public_y,
		.private  = nist_kas_ecc_cdh_testvector_67_private,
		.out      = nist_kas_ecc_cdh_testvector_67_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_68_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_68_public_y,
		.private  = nist_kas_ecc_cdh_testvector_68_private,
		.out      = nist_kas_ecc_cdh_testvector_68_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_69_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_69_public_y,
		.private  = nist_kas_ecc_cdh_testvector_69_private,
		.out      = nist_kas_ecc_cdh_testvector_69_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_70_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_70_public_y,
		.private  = nist_kas_ecc_cdh_testvector_70_private,
		.out      = nist_kas_ecc_cdh_testvector_70_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_71_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_71_public_y,
		.private  = nist_kas_ecc_cdh_testvector_71_private,
		.out      = nist_kas_ecc_cdh_testvector_71_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_72_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_72_public_y,
		.private  = nist_kas_ecc_cdh_testvector_72_private,
		.out      = nist_kas_ecc_cdh_testvector_72_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_73_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_73_public_y,
		.private  = nist_kas_ecc_cdh_testvector_73_private,
		.out      = nist_kas_ecc_cdh_testvector_73_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_74_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_74_public_y,
		.private  = nist_kas_ecc_cdh_testvector_74_private,
		.out      = nist_kas_ecc_cdh_testvector_74_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P256,
		.keysize  = 256,
		.public_x = nist_kas_ecc_cdh_testvector_75_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_75_public_y,
		.private  = nist_kas_ecc_cdh_testvector_75_private,
		.out      = nist_kas_ecc_cdh_testvector_75_out,
	},
	/* [P-384] */
	{
		.level    = 0,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_76_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_76_public_y,
		.private  = nist_kas_ecc_cdh_testvector_76_private,
		.out      = nist_kas_ecc_cdh_testvector_76_out,
	},
	{
		.level    = 1,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_77_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_77_public_y,
		.private  = nist_kas_ecc_cdh_testvector_77_private,
		.out      = nist_kas_ecc_cdh_testvector_77_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_78_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_78_public_y,
		.private  = nist_kas_ecc_cdh_testvector_78_private,
		.out      = nist_kas_ecc_cdh_testvector_78_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_79_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_79_public_y,
		.private  = nist_kas_ecc_cdh_testvector_79_private,
		.out      = nist_kas_ecc_cdh_testvector_79_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_80_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_80_public_y,
		.private  = nist_kas_ecc_cdh_testvector_80_private,
		.out      = nist_kas_ecc_cdh_testvector_80_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_81_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_81_public_y,
		.private  = nist_kas_ecc_cdh_testvector_81_private,
		.out      = nist_kas_ecc_cdh_testvector_81_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_82_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_82_public_y,
		.private  = nist_kas_ecc_cdh_testvector_82_private,
		.out      = nist_kas_ecc_cdh_testvector_82_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_83_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_83_public_y,
		.private  = nist_kas_ecc_cdh_testvector_83_private,
		.out      = nist_kas_ecc_cdh_testvector_83_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_84_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_84_public_y,
		.private  = nist_kas_ecc_cdh_testvector_84_private,
		.out      = nist_kas_ecc_cdh_testvector_84_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_85_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_85_public_y,
		.private  = nist_kas_ecc_cdh_testvector_85_private,
		.out      = nist_kas_ecc_cdh_testvector_85_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_86_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_86_public_y,
		.private  = nist_kas_ecc_cdh_testvector_86_private,
		.out      = nist_kas_ecc_cdh_testvector_86_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_87_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_87_public_y,
		.private  = nist_kas_ecc_cdh_testvector_87_private,
		.out      = nist_kas_ecc_cdh_testvector_87_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_88_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_88_public_y,
		.private  = nist_kas_ecc_cdh_testvector_88_private,
		.out      = nist_kas_ecc_cdh_testvector_88_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_89_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_89_public_y,
		.private  = nist_kas_ecc_cdh_testvector_89_private,
		.out      = nist_kas_ecc_cdh_testvector_89_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_90_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_90_public_y,
		.private  = nist_kas_ecc_cdh_testvector_90_private,
		.out      = nist_kas_ecc_cdh_testvector_90_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_91_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_91_public_y,
		.private  = nist_kas_ecc_cdh_testvector_91_private,
		.out      = nist_kas_ecc_cdh_testvector_91_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_92_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_92_public_y,
		.private  = nist_kas_ecc_cdh_testvector_92_private,
		.out      = nist_kas_ecc_cdh_testvector_92_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_93_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_93_public_y,
		.private  = nist_kas_ecc_cdh_testvector_93_private,
		.out      = nist_kas_ecc_cdh_testvector_93_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_94_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_94_public_y,
		.private  = nist_kas_ecc_cdh_testvector_94_private,
		.out      = nist_kas_ecc_cdh_testvector_94_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_95_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_95_public_y,
		.private  = nist_kas_ecc_cdh_testvector_95_private,
		.out      = nist_kas_ecc_cdh_testvector_95_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_96_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_96_public_y,
		.private  = nist_kas_ecc_cdh_testvector_96_private,
		.out      = nist_kas_ecc_cdh_testvector_96_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_97_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_97_public_y,
		.private  = nist_kas_ecc_cdh_testvector_97_private,
		.out      = nist_kas_ecc_cdh_testvector_97_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_98_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_98_public_y,
		.private  = nist_kas_ecc_cdh_testvector_98_private,
		.out      = nist_kas_ecc_cdh_testvector_98_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_99_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_99_public_y,
		.private  = nist_kas_ecc_cdh_testvector_99_private,
		.out      = nist_kas_ecc_cdh_testvector_99_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P384,
		.keysize  = 384,
		.public_x = nist_kas_ecc_cdh_testvector_100_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_100_public_y,
		.private  = nist_kas_ecc_cdh_testvector_100_private,
		.out      = nist_kas_ecc_cdh_testvector_100_out,
	},
	/* [P-521] */
	{
		.level    = 0,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_101_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_101_public_y,
		.private  = nist_kas_ecc_cdh_testvector_101_private,
		.out      = nist_kas_ecc_cdh_testvector_101_out,
	},
	{
		.level    = 1,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_102_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_102_public_y,
		.private  = nist_kas_ecc_cdh_testvector_102_private,
		.out      = nist_kas_ecc_cdh_testvector_102_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_103_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_103_public_y,
		.private  = nist_kas_ecc_cdh_testvector_103_private,
		.out      = nist_kas_ecc_cdh_testvector_103_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_104_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_104_public_y,
		.private  = nist_kas_ecc_cdh_testvector_104_private,
		.out      = nist_kas_ecc_cdh_testvector_104_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_105_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_105_public_y,
		.private  = nist_kas_ecc_cdh_testvector_105_private,
		.out      = nist_kas_ecc_cdh_testvector_105_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_106_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_106_public_y,
		.private  = nist_kas_ecc_cdh_testvector_106_private,
		.out      = nist_kas_ecc_cdh_testvector_106_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_107_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_107_public_y,
		.private  = nist_kas_ecc_cdh_testvector_107_private,
		.out      = nist_kas_ecc_cdh_testvector_107_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_108_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_108_public_y,
		.private  = nist_kas_ecc_cdh_testvector_108_private,
		.out      = nist_kas_ecc_cdh_testvector_108_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_109_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_109_public_y,
		.private  = nist_kas_ecc_cdh_testvector_109_private,
		.out      = nist_kas_ecc_cdh_testvector_109_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_110_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_110_public_y,
		.private  = nist_kas_ecc_cdh_testvector_110_private,
		.out      = nist_kas_ecc_cdh_testvector_110_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_111_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_111_public_y,
		.private  = nist_kas_ecc_cdh_testvector_111_private,
		.out      = nist_kas_ecc_cdh_testvector_111_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_112_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_112_public_y,
		.private  = nist_kas_ecc_cdh_testvector_112_private,
		.out      = nist_kas_ecc_cdh_testvector_112_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_113_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_113_public_y,
		.private  = nist_kas_ecc_cdh_testvector_113_private,
		.out      = nist_kas_ecc_cdh_testvector_113_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_114_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_114_public_y,
		.private  = nist_kas_ecc_cdh_testvector_114_private,
		.out      = nist_kas_ecc_cdh_testvector_114_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_115_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_115_public_y,
		.private  = nist_kas_ecc_cdh_testvector_115_private,
		.out      = nist_kas_ecc_cdh_testvector_115_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_116_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_116_public_y,
		.private  = nist_kas_ecc_cdh_testvector_116_private,
		.out      = nist_kas_ecc_cdh_testvector_116_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_117_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_117_public_y,
		.private  = nist_kas_ecc_cdh_testvector_117_private,
		.out      = nist_kas_ecc_cdh_testvector_117_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_118_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_118_public_y,
		.private  = nist_kas_ecc_cdh_testvector_118_private,
		.out      = nist_kas_ecc_cdh_testvector_118_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_119_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_119_public_y,
		.private  = nist_kas_ecc_cdh_testvector_119_private,
		.out      = nist_kas_ecc_cdh_testvector_119_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_120_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_120_public_y,
		.private  = nist_kas_ecc_cdh_testvector_120_private,
		.out      = nist_kas_ecc_cdh_testvector_120_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_121_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_121_public_y,
		.private  = nist_kas_ecc_cdh_testvector_121_private,
		.out      = nist_kas_ecc_cdh_testvector_121_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_122_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_122_public_y,
		.private  = nist_kas_ecc_cdh_testvector_122_private,
		.out      = nist_kas_ecc_cdh_testvector_122_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_123_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_123_public_y,
		.private  = nist_kas_ecc_cdh_testvector_123_private,
		.out      = nist_kas_ecc_cdh_testvector_123_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_124_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_124_public_y,
		.private  = nist_kas_ecc_cdh_testvector_124_private,
		.out      = nist_kas_ecc_cdh_testvector_124_out,
	},
	{
		.level    = 15,
		.algo     = TEE_ALG_ECDH_DERIVE_SHARED_SECRET,
		.curve    = TEE_ECC_CURVE_NIST_P521,
		.keysize  = 521,
		.public_x = nist_kas_ecc_cdh_testvector_125_public_x,
		.public_y = nist_kas_ecc_cdh_testvector_125_public_y,
		.private  = nist_kas_ecc_cdh_testvector_125_private,
		.out      = nist_kas_ecc_cdh_testvector_125_out,
	},
	/* [K-163] - GP NOT SUPPORTED */
	/* [K-233] - GP NOT SUPPORTED */
	/* [K-283] - GP NOT SUPPORTED */
	/* [K-409] - GP NOT SUPPORTED */
	/* [K-571] - GP NOT SUPPORTED */
	/* [B-163] - GP NOT SUPPORTED */
	/* [B-233] - GP NOT SUPPORTED */
	/* [B-283] - GP NOT SUPPORTED */
	/* [B-409] - GP NOT SUPPORTED */
	/* [B-571] - GP NOT SUPPORTED */
};

/* G/MT 0003 (SM2) Part 5 Annex C.2 - encryption/decryption */
#if __has_attribute(nonstring)
__attribute__((nonstring))
#endif
static const uint8_t gmt_0003_part5_c2_sm2_testvector_ptx[19] =
/* M */
	"encryption standard";
static const uint8_t gmt_0003_part5_c2_sm2_testvector_private[] = {
/* dB */
	0x39, 0x45, 0x20, 0x8F, 0x7B, 0x21, 0x44, 0xB1, 0x3F, 0x36, 0xE3, 0x8A,
	0xC6, 0xD3, 0x9F, 0x95, 0x88, 0x93, 0x93, 0x69, 0x28, 0x60, 0xB5, 0x1A,
	0x42, 0xFB, 0x81, 0xEF, 0x4D, 0xF7, 0xC5, 0xB8
};
static const uint8_t gmt_0003_part5_c2_sm2_testvector_public_x[] = {
/* xB */
	0x09, 0xF9, 0xDF, 0x31, 0x1E, 0x54, 0x21, 0xA1, 0x50, 0xDD, 0x7D, 0x16,
	0x1E, 0x4B, 0xC5, 0xC6, 0x72, 0x17, 0x9F, 0xAD, 0x18, 0x33, 0xFC, 0x07,
	0x6B, 0xB0, 0x8F, 0xF3, 0x56, 0xF3, 0x50, 0x20
};
static const uint8_t gmt_0003_part5_c2_sm2_testvector_public_y[] = {
/* yB */
	0xCC, 0xEA, 0x49, 0x0C, 0xE2, 0x67, 0x75, 0xA5, 0x2D, 0xC6, 0xEA, 0x71,
	0x8C, 0xC1, 0xAA, 0x60, 0x0A, 0xED, 0x05, 0xFB, 0xF3, 0x5E, 0x08, 0x4A,
	0x66, 0x32, 0xF6, 0x07, 0x2D, 0xA9, 0xAD, 0x13
};
static const uint8_t gmt_0003_part5_c2_sm2_testvector_out[] = {
/* C */
	/* C1 */
	0x04,
	0x04, 0xEB, 0xFC, 0x71, 0x8E, 0x8D, 0x17, 0x98, 0x62, 0x04, 0x32, 0x26,
	0x8E, 0x77, 0xFE, 0xB6, 0x41, 0x5E, 0x2E, 0xDE, 0x0E, 0x07, 0x3C, 0x0F,
	0x4F, 0x64, 0x0E, 0xCD, 0x2E, 0x14, 0x9A, 0x73, 0xE8, 0x58, 0xF9, 0xD8,
	0x1E, 0x54, 0x30, 0xA5, 0x7B, 0x36, 0xDA, 0xAB, 0x8F, 0x95, 0x0A, 0x3C,
	0x64, 0xE6, 0xEE, 0x6A, 0x63, 0x09, 0x4D, 0x99, 0x28, 0x3A, 0xFF, 0x76,
	0x7E, 0x12, 0x4D, 0xF0,
	/* C2 */
	0x21, 0x88, 0x6C, 0xA9, 0x89, 0xCA, 0x9C, 0x7D, 0x58, 0x08, 0x73, 0x07,
	0xCA, 0x93, 0x09, 0x2D, 0x65, 0x1E, 0xFA,
	/* C3 */
	0x59, 0x98, 0x3C, 0x18, 0xF8, 0x09, 0xE2, 0x62, 0x92, 0x3C, 0x53, 0xAE,
	0xC2, 0x95, 0xD3, 0x03, 0x83, 0xB5, 0x4E, 0x39, 0xD6, 0x09, 0xD1, 0x60,
	0xAF, 0xCB, 0x19, 0x08, 0xD0, 0xBD, 0x87, 0x66
};

/* SM2 encryption/decryption */
static const uint8_t sm2_testvector2_ptx[] =
/* M */
	"This test vector is used to test encryption then decryption. The "
	"plain text is longer than 64 characters, so it will exercise parts "
	"of the code that are not used for shorter messages.";
static const uint8_t sm2_testvector2_private[] = {
/* dB */
	0x39, 0x45, 0x20, 0x8F, 0x7B, 0x21, 0x44, 0xB1, 0x3F, 0x36, 0xE3, 0x8A,
	0xC6, 0xD3, 0x9F, 0x95, 0x88, 0x93, 0x93, 0x69, 0x28, 0x60, 0xB5, 0x1A,
	0x42, 0xFB, 0x81, 0xEF, 0x4D, 0xF7, 0xC5, 0xB8
};
static const uint8_t sm2_testvector2_public_x[] = {
/* xB */
	0x09, 0xF9, 0xDF, 0x31, 0x1E, 0x54, 0x21, 0xA1, 0x50, 0xDD, 0x7D, 0x16,
	0x1E, 0x4B, 0xC5, 0xC6, 0x72, 0x17, 0x9F, 0xAD, 0x18, 0x33, 0xFC, 0x07,
	0x6B, 0xB0, 0x8F, 0xF3, 0x56, 0xF3, 0x50, 0x20
};
static const uint8_t sm2_testvector2_public_y[] = {
/* yB */
	0xCC, 0xEA, 0x49, 0x0C, 0xE2, 0x67, 0x75, 0xA5, 0x2D, 0xC6, 0xEA, 0x71,
	0x8C, 0xC1, 0xAA, 0x60, 0x0A, 0xED, 0x05, 0xFB, 0xF3, 0x5E, 0x08, 0x4A,
	0x66, 0x32, 0xF6, 0x07, 0x2D, 0xA9, 0xAD, 0x13
};
static const uint8_t sm2_testvector2_out[] = {
	0x00, /* Not used -- test runs in encrypt/decrypt mode */
};

/*
 * G/MT 0003 (SM2) Part 5 Annex A.2 - SM2 digital signature based on
 * elliptic curves
 */
static const uint8_t gmt_003_part5_a2_ptx[] = {
	/* ZA = SM3(ENTLA || IDA || a || b || xG || yG || xA || yA) */
	0xB2, 0xE1, 0x4C, 0x5C, 0x79, 0xC6, 0xDF, 0x5B, 0x85, 0xF4, 0xFE, 0x7E,
	0xD8, 0xDB, 0x7A, 0x26, 0x2B, 0x9D, 0xA7, 0xE0, 0x7C, 0xCB, 0x0E, 0xA9,
	0xF4, 0x74, 0x7B, 0x8C, 0xCD, 0xA8, 0xA4, 0xF3,
	/* M */
	0x6D, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74
};
static const uint8_t gmt_003_part5_a2_private[] = {
	/* dA */
	0x39, 0x45, 0x20, 0x8F, 0x7B, 0x21, 0x44, 0xB1, 0x3F, 0x36, 0xE3, 0x8A,
	0xC6, 0xD3, 0x9F, 0x95, 0x88, 0x93, 0x93, 0x69, 0x28, 0x60, 0xB5, 0x1A,
	0x42, 0xFB, 0x81, 0xEF, 0x4D, 0xF7, 0xC5, 0xB8,
};
static const uint8_t gmt_003_part5_a2_public_x[] = {
	/* xA */
	0x09, 0xF9, 0xDF, 0x31, 0x1E, 0x54, 0x21, 0xA1, 0x50, 0xDD, 0x7D, 0x16,
	0x1E, 0x4B, 0xC5, 0xC6, 0x72, 0x17, 0x9F, 0xAD, 0x18, 0x33, 0xFC, 0x07,
	0x6B, 0xB0, 0x8F, 0xF3, 0x56, 0xF3, 0x50, 0x20,
};
static const uint8_t gmt_003_part5_a2_public_y[] = {
	/* yA */
	0xCC, 0xEA, 0x49, 0x0C, 0xE2, 0x67, 0x75, 0xA5, 0x2D, 0xC6, 0xEA, 0x71,
	0x8C, 0xC1, 0xAA, 0x60, 0x0A, 0xED, 0x05, 0xFB, 0xF3, 0x5E, 0x08, 0x4A,
	0x66, 0x32, 0xF6, 0x07, 0x2D, 0xA9, 0xAD, 0x13,
};
static const uint8_t gmt_003_part5_a2_out[] = {
	/* r */
	0xF5, 0xA0, 0x3B, 0x06, 0x48, 0xD2, 0xC4, 0x63, 0x0E, 0xEA, 0xC5, 0x13,
	0xE1, 0xBB, 0x81, 0xA1, 0x59, 0x44, 0xDA, 0x38, 0x27, 0xD5, 0xB7, 0x41,
	0x43, 0xAC, 0x7E, 0xAC, 0xEE, 0xE7, 0x20, 0xB3,
	/* s */
	0xB1, 0xB6, 0xAA, 0x29, 0xDF, 0x21, 0x2F, 0xD8, 0x76, 0x31, 0x82, 0xBC,
	0x0D, 0x42, 0x1C, 0xA1, 0xBB, 0x90, 0x38, 0xFD, 0x1F, 0x7F, 0x42, 0xD4,
	0x84, 0x0B, 0x69, 0xC4, 0x85, 0xBB, 0xC1, 0xAA,
};

/*
 * G/MT 0003 (SM2) Part 5 Annex B.2 - key exchange protocol based on elliptic
 * curves
 */
static const uint8_t gmt_003_part5_b2_private_A[] = {
	/* dA */
	0x81, 0xEB, 0x26, 0xE9, 0x41, 0xBB, 0x5A, 0xF1, 0x6D, 0xF1, 0x16, 0x49,
	0x5F, 0x90, 0x69, 0x52, 0x72, 0xAE, 0x2C, 0xD6, 0x3D, 0x6C, 0x4A, 0xE1,
	0x67, 0x84, 0x18, 0xBE, 0x48, 0x23, 0x00, 0x29,
};
static const uint8_t gmt_003_part5_b2_public_xA[] = {
	/* xA */
	0x16, 0x0E, 0x12, 0x89, 0x7D, 0xF4, 0xED, 0xB6, 0x1D, 0xD8, 0x12, 0xFE,
	0xB9, 0x67, 0x48, 0xFB, 0xD3, 0xCC, 0xF4, 0xFF, 0xE2, 0x6A, 0xA6, 0xF6,
	0xDB, 0x95, 0x40, 0xAF, 0x49, 0xC9, 0x42, 0x32,
};
static const uint8_t gmt_003_part5_b2_public_yA[] = {
	/* xA */
	0x4A, 0x7D, 0xAD, 0x08, 0xBB, 0x9A, 0x45, 0x95, 0x31, 0x69, 0x4B, 0xEB,
	0x20, 0xAA, 0x48, 0x9D, 0x66, 0x49, 0x97, 0x5E, 0x1B, 0xFC, 0xF8, 0xC4,
	0x74, 0x1B, 0x78, 0xB4, 0xB2, 0x23, 0x00, 0x7F,
};
static const uint8_t gmt_003_part5_b2_eph_private_A[] = {
	/* rA */
	0xD4, 0xDE, 0x15, 0x47, 0x4D, 0xB7, 0x4D, 0x06, 0x49, 0x1C, 0x44, 0x0D,
	0x30, 0x5E, 0x01, 0x24, 0x00, 0x99, 0x0F, 0x3E, 0x39, 0x0C, 0x7E, 0x87,
	0x15, 0x3C, 0x12, 0xDB, 0x2E, 0xA6, 0x0B, 0xB3,
};
static const uint8_t gmt_003_part5_b2_eph_public_xA[] = {
	/* x1 where (x1, y1) = [rA]G */
	0x64, 0xCE, 0xD1, 0xBD, 0xBC, 0x99, 0xD5, 0x90, 0x04, 0x9B, 0x43, 0x4D,
	0x0F, 0xD7, 0x34, 0x28, 0xCF, 0x60, 0x8A, 0x5D, 0xB8, 0xFE, 0x5C, 0xE0,
	0x7F, 0x15, 0x02, 0x69, 0x40, 0xBA, 0xE4, 0x0E,
};
static const uint8_t gmt_003_part5_b2_eph_public_yA[] = {
	/* y1 where (x1, y1) = [rA]G */
	0x37, 0x66, 0x29, 0xC7, 0xAB, 0x21, 0xE7, 0xDB, 0x26, 0x09, 0x22, 0x49,
	0x9D, 0xDB, 0x11, 0x8F, 0x07, 0xCE, 0x8E, 0xAA, 0xE3, 0xE7, 0x72, 0x0A,
	0xFE, 0xF6, 0xA5, 0xCC, 0x06, 0x20, 0x70, 0xC0,
};
static const uint8_t gmt_003_part5_b2_public_xB[] = {
	/* xB */
	0x6A, 0xE8, 0x48, 0xC5, 0x7C, 0x53, 0xC7, 0xB1, 0xB5, 0xFA, 0x99, 0xEB,
	0x22, 0x86, 0xAF, 0x07, 0x8B, 0xA6, 0x4C, 0x64, 0x59, 0x1B, 0x8B, 0x56,
	0x6F, 0x73, 0x57, 0xD5, 0x76, 0xF1, 0x6D, 0xFB,
};
static const uint8_t gmt_003_part5_b2_private_B[] = {
	/* dB */
	0x78, 0x51, 0x29, 0x91, 0x7D, 0x45, 0xA9, 0xEA, 0x54, 0x37, 0xA5, 0x93,
	0x56, 0xB8, 0x23, 0x38, 0xEA, 0xAD, 0xDA, 0x6C, 0xEB, 0x19, 0x90, 0x88,
	0xF1, 0x4A, 0xE1, 0x0D, 0xEF, 0xA2, 0x29, 0xB5,
};
static const uint8_t gmt_003_part5_b2_public_yB[] = {
	/* yB */
	0xEE, 0x48, 0x9D, 0x77, 0x16, 0x21, 0xA2, 0x7B, 0x36, 0xC5, 0xC7, 0x99,
	0x20, 0x62, 0xE9, 0xCD, 0x09, 0xA9, 0x26, 0x43, 0x86, 0xF3, 0xFB, 0xEA,
	0x54, 0xDF, 0xF6, 0x93, 0x05, 0x62, 0x1C, 0x4D,
};
static const uint8_t gmt_003_part5_b2_eph_private_B[] = {
	/* rB */
	0x7E, 0x07, 0x12, 0x48, 0x14, 0xB3, 0x09, 0x48, 0x91, 0x25, 0xEA, 0xED,
	0x10, 0x11, 0x13, 0x16, 0x4E, 0xBF, 0x0F, 0x34, 0x58, 0xC5, 0xBD, 0x88,
	0x33, 0x5C, 0x1F, 0x9D, 0x59, 0x62, 0x43, 0xD6,
};
static const uint8_t gmt_003_part5_b2_eph_public_xB[] = {
	/* x2 where (x2, y2) = [rB]G */
	0xAC, 0xC2, 0x76, 0x88, 0xA6, 0xF7, 0xB7, 0x06, 0x09, 0x8B, 0xC9, 0x1F,
	0xF3, 0xAD, 0x1B, 0xFF, 0x7D, 0xC2, 0x80, 0x2C, 0xDB, 0x14, 0xCC, 0xCC,
	0xDB, 0x0A, 0x90, 0x47, 0x1F, 0x9B, 0xD7, 0x07,
};
static const uint8_t gmt_003_part5_b2_eph_public_yB[] = {
	/* y2 where (x2, y2) = [rB]G */
	0x2F, 0xED, 0xAC, 0x04, 0x94, 0xB2, 0xFF, 0xC4, 0xD6, 0x85, 0x38, 0x76,
	0xC7, 0x9B, 0x8F, 0x30, 0x1C, 0x65, 0x73, 0xAD, 0x0A, 0xA5, 0x0F, 0x39,
	0xFC, 0x87, 0x18, 0x1E, 0x1A, 0x1B, 0x46, 0xFE,
};
static const uint8_t gmt_003_part5_b2_id_A[] = {
	/* IDA */
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x31, 0x32, 0x33, 0x34,
	0x35, 0x36, 0x37, 0x38,
};
static const uint8_t gmt_003_part5_b2_id_B[] = {
	/* IDB */
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x31, 0x32, 0x33, 0x34,
	0x35, 0x36, 0x37, 0x38,
};
static const uint8_t gmt_003_part5_b2_conf_A[] = {
	/* S2 = SA */
	0x18, 0xC7, 0x89, 0x4B, 0x38, 0x16, 0xDF, 0x16, 0xCF, 0x07, 0xB0, 0x5C,
	0x5E, 0xC0, 0xBE, 0xF5, 0xD6, 0x55, 0xD5, 0x8F, 0x77, 0x9C, 0xC1, 0xB4,
	0x00, 0xA4, 0xF3, 0x88, 0x46, 0x44, 0xDB, 0x88,
};
static const uint8_t gmt_003_part5_b2_conf_B[] = {
	/* S1 = SB */
	0xD3, 0xA0, 0xFE, 0x15, 0xDE, 0xE1, 0x85, 0xCE, 0xAE, 0x90, 0x7A, 0x6B,
	0x59, 0x5C, 0xC3, 0x2A, 0x26, 0x6E, 0xD7, 0xB3, 0x36, 0x7E, 0x99, 0x83,
	0xA8, 0x96, 0xDC, 0x32, 0xFA, 0x20, 0xF8, 0xEB,
};
static const uint8_t gmt_003_part5_b2_shared_secret[] = {
	/* KA = KB */
	0x6C, 0x89, 0x34, 0x73, 0x54, 0xDE, 0x24, 0x84, 0xC6, 0x0B, 0x4A, 0xB1,
	0xFD, 0xE4, 0xC6, 0xE5,
};

/* MAC Tests Data and Keys */

static const uint8_t mac_data_md5_key1[10] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_md5_in1[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_md5_out1[] = {
	0x80, 0x07, 0x07, 0x13, 0x46, 0x3e, 0x77, 0x49,
	0xb9, 0x0c, 0x2d, 0xc2, 0x49, 0x11, 0xe2, 0x75
};


/* generated with scripts/digest_hmac.pl */
static const uint8_t mac_data_sha1_key1[10] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_sha1_in1[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_sha1_out1[] = {
	0xDE, 0x7C, 0x9B, 0x85, 0xB8, 0xB7, 0x8A, 0xA6, /* .|...... */
	0xBC, 0x8A, 0x7A, 0x36, 0xF7, 0x0A, 0x90, 0x70, /* ..z6...p */
	0x1C, 0x9D, 0xB4, 0xD9,                         /* .... */
};

static const uint8_t mac_data_sha224_key1[24] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_sha224_in1[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_sha224_out1[] = {
	0x88, 0xFF, 0x8B, 0x54, 0x67, 0x5D, 0x39, 0xB8, /* ...Tg]9. */
	0xF7, 0x23, 0x22, 0xE6, 0x5F, 0xF9, 0x45, 0xC5, /* .#"._.E. */
	0x2D, 0x96, 0x37, 0x99, 0x88, 0xAD, 0xA2, 0x56, /* -.7....V */
	0x39, 0x74, 0x7E, 0x69,                         /* 9t~i */
};


static const uint8_t mac_data_sha256_key1[24] = {
	'Q', 'W', 'E', 'R', 'T', 'Y'
};

static const uint8_t mac_data_sha256_in1[] = { 'a', 'b', 'c' };

static const uint8_t mac_data_sha256_out1[] = {
	0xee, 0x2e, 0x5d, 0x9b, 0x51, 0xe2, 0x9c, 0x1d,
	0x49, 0xe9, 0xae, 0x6f, 0x0a, 0xcc, 0x15, 0x18,
	0xde, 0x1e, 0xa3, 0x88, 0x8e, 0xee, 0x48, 0xbb,
	0x82, 0x77, 0xe9, 0x09, 0x74, 0x4b, 0xa2, 0xf2
};

/* generated with scripts/digest_hmac.pl */
static const uint8_t mac_data_sha256_key2[24] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_sha256_in2[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_sha256_out2[] = {
	0xF7, 0xBC, 0x83, 0xF4, 0x30, 0x53, 0x84, 0x24, /* ....0S.$ */
	0xB1, 0x32, 0x98, 0xE6, 0xAA, 0x6F, 0xB1, 0x43, /* .2...o.C */
	0xEF, 0x4D, 0x59, 0xA1, 0x49, 0x46, 0x17, 0x59, /* .MY.IF.Y */
	0x97, 0x47, 0x9D, 0xBC, 0x2D, 0x1A, 0x3C, 0xD8, /* .G..-.<. */
};

static const uint8_t mac_data_sha384_key1[32] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_sha384_in1[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_sha384_out1[] = {
	0xD7, 0xF4, 0x72, 0x7E, 0x2C, 0x0B, 0x39, 0xAE, /* ..r~, .9. */
	0x0F, 0x1E, 0x40, 0xCC, 0x96, 0xF6, 0x02, 0x42, /* ..@....B */
	0xD5, 0xB7, 0x80, 0x18, 0x41, 0xCE, 0xA6, 0xFC, /* ....A... */
	0x59, 0x2C, 0x5D, 0x3E, 0x1A, 0xE5, 0x07, 0x00, /* Y, ]>.... */
	0x58, 0x2A, 0x96, 0xCF, 0x35, 0xE1, 0xE5, 0x54, /* X...5..T */
	0x99, 0x5F, 0xE4, 0xE0, 0x33, 0x81, 0xC2, 0x37, /* ._..3..7 */
};

static const uint8_t mac_data_sha512_key1[32] = {
	0x6B, 0x65, 0x79, /* key */
};

static const uint8_t mac_data_sha512_in1[] = {
	0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x69, 0x63, /* The quic */
	0x6B, 0x20, 0x62, 0x72, 0x6F, 0x77, 0x6E, 0x20, /* k brown  */
	0x66, 0x6F, 0x78, 0x20, 0x6A, 0x75, 0x6D, 0x70, /* fox jump */
	0x73, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x20, 0x74, /* s over t */
	0x68, 0x65, 0x20, 0x6C, 0x61, 0x7A, 0x79, 0x20, /* he lazy  */
	0x64, 0x6F, 0x67,                               /* dog */
};

static const uint8_t mac_data_sha512_out1[] = {
	0xB4, 0x2A, 0xF0, 0x90, 0x57, 0xBA, 0xC1, 0xE2, /* ....W... */
	0xD4, 0x17, 0x08, 0xE4, 0x8A, 0x90, 0x2E, 0x09, /* ........ */
	0xB5, 0xFF, 0x7F, 0x12, 0xAB, 0x42, 0x8A, 0x4F, /* .....B.O */
	0xE8, 0x66, 0x53, 0xC7, 0x3D, 0xD2, 0x48, 0xFB, /* .fS.=.H. */
	0x82, 0xF9, 0x48, 0xA5, 0x49, 0xF7, 0xB7, 0x91, /* ..H.I... */
	0xA5, 0xB4, 0x19, 0x15, 0xEE, 0x4D, 0x1E, 0xC3, /* .....M.. */
	0x93, 0x53, 0x57, 0xE4, 0xE2, 0x31, 0x72, 0x50, /* .SW..1rP */
	0xD0, 0x37, 0x2A, 0xFA, 0x2E, 0xBE, 0xEB, 0x3A, /* .7.....: */
};

/*
 * First example from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Standards-and-Guidelines/documents/examples/HMAC_SHA3-224.pdf
 */
static const uint8_t mac_data_sha3_224_key1[28] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b,
};
static const uint8_t mac_data_sha3_224_in1[] = {
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x6b, 0x65, 0x79, 0x6c, 0x65,
	0x6e, 0x3c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x6c,
	0x65, 0x6e,
};
static const uint8_t mac_data_sha3_224_out1[] = {
	0x33, 0x2c, 0xfd, 0x59, 0x34, 0x7f, 0xdb, 0x8e,
	0x57, 0x6e, 0x77, 0x26, 0x0b, 0xe4, 0xab, 0xa2,
	0xd6, 0xdc, 0x53, 0x11, 0x7b, 0x3b, 0xfb, 0x52,
	0xc6, 0xd1, 0x8c, 0x04,
};

/*
 * First example from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Standards-and-Guidelines/documents/examples/HMAC_SHA3-256.pdf
 */
static const uint8_t mac_data_sha3_256_key1[32] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};
static const uint8_t mac_data_sha3_256_in1[] = {
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x6b, 0x65, 0x79, 0x6c, 0x65,
	0x6e, 0x3c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x6c,
	0x65, 0x6e,
};
static const uint8_t mac_data_sha3_256_out1[] = {
	0x4f, 0xe8, 0xe2, 0x02, 0xc4, 0xf0, 0x58, 0xe8,
	0xdd, 0xdc, 0x23, 0xd8, 0xc3, 0x4e, 0x46, 0x73,
	0x43, 0xe2, 0x35, 0x55, 0xe2, 0x4f, 0xc2, 0xf0,
	0x25, 0xd5, 0x98, 0xf5, 0x58, 0xf6, 0x72, 0x05,
};

/*
 * First example from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Standards-and-Guidelines/documents/examples/HMAC_SHA3-384.pdf
 */
static const uint8_t mac_data_sha3_384_key1[48] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
};
static const uint8_t mac_data_sha3_384_in1[] = {
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x6b, 0x65, 0x79, 0x6c, 0x65,
	0x6e, 0x3c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x6c,
	0x65, 0x6e,
};
static const uint8_t mac_data_sha3_384_out1[] = {
	0xd5, 0x88, 0xa3, 0xc5, 0x1f, 0x3f, 0x2d, 0x90,
	0x6e, 0x82, 0x98, 0xc1, 0x19, 0x9a, 0xa8, 0xff,
	0x62, 0x96, 0x21, 0x81, 0x27, 0xf6, 0xb3, 0x8a,
	0x90, 0xb6, 0xaf, 0xe2, 0xc5, 0x61, 0x77, 0x25,
	0xbc, 0x99, 0x98, 0x7f, 0x79, 0xb2, 0x2a, 0x55,
	0x7b, 0x65, 0x20, 0xdb, 0x71, 0x0b, 0x7f, 0x42,
};

/*
 * First example from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Standards-and-Guidelines/documents/examples/HMAC_SHA3-512.pdf
 */
static const uint8_t mac_data_sha3_512_key1[64] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
};
static const uint8_t mac_data_sha3_512_in1[] = {
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x6b, 0x65, 0x79, 0x6c, 0x65,
	0x6e, 0x3c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x6c,
	0x65, 0x6e,
};
static const uint8_t mac_data_sha3_512_out1[] = {
	0x4e, 0xfd, 0x62, 0x9d, 0x6c, 0x71, 0xbf, 0x86,
	0x16, 0x26, 0x58, 0xf2, 0x99, 0x43, 0xb1, 0xc3,
	0x08, 0xce, 0x27, 0xcd, 0xfa, 0x6d, 0xb0, 0xd9,
	0xc3, 0xce, 0x81, 0x76, 0x3f, 0x9c, 0xbc, 0xe5,
	0xf7, 0xeb, 0xe9, 0x86, 0x80, 0x31, 0xdb, 0x1a,
	0x8f, 0x8e, 0xb7, 0xb6, 0xb9, 0x5e, 0x5c, 0x5e,
	0x3f, 0x65, 0x7a, 0x89, 0x96, 0xc8, 0x6a, 0x2f,
	0x65, 0x27, 0xe3, 0x07, 0xf0, 0x21, 0x31, 0x96,
};

/*
 * SM3 HMAC
 * GM/T 0042-2015
 * Section D.3 Test vector 1
 */
#if __has_attribute(nonstring)
__attribute__((nonstring))
#endif
static const uint8_t mac_data_sm3_d31_in[112] =
	"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomn"
	"opnopqabcdbcdecdefdefgefghfghighijhijkijkljklmklmn"
	"lmnomnopnopq";

static const uint8_t mac_data_sm3_d31_key[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
	0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
	0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
	0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20,
};

static const uint8_t mac_data_sm3_d31_out[] = {
	0xca, 0x05, 0xe1, 0x44, 0xed, 0x05, 0xd1, 0x85,
	0x78, 0x40, 0xd1, 0xf3, 0x18, 0xa4, 0xa8, 0x66,
	0x9e, 0x55, 0x9f, 0xc8, 0x39, 0x1f, 0x41, 0x44,
	0x85, 0xbf, 0xdf, 0x7b, 0xb4, 0x08, 0x96, 0x3a,
};

/*
 * SM3 HMAC
 * GM/T 0042-2015
 * Section D.3 Test vector 2
 */
static const uint8_t mac_data_sm3_d32_in[] = {
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
	0xcd, 0xcd
};

static const uint8_t mac_data_sm3_d32_key[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
	0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
	0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
	0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x25,
};

static const uint8_t mac_data_sm3_d32_out[] = {
	0x22, 0x0b, 0xf5, 0x79, 0xde, 0xd5, 0x55, 0x39,
	0x3f, 0x01, 0x59, 0xf6, 0x6c, 0x99, 0x87, 0x78,
	0x22, 0xa3, 0xec, 0xf6, 0x10, 0xd1, 0x55, 0x21,
	0x54, 0xb4, 0x1d, 0x44, 0xb9, 0x4d, 0xb3, 0xae,
};

/* AES-CBC-MAC */
static const uint8_t mac_cbc_vect1_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
};

static const uint8_t mac_cbc_vect1_data[] = {
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x20, 0x62, /* Cipher b */
	0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x63, 0x68, 0x61, /* lock cha */
	0x69, 0x6E, 0x69, 0x6E, 0x67, 0x20, 0x28, 0x43, /* ining (C */
	0x42, 0x43, 0x29, 0x20, 0x69, 0x73, 0x20, 0x61, /* BC) is a */
	0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F, 0x6E, 0x20, /*  common  */
	0x63, 0x68, 0x61, 0x69, 0x6E, 0x69, 0x6E, 0x67, /* chaining */
	0x20, 0x6D, 0x6F, 0x64, 0x65, 0x20, 0x69, 0x6E, /*  mode in */
	0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, /*  which t */
	0x68, 0x65, 0x20, 0x70, 0x72, 0x65, 0x76, 0x69, /* he previ */
	0x6F, 0x75, 0x73, 0x20, 0x62, 0x6C, 0x6F, 0x63, /* ous bloc */
	0x6B, 0x27, 0x73, 0x20, 0x63, 0x69, 0x70, 0x68, /* k's ciph */
	0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x20, 0x69, /* ertext i */
	0x73, 0x20, 0x78, 0x6F, 0x72, 0x65, 0x64, 0x20, /* s xored  */
	0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, /* with the */
	0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6E, 0x74, /*  current */
	0x20, 0x62, 0x6C, 0x6F, 0x63, 0x6B, 0x27, 0x73, /*  block's */
	0x20, 0x70, 0x6C, 0x61, 0x69, 0x6E, 0x74, 0x65, /*  plainte */
	0x78, 0x74, 0x20, 0x62, 0x65, 0x66, 0x6F, 0x72, /* xt befor */
	0x65, 0x20, 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, /* e encryp */
	0x74, 0x69, 0x6F, 0x6E, 0x2E, 0x2E, 0x2E, 0x2E, /* tion.... */
};

static const uint8_t mac_cbc_vect1_out[] = {
	0xC9, 0x6E, 0x83, 0x7E, 0x35, 0xC8, 0xA7, 0xA0, /* .n.~5... */
	0x33, 0xA3, 0xB1, 0x4B, 0x5A, 0x92, 0x51, 0x2E, /* 3..KZ.Q. */
};

/* DES-CBC-MAC */
static const uint8_t mac_cbc_vect2_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
};

#define mac_cbc_vect2_data mac_cbc_vect1_data
static const uint8_t mac_cbc_vect2_out[] = {
	0xE9, 0x41, 0x46, 0x30, 0x69, 0x32, 0xBD, 0xD6, /* .AF0i2.. */
};

/* DES3-CBC-MAC */
static const uint8_t mac_cbc_vect3_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, /* 12345678 */
};

#define mac_cbc_vect3_data mac_cbc_vect2_data
static const uint8_t mac_cbc_vect3_out[] = {
	0x1C, 0x17, 0xB7, 0xB5, 0x9F, 0x54, 0x9C, 0x63, /* .....T.c */
};

/* AES-CBC-MAC PKCS#5 pad*/
static const uint8_t mac_cbc_vect4_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
};

#define mac_cbc_vect4_data mac_cbc_vect1_data
static const uint8_t mac_cbc_vect4_out[] = {
	0x0B, 0x46, 0xC7, 0xA2, 0xE1, 0x5A, 0xE2, 0x23, /* .F...Z.# */
	0x83, 0x34, 0x1C, 0x86, 0x53, 0xF8, 0x51, 0x24, /* .4..S.Q$ */
};

/* DES-CBC-MAC PKCS#5 pad*/
static const uint8_t mac_cbc_vect5_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
};

#define mac_cbc_vect5_data mac_cbc_vect1_data
static const uint8_t mac_cbc_vect5_out[] = {
	0x30, 0x81, 0x4F, 0x42, 0x03, 0x7E, 0xD8, 0xA9, /* 0.OB.~.. */
};

/* DES3-CBC-MAC PKCS#5 pad*/
static const uint8_t mac_cbc_vect6_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, /* 12345678 */
};

#define mac_cbc_vect6_data mac_cbc_vect1_data
static const uint8_t mac_cbc_vect6_out[] = {
	0x6E, 0x37, 0x6E, 0x14, 0x5E, 0x21, 0xDD, 0xF8, /* n7n.^!.. */
};

/* AES-CBC-MAC PKCS#5 pad*/
#define mac_cbc_vect7_key mac_cbc_vect4_key
static const uint8_t mac_cbc_vect7_data[] = {
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x20, 0x62, /* Cipher b */
	0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x63, 0x68, 0x61, /* lock cha */
	0x69, 0x6E, 0x69, 0x6E, 0x67, 0x20, 0x28, 0x43, /* ining (C */
	0x42, 0x43, 0x29, 0x20, 0x69, 0x73, 0x20, 0x61, /* BC) is a */
	0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F, 0x6E, 0x20, /*  common  */
	0x63, 0x68, 0x61, 0x69, 0x6E, 0x69, 0x6E, 0x67, /* chaining */
	0x20, 0x6D, 0x6F, 0x64, 0x65, 0x20, 0x69, 0x6E, /*  mode in */
	0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, /*  which t */
	0x68, 0x65, 0x20, 0x70, 0x72, 0x65, 0x76, 0x69, /* he previ */
	0x6F, 0x75, 0x73, 0x20, 0x62, 0x6C, 0x6F, 0x63, /* ous bloc */
	0x6B, 0x27, 0x73, 0x20, 0x63, 0x69, 0x70, 0x68, /* k's ciph */
	0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x20, 0x69, /* ertext i */
	0x73, 0x20, 0x78, 0x6F, 0x72, 0x65, 0x64, 0x20, /* s xored  */
	0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, /* with the */
	0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6E, 0x74, /*  current */
	0x20, 0x62, 0x6C, 0x6F, 0x63, 0x6B, 0x27, 0x73, /*  block's */
	0x20, 0x70, 0x6C, 0x61, 0x69, 0x6E, 0x74, 0x65, /*  plainte */
	0x78, 0x74, 0x20, 0x62, 0x65, 0x66, 0x6F, 0x72, /* xt befor */
	0x65, 0x20, 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, /* e encryp */
	0x74, 0x69, 0x6F, 0x6E, 0x2E,                   /* tion.    */
};

static const uint8_t mac_cbc_vect7_out[] = {
	0xFD, 0x89, 0x35, 0xB3, 0x93, 0x7F, 0xBB, 0xA2, /* ..5..... */
	0xFB, 0x65, 0x60, 0xC4, 0x0A, 0x62, 0xA0, 0xF9, /* .e`..b.. */
};

/* DES-CBC-MAC PKCS#5 pad*/
#define mac_cbc_vect8_key mac_cbc_vect5_key
#define mac_cbc_vect8_data mac_cbc_vect7_data
static const uint8_t mac_cbc_vect8_out[] = {
	0x02, 0x2A, 0xA8, 0x2E, 0x47, 0xC6, 0xBB, 0x7C, /* ....G..| */
};

/* DES3-CBC-MAC PKCS#5 pad*/
#define mac_cbc_vect9_key mac_cbc_vect6_key
#define mac_cbc_vect9_data mac_cbc_vect7_data
static const uint8_t mac_cbc_vect9_out[] = {
	0xD4, 0xF7, 0x3E, 0x27, 0x78, 0x0E, 0x1C, 0x79, /* ..>'x..y */
};

/*
 * DES3-CBC-MAC, with key size of 112bit
 * out obtained with:
 * echo -n "Cipher block chaining (CBC) is a common chaining mode in which the previous block's ciphertext is xored with the current block's plaintext before encryption...."|openssl enc  -iv 0 -des3 -K 303132333435363738394142434445463031323334353637 |xxd
 */
/* DES3-CBC-MAC PKCS#5 pad*/
static const uint8_t mac_cbc_vect10_key[] = {
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, /* 01234567 */
	0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, /* 89ABCDEF */
};
#define mac_cbc_vect10_data mac_cbc_vect1_data
static const uint8_t mac_cbc_vect10_out[] = {
	0x30, 0x92, 0x60, 0x99, 0x66, 0xac, 0x8c, 0xa6,
};


/*
 * AES-CMAC
 * Test vectors from
 * http://csrc.nist.gov/publications/nistpubs/800-38B/SP_800-38B.pdf
 */

/* AES-128 */
static const uint8_t mac_cmac_vect1_key[] = {
	0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
	0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c
};

static const uint8_t mac_cmac_vect1_out[] = {
	0xbb, 0x1d, 0x69, 0x29, 0xe9, 0x59, 0x37, 0x28,
	0x7f, 0xa3, 0x7d, 0x12, 0x9b, 0x75, 0x67, 0x46
};

#define mac_cmac_vect2_key mac_cmac_vect1_key
static const uint8_t mac_cmac_vect2_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
};

static const uint8_t mac_cmac_vect2_out[] = {
	0x07, 0x0a, 0x16, 0xb4, 0x6b, 0x4d, 0x41, 0x44,
	0xf7, 0x9b, 0xdd, 0x9d, 0xd0, 0x4a, 0x28, 0x7c
};

#define mac_cmac_vect3_key mac_cmac_vect1_key
static const uint8_t mac_cmac_vect3_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11
};

static const uint8_t mac_cmac_vect3_out[] = {
	0xdf, 0xa6, 0x67, 0x47, 0xde, 0x9a, 0xe6, 0x30,
	0x30, 0xca, 0x32, 0x61, 0x14, 0x97, 0xc8, 0x27
};

#define mac_cmac_vect4_key mac_cmac_vect1_key
static const uint8_t mac_cmac_vect4_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10
};

static const uint8_t mac_cmac_vect4_out[] = {
	0x51, 0xf0, 0xbe, 0xbf, 0x7e, 0x3b, 0x9d, 0x92,
	0xfc, 0x49, 0x74, 0x17, 0x79, 0x36, 0x3c, 0xfe
};

/* AES-192 */
static const uint8_t mac_cmac_vect5_key[] = {
	0x8e, 0x73, 0xb0, 0xf7, 0xda, 0x0e, 0x64, 0x52,
	0xc8, 0x10, 0xf3, 0x2b, 0x80, 0x90, 0x79, 0xe5,
	0x62, 0xf8, 0xea, 0xd2, 0x52, 0x2c, 0x6b, 0x7b
};

static const uint8_t mac_cmac_vect5_out[] = {
	0xd1, 0x7d, 0xdf, 0x46, 0xad, 0xaa, 0xcd, 0xe5,
	0x31, 0xca, 0xc4, 0x83, 0xde, 0x7a, 0x93, 0x67
};


#define mac_cmac_vect6_key mac_cmac_vect5_key
static const uint8_t mac_cmac_vect6_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
};

static const uint8_t mac_cmac_vect6_out[] = {
	0x9e, 0x99, 0xa7, 0xbf, 0x31, 0xe7, 0x10, 0x90,
	0x06, 0x62, 0xf6, 0x5e, 0x61, 0x7c, 0x51, 0x84
};

#define mac_cmac_vect7_key mac_cmac_vect5_key
static const uint8_t mac_cmac_vect7_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11
};

static const uint8_t mac_cmac_vect7_out[] = {
	0x8a, 0x1d, 0xe5, 0xbe, 0x2e, 0xb3, 0x1a, 0xad,
	0x08, 0x9a, 0x82, 0xe6, 0xee, 0x90, 0x8b, 0x0e
};

#define mac_cmac_vect8_key mac_cmac_vect5_key
static const uint8_t mac_cmac_vect8_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10
};

static const uint8_t mac_cmac_vect8_out[] = {
	0xa1, 0xd5, 0xdf, 0x0e, 0xed, 0x79, 0x0f, 0x79,
	0x4d, 0x77, 0x58, 0x96, 0x59, 0xf3, 0x9a, 0x11
};

/* AES-256 */
static const uint8_t mac_cmac_vect9_key[] = {
	0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe,
	0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
	0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7,
	0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4
};

static const uint8_t mac_cmac_vect9_out[] = {
	0x02, 0x89, 0x62, 0xf6, 0x1b, 0x7b, 0xf8, 0x9e,
	0xfc, 0x6b, 0x55, 0x1f, 0x46, 0x67, 0xd9, 0x83
};

#define mac_cmac_vect10_key mac_cmac_vect9_key
static const uint8_t mac_cmac_vect10_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
};

static const uint8_t mac_cmac_vect10_out[] = {
	0x28, 0xa7, 0x02, 0x3f, 0x45, 0x2e, 0x8f, 0x82,
	0xbd, 0x4b, 0xf2, 0x8d, 0x8c, 0x37, 0xc3, 0x5c
};

#define mac_cmac_vect11_key mac_cmac_vect9_key
static const uint8_t mac_cmac_vect11_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11
};

static const uint8_t mac_cmac_vect11_out[] = {
	0xaa, 0xf3, 0xd8, 0xf1, 0xde, 0x56, 0x40, 0xc2,
	0x32, 0xf5, 0xb1, 0x69, 0xb9, 0xc9, 0x11, 0xe6
};

#define mac_cmac_vect12_key mac_cmac_vect9_key
static const uint8_t mac_cmac_vect12_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10
};

static const uint8_t mac_cmac_vect12_out[] = {
	0xe1, 0x99, 0x21, 0x90, 0x54, 0x9f, 0x6e, 0xd5,
	0x69, 0x6a, 0x2c, 0x05, 0x6c, 0x31, 0x54, 0x10
};

#define mac_cmac_vect13_key mac_cmac_vect1_key
static const uint8_t mac_cmac_vect13_data[] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
	0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
	0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
	0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
	0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
	0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10,
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
	0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
};

static const uint8_t mac_cmac_vect13_out[] = {
	0xF6, 0xDC, 0xBF, 0x9A, 0x5A, 0x3E, 0x1E, 0xF9,
	0x7B, 0xE1, 0x02, 0x08, 0x5B, 0xF4, 0x19, 0x7F,
};

/*
 * DES3-CMAC
 * Test vectors from
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/cavp-testing-block-cipher-modes
 */

/* Three Key TDEA */

/* CMACGenTDES3.rsp Count = 8 */
static const uint8_t mac_des3_cmac_vect1_key[] = {
	0xf8, 0x7c, 0x4c, 0x3d, 0xf7, 0x1f, 0xd9, 0x8c,
	0xe5, 0x32, 0xf4, 0x1f, 0xfe, 0x31, 0x58, 0x20,
	0x51, 0x4f, 0xad, 0x7c, 0x7a, 0xae, 0x2f, 0x46
};

static const uint8_t mac_des3_cmac_vect1_out[] = {
	0x19, 0xfb, 0xd3, 0xdc, 0x15, 0x4b, 0xc1, 0x39
};

/* CMACVerTDES3.rsp Count = 25 */
static const uint8_t mac_des3_cmac_vect2_key[] = {
	0xa2, 0x52, 0xda, 0xad, 0x73, 0x1c, 0x10, 0x97,
	0x45, 0x46, 0x38, 0xab, 0xf1, 0xf8, 0x40, 0x6d,
	0xd0, 0xae, 0xcb, 0xc7, 0x8c, 0x01, 0x8a, 0xa8
};

static const uint8_t mac_des3_cmac_vect2_data[] = {
	0x1d, 0x99, 0x92, 0x0c, 0x59, 0x73, 0x99, 0x7c,
	0xc0, 0x59, 0xd4, 0x42, 0x46, 0x7f, 0x76, 0x59
};

static const uint8_t mac_des3_cmac_vect2_out[] = {
	0x7c, 0x14, 0x90, 0x12, 0xd6, 0x12, 0x0e, 0xc6
};

/* CMACVerTDES3.rsp Count = 40 */
static const uint8_t mac_des3_cmac_vect3_key[] = {
	0xf2, 0x45, 0xf8, 0xd5, 0x85, 0x13, 0x3e, 0x31,
	0x04, 0xd3, 0xfb, 0xc2, 0xd0, 0xec, 0x80, 0xf4,
	0x3e, 0xce, 0x1f, 0xd9, 0xa2, 0x8f, 0x5e, 0xd5
};

static const uint8_t mac_des3_cmac_vect3_data[] = {
	0x99, 0x3d, 0xac, 0xbc, 0x22, 0x1e, 0xd3, 0x2a,
	0x6f, 0xb3, 0xd9, 0x05, 0x59, 0xc6, 0x74, 0xfb,
	0x68, 0x08, 0x9e, 0xea, 0x8d, 0xf9, 0xea, 0xec,
	0x14, 0x07, 0x19, 0x91, 0xd4, 0xfa, 0xe8, 0x6b
};

static const uint8_t mac_des3_cmac_vect3_out[] = {
	0x25, 0xfb, 0x96, 0x2e, 0xa9, 0x3b, 0x89, 0x7f
};

/* CMACVerTDES3.rsp Count = 57 */
static const uint8_t mac_des3_cmac_vect4_key[] = {
	0xc2, 0x9e, 0xc1, 0x2c, 0xa4, 0x83, 0xc2, 0x61,
	0xc1, 0xfe, 0xa7, 0x34, 0xf4, 0xad, 0x08, 0x10,
	0x8a, 0xc2, 0x75, 0x02, 0x68, 0x2c, 0x67, 0xdc
};

static const uint8_t mac_des3_cmac_vect4_data[] = {
	0x19, 0x5c, 0x0b, 0x84, 0xba, 0xac, 0xc8, 0x8a, 0x33
};

static const uint8_t mac_des3_cmac_vect4_out[] = {
	0xe3, 0xeb, 0xff, 0x96, 0x12, 0x49, 0x42, 0x45
};

/* Two Key TDEA */

/* CMACVerTDES2.rsp Count = 55 */
static const uint8_t mac_des3_cmac_vect5_key[] = {
	0xb6, 0xe0, 0xe5, 0x80, 0x20, 0x92, 0x34, 0x94,
	0xdc, 0x76, 0x80, 0x08, 0xe9, 0x98, 0x8f, 0xc2,
	0xb6, 0xe0, 0xe5, 0x80, 0x20, 0x92, 0x34, 0x94
};

static const uint8_t mac_des3_cmac_vect5_out[] = {
	0x5c, 0x73, 0x43, 0xa4, 0x16, 0x8a, 0x37, 0x0f
};

/* CMACVerTDES2.rsp Count = 101 */
static const uint8_t mac_des3_cmac_vect6_key[] = {
	0x61, 0xc4, 0xec, 0x20, 0x70, 0xe9, 0xbf, 0x2a,
	0xec, 0x02, 0xd0, 0xb0, 0xe9, 0x9e, 0x8f, 0x01,
	0x61, 0xc4, 0xec, 0x20, 0x70, 0xe9, 0xbf, 0x2a
};

static const uint8_t mac_des3_cmac_vect6_data[] = {
	0xff, 0xbd, 0x75, 0x61, 0x93, 0x91, 0x88, 0xbc
};

static const uint8_t mac_des3_cmac_vect6_out[] = {
	0x55, 0xa0, 0x4c, 0x23, 0xd5, 0xb4, 0x3e, 0x49
};

/* CMACVerTDES2.rsp Count = 223 */
static const uint8_t mac_des3_cmac_vect7_key[] = {
	0xb6, 0xc8, 0x9d, 0x79, 0x85, 0x70, 0xab, 0x6e,
	0xcd, 0x54, 0x54, 0xc1, 0xa7, 0x29, 0xf2, 0xd9,
	0xb6, 0xc8, 0x9d, 0x79, 0x85, 0x70, 0xab, 0x6e
};

static const uint8_t mac_des3_cmac_vect7_data[] = {
	0x83, 0xd2, 0xc3, 0x86, 0xe8, 0x73, 0xad, 0xa1,
	0x49, 0x76, 0x71, 0x2b, 0x67, 0x27, 0x7c
};

static const uint8_t mac_des3_cmac_vect7_out[] = {
	0x03, 0xbf, 0x2c, 0x9f, 0x49, 0x6e, 0x4f, 0xa9
};

/* CMACVerTDES2.rsp Count = 358 */
static const uint8_t mac_des3_cmac_vect8_key[] = {
	0xe0, 0x85, 0xab, 0xa8, 0x58, 0x83, 0xc7, 0x5d,
	0x62, 0x76, 0x75, 0x7a, 0x54, 0x31, 0xc8, 0x37,
	0xe0, 0x85, 0xab, 0xa8, 0x58, 0x83, 0xc7, 0x5d
};

static const uint8_t mac_des3_cmac_vect8_data[] = {
	0xb0, 0x53, 0x76, 0xdb, 0x71, 0xce, 0x06, 0x66,
	0x63, 0x81, 0x95, 0x03, 0xeb, 0x0a, 0xd5, 0xef,
	0x63, 0x2d, 0x0c, 0xa4, 0x6c, 0xd4, 0x0e, 0xfe,
	0x86, 0x54, 0x69, 0x9d, 0xde, 0xf2, 0xdf, 0x8a,
	0x66, 0xa6, 0x19, 0x1d, 0x2b, 0x1f, 0x99, 0x1e
};

static const uint8_t mac_des3_cmac_vect8_out[] = {
	0xd5, 0xe7, 0x9f, 0x0b, 0x3c, 0x67, 0xd7, 0xf3
};

/* X25519 test vectors (RFC 7748 - 6.1) */
static const uint8_t x25519_alice_private[] = {
	0x77, 0x07, 0x6d, 0x0a, 0x73, 0x18, 0xa5, 0x7d,
	0x3c, 0x16, 0xc1, 0x72, 0x51, 0xb2, 0x66, 0x45,
	0xdf, 0x4c, 0x2f, 0x87, 0xeb, 0xc0, 0x99, 0x2a,
	0xb1, 0x77, 0xfb, 0xa5, 0x1d, 0xb9, 0x2c, 0x2a
};
static const uint8_t x25519_alice_public[] = {
	0x85, 0x20, 0xf0, 0x09, 0x89, 0x30, 0xa7, 0x54,
	0x74, 0x8b, 0x7d, 0xdc, 0xb4, 0x3e, 0xf7, 0x5a,
	0x0d, 0xbf, 0x3a, 0x0d, 0x26, 0x38, 0x1a, 0xf4,
	0xeb, 0xa4, 0xa9, 0x8e, 0xaa, 0x9b, 0x4e, 0x6a
};
static const uint8_t x25519_bob_private[] = {
	0x5d, 0xab, 0x08, 0x7e, 0x62, 0x4a, 0x8a, 0x4b,
	0x79, 0xe1, 0x7f, 0x8b, 0x83, 0x80, 0x0e, 0xe6,
	0x6f, 0x3b, 0xb1, 0x29, 0x26, 0x18, 0xb6, 0xfd,
	0x1c, 0x2f, 0x8b, 0x27, 0xff, 0x88, 0xe0, 0xeb
};
static const uint8_t x25519_bob_public[] = {
	0xde, 0x9e, 0xdb, 0x7d, 0x7b, 0x7d, 0xc1, 0xb4,
	0xd3, 0x5b, 0x61, 0xc2, 0xec, 0xe4, 0x35, 0x37,
	0x3f, 0x83, 0x43, 0xc8, 0x5b, 0x78, 0x67, 0x4d,
	0xad, 0xfc, 0x7e, 0x14, 0x6f, 0x88, 0x2b, 0x4f
};
static const uint8_t x25519_shared_secret[] = {
	0x4a, 0x5d, 0x9d, 0x5b, 0xa4, 0xce, 0x2d, 0xe1,
	0x72, 0x8e, 0x3b, 0xf4, 0x80, 0x35, 0x0f, 0x25,
	0xe0, 0x7e, 0x21, 0xc9, 0x47, 0xd1, 0x9e, 0x33,
	0x76, 0xf0, 0x9b, 0x3c, 0x1e, 0x16, 0x17, 0x42
};

/* Ed25519 test vectors (RFC 8032 - 7.1) */
static const uint8_t ed25519_rfc_8032_7_1_private[] = {
	0x83, 0x3f, 0xe6, 0x24,  0x9, 0x23, 0x7b, 0x9d,
	0x62, 0xec, 0x77, 0x58, 0x75, 0x20, 0x91, 0x1e,
	0x9a, 0x75, 0x9c, 0xec, 0x1d, 0x19, 0x75, 0x5b,
	0x7d, 0xa9, 0x01, 0xb9, 0x6d, 0xca, 0x3d, 0x42
};
static const uint8_t ed25519_rfc_8032_7_1_public[] = {
	0xec, 0x17, 0x2b, 0x93, 0xad, 0x5e, 0x56, 0x3b,
	0xf4, 0x93, 0x2c, 0x70, 0xe1, 0x24, 0x50, 0x34,
	0xc3, 0x54, 0x67, 0xef, 0x2e, 0xfd, 0x4d, 0x64,
	0xeb, 0xf8, 0x19, 0x68, 0x34, 0x67, 0xe2, 0xbf
};
static const uint8_t ed25519_rfc_8032_7_1_ptx[] = {
	0xdd, 0xaf, 0x35, 0xa1, 0x93, 0x61, 0x7a, 0xba,
	0xcc, 0x41, 0x73, 0x49, 0xae, 0x20, 0x41, 0x31,
	0x12, 0xe6, 0xfa, 0x4e, 0x89, 0xa9, 0x7e, 0xa2,
	0x0a, 0x9e, 0xee, 0xe6, 0x4b, 0x55, 0xd3, 0x9a,
	0x21, 0x92, 0x99, 0x2a, 0x27, 0x4f, 0xc1, 0xa8,
	0x36, 0xba, 0x3c, 0x23, 0xa3, 0xfe, 0xeb, 0xbd,
	0x45, 0x4d, 0x44, 0x23, 0x64, 0x3c, 0xe8,  0xe,
	0x2a, 0x9a, 0xc9, 0x4f, 0xa5, 0x4c, 0xa4, 0x9f
};
static const uint8_t ed25519_rfc_8032_7_1_out[] = {
	0xdc, 0x2a, 0x44, 0x59, 0xe7, 0x36, 0x96, 0x33,
	0xa5, 0x2b, 0x1b, 0xf2, 0x77, 0x83, 0x9a, 0x0,
	0x20, 0x10, 0x09, 0xa3, 0xef, 0xbf, 0x3e, 0xcb,
	0x69, 0xbe, 0xa2, 0x18, 0x6c, 0x26, 0xb5, 0x89,
	0x09, 0x35, 0x1f, 0xc9, 0xac, 0x90, 0xb3, 0xec,
	0xfd, 0xfb, 0xc7, 0xc6, 0x64, 0x31, 0xe0, 0x30,
	0x3d, 0xca, 0x17, 0x9c, 0x13, 0x8a, 0xc1, 0x7a,
	0xd9, 0xbe, 0xf1, 0x17, 0x73, 0x31, 0xa7, 0x4
};

/* Ed25519 test vectors (RFC 8032 - 7.2) */
static const uint8_t ed25519ctx_rfc_8032_7_2_private[] = {
	0x03, 0x05, 0x33, 0x4e, 0x38, 0x1a, 0xf7, 0x8f,
	0x14, 0x1c, 0xb6, 0x66, 0xf6, 0x19, 0x9f, 0x57,
	0xbc, 0x34, 0x95, 0x33, 0x5a, 0x25, 0x6a, 0x95,
	0xbd, 0x2a, 0x55, 0xbf, 0x54, 0x66, 0x63, 0xf6
};
static const uint8_t ed25519ctx_rfc_8032_7_2_public[] = {
	0xdf, 0xc9, 0x42, 0x5e, 0x4f, 0x96, 0x8f, 0x7f,
	0x0c, 0x29, 0xf0, 0x25, 0x9c, 0xf5, 0xf9, 0xae,
	0xd6, 0x85, 0x1c, 0x2b, 0xb4, 0xad, 0x8b, 0xfb,
	0x86, 0x0c, 0xfe, 0xe0, 0xab, 0x24, 0x82, 0x92
};
static const uint8_t ed25519ctx_rfc_8032_7_2_ptx[] = {
	0xf7, 0x26, 0x93, 0x6d, 0x19, 0xc8, 0x00, 0x49,
	0x4e, 0x3f, 0xda, 0xff, 0x20, 0xb2, 0x76, 0xa8
};
static const uint8_t ed25519ctx_rfc_8032_7_2_out[] = {
	0x55, 0xa4, 0xcc, 0x2f, 0x70, 0xa5, 0x4e, 0x4,
	0x28, 0x8c, 0x5f, 0x4c, 0xd1, 0xe4, 0x5a, 0x7b,
	0xb5, 0x20, 0xb3, 0x62, 0x92, 0x91, 0x18, 0x76,
	0xca, 0xda, 0x73, 0x23, 0x19, 0x8d, 0xd8, 0x7a,
	0x8b, 0x36, 0x95, 0x0b, 0x95, 0x13, 0x00, 0x22,
	0x90, 0x7a, 0x7f, 0xb7, 0xc4, 0xe9, 0xb2, 0xd5,
	0xf6, 0xcc, 0xa6, 0x85, 0xa5, 0x87, 0xb4, 0xb2,
	0x1f, 0x4b, 0x88, 0x8e, 0x4e, 0x7e, 0xdb, 0xd
};
static const uint8_t ed25519ctx_rfc_8032_7_2_context[] = {
	0x66, 0x6f, 0x6f
};

/* Ed25519 test vectors (RFC 8032 - 7.3) */
static const uint8_t ed25519ph_rfc_8032_7_3_private[] = {
	0x83, 0x3f, 0xe6, 0x24, 0x09, 0x23, 0x7b, 0x9d,
	0x62, 0xec, 0x77, 0x58, 0x75, 0x20, 0x91, 0x1e,
	0x9a, 0x75, 0x9c, 0xec, 0x1d, 0x19, 0x75, 0x5b,
	0x7d, 0xa9, 0x01, 0xb9, 0x6d, 0xca, 0x3d, 0x42
};
static const uint8_t ed25519ph_rfc_8032_7_3_public[] = {
	0xec, 0x17, 0x2b, 0x93, 0xad, 0x5e, 0x56, 0x3b,
	0xf4, 0x93, 0x2c, 0x70, 0xe1, 0x24, 0x50, 0x34,
	0xc3, 0x54, 0x67, 0xef, 0x2e, 0xfd, 0x4d, 0x64,
	0xeb, 0xf8, 0x19, 0x68, 0x34, 0x67, 0xe2, 0xbf
};
static const uint8_t ed25519ph_rfc_8032_7_3_ptx[] = {
	0x61, 0x62, 0x63
};
static const uint8_t ed25519ph_rfc_8032_7_3_out[] = {
	0x98, 0xa7, 0x02, 0x22, 0xf0, 0xb8, 0x12, 0x1a,
	0xa9, 0xd3, 0x0f, 0x81, 0x3d, 0x68, 0x3f, 0x80,
	0x9e, 0x46, 0x2b, 0x46, 0x9c, 0x7f, 0xf8, 0x76,
	0x39, 0x49, 0x9b, 0xb9, 0x4e, 0x6d, 0xae, 0x41,
	0x31, 0xf8, 0x50, 0x42, 0x46, 0x3c, 0x2a, 0x35,
	0x5a, 0x20, 0x03, 0xd0, 0x62, 0xad, 0xf5, 0xaa,
	0xa1, 0x0b, 0x8c, 0x61, 0xe6, 0x36, 0x06, 0x2a,
	0xaa, 0xd1, 0x1c, 0x2a, 0x26, 0x08, 0x34, 0x06
};

/*
 * RSA AES wrapped key
 * Test data generated as follows:
 * - generate target AES-256 key (target.aes)
 * - generate wrapping RSA keypair (we use ac_rsassa_vect2 in this case)
 * - generate intermediate AES-256 KEK
 * - wrap target key using KEK (RFC 5649):
 *	openssl enc \
 *		-id-aes256-wrap-pad \
 *		-iv A65959A6 \
 *		-K $( hexdump -v -e '/1 "%02x"' < kek.aes ) \
 *		-in target.aes \
 *		-out target_wrapped.enc
 * - encrypt KEK using wrapping RSA public key:
 *	openssl pkeyutl \
 *		-encrypt \
 *		-pubin \
 *		-inkey vect2_pub.key \
 *		-in kek.aes -out kek_wrapped.enc \
 *		-pkeyopt rsa_padding_mode:oaep \
 *		-pkeyopt rsa_oaep_md:sha256 \
 *		-pkeyopt rsa_mgf1_md:sha256
 *
 * - concatenate both:
 *	cat kek_wrapped.enc target_wrapped.enc > pkcs11_rsa_aes_wrapped_key
 */
static const uint8_t pkcs11_rsa_aes_wrapped_key[] = {
	0x5c, 0x1f, 0x2d, 0x4f, 0xe9, 0x72, 0xf2, 0x67,
	0xc7, 0x82, 0x78, 0x28, 0x15, 0xe0, 0x25, 0x75,
	0xc5, 0xf0, 0x5c, 0x0b, 0x11, 0x78, 0xbc, 0x3e,
	0xf7, 0x3d, 0x8e, 0x33, 0x44, 0x2a, 0xb5, 0x81,
	0xc6, 0x4c, 0x06, 0xea, 0x8a, 0xfa, 0x34, 0x86,
	0x17, 0x07, 0x87, 0x80, 0x0f, 0x8e, 0x47, 0xe6,
	0xaf, 0x48, 0x6c, 0x8b, 0x29, 0x98, 0xb4, 0x69,
	0xe2, 0x91, 0x03, 0x51, 0xea, 0x90, 0xa4, 0x66,
	0x5c, 0x07, 0xa2, 0xa3, 0x4c, 0x02, 0x3b, 0x71,
	0x0c, 0xf2, 0x57, 0x4a, 0x4f, 0x63, 0x14, 0xce,
	0x63, 0x17, 0x15, 0xa4, 0x1d, 0x4e, 0x38, 0x53,
	0x56, 0x11, 0x56, 0xcc, 0x2e, 0x80, 0xb3, 0xc1,
	0xf2, 0x1a, 0x54, 0xd5, 0x5b, 0x80, 0xb5, 0xd8,
	0xd7, 0x29, 0x37, 0x76, 0x79, 0xbd, 0xa9, 0xfa,
	0x8f, 0x8c, 0x8d, 0x8d, 0xd8, 0xe2, 0x94, 0xe5,
	0xf0, 0x62, 0x62, 0x0c, 0x8c, 0x28, 0x5e, 0x77,
	0xb6, 0xf3, 0xa9, 0x64, 0x76, 0xe6, 0xd7, 0x9f,
	0x0b, 0xe7, 0x17, 0xba, 0x23, 0xe5, 0x13, 0x6f,
	0xf8, 0x0f, 0x51, 0xd6, 0x2a, 0x2c, 0x75, 0xb4,
	0xd8, 0x1b, 0x13, 0xc8, 0xd4, 0x7f, 0x2a, 0x2c,
	0x2c, 0x34, 0x58, 0x6e, 0x26, 0x7a, 0x6c, 0xa9,
	0x77, 0x18, 0xb1, 0xbd, 0xb5, 0x0a, 0xdd, 0x46,
	0xd6, 0x31, 0x80, 0x51, 0xc1, 0x7c, 0x6b, 0x74,
	0x4d, 0x91, 0x9e, 0xbf, 0xce, 0x3a, 0x39, 0xbb,
	0x79, 0xab, 0x5f, 0x9e, 0xb5, 0xab, 0x76, 0x37,
	0xea, 0x11, 0xf6, 0xe1, 0x50, 0xcb, 0x74, 0xf9,
	0x1c, 0x91, 0x5f, 0xf6, 0xc9, 0xd5, 0x9b, 0xc1,
	0xfc, 0x76, 0x5a, 0x58, 0xfb, 0xaa, 0x88, 0xcc,
	0xaa, 0x4e, 0x31, 0x8e, 0xe5, 0x3d, 0x22, 0xc3,
	0xcb, 0x21, 0x3b, 0xd5, 0x95, 0x3a, 0x09, 0xd8,
	0xce, 0x7f, 0x39, 0x9b, 0x38, 0x8c, 0x51, 0x61,
	0x87, 0x18, 0x7e, 0xf5, 0x5a, 0x0b, 0x70, 0x2b,
	0x35, 0xd3, 0x18, 0x0f, 0xc9, 0xe7, 0xc4, 0xf3,
	0x9d, 0x14, 0x20, 0x85, 0x64, 0xb1, 0xfb, 0x3b,
	0xc0, 0xc1, 0x21, 0x08, 0x8f, 0x2f, 0x3f, 0xb9,
	0xde, 0xe9, 0x11, 0x57, 0xaf, 0x35, 0x65, 0xa0,
	0x5b, 0x9c, 0x62, 0xfb, 0xc9, 0x80, 0x8b, 0xcc
};

/*
 * Sample AES-256 key
 */
static const uint8_t pkcs11_rsa_aes_tagret_key[] = {
	0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20,
	0x76, 0x65, 0x72, 0x79, 0x20, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x20, 0x41, 0x45, 0x53, 0x20,
	0x32, 0x35, 0x36, 0x20, 0x6b, 0x65, 0x79, 0x0a
};

#endif /*XTEST_4000_DATA_H*/
