# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python patch_security_connector_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="a5caac9c-5c04-49af-b3d0-e204f40345d5",
    )

    response = client.security_connectors.update(
        resource_group_name="exampleResourceGroup",
        security_connector_name="exampleSecurityConnectorName",
        security_connector={
            "etag": "etag value (must be supplied for update)",
            "location": "Central US",
            "properties": {
                "environmentData": {"environmentType": "AwsAccount"},
                "environmentName": "AWS",
                "hierarchyIdentifier": "exampleHierarchyId",
                "offerings": [
                    {
                        "nativeCloudConnection": {"cloudRoleArn": "arn:aws:iam::00000000:role/ASCMonitor"},
                        "offeringType": "CspmMonitorAws",
                    }
                ],
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2024-08-01-preview/examples/SecurityConnectors/PatchSecurityConnector_example.json
if __name__ == "__main__":
    main()
