/*
 * ABOUTME: TXT resource record parsing and formatting.
 * ABOUTME: Uses txtlike infrastructure for implementation.
 *
 * Part of DNS zone file validator `validns`.
 *
 * Copyright 2025-2026 OARC, Inc.
 * Copyright 2011-2025 Anton Berezin <tobez@tobez.org>
 * Modified BSD license.
 * (See LICENSE file in the distribution.)
 *
 */
#include <sys/types.h>
#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "textparse.h"
#include "rr.h"
#include "txtlike.h"

static struct rr *txt_parse(char *name, long ttl, int type, char *s)
{
    return txtlike_parse(name, ttl, type, s, "TXT");
}

struct rr_methods txt_methods = { txt_parse, txtlike_human, txtlike_wirerdata, NULL, NULL };
