/* _unix.c  94.12.17
 * Copyright 1983-1992   Albert Davis
 * Non-portable functions for unix systems (Sun, Next, ....)
 */
#include "error.h"
#include <signal.h>
#ifdef SIGNALVARARGS
#define ARGTAIL ,...
#else
#define ARGTAIL
#endif
/*--------------------------------------------------------------------------*/
	void    initialize_io(void);
	void    setup_traps(void);
static	void	sig_int(int ARGTAIL);
	void	shell(void);
/*--------------------------------------------------------------------------*/
extern struct ioctrl io;
extern FILE *stream[];	    /* reverse of fileno() */
/*--------------------------------------------------------------------------*/
void initialize_io(void)
{
 stream[(int)fileno(stdin )] = stdin;
 stream[(int)fileno(stdout)] = stdout;
 stream[(int)fileno(stderr)] = stderr;
 io.mstdout = io.mstderr = 1<<fileno(stdout);
 io.mprint = 0;
}
/*--------------------------------------------------------------------------*/
void setup_traps(void)
{
 (void)signal(SIGINT,sig_int);
}
/*--------------------------------------------------------------------------*/
/* sig_int: what to do on receipt of interrupt signal (SIGINT)
 * cancel batch files, then back to command mode.
 * (actually, control-c trap)
 */
/*ARGSUSED*/
static void sig_int(int sig ARGTAIL)
{
 (void)signal(SIGINT,sig_int);
 error(bERROR, "\n");
}
/*--------------------------------------------------------------------------*/
void shell(void)
{
 (void)system(getenv("SHELL"));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
