/* ac_load.c  94.10.14
 * Copyright 1983-1992   Albert Davis
 * Load AC matrix from pre-computed values
 */
#include "ecah.h"
#include "array.h"
#include "branch.h"
#include "nodestat.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	acloadsource(const branch_t*);
	void	acloadpassive(const branch_t*);
	void	acloadpassivereal(const branch_t*);
	void	acloadpassiveimaginary(const branch_t*);
	void	acloadactive(const branch_t*);
	void	acloadactivereverse(const branch_t*);
	void	acloadmutual(const branch_t*);
/*--------------------------------------------------------------------------*/
extern       struct nodestuff ns;
/*--------------------------------------------------------------------------*/
void acloadsource(const branch_t *brh)
{
 if (brh->n[OUT2].m != 0){
    ns.acx[brh->n[OUT2].m] += brh->acg.x;
    ns.acy[brh->n[OUT2].m] += brh->acg.y;
 }
 if (brh->n[OUT1].m != 0){
    ns.acx[brh->n[OUT1].m] -= brh->acg.x;
    ns.acy[brh->n[OUT1].m] -= brh->acg.y;
 }
}
/*--------------------------------------------------------------------------*/
void acloadpassive(const branch_t *brh)
{
 if (brh->acg.x != 0.)
    acloadpassivereal(brh);
 if (brh->acg.y != 0.)
    acloadpassiveimaginary(brh);
}
/*--------------------------------------------------------------------------*/
void acloadpassivereal(const branch_t *brh)
{
 if (brh->n[OUT2].m != 0){
    *Red(brh->n[OUT2].m,brh->n[OUT2].m) += brh->acg.x;
    if (brh->n[OUT1].m != 0){
       *Red(brh->n[OUT1].m,brh->n[OUT1].m) += brh->acg.x;
       *Re(brh->n[OUT1].m,brh->n[OUT2].m)  -= brh->acg.x;
       *Re(brh->n[OUT2].m,brh->n[OUT1].m)  -= brh->acg.x;
    }
 }else if (brh->n[OUT1].m != 0){
    *Red(brh->n[OUT1].m,brh->n[OUT1].m) += brh->acg.x;
 }
}
/*--------------------------------------------------------------------------*/
void acloadpassiveimaginary(const branch_t *brh)
{
 if (brh->n[OUT2].m != 0){
    *Imd(brh->n[OUT2].m,brh->n[OUT2].m) += brh->acg.y;
    if (brh->n[OUT1].m != 0){
       *Imd(brh->n[OUT1].m,brh->n[OUT1].m) += brh->acg.y;
       *Im(brh->n[OUT1].m,brh->n[OUT2].m)  -= brh->acg.y;
       *Im(brh->n[OUT2].m,brh->n[OUT1].m)  -= brh->acg.y;
    }
 }else if (brh->n[OUT1].m != 0){
    *Imd(brh->n[OUT1].m,brh->n[OUT1].m) += brh->acg.y;
 }
}
/*--------------------------------------------------------------------------*/
void acloadactive(const branch_t *brh)
{
 if (brh->acg.x != 0.){
    *re(brh->n[OUT1].m,brh->n[IN1].m) += brh->acg.x;
    *re(brh->n[OUT2].m,brh->n[IN2].m) += brh->acg.x;
    *re(brh->n[OUT1].m,brh->n[IN2].m) -= brh->acg.x;
    *re(brh->n[OUT2].m,brh->n[IN1].m) -= brh->acg.x;
 }
 if (brh->acg.y != 0.){
    *im(brh->n[OUT1].m,brh->n[IN1].m) += brh->acg.y;
    *im(brh->n[OUT2].m,brh->n[IN2].m) += brh->acg.y;
    *im(brh->n[OUT1].m,brh->n[IN2].m) -= brh->acg.y;
    *im(brh->n[OUT2].m,brh->n[IN1].m) -= brh->acg.y;
 }
}
/*--------------------------------------------------------------------------*/
void acloadactivereverse(const branch_t *brh)
{
 if (brh->acg.x != 0.){
    *re(brh->n[IN1].m,brh->n[OUT1].m) += brh->acg.x;
    *re(brh->n[IN2].m,brh->n[OUT2].m) += brh->acg.x;
    *re(brh->n[IN1].m,brh->n[OUT2].m) -= brh->acg.x;
    *re(brh->n[IN2].m,brh->n[OUT1].m) -= brh->acg.x;
 }
 if (brh->acg.y != 0.){
    *im(brh->n[IN1].m,brh->n[OUT1].m) += brh->acg.y;
    *im(brh->n[IN2].m,brh->n[OUT2].m) += brh->acg.y;
    *im(brh->n[IN1].m,brh->n[OUT2].m) -= brh->acg.y;
    *im(brh->n[IN2].m,brh->n[OUT1].m) -= brh->acg.y;
 }
}
/*--------------------------------------------------------------------------*/
void acloadmutual(const branch_t *brh)
{
 acloadactive(brh);
 acloadactivereverse(brh);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
