/* sweep.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Step a parameter and repeat a group of commands
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "io.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_sweep(const char*,int*);
static	void	buildfile(const char*,int*);
static	void	doit(void);
static	void	setup(const char*,int*);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern int crtplot;
extern int swp_count[], swp_steps[];
extern int swp_type[];
extern int swp_nest;
static char tempfile[] = STEPFILE;
/*--------------------------------------------------------------------------*/
void cmd_sweep(const char *cmd, int *cnt)
{
 if (cmd[*cnt])
    buildfile(cmd,cnt);
 doit();
 cmd_unfault();
}
/*--------------------------------------------------------------------------*/
static void buildfile(const char *cmd, int *cnt)
{
 auto char buffer[BUFLEN];
 static FILE *fptr;
 
 setup(cmd,cnt);
 if (fptr)
     (void)fclose(fptr);
 fptr = fopen( tempfile, "w" );
 if (!fptr)
    error(bERROR, "can't open temporary file\n" );
 (void)fprintf(fptr, "%s\n", cmd );
 
 for (;;){
    (void)getcmd( ">>>", buffer, BUFLEN );
    if ( match(buffer,"GO") )
       break;
    (void)fprintf(fptr,"%s\n",buffer);
 }
 (void)fclose(fptr);
 fptr = (FILE*)NULL;
}
/*--------------------------------------------------------------------------*/
static void doit(void)
{
 auto char buffer[BUFLEN];
 static FILE *fptr;
 int ind;
 
 for ( swp_count[swp_nest]=0 ; swp_count[swp_nest]<=swp_steps[swp_nest] ;
       swp_count[swp_nest]++ ){
    if (fptr)
       (void)fclose(fptr);
    fptr = fopen(tempfile, "r");
    if (!fptr)
       error(bERROR, "can't open %s\n", tempfile);
    (void)fgets(buffer,BUFLEN,fptr);
    ind = 0;
    if ( pmatch(buffer,&ind,"SWeep") )
       setup(buffer,&ind);
    else
       error(bERROR, "bad file format: %s\n", tempfile);
    strncpy( buffer, "fault                              ", (size_t)ind);
    buffer[ind-1] = ' ';		/* make sure there is a delimiter   */
					/* in case the words run together   */
    for (;;){				/* may wipe out one letter of fault */
       (void)cmdproc(buffer);
       if (!fgets(buffer,BUFLEN,fptr))
	  break;
       if (!crtplot)
	  mprintf(io.mstdout,"%u> %s", swp_count[swp_nest]+1, buffer);
    }
 }
 (void)fclose(fptr);
 fptr = (FILE*)NULL;
 swp_count[swp_nest] = 0;
}
/*--------------------------------------------------------------------------*/
static void setup(const char *cmd, int *cnt)
{
 for (;;){
    if (isdigit(cmd[*cnt])){
       swp_steps[swp_nest] = ctoi(cmd,cnt) ;
       swp_steps[swp_nest] = (swp_steps[swp_nest]) ? swp_steps[swp_nest]-1
						   : 0;
    }else if (pmatch(cmd,cnt,"LInear")){
       swp_type[swp_nest] = 0;
    }else if (pmatch(cmd,cnt,"LOg")){
       swp_type[swp_nest] = 'L';
    }else{
       break;
    }
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
