/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: socket.h,v 35004.3 1995/08/07 04:39:12 hawkeye Exp $ */

#ifndef SOCKET_H
#define SOCKET_H

#define SOCKDEAD      00001     /* connection dead */
#define SOCKRESOLVING 00002     /* hostname not yet resolved */
#define SOCKPENDING   00004     /* connection not yet established */
#define SOCKLOGIN     00010     /* autologin requested by user */
#define SOCKPROMPT    00020     /* last prompt was definitely a prompt */
#define SOCKEOR       00040     /* server will send EOR after prompts */
#define SOCKECHO      00100     /* do local keyboard echo */
#define SOCKNAWS      00200     /* do negotiate about window size */
#define SOCKEDIT      00400     /* do local editing (not used) */
#define SOCKTRAP      01000     /* do local signal trapping (not used) */
#define SOCKLINEMODE  02000     /* do telnet LINEMODE negotiation (not used) */
#define SOCKTELNET    04000     /* server supports telnet protocol (not used) */


extern void    NDECL(main_loop);
extern void    NDECL(init_sock);
extern int     FDECL(is_active,(int fd));
extern void    FDECL(readers_clear,(int fd));
extern void    FDECL(readers_set,(int fd));
extern TIME_T  FDECL(sockidle,(CONST char *name));
extern void    NDECL(tog_bg);
extern struct World *NDECL(fworld);
extern struct World *NDECL(xworld);
extern int     FDECL(openworld,(char *name, char *port, int autologin,
                     int quietlogin));
extern int     FDECL(opensock,(struct World *w, int autologin, int quietlogin));
extern void    FDECL(world_output,(struct World *world, Aline *aline));
extern int     FDECL(send_line,(char *s, unsigned int len));
extern String *NDECL(fgprompt);
extern void    NDECL(tog_lp);
extern void    NDECL(transmit_window_size);

#endif /* SOCKET_H */
